E /*  .TITLE  FIXDRIVER - VAX/VMS Device Driver RENAME Program.		    */ " /*  .IDENT  'X001-01'							    */ /*									    */ J /*  BY:  William J. Sabatine - Micro Technology, Inc.  Anaheim, CA.	    */    / #include    <rms>				    /* RMS routines	    */ 2 #include    <iodef>				    /* I/O constants	    */5 #include    <ssdef>				    /* Sys status constants */ 6 #include    <libdef>				    /* Library constants    */7 #include    <descrip>				    /* Descriptor macros    */ 8 #include    <lib$routines>			    /* Library calls	    */    < #define	BUFFER_SIZE	    255			    /* Image filespec size  */> #define NEW_NAME_SIZE       9			    /* New image name size  */@ #define DISK_BLOCK_SIZE     512			    /* Size of disk blocks  */> #define PROLOG_TABLE_OFFSET 36			    /* Offset in image	    */    @ char	driver_buffer[BUFFER_SIZE];		    /* Image filespec buff  */D char	new_name_buffer[NEW_NAME_SIZE];		    /* New image name buff  */    N $DESCRIPTOR(driver_buffer_desc, driver_buffer);	    /* Image file spec desc */N $DESCRIPTOR(new_name_buffer_desc, new_name_buffer); /* New image name desc  */    < unsigned long	fixup_driver();			    /* Modifies image	    */     main() {   @ /* main() performs the image open, read and write calls.		    */G /* It calls get_input() to receive filespecs from the user, and		    */ ? /* fixup_driver() to modify the image to the new name.			    */       $ /* Define user messages.						    */  5 $DESCRIPTOR(done_message, "Driver Fixup Successful"); M $DESCRIPTOR(badimage_message, "New name or image is invalid - Fixup failed");      struct { K    unsigned short   condition_value;	/* I/O status block - return status.*/ J    unsigned short   transfer_count;	/* I/O status block - not used by us*/G    unsigned long    information;	/* I/O status block - not used by us*/ C }  driver_iosb = {0, 0, 0};		/* Initialize before use with QIO   */     = struct	FAB	driver_fab;		/* File Access Block for $OPEN	    */     > unsigned long	 status;		/* Results indicator for sys calls  */B unsigned long	 image_size;		/* Size in bytes of driver image    */; char		*image_pointer;		/* Pointer to image in memory	    */       K /* Call to get_input() to receive image name and new name from user.	    */    get_input();      9 /* Initialize the FAB with the system defaults.				    */ N /* Add User File Open option, allow reads and writes and assign buffers.    */   driver_fab = cc$rms_fab;  ! driver_fab.fab$l_fop = FAB$M_UFO; + driver_fab.fab$b_fac = FAB$M_GET|FAB$M_PUT; & driver_fab.fab$l_fna = &driver_buffer;7 driver_fab.fab$b_fns = driver_buffer_desc.dsc$w_length;       E /* Perform the file open only.  No other RMS to do (via UFO).		    */    status = sys$open(&driver_fab); , if (status != RMS$_NORMAL) sys$exit(status);      E /* Calculate image size as disk blocks used times block size.		    */ B /* Allocate enough memory to read in entire image at once.		    */2 /* Perform QIO to get the entire image.					    */  4 image_size = driver_fab.fab$l_alq * DISK_BLOCK_SIZE;  4 status = lib$get_vm(&image_size, &image_pointer, 0);+ if (status != SS$_NORMAL) sys$exit(status);       * status = sys$qiow(0, driver_fab.fab$l_stv, 		  IO$_READVBLK,  		  &driver_iosb, 0, 0,  		  image_pointer, 		  image_size, 1, 0, 0, 0);  + if (status != SS$_NORMAL) sys$exit(status);   . if (driver_iosb.condition_value != SS$_NORMAL)*     sys$exit(driver_iosb.condition_value);      I /* Call fixup_driver() to modify the driver image to the new name.	    */ 9 /* Call QIO to write out the image if all is ok.			    */ D /* Write message for user indicating the problem or success.		    */1 /* Close the I/O channel when through.					    */   7 status = fixup_driver(image_pointer, &new_name_buffer);        if (!status) { .     status = sys$qiow(0, driver_fab.fab$l_stv,    		      IO$_WRITEVBLK,  		      &driver_iosb, 0, 0,  		      image_pointer,  		      image_size, 1, 0, 0, 0);  /     if (status != SS$_NORMAL) sys$exit(status);   2     if (driver_iosb.condition_value != SS$_NORMAL)' 	sys$exit(driver_iosb.condition_value);     +     status = lib$put_output(&done_message); /     if (status != SS$_NORMAL) sys$exit(status);  }  else { /     status = lib$put_output(&badimage_message); /     if (status != SS$_NORMAL) sys$exit(status);  }     * status = sys$dassgn(driver_fab.fab$l_stv);+ if (status != SS$_NORMAL) sys$exit(status);    }      get_input()  {   N /* get_input() receives the image filespec and new image name from the user.*/    G $DESCRIPTOR(name_prompt,"_New Name: ");		/* Prompt for new image name*/ K $DESCRIPTOR(driver_prompt,"_Driver Name: ");	/* Prompt for image filespec*/     7 unsigned long	status;				/* Holds status of sys calls*/ 8 unsigned long	flag = 1;			/* Lib$ flag for prompt.    */0 char	 	*index;				/* Search ptr to input str. */    N /* Check to command line for input and ask for image name if not provided.  */H /* Check for both image name AND new name in command line string.	    */  - status = lib$get_foreign(&driver_buffer_desc, (                          &driver_prompt,& 			 &driver_buffer_desc.dsc$w_length);  + if (status != SS$_NORMAL) sys$exit(status);       6 driver_buffer[driver_buffer_desc.dsc$w_length] = '\0';# index = strchr(driver_buffer, ' ');     E /* If the new name was not given in command line, ask for it.		    */ N /* Otherwise, parse it out of the input filespec string and adjust lengths  */   if (!index)  { 3     status = lib$get_foreign(&new_name_buffer_desc, # 	                     &name_prompt, + 			     &new_name_buffer_desc.dsc$w_length, $                              &flag);  >     if ( (status != SS$_NORMAL) & (status != LIB$_INPSTRTRU) ) 	sys$exit(status); }      else { *     strncpy(&new_name_buffer, index+1, 8);  *     new_name_buffer_desc.dsc$w_length = 8;=     driver_buffer_desc.dsc$w_length = index - &driver_buffer;  }    }     8 unsigned long fixup_driver(driver_pointer, name_pointer) char	*driver_pointer;  char	*name_pointer;   I /* Fixup_driver() modified driver image to the new name specified.	    */  {     ; /* status = Holds return status from system calls.			    */ N /* offset = Holds offset into driver image containing name to be modified.  */N /* syntax = Contains name to match against as a check before imge change.   */     unsigned long	status = 0; C unsigned long	offset = (DISK_BLOCK_SIZE + 1 + PROLOG_TABLE_OFFSET);    char		syntax[7] = "DRIVER";     N /* Double check that we were given a legit name by the user.                */N /* Double check that we have a legit image name.                            */H /* If all ok, change the first two bytes to the new name.	            */  . status = strncmp((name_pointer+2), syntax, 6);     if (!status) {   ;     status = strncmp((driver_pointer+offset+2), syntax, 6);      if (!status)     {   0 	*(driver_pointer+offset+0) = *(name_pointer+0);0 	*(driver_pointer+offset+1) = *(name_pointer+1);     }    }    return (status);   } 