#include	<stdio.h>			/* standard I/O definitions */
#include	<descrip.h>			/* descriptor definitions */
#include	<ssdef.h>			/* system service definitions */
#include	<varargs.h>			/* variable arguments */

/*
 *	Write a buffer to a network link
 *
 *	mai$ax_buffer		descriptor for buffer to write
 *
 * Seems to be only called to write error texts to the network equivalent of SYS$OUTPUT when running as a slave.
 *
 * Return: System status code for success/failure
 *
 */

PROTO_IO_WRITE(
	long	*mai$al_context,		/* Context field for protocol */
	long	mai$l_operation,		/* LNK_C_IO_WRITE */
	va_list	arglist)			/* remainder of arguments */
{
	struct	dsc$descriptor	*mai$ax_buffer ;/* Buffer to write into */

	mai$ax_buffer =
	  (struct dsc$descriptor *) va_arg(arglist, struct dsc$descriptor *) ;

	printf( "* Operation type = %d (LNK_C_IO_WRITE)\n", mai$l_operation );
	printf( "  Context field  = 0x%08x\n", *mai$al_context );
	printf( "  Buffer         = %.*s\n", mai$ax_buffer->dsc$w_length, mai$ax_buffer->dsc$a_pointer );

	return(SS$_NORMAL) ;			/* Return success to caller */
}
