#include	<stdio.h>			/* standard I/O definitions */
#include	<descrip.h>			/* descriptor definitions */
#include	<ssdef.h>			/* system service definitions */
#include	<varargs.h>			/* variable arguments */

/*
 *	Establish a connection (possibly with a remote node)
 *
 *	mai$ax_protocol		Protocol field from address (to the left of
 *				the '%')
 *	mai$ax_node		Node name from address (to the right of the
 *				'%') if a '::' was found, else a blank string
 *
 *
 * Return: SS$_NORMAL for success, else mai$l_signal as passed
 *
 */

PROTO_OUT_CONNECT(
	long	*mai$al_context,		/* Context field for protocol */
	long	mai$l_operation,		/* LNK_C_OUT_CONNECT */
	va_list	arglist)			/* remainder of arguments */
{
	struct	dsc$descriptor *mai$ax_protocol ; /* Protocol to use */
	struct	dsc$descriptor *mai$ax_node ;	/* Node to connect to */
	long	mai$l_signal ;			/* MAIL$_LOGLINK - what to return for failure */
	char	mai$b_filrat ;			/* File RMS RAT field */
	char	mai$b_filrfm ;			/* File RMS RFM field */
	short	mai$w_sysflags ;		/* Low 16 bits of MAIL$GL_SYSFLAGS */
	struct	dsc$descriptor *mai$ax_attach ;	/* SEND/ATTACH file descriptor (or 0) */
	char	mai$b_filorg ;			/* File RMS ORG field */
	long	mai$l_system_flags ;		/* System flags */

	mai$ax_protocol =
	  (struct dsc$descriptor *) va_arg(arglist, struct dsc$descriptor *) ;
	mai$ax_node =
	  (struct dsc$descriptor *) va_arg(arglist, struct dsc$descriptor *) ;
	mai$l_signal = (long) va_arg(arglist, long) ;
	mai$b_filrat = (char) va_arg(arglist, char) ;
	mai$b_filrfm = (char) va_arg(arglist, char) ;
	mai$w_sysflags = (short) va_arg(arglist, short) ;
	mai$ax_attach =
	  (struct dsc$descriptor *) va_arg(arglist, struct dsc$descriptor *) ;
	mai$b_filorg = (char) va_arg(arglist, char) ;
	mai$l_system_flags = (long) va_arg(arglist, long) ;

	printf( "* Operation type = %d (LNK_C_OUT_CONNECT)\n", mai$l_operation );
	printf( "  Context field  = 0x%08x\n", *mai$al_context );
	printf( "  Mail protocol  = %.*s\n", mai$ax_protocol->dsc$w_length, mai$ax_protocol->dsc$a_pointer );
	printf( "  Node name      = %.*s\n", mai$ax_node->dsc$w_length, mai$ax_node->dsc$a_pointer );
	printf( "  Signal value   = 0x%08x\n", mai$l_signal );
	printf( "  RMS RAT field  = 0x%02x\n", mai$b_filrat );
	printf( "  RMS RFM field  = 0x%02x\n", mai$b_filrfm );
	printf( "  RMS ORG field  = 0x%02x\n", mai$b_filorg );
	printf( "  MAIL flags     = 0x%04x\n", mai$w_sysflags );
	printf( "  System flags   = 0x%08x (<0> = Foreign)\n", mai$l_system_flags );
	if ( mai$ax_attach != 0 ) {
		printf( "  SEND/ATTACH file = %.*s\n", mai$ax_attach->dsc$w_length, mai$ax_attach->dsc$a_pointer );
	}
	return(SS$_NORMAL) ;			/* Return success to caller */
}

