#include	<stdio.h>			/* standard I/O definitions */
#include	<descrip.h>			/* descriptor definitions */
#include	<ssdef.h>			/* system service definitions */
#include	<varargs.h>			/* variable arguments */
#include	<rab.h>				/* Define RMS RAB fields */

/*
 *	Send a message to a remote node
 *
 *	mai$ax_node		Node name from address (to the right of the
 *				'%') if a '::' was found, else a blank string
 *	mai$ar_rab		Address of RAB for file to send to the remote
 *				node. We only send the file once to each node
 *				as PROTO_OUT_CKSEND is called for each user
 *				subsequently.
 *	mai$a_error		Passed address of a routine to be used to
 *				report any I/O error whilst reading the file
 *				and to format the message correctly for MAIL.
 *				Call this routine with:
 *					4(AP)	RAB address as passed
 *
 * Return: System service code for success/failure
 *
 */

PROTO_OUT_FILE(
	long	*mai$al_context,		/* Context field for protocol */
	long	mai$l_operation,		/* LNK_C_OUT_FILE */
	va_list	arglist)			/* remainder of arguments */
{
	struct	dsc$descriptor *mai$ax_node ;	/* Node to connect to */
	struct	RAB *mai$ar_rab ;		/* File RAB to send */
	long	(*mai$a_error)() ;		/* Routine to log I/O error */

	mai$ax_node =
	  (struct dsc$descriptor *) va_arg(arglist, struct dsc$descriptor *) ;
	mai$ar_rab = (struct RAB *) va_arg(arglist, struct RAB *) ;
	mai$a_error = (long (*)()) va_arg(arglist, long *) ;

	printf( "* Operation type = %d (LNK_C_OUT_FILE)\n", mai$l_operation );
	printf( "  Context field  = 0x%08x\n", *mai$al_context );
	printf( "  Node name      = %.*s\n", mai$ax_node->dsc$w_length, mai$ax_node->dsc$a_pointer );
	printf( "  RAB address    = 0x%08x\n", mai$ar_rab );
	printf( "  Error routine  = 0x%08x\n", mai$a_error );

	return(SS$_NORMAL) ;			/* Return success to caller */
}
