! MMS description file for libvms (VMS Library for NCSA Mosaic)
! George E. Cook, WVNET, 12-May-1996
! Mosaic 2.7-4
!

.INCLUDE [-.SRC]CONFIG.MMS_$(WORK)

WDIR = [.$(WORK)]

LIBTARGET = $(WDIR)libvms.olb

VMS_DEFS = $(VMS_DEF1)$(VMS_DEF2)

.IFDEF DECC
.IFDEF PATHWAY
.INCLUDE [-.TWG]DECC_PREFIX_RULES.MMS
CQUALC=/DECC $(CC_PREFIX_NO_SIN)
.ELSE
.IFDEF MULTINET
CQUALC=/DECC/Prefix=ANSI
.ELSE
CQUALC=/DECC/Prefix=ALL
.ENDIF
.ENDIF
.ELSE ! Not DEC C
.IFDEF DECCVAXC
CQUALC=/VAXC
.ELSE
CQUALC=
.ENDIF
.ENDIF

.IFDEF MULTINET
CDEFS =/Define=($(VMS_DEFS)MULTINET)
.ELSE
.IFDEF PATHWAY
CDEFS =/Define=($(VMS_DEFS)WIN_TCP)
.ELSE
.IFDEF SOCKETSHR
CDEFS =/Define=($(VMS_DEFS)SOCKETSHR)
.ELSE
CDEFS =/Define=($(VMS_DEFS)UCX)
.ENDIF
.ENDIF
.ENDIF

.IFDEF DEBUG
CFLAGS = $(CQUALC)$(CDEFS)/NoOpt/Debug
.ELSE
CFLAGS = $(CQUALC)$(CDEFS)
.ENDIF

OBJECTS =  Odir:cmdline.obj Odir:mosaic_cld.obj

.FIRST
        @ If F$Search("$(LIBTARGET)") .EQS. "" Then Library/Create $(LIBTARGET)
	@ Define/NoLog Odir $(WDIR)
.IFDEF PATHWAY
	@ @[-.TWG]def
.ENDIF
.IFDEF DECC
.IFDEF ALPHA
	@ If F$TRNLNM("ALPHA$LIBRARY") .NES. "" Then Define/NoLog Sys Alpha$Library
.ELSE
	@ If F$TRNLNM("DECC$LIBRARY_INCLUDE") .NES. "" Then Define/NoLog Sys DECC$Library_Include
.ENDIF
.ELSE
	@ Define/NoLog Sys SYS$Library
.ENDIF

default :       $(LIBTARGET) [-]mosaic.hlp
	@	! Do nothing

$(LIBTARGET) : $(LIBTARGET)($(OBJECTS))
	@ Write SYS$Output "Library libvms.olb built."

Odir:cmdline.obj    : cmdline.c [-.src]mosaic.h
Odir:mosaic_cld.obj : mosaic_cld.cld

mosaic.rnh          : mosaic.help
        EDIT/TPU/NOSECTION/NODISPLAY/COMMAND=CVTHELP.TPU MOSAIC.HELP
[-]mosaic.hlp       : mosaic.rnh
	$(RUNOFF) $(RFLAGS) $(MMS$SOURCE)
	@ Write SYS$Output "Mosaic help file created."

.c.obj
	$(CC)$(CFLAGS)/OBJECT=$@ $<

.obj.olb
	$(LIBR) $(LIBRFLAGS) $(MMS$TARGET) $(MMS$SOURCE)

clean :
	Delete/Log $(WDIR)*.OBJ;*
	Delete/Log $(LIBTARGET);*

