! MMS description file for LIBWWW2
! Bjorn S. Nilsson, Aleph, CERN, 20-Nov-1993
! (Mosaic version 2.0)
! Mosaic version 2.4 20-Aug-1994
! Mosaic version 2.6 1-Nov-1995, George Cook
!
! Usage:
!       $ MMS                           for DEC/UCX/VAXC
! Add a MULTINET=1 MACRO when using MultiNet TCP/IP.
! Add a SOCKETSHR=1 MACRO when using SOCKETSHR.  BGT
! Add a DEBUG=1    MACRO when debugging.
! Add a DECC=1     MACRO when compiling with DEC C.
! Add a NOWAIS=1   MACRO when compiling without direct WAIS support.
!
! You may have to use the /IGNORE=WARNING qualifier to make MMS run all
! the way through if you get (acceptable) compilation warnings.

.INCLUDE Config.mms_$(WORK)

WDIR = [.$(WORK)]

LIBTARGET = $(WDIR)libwww.olb

.LAST
	@ Delete config.mms_$(WORK);*
.FIRST
        @ If F$Search("$(LIBTARGET)") .EQS. "" Then Library/Create $(LIBTARGET)
	@ Define/NoLog Odir $(WDIR)
.IFDEF PATHWAY
	@ @[-.TWG]def
.ENDIF
.IFDEF DECC
.IFDEF ALPHA
	@ If F$TRNLNM("ALPHA$LIBRARY") .NES. "" Then Define/NoLog Sys Alpha$Library
.ELSE
	@ If F$TRNLNM("DECC$LIBRARY_INCLUDE") .NES. "" Then Define/NoLog Sys DECC$Library_Include
.ENDIF
.ELSE
	@ Define/NoLog Sys SYS$Library
.ENDIF
.IFDEF NOWAIS
.ELSE
	@ Topdir = F$Environment("Default")-"LIBWWW2]"
	@ Define WAIS_IR  'Topdir'FREEWAIS-0_5.IR]
.IFDEF DECC
	@ Define DECC$User_Include 'F$Environment("Default")',WAIS_IR
	@ Define DECC$System_Include 'F$Environment("Default")',WAIS_IR,SYS
.ELSE
	@ Define C$Include 'F$Environment("Default")',WAIS_IR
	@ Define VAXC$Include 'F$Environment("Default")',WAIS_IR,SYS
.ENDIF
WAISDEF=DIRECT_WAIS,
WAISDEFS=DIRECT_WAIS
WAISMODULES = Odir:HTWAIS.obj
.ENDIF

.IFDEF DECC
.IFDEF PATHWAY
.INCLUDE [-.TWG]DECC_PREFIX_RULES.MMS
CQUALC=/DECC/Standard=VAXC/Precision=SINGLE $(CC_PREFIX_NO_SIN)
.ELSE
.IFDEF MULTINET
CQUALC=/DECC/Standard=VAXC/Precision=SINGLE/Prefix=ANSI
.ELSE
CQUALC=/DECC/Standard=VAXC/Precision=SINGLE
.ENDIF
.ENDIF
.ELSE
.IFDEF DECCVAXC
CQUALC=/VAXC/Precision=SINGLE
.ELSE
CQUALC=/Precision=SINGLE
.ENDIF
.ENDIF

.IFDEF MULTINET
CDEFS = /Define=($(WAISDEF)$(VMS_DEF)MULTINET)
.ENDIF

.IFDEF PATHWAY
CDEFS = /Define=($(WAISDEF)$(VMS_DEF)WIN_TCP)
.ENDIF

.IFDEF SOCKETSHR ! BGT
CDEFS = /Define=($(WAISDEF)$(VMS_DEF)SOCKETSHR) ! BGT
.ENDIF ! BGT

.IFDEF CDEFS
.ELSE
CDEFS=/Define=($(VMS_DEF)$(WAISDEFS))
.ENDIF

.IFDEF DEBUG
CFLAGS = $(CQUALC)$(CDEFS)/NoOpt/Debug
.ELSE
CFLAGS = $(CQUALC)$(CDEFS)
.ENDIF

OBJECTS = Odir:HTAccess.obj Odir:HTAlert.obj Odir:HTAnchor.obj Odir:HTAtom.obj \
  Odir:HTSort.obj Odir:HTChunk.obj Odir:HTFTP.obj Odir:HTFWriter.obj \
  Odir:HTFile.obj Odir:HTFormat.obj Odir:HTGopher.obj Odir:HTInit.obj \
  Odir:HTList.obj Odir:HTMIME.obj Odir:HTML.obj Odir:HTMLDTD.obj \
  Odir:HTMLGen.obj Odir:HTNews.obj Odir:HTParse.obj Odir:HTPlain.obj \
  Odir:HTMosaicHTML.obj Odir:HTString.obj Odir:HTTCP.obj Odir:HTTP.obj \
  Odir:HTTelnet.obj Odir:HTWSRC.obj Odir:HTWriter.obj Odir:SGML.obj \
  Odir:HTIcon.obj Odir:HTCompressed.obj Odir:HTAAUtil.obj Odir:HTAssoc.obj \
  Odir:HTUU.obj Odir:HTAABrow.obj Odir:HTMailto.obj $(WAISMODULES)

$(LIBTARGET) : $(LIBTARGET)($(OBJECTS))
	@ Write SYS$Output "Library libwww.olb built."

Odir:HTAABrow.obj :     HTAABrow.c htaabrow.h htaautil.h htalert.h htassoc.h \
                        htlist.h htparse.h htstring.h htutils.h htuu.h tcp.h \
                        [-.src]md5.h
Odir:HTAAUtil.obj :     HTAAUtil.c htaautil.h htassoc.h htlist.h htstring.h \
                        htutils.h tcp.h
Odir:HTAccess.obj :     HTAccess.c htaccess.h htalert.h htanchor.h htatom.h \
                        htext.h htformat.h htlist.h html.h htmldtd.h \
                        htparse.h htstream.h htstring.h htutils.h sgml.h \
                        tcp.h [-.src]proxy.h
Odir:HTAlert.obj :      HTAlert.c htalert.h htstring.h htutils.h tcp.h
Odir:HTAnchor.obj :     HTAnchor.c htanchor.h htatom.h htformat.h htlist.h \
                        htparse.h htstream.h htstring.h htutils.h tcp.h
Odir:HTAssoc.obj :      HTAssoc.c htaautil.h htassoc.h htlist.h htstring.h \
                        htutils.h tcp.h
Odir:HTAtom.obj :       HTAtom.c htatom.h htstring.h htutils.h tcp.h
Odir:HTChunk.obj :      HTChunk.c htchunk.h htstring.h htutils.h
Odir:HTCompressed.obj : HTCompressed.c htaccess.h htalert.h htanchor.h \
                        htatom.h htext.h htfile.h htformat.h htfwriter.h \
                        htinit.h htlist.h html.h htmldtd.h htmlgen.h \
                        htplain.h htstream.h htstring.h htutils.h sgml.h \
                        tcp.h [-.libnut]system.h
Odir:HTFile.obj :       HTFile.c htaccess.h htalert.h htanchor.h htatom.h \
                        htext.h htfile.h htformat.h htftp.h htfwriter.h \
                        htinit.h htlist.h html.h htmldtd.h htparse.h htsort.h \
                        htstream.h htstring.h httcp.h htutils.h htwriter.h \
                        sgml.h tcp.h
Odir:HTFormat.obj :     HTFormat.c htalert.h htanchor.h htatom.h htext.h \
                        htformat.h htfwriter.h htinit.h htlist.h htmime.h \
                        html.h htmldtd.h htmlgen.h htplain.h htstream.h \
                        htstring.h htutils.h sgml.h tcp.h
Odir:HTFTP.obj :        HTFTP.c tcp.h htaautil.h htaccess.h htalert.h \
                        htanchor.h htatom.h htchunk.h htext.h htfile.h \
                        htformat.h htftp.h htlist.h html.h htmldtd.h \
                        htparse.h htsort.h htstream.h htstring.h httcp.h \
                        htutils.h sgml.h tcp.h
Odir:HTFWriter.obj :    HTFWriter.c htaccess.h htalert.h htanchor.h htatom.h \
                        htcompressed.h htext.h htfile.h htformat.h \
                        htfwriter.h htlist.h html.h htmldtd.h htstream.h \
                        htstring.h htutils.h sgml.h tcp.h
Odir:HTGopher.obj :     HTGopher.c htaccess.h htanchor.h htatom.h htfile.h \
                        htformat.h htgopher.h htlist.h html.h htmldtd.h \
                        htparse.h htstream.h htstring.h httcp.h htutils.h \
                        sgml.h tcp.h
Odir:HTIcon.obj :       HTIcon.c htaccess.h htanchor.h htatom.h htfile.h \
                        htformat.h htlist.h html.h htmldtd.h htstream.h \
                        htstring.h htutils.h sgml.h tcp.h
Odir:HTInit.obj :       HTInit.c htaccess.h htanchor.h htatom.h htfile.h \
                        htformat.h htinit.h htlist.h htmime.h html.h \
                        htmldtd.h htmlgen.h htmosaichtml.h htplain.h \
                        htstream.h htstring.h htutils.h htwsrc.h sgml.h tcp.h
Odir:HTList.obj :       HTList.c htlist.h htstring.h htutils.h
Odir:HTMailto.obj :     HTMailto.c htaccess.h htanchor.h htatom.h htformat.h \
                        htlist.h html.h htmldtd.h htparse.h htstream.h \
                        htstring.h htutils.h sgml.h tcp.h
Odir:HTMIME.obj :       HTMIME.c htaautil.h htaccess.h htalert.h htanchor.h \
                        htatom.h htfile.h htformat.h htlist.h htmime.h html.h \
                        htmldtd.h htstream.h htstring.h htutils.h sgml.h tcp.h
Odir:HTML.obj :         HTML.c htalert.h htanchor.h htatom.h htchunk.h \
                        htext.h htformat.h htlist.h html.h htmldtd.h \
                        htmlgen.h htparse.h htstream.h htstring.h htutils.h \
                        sgml.h tcp.h
Odir:HTMLDTD.obj :      HTMLDTD.c htmldtd.h htstream.h htstring.h htutils.h \
                        sgml.h
Odir:HTMLGen.obj :      HTMLGen.c htanchor.h htatom.h htformat.h htlist.h \
                        html.h htmldtd.h htmlgen.h htstream.h htstring.h \
                        htutils.h sgml.h
Odir:HTMosaicHTML.obj : HTMosaicHTML.c htaccess.h htanchor.h htatom.h \
                        htcompressed.h htext.h htfile.h htformat.h htlist.h \
                        html.h htmldtd.h htmosaichtml.h htstream.h htstring.h \
                        htutils.h sgml.h tcp.h
Odir:HTNews.obj :       HTNews.c htaccess.h htanchor.h htatom.h htformat.h \
                        htlist.h html.h htmldtd.h htnews.h htparse.h \
                        htstream.h htstring.h htutils.h sgml.h tcp.h \
                        [-.libxmx]xmx.h [-.src]mosaic.h [-.src]newsrc.h \
                        [-.src]prefs.h [-.src]prefs_defs.h [-.src]toolbar.h
Odir:HTParse.obj :      HTParse.c htparse.h htstring.h htutils.h tcp.h
Odir:HTPlain.obj :      HTPlain.c htaccess.h htanchor.h htatom.h \
                        htcompressed.h htext.h htfile.h htformat.h htlist.h \
                        html.h htmldtd.h htplain.h htstream.h htstring.h \
                        htutils.h sgml.h tcp.h
Odir:HTSort.obj :       HTSort.c htstring.h htutils.h
Odir:HTString.obj :     HTString.c htstring.h htutils.h tcp.h
Odir:HTTCP.obj :        HTTCP.c htaccess.h htalert.h htanchor.h htatom.h \
                        htformat.h htlist.h htparse.h htstream.h htstring.h \
                        htutils.h tcp.h
Odir:HTTelnet.obj :     HTTelnet.c htaccess.h htalert.h htanchor.h htatom.h \
                        htext.h htfile.h htformat.h htlist.h html.h htmldtd.h \
                        htparse.h htstream.h htstring.h httelnet.h http.h \
                        htutils.h sgml.h tcp.h
Odir:HTTP.obj :         HTTP.c htaabrow.h htaautil.h htaccess.h htalert.h \
                        htanchor.h htatom.h htfile.h htformat.h htinit.h \
                        htlist.h htmime.h html.h htmldtd.h htparse.h \
                        htstream.h htstring.h httcp.h http.h htutils.h sgml.h \
                        tcp.h [-.src]kcms.h
Odir:HTUU.obj :         HTUU.c htstring.h htutils.h htuu.h
Odir:HTWAIS.obj :       HTWAIS.c htaccess.h htalert.h htanchor.h htatom.h \
                        htfile.h htformat.h htlist.h html.h htmldtd.h \
                        htparse.h htstream.h htstring.h httcp.h htutils.h \
                        sgml.h tcp.h [-.freewais-0_5.ir]cdialect.h \
                        [-.freewais-0_5.ir]cutil.h [-.freewais-0_5.ir]panic.h \
                        [-.freewais-0_5.ir]server.h \
                        [-.freewais-0_5.ir]transprt.h [-.freewais-0_5.ir]ui.h \
                        [-.freewais-0_5.ir]version.h \
                        [-.freewais-0_5.ir]wmessage.h \
                        [-.freewais-0_5.ir]wprot.h [-.freewais-0_5.ir]zprot.h \
                        [-.freewais-0_5.ir]ztype1.h [-.freewais-0_5.ir]zutil.h
Odir:HTWriter.obj :     HTWriter.c htstream.h htstring.h htutils.h htwriter.h \
                        tcp.h
Odir:HTWSRC.obj :       HTWSRC.c htanchor.h htatom.h htformat.h htlist.h \
                        html.h htmldtd.h htparse.h htstream.h htstring.h \
                        htutils.h htwsrc.h sgml.h tcp.h
Odir:SGML.obj :         SGML.c htchunk.h htstream.h htstring.h htutils.h sgml.h

.c.obj :
	$(CC)$(CFLAGS)/OBJECT=$@ $<

.obj.olb
	$(LIBR) $(LIBRFLAGS) $(MMS$TARGET) $(MMS$SOURCE)

clean :
	Delete/Log $(WDIR)*.OBJ;*
	Delete/Log $(LIBTARGET);*

