/*
 alias.c
 this file contains all kinds of functions that have to do with aliases.
*/
#include "mail.h"
#include <descrip.h>
#include <maildef.h>
#include <smgdef.h>
#include <smg$routines.h>
#include <ssdef.h>
#include <stdio.h>
#include <stdlib.h>
#include <nam.h>
#include <string.h>
#include <ctype.h>

				/* global variables for windows */
extern long file_context, message_context, user_context, send_context;
extern long pboard_id, body_id, command_id, keyboard_id, error_id;
extern long full_screen_id, bottom_id, title_id, help1_id, help2_id;
extern long input_id;
				/* global variable to linked list */
extern alias_info *aliases;

extern int yesno();
extern void upcase();
extern void clear();
extern void paste();
extern void unpaste();
extern int get_string();
extern int get_number();
extern void send_mail();
extern void display_alias_commands();
extern void display_alias_title();
extern void print();

/*
 read_aliases will read all the aliases from the alias file into a linked list
*/
void read_aliases()
{
 alias_info *tmp, *last;
 FILE *f;
 char s[NAM$C_MAXRSS+1];

				/* If there is a list in memory, free it */
 while (aliases != 0) {
   tmp = (alias_info *) aliases;
   aliases = (alias_info *) aliases->next;
   free(tmp);
 }				/* End of while (.. */
 if (!(f=fopen(ALIASFILE, "r"))) {	/* Try opening alias file for reading*/
  if (!(f = fopen(ALIASFILE, "w"))) {	/* Try opening it for writing */
   aliases = 0;
   return;			/* all of them fail, return 0 */
  }				/* End of if (!(f = fop */
				/* Create new file, with header... */
  fprintf(f, "# This file contains aliases for the PTmail program\n");
  fclose(f);			
  return;			/* And return */
 }				/* End of if (!(f=fopen */
 fgets(s, 130, f);		/* Read the header and skip it */
 while (fgets(s, 130, f)) {	/* Read line with alias and translation */
				/* grab some memory */
   if ((tmp = malloc(sizeof(alias_info))) == 0) {
     fprintf(stderr, "Memory allocation error [read_aliases]\n");
     exit(SS$_NORMAL);
   }				/* End of if ((tmp = */
				/* fill the alias structure */
   sscanf(s, "%s %s", tmp->alias, tmp->trans);
   upcase(tmp->alias);
/* upcase(tmp->trans); */
   tmp->next = 0;		
				/* Add it to the linked list */
   if (aliases == 0) aliases = last = tmp;
   else {
     last->next = tmp;
     last = tmp;
   }				/* End of if (aliaes) else */
  }				/* End of while( */
}				/* End of read_aliases() */

/*
 write aliases will write all the aliases in memory to the alias file
*/
void write_aliases()
{
  FILE *f;
  alias_info *tmp;

  if (!(f = fopen(ALIASFILE, "w"))){	/* Try opening the file */
    print(&error_id, "Error writing to alias file...");
    return;
  }				/* End of if (!(f = fop */
				/* Print header to file */
  fprintf(f, "# This file contains aliases for the PTmail program\n");
  tmp = aliases;		/* go to the front of linked list */
  while (tmp != 0) {		/* while there are still more.. */
				/* print them to file */
    fprintf(f, "%s %s\n", tmp->alias, tmp->trans);
    tmp = tmp->next;		/* and move to the next one */
  }				/* End of while (tmp.. */
  fclose(f);			/* Close alias file */
}				/* End of write_aliases() */

/*
 create_menu_from_aliases will create a menu array from the aliase linked
list
*/
void create_menu_from_aliases(alias_info *aliases, 
  struct m_descriptor *menu_list, int *total)
{
  int counter = 0;
  alias_info *tmp;
  char *tmp_list;

  tmp = aliases;		/* go to the front of the linked list */
  while (tmp != 0) {		/* are we at the end? */
    (*total)++;			/* increase counter */
    tmp = tmp->next;		/* move to the next one */
  }				/* End of while(. */
  menu_list->length = 79;
  menu_list->dtype = DSC$K_DTYPE_T;
  menu_list->class = DSC$K_CLASS_A;
				/* grab enough memory */
  if ((menu_list->pointer = malloc(79 * (*total)))==0) {
    fprintf(stderr, "Memory allocation error [create_menu_from_aliases]\n");
    exit(SS$_NORMAL);
  }				/* End of if ((menu_ */
  memset(menu_list->pointer, 32, 79*(*total));
  menu_list->aflags = 14 * 16;
  menu_list->dimct = 1;
  menu_list->arsize = 79 * (*total);
  menu_list->a0 = menu_list->pointer - 79;
  menu_list->m1 = (*total);
  menu_list->l1 = 1;
  menu_list->u1 = (*total);
  tmp = aliases;		/* go to front of linked list */
  tmp_list = menu_list->pointer;
  for (counter = 0; counter < *total; counter++) {
				/* create menu item */
    sprintf(tmp_list, "%3d %-15.15s %-58.58s", counter+1, tmp->alias, tmp->trans);
    tmp_list+= 79;		/* move to the next menu item */
    tmp = tmp->next;		/* move to the next alias in list */
  }				/* End of for (counter */
}				/* End of create_menu_from_aliases() */

/* 
 add_alias will add a new alias to the linked list in memory
*/
void add_alias()
{
  alias_info *tmp;
  char temp[NAM$C_MAXRSS+1];
  short rlen = 0;
  int done;

				/* grab enough memory for new entry */
  if ((tmp = malloc(sizeof(alias_info))) == 0) {
    fprintf(stderr, "Memory allocation error [add_alias]\n");
    exit(SS$_NORMAL);	
  }				/* End of if ((tmp */
  clear(&input_id);
  paste(&input_id, 15, 1);
  do {
				/* Get the alias name */
    if (!get_string("Alias: ", temp, &input_id, &rlen)) {
     unpaste(&input_id);
     return;		
    }				/* End of if (!get */
    if (strchr(temp, ' ')) {	/* check for spaces */
     print(&command_id, "No spaces are allowed...");
     done = FALSE;
    } else done = TRUE; 
  } while (!done);		/* keep going until a valid alias */
  strcpy(tmp->alias, temp);
  upcase(tmp->alias);	/* uppercase it */
  do {
				/* Get the translation */
    if (!get_string("Address: ", temp, &input_id, &rlen)) {
     unpaste(&input_id);
     return;	
    }				/* End of if (!get_ */
    if (strchr(temp, ' ')) {	/* Again, checkf or spaces */
      print(&input_id, "No spaces are allowed...");
      done = FALSE;
    } else done = TRUE;
  } while (!done);		/* keep going until a valid translation */
  strcpy(tmp->trans, temp);
/* upcase(tmp->trans);	*/	/* uppercase it */
  tmp->next = (alias_info *) aliases; /* put alias list after this one */
  aliases = tmp;		/* make new alias the front */
  unpaste(&input_id);
}				/* End of add_alis() */

/*
 del_alias will remove an alias from the linked list in memory 
*/
void del_alias(int select)
{
  alias_info *tmp, *back;
  int counter;

  tmp = aliases;		/* go to the front of the list */
  clear(&input_id);
  paste(&input_id, 15, 1);
  print(&input_id, "", 2);
  if (yesno(&input_id, "Are you sure you want to delete that alias? [y/n] ") == NO) {
    unpaste(&input_id);
    return;
  }				/* End of if (yesno.. */
  if (select == 1) {		/* is it the first alias in the list? */
    aliases = aliases->next;	/* then assing a new first node */
    free(tmp);			/* and free the memory */
  } else {
    back = tmp;			/* otherwise find the node */
    for (counter = 0; counter < select - 1; counter++) {
      back = tmp;		/* and remove it from the list */
      tmp = tmp->next;
    }
    back->next = tmp->next;
    free(tmp);
  }				/* End of if (sele.. else */
  unpaste(&input_id);
}				/* End of del_alias */

/*
 handle_aliases will display all the alias and the user can add or delete
aliases. Or even send mail to the one selected.
*/
alias_info *handle_aliases(user_info *profile)
{
  int counter, last = 0, done = 0, select = 0, total=0, temp;
  int SMG_FLAG;
  short terminator;
  struct m_descriptor menu_list;
  alias_info *tmp;

  menu_list.length  = 0;
  menu_list.dtype   = 0;
  menu_list.class   = 0;
  menu_list.pointer = 0;
  menu_list.scale   = 0;
  menu_list.digits  = 0;
  menu_list.aflags  = 0;
  menu_list.dimct   = 0;
  menu_list.arsize  = 0L;
  menu_list.a0      = 0;
  menu_list.m1      = 0L;
  menu_list.l1      = 0L;
  menu_list.u1      = 0L;

  display_alias_commands();
  do {
    clear(&body_id);
    if (aliases != 0) {		/* Are there any aliases? */
      total = 0;
				/* free up the menu array */
      if (menu_list.pointer != 0) free(menu_list.pointer);
				/* create a new menu array */
      create_menu_from_aliases(aliases, &menu_list, &total);
				/* display the title */
      display_alias_title(total);
      SMG_FLAG = SMG$K_VERTICAL;
      if (!vms_ok(smg$create_menu(&body_id, &menu_list, &SMG_FLAG))) {
         fprintf(stderr, "Error in smg$create_menu [handle_aliases]\n");
         exit(SS$_NORMAL);
      }				/* End of errorchecking */
      SMG_FLAG = SMG$M_RETURN_IMMED;
      smg$select_from_menu(&keyboard_id, &body_id, &select, &last,
        &SMG_FLAG, 0, 0, &terminator);
    }				/* End of if (ali */
    else {
      display_alias_title(0);
				/* Otherwise just get a keypress */
      smg$read_keystroke(&keyboard_id, &terminator);
    }  				/* End of if (alias else */
				/* did use type a number 0..9 */
     if ((terminator >= 49) && (terminator <= 57)) {
       temp = get_number(terminator, total);
       if ((temp != 0) && (temp <= total)) select = temp;
     }
     tmp = aliases;
     last = select;
     for (counter = 0; counter < select-1; counter++)
       tmp = tmp->next;		/* move to the correct alias */
     switch (terminator) {	/* what key was pressed? */
       case 26:			/* CTRL-Z */
       case 113:		/* quit */
       case 120:		/* exit */
         done = TRUE;			
         break;
       case 13:
         clear(&input_id);
         paste(&input_id, 15, 1);
				/* send a mail message to that person */
         send_mail(profile, 0, aliases, tmp->trans, FALSE);
         unpaste(&input_id);
         break;
       case 97:				/* "a" add alias */
         add_alias();
         break;
       case 100:			/* "d" delete alias */
         del_alias(select);
         break;      
     }
  } while (!done);
  write_aliases();
  read_aliases();
  return(aliases);
}				/* End of handle_aliases */

/* 
 find_alias will return a email address if the name given is an alias
*/
void find_alias(alias_info *aliases, char *out, char *in)
{
  alias_info *tmp;
  char *BIGIN;

  BIGIN = (char *) malloc(NAM$C_MAXRSS+1);
  strcpy(BIGIN,in);
  upcase(BIGIN);

  tmp = aliases;
  while (tmp != 0) {			/* are there more aliases ? */
    if (!strcmp(tmp->alias, BIGIN)) {	/* is it the one we want? */
      strcpy(out, tmp->trans);		/* if so, copy it */
      return;				/* and get outta here */
    }					/* End of if (!strcmp */
    tmp = tmp->next;
  }				/* End of while (tmp */
  strcpy(out, in);		/* Just return what came in */
}   				/* End of find_alias() */
