/* dllist.c */

#include <stdio.h>
#include <stdlib.h>
#include "dllist.h"

listptr add_node(listptr list, char *data)
{
	listptr tmp;

	tmp = (listptr) malloc(sizeof(listnode));
	if (tmp == NULL)
		return(0);
	DATA(tmp) = data;
	NEXT(tmp) = list;
	PREV(tmp) = NULL;
	PREV(list) = tmp;
	list = tmp;
	return(list);
}

listptr find_node(listptr list, char *data, int (*func)())
{
	listptr walk;

	walk = list;
	while (walk != NULL && (!(*func)(DATA(walk), data)))
		walk = NEXT(walk);
	return(walk);
}

listptr disconnect_node(listptr root, listptr node)
{
	listptr tmp;

	tmp = root;
	if (PREV(node) != NULL)
		NEXT(PREV(node)) = NEXT(node);
	else
		tmp = NEXT(tmp);
	if (NEXT(node) != NULL)
		PREV(NEXT(node)) = PREV(node);
	PREV(node) = NULL;
	NEXT(node) = NULL;
	return(tmp);
}

listptr remove_node(listptr root, listptr node)
{
	root = disconnect_node(root, node);
	free(node);
	node = NULL;
	return(root);
}

int count_list(listptr root)
{
	if (root != NULL) return(1+count_list(NEXT(root)));
	else return(0);
}
