/*
 folder.c
 This file contains functions that handle the folder level of PTmail. Ie,
 everything that happens when you see the messages listed on your screen.
 Falke Bruinsma  (falke@innersource.com)
 February 18, 1994
*/
#include "mail.h"
#include <descrip.h>
#include <maildef.h>
#include <smgdef.h>
#include <smg$routines.h>
#include <ssdef.h>
#include <stdio.h>
#include <stdlib.h>
#include <nam.h>
#include <string.h>
#include <ctype.h>
#include <signal.h>

				/* Global variables to handle the windows */
extern long file_context, message_context, user_context, send_context;
extern long pboard_id, body_id, command_id, keyboard_id, error_id;
extern long full_screen_id, bottom_id, title_id, help1_id, help2_id;
extern long input_id;
				/* Global variable to a linked list */
extern alias_info *aliases;
extern alias_info *handle_aliases();
extern msg_entry *get_msgs();
extern msg_entry *clear_msgs();
extern int yesno();
extern void upcase();
extern void clear();
extern void paste();
extern void unpaste();
extern int get_string();
extern int get_number();
extern void send_mail();
extern void center();
extern void display_changefolder_commands();
extern void display_folder_help();
extern void display_commands();
extern void display_title();
extern void create_menu_from_msgs();
extern void handle_msgs();
extern void handle_profile();
extern int dump_msg();
extern long printfile();
extern int purge();
extern void mark();
extern void open_message();
extern void close_message();
extern void print();

/*
 folder_routine gets called by a VMS MAIL routine that reads in all the 
 folders. This routine will simply create a linked list of all the folders.
*/
int folder_routine(struct list *folders, struct dsc$descriptor *name)
{
  struct list *tmp;

  if (name->dsc$w_length) {
				/* Grab some memory */
    if ((tmp = malloc(sizeof(struct list))) == 0) {
      fprintf(stderr, "Memory allocation error [folder_routine]\n");
      exit(SS$_NORMAL);
    }
    tmp->next = 0;
    if ((tmp->foldername = malloc(name->dsc$w_length+1))==0) {
      fprintf(stderr, "Memory allocation error [folder_routine]\n");
      exit(SS$_NORMAL);
    }
                                /* Copy the foldername */
    strncpy(tmp->foldername, name->dsc$a_pointer, name->dsc$w_length);
    tmp->foldername[name->dsc$w_length] = '\0';
    tmp->message_count = 0;    /* And set the message counter to 0 */
    
    while (folders->next != NULL)
        folders= folders->next;
    folders->next = tmp;
  }				/* End of if (name->... */
  return(SS$_NORMAL);		/* Everything is cool.. */
}				/* End of folder_routine() */

int add_folder(struct list *folders, char *name)
{
  struct list *tmp;

  if (*name) {
				/* Grab some memory */
    if ((tmp = malloc(sizeof(struct list))) == 0) {
      fprintf(stderr, "Memory allocation error [folder_routine]\n");
      exit(SS$_NORMAL);
    }
    tmp->next = folders->next;
    if ((tmp->foldername = malloc(strlen(name)+1))==0) {
      fprintf(stderr, "Memory allocation error [folder_routine]\n");
      exit(SS$_NORMAL);
    }
                                /* Copy the foldername */
    strcpy(tmp->foldername, name);
    tmp->message_count = 0;    /* And set the message counter to 0 */
    
    folders->next = tmp;
  }				/* End of if (name->... */
  return(SS$_NORMAL);		/* Everything is cool.. */
}				/* End of folder_routine() */

/*
 read_folders will read in all the folders and return a pointer to the linked
 list of them 
*/
void read_folders(user_info *profile, struct list  *folders)
{
  long len1, len2;
  struct list *walk, *tmp;

  itemlist itmlst_folder[4];
  itemlist itmlst_message_in[3];
  itemlist itmlst_message_out[2];
  itemlist itmlst_mailfile[4];
  int status;

  len1 = len2 = 0;

  itmlst_folder[0].buffer_length         = 4;
  itmlst_folder[0].item_code             = MAIL$_MAILFILE_FOLDER_ROUTINE;
  itmlst_folder[0].buffer_address        = (void *) folder_routine;
  itmlst_folder[0].return_length_address = 0;
  itmlst_folder[1].buffer_length         = 4;
  itmlst_folder[1].item_code             = MAIL$_MAILFILE_USER_DATA;
  itmlst_folder[1].buffer_address        = 0;
  itmlst_folder[1].return_length_address = 0;
  itmlst_folder[2].buffer_length         = 0;
  itmlst_folder[2].item_code             = MAIL$_NOSIGNAL;
  itmlst_folder[2].buffer_address        = 0;
  itmlst_folder[2].return_length_address = 0;
  itmlst_folder[3].buffer_length         = 0;
  itmlst_folder[3].item_code             = 0;
  itmlst_folder[3].buffer_address        = 0;
  itmlst_folder[3].return_length_address = 0;

  itmlst_message_in[0].buffer_length         = 0;
  itmlst_message_in[0].item_code             = MAIL$_MESSAGE_FOLDER;
  itmlst_message_in[0].buffer_address        = 0;
  itmlst_message_in[0].return_length_address = 0;
  itmlst_message_in[1].buffer_length         = 0;
  itmlst_message_in[1].item_code             = MAIL$_NOSIGNAL;
  itmlst_message_in[1].buffer_address        = 0;
  itmlst_message_in[1].return_length_address = 0;
  itmlst_message_in[2].buffer_length         = 0;
  itmlst_message_in[2].item_code             = 0;
  itmlst_message_in[2].buffer_address        = 0;
  itmlst_message_in[2].return_length_address = 0;

  itmlst_message_out[0].buffer_length         = 4;
  itmlst_message_out[0].item_code             = MAIL$_MESSAGE_SELECTED;
  itmlst_message_out[0].buffer_address        = 0;
  itmlst_message_out[0].return_length_address = 0;
  itmlst_message_out[1].buffer_length         = 0;
  itmlst_message_out[1].item_code             = 0;
  itmlst_message_out[1].buffer_address        = 0;
  itmlst_message_out[1].return_length_address = 0;

  itmlst_mailfile[0].buffer_length         = 4;
  itmlst_mailfile[0].item_code             = MAIL$_MAILFILE_DELETED_BYTES;
  itmlst_mailfile[0].buffer_address        = 0;
  itmlst_mailfile[0].return_length_address = 0;
  itmlst_mailfile[1].buffer_length         = NAM$C_MAXRSS;
  itmlst_mailfile[1].item_code             = MAIL$_MAILFILE_WASTEBASKET;
  itmlst_mailfile[1].buffer_address        = 0;
  itmlst_mailfile[1].return_length_address = 0;
  itmlst_mailfile[2].buffer_length         = NAM$C_MAXRSS;
  itmlst_mailfile[2].item_code             = MAIL$_MAILFILE_RESULTSPEC;
  itmlst_mailfile[2].buffer_address        = 0;
  itmlst_mailfile[2].return_length_address = 0;
  itmlst_mailfile[3].buffer_length         = 0;
  itmlst_mailfile[3].item_code             = 0;
  itmlst_mailfile[3].buffer_address        = 0;
  itmlst_mailfile[3].return_length_address = 0;

  walk = folders->next;
  while (walk != NULL) {
    tmp = walk;
    walk = walk->next;
    free(tmp->foldername);
    free(tmp);
  }
  folders->next = 0;
				/* Fill the itemlist with requests for info */
  itmlst_folder[1].buffer_address = folders;
  itmlst_mailfile[0].buffer_address = &profile->deleted_bytes;
  itmlst_mailfile[1].buffer_address = profile->wastebasket;
  itmlst_mailfile[1].return_length_address = &len1;
  itmlst_mailfile[2].buffer_address = profile->result_spec;
  itmlst_mailfile[2].return_length_address = &len2;

  mail$mailfile_info_file(&file_context,itmlst_folder,itmlst_mailfile);

				/* Null terminate all returned strings */
  profile->wastebasket[len1] = profile->result_spec[len2] = 0;
  profile->total_folders = profile->total_messages = 0;
  tmp = folders;		/* get the front of the linked list */

  open_message();
  while (tmp->next) {		/* Are there still more folders? */
    tmp = tmp->next;		/* Ok get the next one */
				/* We want the number of msgs in each folder */
    itmlst_message_in[0].buffer_address = tmp->foldername;
    itmlst_message_in[0].buffer_length = strlen(tmp->foldername);
    itmlst_message_out[0].buffer_address = &tmp->message_count;

    status = mail$message_select(&message_context, itmlst_message_in,
      				itmlst_message_out);
    if (!vms_ok(mail$message_select(&message_context, itmlst_message_in,
       				itmlst_message_out))) {
         fprintf(stderr, "Error in mail$message_select [read_folders]\n");
         exit(SS$_NORMAL);
    }
				/* Save the number of msgs in wastebasket */
    if (!strcmp(profile->wastebasket, tmp->foldername))
      profile->waste_messages = tmp->message_count;
    profile->total_folders++;	/* Just some misc. counters to be saved */
    profile->total_messages+= tmp->message_count;
  }				/* End of while (tmp.. */
  close_message();
}				/* End of read_folders */

/*
 get_folder_name will display all the folders and if asked for the option
 of creating a new folder or typing in a filename.
 This will be used when you want to change folders, or when you want to
 save/move/copy a message to a folder or file
*/
int get_folder_name(user_info *profile, struct list *folders, char *temp,
  int allownew)
{
  char scratch[79];
  char *name;
  struct list *tmp;
  struct m_descriptor fmenu_list;
  int SMG_FLAG1, SMG_FLAG2;
  long select = 0, last = 0, counter;
  short terminator, rlen = 0;

  fmenu_list.length  = 0;
  fmenu_list.dtype   = 0;
  fmenu_list.class   = 0;
  fmenu_list.pointer = 0;
  fmenu_list.scale   = 0;
  fmenu_list.digits  = 0;
  fmenu_list.aflags  = 0;
  fmenu_list.dimct   = 0;
  fmenu_list.arsize  = 0L;
  fmenu_list.a0      = 0;
  fmenu_list.m1      = 0L;
  fmenu_list.l1      = 0L;
  fmenu_list.u1      = 0L;


START:				/* whats this? a goto label?? hmm :-) */
  fmenu_list.length = 79;
  fmenu_list.dtype = DSC$K_DTYPE_T;
  fmenu_list.class = DSC$K_CLASS_A;
				/* grab enough memory for the menu array */
  if ((fmenu_list.pointer = malloc((79+allownew) * profile->total_folders)) == 0) {
    fprintf(stderr, "Memory allocation error [change_folder]\n");
    exit(SS$_NORMAL);
  }				/* End of errorchecking */
				/* Clear the memory */
  memset(fmenu_list.pointer, 32, (79 * (allownew * 2 +profile->total_folders)));
  fmenu_list.scale = 0;
  fmenu_list.digits = 0;
  fmenu_list.aflags = 14 * 16;
  fmenu_list.dimct = 1;
  fmenu_list.arsize = (79 * (allownew * 2 + profile->total_folders));
  fmenu_list.a0 = fmenu_list.pointer - 79 - allownew;
  fmenu_list.m1 = profile->total_folders + allownew * 2;
  fmenu_list.l1 = 1;
  fmenu_list.u1 = profile->total_folders + allownew * 2;
  tmp = folders;		/* Head of the folder linked list */
  name = fmenu_list.pointer;
  if (allownew) {		/* User may create a new file/folder? */
    strcpy(name, "Filename...");
    name+= 79;
    strcpy(name, "New folder...");
    name+= 79;
  }				/* End of if (allown.. */
				/* Now do all the folders */
  for (counter = 0; counter < profile->total_folders; counter++) {
    tmp = tmp->next;		/* move to the next one */
				/* Create a new menu item in the array */
    if (tmp->message_count == 0) 
      sprintf(scratch, "%-12s (New Folder)\0", tmp->foldername, tmp->message_count);
    else
      sprintf(scratch, "%-12s (%2d Messages)\0", tmp->foldername, tmp->message_count);
    strcpy(name, scratch);
    name+= 79;			/* Move to the next array item */
  }				/* End of for (coun.. */
  if (profile->total_folders == 0) {	/* What no folders? */
    clear(&command_id);		/* Say something nice about.. */
    print(&command_id, "No folders found...", 1);
    sleep(2);
    return(0);
  }				/* End of if (profile.. */
  do {
    clear(&body_id);		/* clear the screen */
    display_changefolder_commands();	/* display commands on the bottom */
    SMG_FLAG1 = SMG$K_BLOCK;
    SMG_FLAG2 = SMG$M_FIXED_FORMAT;
    if (!vms_ok(smg$create_menu(&body_id,&fmenu_list,&SMG_FLAG1,&SMG_FLAG2))) {
      fprintf(stderr, "Error in smg$create_menu [get_folder_name]\n");
      exit(SS$_NORMAL);
    }				/* End of errorchecking */
    SMG_FLAG1 = SMG$M_RETURN_IMMED;
    smg$select_from_menu(&keyboard_id, &body_id, &select, &last,
			&SMG_FLAG1, 0, 0, &terminator);
    free(fmenu_list.pointer);  	/* Free the array */
    if (terminator == 82) {	/* "R" reread folders... */
      clear(&command_id);
      center(&command_id, "Reading folders... Please wait...", 1);
      read_folders(profile, folders);
      goto START;		/* See, you can use goto's in C :-) */  
    }				/* End of if (termin.. */
    if (terminator == 26 || terminator == 113 || terminator == 105)
      return(0);		/* CTRL-Z, "q" and "x" will return */
    last = select;		/* update the cursor position */
  } while (terminator != 13);  	/* And get next selection unless <enter> */
  if (allownew) {		/* If filename.. and new folder.. allowed */
    if (select == 1) {		/* If 1st one is selected (filename).. */
      clear(&input_id);		/* Create input window */
      paste(&input_id, 15, 1);
				/* Ask for a filename */
      if (!get_string("Enter filename to save message to: ", temp, &input_id, &rlen)) {
        unpaste(&input_id);	/* delete input window */
        return(0);		/* return 0, cuz something went wrong */
      }				/* End of if (!get_string */
      unpaste(&input_id);
      return(T_FILE);		/* Everything cool? say we got a file */
    } else		
    if (select == 2) {		/* If 2nd one is selected (new folder) */
      clear(&input_id);         /* Create input window */
      paste(&input_id, 15, 1);
                                /* Ask for a new folder name */
      if (!get_string("New folder name: ", temp, &input_id, &rlen)) {
        unpaste(&input_id);	/* delete input window */
        return(0);		/* return 0, cuz something went wrong */
      }	else			/* End of if (!get_string */
       unpaste(&input_id);
      upcase(temp, temp);	/* we only want upcase */
      add_folder(folders, temp);
      return(T_NEWFOLDER);
    } else {
      tmp = folders;		/* if not 1 or two it must be a foldername */
      for (counter = 0; counter < select - 2; counter++)
        tmp = tmp->next;	/* Go to the correct folder structure */
      strcpy(temp, tmp->foldername);	/* And copy the foldername */
    }				/* End of if (select.. else */
  } else {			/* End of if (allownew.. else */
    tmp = folders;		/* go to the head of linked list */
    for (counter = 0; counter < select; counter++)
      tmp = tmp->next;		/* go to the correct folders structure */
    strcpy(temp, tmp->foldername);	/* And copy the foldername */
  }   				/* End of if (allowne. else */
  return(T_FOLDER);		/* Return that we selected a folder */
}				/* End of get_folder_name */

int get_folder_name1(struct list *folders, char *temp, int allownew) 
{
  struct list *tmp = folders;
  int rlen;

  clear(&input_id);
  paste(&input_id, 15, 1);
  if (!get_string("Enter folder or filename: ", temp, &input_id, &rlen)) {
    unpaste(&input_id);
    return(0);
  }
  upcase(temp, temp);
  while (tmp->next) {
    if (!strcmp(tmp->foldername, temp)) return(T_FOLDER);
    tmp = tmp->next;
  }
  if (yesno(&input_id, "Folder doesn't exist, create one? [Y/n] ") == NO) {
    unpaste(&input_id);
    return(0);
  }
  unpaste(&input_id);
  return(T_FOLDER);
}

/*
 handle_folder handles everything that happens when the msgs (subject, from,
 etc) are displayed on the screen. Basically this is the main procedure of 
 PTMAIL
*/
short handle_folder(user_info *profile, struct list *folders, char *foldername,
   alias_info *aliases, int *changed)     
{
  int SMG_FLAG;
  char tempfolder[NAM$C_MAXRSS+1];
  msg_entry *msgs = 0, *tmp_msg;
  struct m_descriptor menu_list;
  short terminator, action = FALSE;
  long newmail=0, msg_count = 0, select = 0;
  long answer, result, temp, last= 1, status;

  menu_list.length  = 0;
  menu_list.dtype   = 0;
  menu_list.class   = 0;
  menu_list.pointer = 0;
  menu_list.scale   = 0;
  menu_list.digits  = 0;
  menu_list.aflags  = 0;
  menu_list.dimct   = 0;
  menu_list.arsize  = 0L;
  menu_list.a0      = 0;
  menu_list.m1      = 0L;
  menu_list.l1      = 0L;
  menu_list.u1      = 0L;


  if (!strcmp("NEWMAIL", foldername)) 
    newmail = 1;		/* Set flag, telling us we are in NEWMAIL */
  msgs = clear_msgs(msgs);
				/* Read in all the msgs */
  msgs = get_msgs(foldername, &msg_count);
				/* Display the title on the screen */
  display_title(foldername, msg_count);
				/* Create a menu from all the msgs */
  create_menu_from_msgs(&menu_list, msgs, msg_count);
  clear(&body_id);		/* Clear the screen */
  display_commands();	/* Display the commands at the bottom */
  do {
    if (msg_count > 0) {	/* are there msgs? then display them */
      SMG_FLAG = SMG$K_VERTICAL;
      if (!vms_ok(smg$create_menu(&body_id, &menu_list, &SMG_FLAG))) {
        fprintf(stderr, "Error in smg$create_menu [handle_folder]\n");
        exit(SS$_NORMAL);
      }				/* End of errorchecking */
				/* Get a menu selection */
      SMG_FLAG = SMG$M_RETURN_IMMED;
      status = smg$select_from_menu(&keyboard_id, &body_id, &select, &last,
                                    &SMG_FLAG, 0, 0, &terminator);
				/* Did user type a number 0..9? */
      if ((terminator >= 49) && (terminator <= 57)) {      
				/* if so, get the complete number */
        temp = get_number(terminator, msg_count);      
        if ((temp <= msg_count) && (temp > 0)) 
	  select = temp;	/* set current selection to that number */
      }				/* End of if ((termni.. */
      last = select;		/* update the cursor position */
      tmp_msg = msgs;		/* Go to the head of linked list */
      select--;
      while (select > 0) {	/* And select the current msgs structure */
        tmp_msg = tmp_msg->next;
        select--;
      }				/* End of while (... */
    }				/* End of if (msg_count > 0 */
    else 			/* no msgs? than just read a keypress */
     status = smg$read_keystroke(&keyboard_id, &terminator); 
    switch (terminator) {	/* what key was pressed? */
      case 42:			/* "*" jump to last message */
        last = msg_count;
        break;
      case 63:			/* "?"  help! */
        print(&command_id, "Help", 0);
        display_folder_help();
        break;
      case 26:                  /* CTRL-Z, exit */
      case 120:			/* "x" exit (save changes) */
        print(&command_id, "eXit", 0);
        action = EXIT;		/* Set action flag: exit the loop and purge */
        break;
      case 113:			/* "q" quit (dont save changes) */
        clear(&command_id);
        if (yesno(&command_id, "Are you sure you want to abandon all changes? [y/n] ") == YES)
          action = QUIT;	/* set action flag: exit the loop NO purge */
        else 
         display_commands();
        break;
      case 13:			/* <enter>  read */
        if (msg_count == 0) break; /* Make sure there is a message to read   */
        clear(&body_id); 	   /* Clear the screen and go handle the msg */
        handle_msgs(tmp_msg, profile, folders, &last,
		    &menu_list, msg_count, aliases, newmail);
        break;
      case 97:			/* "a" aliases */
				/* go do the alias stuff */
        aliases = handle_aliases(profile);
        clear(&body_id);
        display_title(foldername, msg_count);	/* display title again */
        display_commands();	/* display commands again */
        break;
      case 32:			/* <space>  unmark */
        if (msg_count > 0) {	/* Is there anything to unmark */
          mark(last, tmp_msg, &menu_list, 0);
          if (last < msg_count) last++;
        }
        break;
      case 99:			/* "c"  Change folder */
       print(&command_id, "Change folder", 0);
       action = EXIT;		/* exit loop and save all changes */
       break;
      case 112: 		/* "p" print message */
        if (msg_count == 0) break;	/* Any messages to print? */
        clear(&input_id);
        paste(&input_id, 15, 1);
        center(&input_id, "Preparing message to be queued for printing... Please wait...", 0);
				/* dumping the message to a file */
        if (!dump_msg(tmp_msg, "", TEMPPRINT, TRUE)) {
            print(&input_id, "Error opening temp file", 0);
            sleep(1);
            unpaste(&input_id);
            break;
        }			/* End of if (!dump_msg */
        if (!vms_ok(printfile(profile, TEMPPRINT))) {
            print(&input_id, "Error printing message", 0);
            sleep(1);
        } 			/* End of errorchecking */
        unpaste(&input_id);
        break;
      case 82:			/* "R" Reread folder */
        clear(&command_id);
        answer = yesno(&command_id, "Reread folder and update changes? [y/n] ");
        if (answer == YES) 
          action = EXIT;	/* ok, do a complete update (by exiting :)*/
        else display_commands();
        break;
      case 114:			/* "r" reply to message */
        if (msg_count == 0)  break;	/* Any messages to reply to? */
        clear(&input_id);
        paste(&input_id, 15, 1);
				/* dump the message to a file */
        if (!dump_msg(tmp_msg, profile->quote, TEMPFILE_IN, FALSE)) {
            print(&input_id, "Error opening temp file", 0);
            sleep(1);
            unpaste(&input_id);
            break;
        }			/* End of if (!dump_msg */
				/* send mail using the temp file */
        send_mail(profile, tmp_msg, aliases, tmp_msg->reply, REPLY);
        unpaste(&input_id);
        break;
      case 115:			/* "s" save message */
        if (msg_count == 0) break;
				/* get a file or foldername */
        result = get_folder_name(profile, folders, tempfolder, 1);
        if (result == T_FOLDER || result == T_NEWFOLDER) {
 				/* did we get a folder? */
          mark(last, tmp_msg, &menu_list, M_MOVE);
				/* save the destination */
          strcpy(tmp_msg->dest, tempfolder);
        } else			
        if (result == T_FILE) {		/* did we get a filename? */
				/* dump the message to the file */
          if (!dump_msg(tmp_msg, "", tempfolder, TRUE)) {
            print(&command_id, "Error opening temp file", 0);
            sleep(2);
          } else {
            print(&command_id, "Message succesfully saved", 0);
            sleep(1); 
          }			/* End of if(!dump.. else */
        }			/* End of if (result.. */
        display_commands();
        break; 
      case 100:			/* "d" delete */
        if (msg_count > 0) {  	/* is there something to delete? */           
          mark(last, tmp_msg, &menu_list, M_DEL);
          if (last < msg_count) last++;
        } 
        break;
      case 102:			/* "f" forward */
         if (msg_count == 0) break;	/* any msgs to forward? */
         clear(&input_id);
         paste(&input_id, 15, 1);
				/* Dump the message to a temp file */
         if (!dump_msg(tmp_msg, profile->quote, TEMPFILE_IN, TRUE)) {
            print(&input_id, "Error opening temp file", 0);
            sleep(2);
            unpaste(&input_id);
            break;
         }			/* End of if (!dump.. */
				/* Send mail using temp file */
         send_mail(profile, tmp_msg, aliases, "", FORWARD);
         unpaste(&input_id);
         break;
      case 109:			/* "m"  send mail */
         clear(&input_id);
         paste(&input_id, 15, 1);
				/* send a new mail message */
         send_mail(profile, tmp_msg, aliases, "", SEND);
         unpaste(&input_id);
         break;
      case 111:			/* "o" options */
         handle_profile(profile);	/* do the options menu */
         clear(&body_id);
         display_title(foldername, msg_count);	/* display title again */
         display_commands();		/* display commands again */
         break;
      case 117:			/* "u" undelete */
         if (msg_count > 0) {   /* is there something to undelete? */
          mark(last, tmp_msg, &menu_list, 0);
          if (last < msg_count) last++;
        }
        break;

    }				/* End of switch(terminator) */
  } while (action != EXIT && action != QUIT);	/* Are we supposed to exit? */
  free(menu_list.pointer);	/* Free the menu array */
  if (action == EXIT) 		/* Do we want to purge? */
    *changed = purge(msgs, profile, newmail);
  else *changed = FALSE;
  msgs = clear_msgs(msgs);
  return(terminator);		/* Return the last keypress */
}				/* End of handle_folder() */
