/*
 PTmail 

 Author: Falke Bruinsma
 Illinois Institute of Technology, Chicago, IL

 (as at 2-Feb-1996)
 falke@innersource.com
 P.O. box 1271
 Lombard, IL 60148


 This program replaces (at least to some degree) VAX/VMS MAIL. It is supposed
 to look and feel somewhat like Elm, however a few things are different. I 
 think the biggest difference is the fact that you exit PTmail with 'x' and
 not with 'q'uit at least when you want to save your changes. Elm is exactly
 the otherway around for who knows what reason.
 The previous version of PTmail was simply a 'wrap-around' for the MAIL program
 itself. Very clumsy but it worked to some degree. This version, is a complete
 rewrite of all MAIL routines and VAX/VMS MAIL is no longer used as a 
 foundation.

 NOTE: What Falke is trying to say above is that he found the excellent
       S-MAIL program by Michael N. LeVine of the Naval Weapons Centre,
       China Lake, California, USA. - which he then reorganised in a big
       way. (hey - credit where credit is due, yeah?)

 February 18, 1994	v3.0
   Initial coding done after 2 weekends. First weekend I worked from Friday
 night 6:00 til Sunday morning 10:00am _straight_. The second weekend I 
 only worked on Saturday from 10:00am til 9:00pm. After those two programming
 session the major layout of the program was done and I had people test it.
 One week later after fixing quite some bugs and optimizing the code I made
 it public.
 February 21, 1994	
  -Optimized screen redraws by deleting unnecessay info and just leaving
 the windows in the back blank. 
  -Added CTRL-Z as a nice way of exiting the program
  -Added a function to strip the garbage off the 'from' field when display
 the msgs in the folder
September 15, 1994	v4.0
  -bugs have been fixed.. one in particular that blew up the program
 when moving messages between different folders.
  -rewrite the part on how reread folder works.. (now I just exit the
  handlefolder and restart it with the same foldername)
  -If the "copy send", "copy reply" or "copy forward" flags are set you will 
 actually get a copy of the message send out
  -Distribution lists (@filename.ext) will work both at the To: and CC: prompt
  -(o)ptions menu is now listed in the help menu
  -When forwarding a message lines are wrapped correctly  
  -Messages marked as "D"eleted first and then "M"oved wot
 deleted
  -Removed unnecessary screen updates 
  -Internet aliases are handled correctly


L.Brennan@cchs.su.edu.au
27-July-1995           v4.1
  -fix all the appalling VAXC random/wild usage of "&" in just about
   any context! If in doubt - throw in an ampersand! Sends DECC and GCC
   'round the twist!
  -massive code cleanup, so DECC/ALPHA is now ok. On a VAX, GCC produces
   a 77 rather than 92 block .EXE, so my creaking VAX is happier too :-)
  -removed all the auto inits of structs so that DECC is happy too.
*/

#include "mail.h"
#include <descrip.h>
#include <maildef.h>
#include <smgdef.h>
#include <smg$routines.h>
#include <ssdef.h>
#include <stdio.h>
#include <stdlib.h>
#include <nam.h>
#include <string.h>
#include <ctype.h>

				/* Global variables used for the windows */
long file_context = 0, message_context = 0, user_context = 0, send_context = 0;
long pboard_id, body_id, command_id, keyboard_id, error_id, full_screen_id;
long bottom_id, title_id, help1_id, help2_id, input_id;
				/* Global variable pointing to a linked list */
alias_info *aliases=0;

extern void upcase();
extern void clear();
extern void center();
extern void purge_mail();
extern void read_profile();
extern void read_folders();
extern void read_aliases();
extern void delete_tempfiles();
extern void init_screen();
extern void restore_screen();
extern int get_folder_name();
extern short handle_folder();
extern void cursor_on();
extern void cursor_off();

/*
 close_message will close the MAIL file
*/
void close_message()
{
  itemlist null_list[1];

  null_list[0].buffer_length         = 0;
  null_list[0].item_code             = 0;
  null_list[0].buffer_address        = 0;
  null_list[0].return_length_address = 0;

  (void) mail$message_end(message_context, null_list, null_list);
  message_context = 0;
}                               /* End of close_message */

/*
 open_message will open the MAIL file and get the message context 
*/
void open_message()
{
  itemlist null_list[1];
  itemlist itmlst_begin[3];
  
  null_list[0].buffer_length         = 0;
  null_list[0].item_code             = 0;
  null_list[0].buffer_address        = 0;
  null_list[0].return_length_address = 0;

  itmlst_begin[0].buffer_length         = sizeof(file_context);
  itmlst_begin[0].item_code             = MAIL$_MESSAGE_FILE_CTX;
  itmlst_begin[0].buffer_address        = &file_context;
  itmlst_begin[0].return_length_address = 0;
  itmlst_begin[1].buffer_length         = 0;
  itmlst_begin[1].item_code             = MAIL$_NOSIGNAL;
  itmlst_begin[1].buffer_address        = 0;
  itmlst_begin[1].return_length_address = 0;
  itmlst_begin[2].buffer_length         = 0;
  itmlst_begin[2].item_code             = 0;
  itmlst_begin[2].buffer_address        = 0;
  itmlst_begin[2].return_length_address = 0;

  if (message_context != 0) close_message();
  mail$message_begin(&message_context, itmlst_begin, null_list);

}				/* End of open_message() */

/*
 open_mail will initialize all kinds of context variables used by the
 MAIL routines
*/
void open_mail()
{
  long indexed = 0;
  itemlist null_list[1];
  itemlist out_list[2];

  null_list[0].buffer_length         = 0;
  null_list[0].item_code             = 0;
  null_list[0].buffer_address        = 0;
  null_list[0].return_length_address = 0;

  if (!vms_ok(mail$mailfile_begin(&file_context, null_list, null_list))) {
    fprintf(stderr, "Error in mail$mailfile_begin [open_mail]\n");
    exit(SS$_NORMAL);
  }

  out_list[0].buffer_length         = sizeof(indexed);
  out_list[0].item_code             = MAIL$_MAILFILE_INDEXED;
  out_list[0].buffer_address        = &indexed;
  out_list[0].return_length_address = 0;
  out_list[1].buffer_length         = 0;
  out_list[1].item_code             = 0;
  out_list[1].buffer_address        = 0;
  out_list[1].return_length_address = 0;

  mail$mailfile_open(&file_context, null_list, out_list);
  mail$user_begin(&user_context, null_list, null_list);

}				/* End of open_mail() */


/*
 close_mail does the opposite of open_mail :-)
*/
void close_mail()
{ 
  itemlist null_list[1];

  null_list[0].buffer_length         = 0;
  null_list[0].item_code             = 0;
  null_list[0].buffer_address        = 0;
  null_list[0].return_length_address = 0;

  (void) mail$user_end(&user_context, null_list, null_list);
  (void) mail$mailfile_end(&file_context, null_list, null_list);
  (void) mail$mailfile_close(&file_context, null_list, null_list);
}				/* End of close_mail() */
    
/* 
 Main procedure which isnt actually the main function since the program
 itself evolves around the handle_folder function. 
   main()
       \-handle_folder()         
                     \-handle_msgs()
                                 \-read_msg()
*/
int main(int argc, char *argv[])
{
  struct list folders;
  char temp[NAM$C_MAXRSS+1];
  user_info profile;
  char foldername[NAM$C_MAXRSS+1];
  short terminator, changed = FALSE;

  folders.next = NULL;
  folders.foldername = (char) NULL;
  folders.message_count = 0;

  foldername[0] = (char) NULL;		/* Always put user in NEWMAIL */

  printf("Loading PTmail v%d.%d.%d\n",VER_MAJOR,VER_MINOR,VER_PATCH);
  printf("Opening mail file...");
  open_mail();
  printf("\r                                             \r");
  printf("Reading mail profile...");
  read_profile(&profile);
  printf("\r                                             \r");
  printf("Reading mail folders...");
  read_folders(&profile, &folders);
  printf("\r                                             \r");
  printf("Reading alias file...");
  read_aliases();
  printf("\r                                             \r");
  delete_tempfiles();		/* Delete possible old temp files */
  init_screen(&profile);	/* Create all virtual windows etc */
  cursor_off(); 		/* Turn the cursor off */
  if (profile.new_messages == 0) 
    strcpy(foldername, "MAIL");	/* If there is no newmail go to MAIL */
  else 
    strcpy(foldername, "NEWMAIL");
  if (argc > 1) 		/* if an arguament is giving.. */
    upcase(foldername, argv[1]);	/* .. then use that folder */
  do {
   open_message();
				/* get commands and do stuff :) */
   terminator = handle_folder(&profile, &folders, foldername, aliases, &changed);
   switch (terminator) {	/* What key got returned? */
    case 99: 			/* "c" Change folder */
      if (changed) {
         clear(&command_id);
         center(&command_id, "Reading folders... Please Wait");
         read_folders(&profile, &folders);
      }
				/* get a new foldername */
      if (get_folder_name(&profile,&folders, temp, 0)) 
        strcpy(foldername, temp);
      break;
    case 82:			/* "R" reread, use same folder */
     break;
   }				/* End of switch(.. */
  } while ((terminator != 113) && 	/* quit */
          (terminator != 120) &&       	/* exit */
          (terminator != 26));		/* CTRL-Z */
  cursor_on();			/* Turn the cursor back on */
  restore_screen();		/* Clear the screen */
  if (profile.auto_purge && profile.waste_messages > 10)
    purge_mail();
  close_mail();
}				/* End of main() */
