/* MAIL.H */

#include "version.h"
#include "userdef.h"

#include <descrip.h>
#include <nam.h>

extern int mail$message_begin();
extern int mail$message_end();
extern int mail$message_select();
extern int mail$message_get();
extern int mail$message_copy();
extern int mail$message_info();
extern int mail$mailfile_begin();
extern int mail$mailfile_end();
extern int mail$mailfile_open();
extern int mail$mailfile_close();
extern int mail$mailfile_compress();
extern int mail$mailfile_purge_waste();
extern int mail$mailfile_info_file();
extern int mail$user_begin();
extern int mail$user_end();
extern int mail$user_get_info();
extern int mail$user_set_info();
extern int mail$send_begin();
extern int mail$send_end();
extern int mail$send_abort();
extern int mail$send_add_address();
extern int mail$send_add_attribute();
extern int mail$send_add_bodypart();
extern int mail$send_message();

extern int edt$edit();
extern int tpu$tpu();

#define MAIL$_NOMOREREC 8314792
#define MAIL$_NOTEXIST 8290522
#define MAIL$_NOMOREMSG 8290386
#define MAIL$_NOSUCHUSR 8290346
#define MAIL$_USERSPEC 8290402

#define TEMPFILE_IN "sys$scratch:ptmail$temp_in.tmp"
#define TEMPFILE_OUT "sys$scratch:ptmail$temp_out.tmp"
#define TEMPPRINT "sys$scratch:ptmail$temp_print.tmp"
#define ALIASFILE "sys$login:ptmail.alias"
#define INITFILE "sys$login:ptmail.ini"
#define TEMPINIT "sys$scratch:ptmail$ini.tmp"

	/* True and false definitions */
#define TRUE	1
#define FALSE	0
#define YES     1
#define NO      0

        /* Different types returned by get_folder_name */
#define T_FILE   1
#define T_FOLDER 2 
#define T_NEWFOLDER 3

	/* Different ways to exit a folder, exit = save changes, quit = dont */
#define EXIT	1
#define QUIT    2
#define UPDATE  4

	/* Flags for a message */
#define M_UNSEL 1
#define M_SEL   2
#define M_DEL   4
#define M_MOVE  8
#define M_COPY  16
#define M_READ  32

	/* types of message to send out */
#define SEND	1
#define REPLY   2
#define FORWARD 3

#define setit(n, mask)          n |= mask
#define clearit(n, mask)        n &= ~mask

#define vms_ok(x) ((x) & 1)

#define VMSFUNC unsigned int


#if defined(USEVARIANTS) /* VARIANTs are possible with DECC and VAXC, but  */
                         /* hardly 'portable' in the normal "C" sense, so  */
                         /* not used. (and GCC just gets angry)            */
typedef struct {
  variant_union {
   variant_struct {
     short unsigned int buf_len;
     short unsigned int item_code;
   } first2;
     long unsigned int end;
  } lencode_or_end;
    char *buf_addr;
    unsigned int *ret_len_addr;
} vms_item;

#else

typedef struct {
  short unsigned int buf_len;
  short unsigned int item_code;
  char *buf_addr;
  unsigned int *ret_len_addr;
} vms_item;

#endif /* USEVARIANTS */

typedef struct {
  short buffer_length;
  short item_code;
  void *buffer_address;
  long *return_length_address;
} itemlist;

struct list {
  struct list *next;
  char *foldername;
  long message_count;
};

typedef struct {
  long deleted_bytes;
  long total_folders;
  long total_messages;
  long auto_purge;
  long cc_prompt;
  long copy_forward;
  long copy_reply;
  long copy_send;
  short new_messages;
  short waste_messages;
  char wastebasket[NAM$C_MAXRSS+1];
  char result_spec[NAM$C_MAXRSS+1];
  char editor[NAM$C_MAXRSS+1];
  char forwarding[NAM$C_MAXRSS+1];
  char form[NAM$C_MAXRSS+1];
  char full_dir[NAM$C_MAXRSS+1];
  char personal_name[NAM$C_MAXRSS+1];
  char queue[NAM$C_MAXRSS+1];
  char sub_dir[NAM$C_MAXRSS+1];
  char username[NAM$C_MAXRSS+1];
  char quote[NAM$C_MAXRSS+1];
  char editini[NAM$C_MAXRSS+1];
  char sigfile[NAM$C_MAXRSS+1];
  int addsig;
  int novice;
} user_info;

struct m_descriptor {
  short length;
  char dtype;
  char class;
  char *pointer;
  char scale;
  char digits;
  char aflags;
  char dimct;
  long arsize;
  char *a0;
  long m1;
  long l1;
  long u1;
};

typedef struct {
  short len;
  short type;
  char *addr;
} s_desc;

typedef struct msg_entry {
  struct msg_entry *prev;
  struct msg_entry *next;
  long id;
  long size;
  char date[NAM$C_MAXRSS+1];
  char from[NAM$C_MAXRSS+1];
  char reply[NAM$C_MAXRSS+1];
  char subject[NAM$C_MAXRSS+1];
  char dest[NAM$C_MAXRSS+1];
  long flags;
} msg_entry;


typedef struct alias_info {
  struct alias_info *next;
  char alias[21];
  char trans[61];
} alias_info;

