 /*I   msgs.c  This file contains all kinds of routines having to do with mail            messages themselves.(   Falke Bruinsma (falke@innersource.com)   February 18, 1994  */ #include "mail.h"  #include <descrip.h> #include <maildef.h> #include <smgdef.h>  #include <smg$routines.h>  #include <ssdef.h> #include <nam.h> #include <lib$routines.h>  #include <stdio.h> #include <stdlib.h>  #include <string.h>  #include <ctype.h> #include <signal.h>  #include <unixio.h>   - 				/* Global variables for screen handles */ F extern long file_context, message_context, user_context, send_context;B extern long pboard_id, body_id, command_id, keyboard_id, error_id;C extern long full_screen_id, bottom_id, title_id, help_id, input_id; * 				/* Global variable pointer to llist */ extern alias_info *aliases;    extern int yesno();  extern void upcase();  extern void clear(); extern void paste(); extern void unpaste(); extern int get_string(); extern void display_commands();  extern long printfile(); extern void mark();  extern int get_folder_name();  extern void center();  extern void cursor_off();  extern void cursor_on();  extern void display_msgs_help(); extern int add_sig();  extern void open_message();  extern void find_alias();  extern long spell(); extern long movefile();  extern long copyfile();  extern void print();    O void write_to_file(FILE *f, char *quote, char *orig_str, int *asked, int *wrap)  {  char *lstr = orig_str; char *p;  "         while( strlen(lstr) > 75 )	         {                   if (!(*asked)) {n                   if (yesno(&input_id, "Some lines are too long. Would you like them wrapped? [y/n] ") == NO)                      (*asked)=1;                    else {                     (*wrap)=1;                     (*asked)=1;                    } +                 } else if (!(*wrap)) break;                  p = &lstr[74];:                 if( *p == ' ' || *p == '\t' || p == lstr )                 { &                         *(p++) = '\0';                 }                  else                 { K                         while( *(--p) != ' ' && *p != '\t' && p != lstr ) ; '                         if( p == lstr )                          { %                         char tmp[80]; 7                                 strncpy(tmp, lstr, 75); /                                 tmp[75] = '\0'; A                                 fprintf(f, "%s%s\n", quote, tmp); 1                                 lstr = &lstr[75]; )                                 continue;                          }   &                         *(p++) = '\0';                 }   @                 /* Skip over leading whitespace of next line. */5                 while( *p == ' ' || *p == '\t' ) p++; 2                 fprintf(f, "%s%s\n", quote, lstr);                 lstr = p; 	         } )         fprintf(f, "%s%s\n",quote, lstr);  }      /*  K  dump_msg will get a message from VMS MAIL by using the message_id and then M  dump it into a given file. It has the option to leave out the headers and/or #  put a quote in front of the lines.  */S int dump_msg(msg_entry *message_data, char *quote, char *filename, int showheaders)  {    char message[NAM$C_MAXRSS+1];    long len, total = 0;
   FILE *f;   int asked = 0, wrap = 0;     itemlist null_list[1];   itemlist itmlst_select[2];   itemlist itmlst_in[2];   itemlist itmlst_out[2];   )   null_list[0].buffer_length         = 0; )   null_list[0].item_code             = 0; )   null_list[0].buffer_address        = 0; )   null_list[0].return_length_address = 0;   -   itmlst_select[0].buffer_length         = 4; <   itmlst_select[0].item_code             = MAIL$_MESSAGE_ID;=   itmlst_select[0].buffer_address        = &message_data->id; -   itmlst_select[0].return_length_address = 0; -   itmlst_select[1].buffer_length         = 0; -   itmlst_select[1].item_code             = 0; -   itmlst_select[1].buffer_address        = 0; -   itmlst_select[1].return_length_address = 0;   -   itmlst_in[0].buffer_length             = 0; B   itmlst_in[0].item_code                 = MAIL$_MESSAGE_CONTINUE;-   itmlst_in[0].buffer_address            = 0; -   itmlst_in[0].return_length_address     = 0; -   itmlst_in[1].buffer_length             = 0; -   itmlst_in[1].item_code                 = 0; -   itmlst_in[1].buffer_address            = 0; -   itmlst_in[1].return_length_address     = 0;   9   itmlst_out[0].buffer_length             = NAM$C_MAXRSS; A   itmlst_out[0].item_code                 = MAIL$_MESSAGE_RECORD; 4   itmlst_out[0].buffer_address            = message;1   itmlst_out[0].return_length_address     = &len; .   itmlst_out[1].buffer_length             = 0;.   itmlst_out[1].item_code                 = 0;.   itmlst_out[1].buffer_address            = 0;.   itmlst_out[1].return_length_address     = 0;  N   if (!vms_ok(mail$message_get(&message_context, itmlst_select, null_list))) {>     fprintf(stderr, "Error in mail$message_get [dump_msg]\n");     exit(SS$_NORMAL);    } $ 				/* Open a file to write to... */#   if (!(f = fopen(filename, "w")))       return(0);& 				/* Get each line in the message */C   while (mail$message_get(&message_context, itmlst_in, itmlst_out)            != MAIL$_NOMOREREC) {?     if ((total <= 5) && 	/* Skip 1st 5 lines and all headers */ P         ((strstr(message, "Return-path:")) || (strstr(message, "Received:"))) &&         !showheaders) { ;       while (len != 0) {	/* until there is an empty line */ E         if (mail$message_get(&message_context, itmlst_in, itmlst_out) #          == MAIL$_NOMOREREC) break;        }      } else {0       total++;			/* increase the line counter */3       message[len] = 0;		/* Truncate the message */ 3 				/* And print it to the file with a insertion */ T       if (total > 5 || showheaders) write_to_file(f, quote, message, &asked, &wrap);%     }				/* End of if ((tota..else */    }				/* End of while... */*   fclose(f);			/* Close the output file */'   return(1);			/* And return an 'ok' */  }    /*  K  read_msg will display a message to the screen and return a terminator code K  if the keypressed was something else than space or if we are at the end of    the message that we are reading */  R int read_msg(msg_entry *message_data, long last, long msg_count, short showheader) {    char MSGTEXT_A[76];    char MSGTEXT_B[76];      int SMG_FLAG1, SMG_FLAG2; )   char message[NAM$C_MAXRSS+1], work[81]; %   long line_counter = 0, status, len;    short terminator = 0;    s_desc s_message;    s_desc s_work;   int ONE = 1;   itemlist null_list[1];   itemlist itmlst_select[2];   itemlist itmlst_in[2];   itemlist itmlst_out[2];   f   strcpy(MSGTEXT_A, "<Message %ld/%ld> -- <End of msg> -- spacebar)next msg,  q)uit, s)ave, ?)help" );h   strcpy(MSGTEXT_B, "<Message %ld/%ld> -- <Line %ld/%ld> -- spacebar)next page, q)uit, s)ave, ?)help" );  )   null_list[0].buffer_length         = 0; )   null_list[0].item_code             = 0; )   null_list[0].buffer_address        = 0; )   null_list[0].return_length_address = 0;      s_message.len  = 0;    s_message.type = 0;    s_message.addr = message;      s_work.len  = 0;   s_work.type = 0;   s_work.addr = work;   -   itmlst_select[0].buffer_length         = 4; <   itmlst_select[0].item_code             = MAIL$_MESSAGE_ID;=   itmlst_select[0].buffer_address        = &message_data->id; -   itmlst_select[0].return_length_address = 0; -   itmlst_select[1].buffer_length         = 0; -   itmlst_select[1].item_code             = 0; -   itmlst_select[1].buffer_address        = 0; -   itmlst_select[1].return_length_address = 0;   N   if (!vms_ok(mail$message_get(&message_context, itmlst_select, null_list))) {>     fprintf(stderr, "Error in mail$message_get [read_msg]\n");     exit(SS$_NORMAL);    }     )   itmlst_in[0].buffer_length         = 0; >   itmlst_in[0].item_code             = MAIL$_MESSAGE_CONTINUE;)   itmlst_in[0].buffer_address        = 0; )   itmlst_in[0].return_length_address = 0; )   itmlst_in[1].buffer_length         = 0; )   itmlst_in[1].item_code             = 0; )   itmlst_in[1].buffer_address        = 0; )   itmlst_in[1].return_length_address = 0;   5   itmlst_out[0].buffer_length         = NAM$C_MAXRSS; =   itmlst_out[0].item_code             = MAIL$_MESSAGE_RECORD; 0   itmlst_out[0].buffer_address        = message;-   itmlst_out[0].return_length_address = &len; *   itmlst_out[1].buffer_length         = 0;*   itmlst_out[1].item_code             = 0;*   itmlst_out[1].buffer_address        = 0;*   itmlst_out[1].return_length_address = 0;       do {3 				/* Ok, lets get the next line of the message */ G     status = mail$message_get(&message_context, itmlst_in, itmlst_out); <     if (status == MAIL$_NOMOREREC) {	/* No more messages? */;       if (line_counter != 0) {		/* Print the status line */          memset(work, 0, 80);1         sprintf(work,MSGTEXT_A, last, msg_count); "         s_work.len = strlen(work);%         SMG_FLAG1 = SMG$M_ERASE_LINE;  	SMG_FLAG2 = SMG$M_REVERSE; L         smg$put_chars(&bottom_id,&s_work,&ONE,&ONE,&SMG_FLAG1,0,&SMG_FLAG2);6         smg$read_keystroke(&keyboard_id, &terminator);"       }				/* End of if (line.. */;       return(terminator);	/* Return the last key pressed */ "     }				/* End of if (status.. */P     if ((line_counter == 5) && strstr(message, "Return-path:") && !showheader) {E       while (len != 0) {	/* skip all headers if thats what we want */ E         if (mail$message_get(&message_context, itmlst_in, itmlst_out) #          == MAIL$_NOMOREREC) break;        } -     } else {			/* otherwise print the line */        s_message.len = len;6       line_counter++;		/* increase the line counter */I       if (len > 80) line_counter++;	/* if it wraps it is an extra line */ "       SMG_FLAG1 = SMG$M_WRAP_WORD;F       smg$put_line(&full_screen_id, &s_message, 0, 0, 0, &SMG_FLAG1); D       if (line_counter % 22 == 0) {	/* do we have a full screen?? */         memset(work, 0, 80);r         sprintf(work, MSGTEXT_B, last, msg_count, line_counter, message_data->size+5);	/* add header+empty line */"         s_work.len = strlen(work);%         SMG_FLAG1 = SMG$M_ERASE_LINE;     	SMG_FLAG2 = SMG$M_REVERSE;L         smg$put_chars(&bottom_id,&s_work,&ONE,&ONE,&SMG_FLAG1,0,&SMG_FLAG2);6         smg$read_keystroke(&keyboard_id, &terminator);J         if (terminator != 32) {	/* If anything else than <space> return */           return(terminator); 	         } &       }				/* End of if (line_cou.. */'     }				/* End of if (status.. else */ )   } while (1);			/* Just keep going... */   }				/* End of read_message() */   /*K  get_msgs will take a foldername and return a pointer to a linked list with   all the messages in it. */6 msg_entry *get_msgs(char *foldername, long *msg_count) {    itemlist itmlst_folder_in[3];     itemlist itmlst_folder_out[2];   itemlist itmlst_message[7]; "   itemlist itmlst_next_message[3];     long counter, status; +   msg_entry *tmp_msg, *last_msg, *msgs = 0;      A   itmlst_folder_in[0].buffer_length         = strlen(foldername); C   itmlst_folder_in[0].item_code             = MAIL$_MESSAGE_FOLDER; 9   itmlst_folder_in[0].buffer_address        = foldername; 0   itmlst_folder_in[0].return_length_address = 0;0   itmlst_folder_in[1].buffer_length         = 0;=   itmlst_folder_in[1].item_code             = MAIL$_NOSIGNAL; 0   itmlst_folder_in[1].buffer_address        = 0;0   itmlst_folder_in[1].return_length_address = 0;0   itmlst_folder_in[2].buffer_length         = 0;0   itmlst_folder_in[2].item_code             = 0;0   itmlst_folder_in[2].buffer_address        = 0;0   itmlst_folder_in[2].return_length_address = 0;  1   itmlst_folder_out[0].buffer_length         = 4; F   itmlst_folder_out[0].item_code             = MAIL$_MESSAGE_SELECTED;9   itmlst_folder_out[0].buffer_address        = msg_count; 1   itmlst_folder_out[0].return_length_address = 0; 1   itmlst_folder_out[1].buffer_length         = 0; 1   itmlst_folder_out[1].item_code             = 0; 1   itmlst_folder_out[1].buffer_address        = 0; 1   itmlst_folder_out[1].return_length_address = 0;      open_message(); C   status = mail$message_select(&message_context, itmlst_folder_in,       				itmlst_folder_out); 8   if ((status == MAIL$_NOTEXIST) || (*msg_count == 0)) {3     *msg_count = 0;		/* What? no msgs??? Oh well */      return(0);   }				/* End of if (statu.. */    if (!vms_ok(status)) {B     fprintf(stderr, "Error in mail$message_select [msg_entry]\n");     exit(SS$_NORMAL);    } 9   last_msg = 0;			/* Let loop through all the messages */ 6   for (counter = 0; counter < *msg_count; counter++) {5     if ((tmp_msg = malloc(sizeof(msg_entry))) == 0) { ?       fprintf(stderr, "Memory allocation error [msg_entry]\n");        exit(SS$_NORMAL);      } *     memset(tmp_msg, 0, sizeof(msg_entry));  0     itmlst_message[0].buffer_length         = 4;G     itmlst_message[0].item_code             = MAIL$_MESSAGE_CURRENT_ID; ;     itmlst_message[0].buffer_address        = &tmp_msg->id; 0     itmlst_message[0].return_length_address = 0;;     itmlst_message[1].buffer_length         = NAM$C_MAXRSS; A     itmlst_message[1].item_code             = MAIL$_MESSAGE_DATE; <     itmlst_message[1].buffer_address        = tmp_msg->date;0     itmlst_message[1].return_length_address = 0;0     itmlst_message[2].buffer_length         = 4;A     itmlst_message[2].item_code             = MAIL$_MESSAGE_SIZE; =     itmlst_message[2].buffer_address        = &tmp_msg->size; 0     itmlst_message[2].return_length_address = 0;;     itmlst_message[3].buffer_length         = NAM$C_MAXRSS; A     itmlst_message[3].item_code             = MAIL$_MESSAGE_FROM; <     itmlst_message[3].buffer_address        = tmp_msg->from;0     itmlst_message[3].return_length_address = 0;;     itmlst_message[4].buffer_length         = NAM$C_MAXRSS; G     itmlst_message[4].item_code             = MAIL$_MESSAGE_REPLY_PATH; =     itmlst_message[4].buffer_address        = tmp_msg->reply; 0     itmlst_message[4].return_length_address = 0;;     itmlst_message[5].buffer_length         = NAM$C_MAXRSS; D     itmlst_message[5].item_code             = MAIL$_MESSAGE_SUBJECT;?     itmlst_message[5].buffer_address        = tmp_msg->subject; 0     itmlst_message[5].return_length_address = 0;0     itmlst_message[6].buffer_length         = 0;0     itmlst_message[6].item_code             = 0;0     itmlst_message[6].buffer_address        = 0;0     itmlst_message[6].return_length_address = 0;  5     itmlst_next_message[0].buffer_length         = 0; F     itmlst_next_message[0].item_code             = MAIL$_MESSAGE_NEXT;5     itmlst_next_message[0].buffer_address        = 0; 5     itmlst_next_message[0].return_length_address = 0; 5     itmlst_next_message[1].buffer_length         = 0; B     itmlst_next_message[1].item_code             = MAIL$_NOSIGNAL;5     itmlst_next_message[1].buffer_address        = 0; 5     itmlst_next_message[1].return_length_address = 0; 5     itmlst_next_message[2].buffer_length         = 0; 5     itmlst_next_message[2].item_code             = 0; 5     itmlst_next_message[2].buffer_address        = 0; 5     itmlst_next_message[2].return_length_address = 0;    				/* get the info! yeah... */ F     status = mail$message_info(&message_context, itmlst_next_message,        				itmlst_message);#     if (status == MAIL$_NOMOREMSG)  A       counter = *msg_count;	/* no more msgs? ok, we are done.. */ 
     else {       if (!vms_ok(status)) {D         fprintf(stderr, "Error in mail$message_info [msg_entry]\n");         exit(SS$_NORMAL);        }				/* if (!vms_ok... */ /       if (msgs == 0) msgs = last_msg = tmp_msg; 2       else {			/* Add it all to the linked list */!         tmp_msg->prev = last_msg; !         last_msg->next = tmp_msg;          last_msg = tmp_msg; $       }				/* if (msgs == 0) else */     }				/* if (status ==... */    }				/* for (counter... */   return(msgs);   }    				/* End of get_msgs() */   /*H  create_menu_from_msgs will creates an array of menu items from the msgs!  linked list created by get_msgs.  */L void create_menu_from_msgs(struct m_descriptor *menu_list, msg_entry *msgs,    long msg_count)  {    char *tmp_list;    char marked;   msg_entry *tmp_msg;    int counter;     menu_list->length = 79; #   menu_list->dtype = DSC$K_DTYPE_T; #   menu_list->class = DSC$K_CLASS_A; ) 				/* Get enough memory for the array */ ;   if ((menu_list->pointer = malloc(79 * msg_count)) == 0) { L     fprintf(stderr, "Memory allocation error in [create_menu_from_msgs]\n");     exit(SS$_NORMAL);    } 3   memset(menu_list->pointer, 32, (79 * msg_count));    menu_list->aflags = 14 * 16;   menu_list->dimct = 1; %   menu_list->arsize = 79 * msg_count; *   menu_list->a0 = menu_list->pointer - 79;   menu_list->m1 = msg_count;   menu_list->l1 = 1;   menu_list->u1 = msg_count;    tmp_list = menu_list->pointer;   tmp_msg = msgs; + 				/* Add all the messages to the array */ 5   for (counter = 0; counter < msg_count; counter++) { G     switch (tmp_msg->flags) {	/* Set the flag to the right character */        case M_SEL: marked = '*';                    break;        case M_MOVE: marked = 'M';                    break;         case M_DEL:  marked = 'D';                    break;         case M_COPY: marked = 'C';                    break;        default: marked = ' ';     } % 				/* Add everything to the array */ L     sprintf(tmp_list, "%c%3d %-20.20s %-11.11s %-40.40s", marked, counter+1,6       tmp_msg->from, tmp_msg->date, tmp_msg->subject);@     tmp_list+= 79;		/* And move to the next item in the array */I     tmp_msg = tmp_msg->next;	/* And move to the next msg in the llist */     }				/* for (counter.. */ ) }				/* End of create_menu_from_msgs() */    /*  K  yes_send gets called each time a message is succesfully sent by VMS MAIL.     It will simply print a message. */ int yes_send(s_desc *name) {    char message[300];   s_desc output;   char SUCCESS[25];   -   strcpy(SUCCESS,"Success sending mail to ");   0   memset(message, 0, 80);	/* Clear the string */   strcpy(message, SUCCESS); *   strncat(message, name->addr, name->len);>   output.type = 0;		/* set up yet another descriptor *sigh* */   output.addr = &message[0];#   output.len = strlen(&message[0]); @   smg$put_line(&input_id, &output);	/* Print it to the screen */   return(SS$_NORMAL);  }				/* End of yes_send() */   /*I  no_send gets called each time a message is succesfully sent by VMS MAIL.    It will simply print a message. */ int no_send(s_desc *name)  {    char message[300];   s_desc output;   char FAILURE[25];   -   strcpy(FAILURE,"Failure sending mail to ");   0   memset(message, 0, 80);	/* Clear the string */   strcpy(message, FAILURE); *   strncat(message, name->addr, name->len);7   output.type = 0;		/* Damn descriptors, I hate them */    output.addr = &message[0];#   output.len = strlen(&message[0]); A   smg$put_line(&input_id, &output);	/* Ok, display the message */    return(SS$_NORMAL);  }				/* End of no_send() */    /*  I  fix_address will return a correct VMS MAIL address, Ie. it makes sure it K  has the GATEWAY::" " carrier if it wasnt given... guess thats about it. :)  */ char *fix_address(char *to)  { 
   char *test; (   test = (char *)malloc(NAM$C_MAXRSS+1);     strcpy(test, to); ?   upcase(test);  		/* Leave original CASE alone! (29-Jan-96) */ . 				/* Is it an internet address and no ""? */  >   if (strchr((test), '@') && !strstr(test, INTERNET_MAILER)) {-      sprintf(test, INTERNET_MAILER_ADDR, to); 0      return(test);		/* And return the results */   } 8   return(to);			/* Return the original, address is ok */ }				/* End of fix_address() */    /*  J  add_user_to_list will simply add another recipient to VMS MAIL's outgoingJ  list. It updates the counter if the recipient was ok. There are two kindsB  of recipients.. those who are in the "to" field and "cc" field..  */8 void add_user_to_list(char *to, long *count, short flag) { 2   char temp[NAM$C_MAXRSS+1], work[NAM$C_MAXRSS+1];   itemlist null_list[1];   itemlist add_to_in[4];   long status;  )   null_list[0].buffer_length         = 0; )   null_list[0].item_code             = 0; )   null_list[0].buffer_address        = 0; )   null_list[0].return_length_address = 0;      strcpy(temp, to);  				/* Set up the itemlist */ )   add_to_in[0].buffer_length         = 2; @   add_to_in[0].item_code             = MAIL$_SEND_USERNAME_TYPE;-   add_to_in[0].buffer_address        = &flag; )   add_to_in[0].return_length_address = 0; 4   add_to_in[1].buffer_length         = strlen(temp);;   add_to_in[1].item_code             = MAIL$_SEND_USERNAME; ,   add_to_in[1].buffer_address        = temp;)   add_to_in[1].return_length_address = 0; )   add_to_in[2].buffer_length         = 0; 6   add_to_in[2].item_code             = MAIL$_NOSIGNAL;)   add_to_in[2].buffer_address        = 0; )   add_to_in[2].return_length_address = 0; )   add_to_in[3].buffer_length         = 0; )   add_to_in[3].item_code             = 0; )   add_to_in[3].buffer_address        = 0; )   add_to_in[3].return_length_address = 0;   F   status = mail$send_add_address(&send_context, add_to_in, null_list);A   if (status == MAIL$_NOSUCHUSR) {	/* What? user doesnt exist? */ ,     sprintf(work, "No such user: %s", temp);=     print(&input_id, work, 1);		/* disply the complaint :) */ .   } else			/* What did we get a bogus name? */!   if (status == MAIL$_USERSPEC) { 6     sprintf(work, "Bad user specification: %s", temp);C     print(&input_id, work, 1);	/* Make sure we let the user know */ 
   } else { 				/* Otherwise */      if (!vms_ok(status)) {M       fprintf(stderr, "Error in mail$send_add_address [add_user_to_list]\n"); 5       fprintf(stderr, "Invalid address: %s\n", temp);        exit(SS$_NORMAL);      } D     (*count)++;                 /* number of valid recipients + 1 */    }				/* End of if (..) else */$ }				/* End of add_user_to_list() */   /*K  handle_dist_list will take a filename and all the people from that list to   the recipients list.  */> void handle_dist_list(char *filename, long *count, short flag) { 
   FILE *f;0   char temp[NAM$C_MAXRSS+1], to[NAM$C_MAXRSS+1];  8   if (!(f = fopen(filename, "r"))) {	/* Open the file */D     sprintf(temp, "Could not open distribution list: %s", filename);<     print(&command_id, temp, 1);	/* Give an error message */
     sleep(1);      return; #   }				/* End of if (!(f = fop.. */ @   while (fgets(to, NAM$C_MAXRSS, f)) { 	/* Get the first line */1     to[strlen(to)-1] = 0;	/* get rid of the \n */ - 				/* Add the user to the recipients list */ 3     add_user_to_list(fix_address(to), count, flag);    }				/* End of while.. */ #   fclose(f);			/* close the file */ " }				/* End of handle_dist_list */   /*H  parse_users will take a string with recipients seperated by commas and $  add them all to the recipient list  */< int parse_users(char *work, short flag, alias_info *aliases) { !   char *to, temp[NAM$C_MAXRSS+1];    long count=0, first=0;  8   to = strtok(work, ", ");	/* Get the first recipient */-   if (to == 0) return(0);	/* No usernames! */ ;   while (to != 0) {		/* There are still more recipients? */ >     find_alias(aliases, to, to);	/* Check if it is an alias */<     strcpy(temp, fix_address(to));	/* Fix the IN%"" stuff */%     while (to[first] == ' ') first++; <     if (to[first] == '@') 	/* What? this is a dist. list? */H       handle_dist_list(to+1, &count, flag);	/* than get all the names */3     else			/* Otherwise add the user to the list */ +       add_user_to_list(temp, &count, flag); 7     to = strtok(NULL, ",");	/* Get the next username */ #   }				/* End of while (to != 0) */ P   if (count == 0 && flag != MAIL$_CC) {		/* If no valid recipients then abort */E     print(&input_id, "No recipients entered, message aborted...", 1); 
     sleep(2);      return(0);   }				/* End of if (count.. */ %   return(1);			/* Everything is ok */  }				/* End of parse_users() */       /*K  This will get input from user or from a given field and create a recipient   "TO" list.  *// int get_to_users(alias_info *aliases, char *to)  {    char names[NAM$C_MAXRSS+1];    short rlen = 0;   3   if (!strcmp(to, "")) {	/* No recipients given? */ " 				/* Then get input from user */6     if (!get_string("To: ", names, &input_id, &rlen)) *       return(0);		/* Oh well, guess not */7   } else {			/* Otherwise use the given recipient(s) */ ;     print(&input_id, "Verifying return address(es)...", 1);      strcpy(names, to);		#   }				/* End of if (!str.. else */ 0   return(parse_users(names, MAIL$_TO, aliases));  }				/* End of get_to_users() */  L /* get_cc_users will get input from user or from a given field and create a    recipient "CC" list. */P int get_cc_users(user_info *profile, alias_info *aliases, int ask, int msg_type) { )   char names[NAM$C_MAXRSS+1], myself[25];    short rlen = 0;      names[0] = (char) NULL;   ,   sprintf(myself, ",%s", profile->username); 				/* get input from user */    if (ask)  5     if (!get_string("CC: ", names, &input_id, &rlen))        strcpy(names, "");1   if ((msg_type == SEND && profile->copy_send) || 7       (msg_type == FORWARD && profile->copy_forward) || H       (msg_type == REPLY && profile->copy_reply)) strcat(names, myself);0   return(parse_users(names, MAIL$_CC, aliases));  }				/* End of get_cc_users() */   /*L  get_subject will get a subject from the user, or create it from the message.  you are replying to and 'give' it to VMS MAIL */8 int get_subject(msg_entry *message_data, short msg_type) {    char subj[NAM$C_MAXRSS+1];   itemlist null_list[1];   itemlist attr_in[2];   short rlen = 0;   )   null_list[0].buffer_length         = 0; )   null_list[0].item_code             = 0; )   null_list[0].buffer_address        = 0; )   null_list[0].return_length_address = 0;   '   attr_in[0].buffer_length         = 0; 8   attr_in[0].item_code             = MAIL$_SEND_SUBJECT;*   attr_in[0].buffer_address        = subj;'   attr_in[0].return_length_address = 0; '   attr_in[1].buffer_length         = 0; '   attr_in[1].item_code             = 0; '   attr_in[1].buffer_address        = 0; '   attr_in[1].return_length_address = 0;   ) 				/* We arent replying to a message? */ /   if (msg_type == SEND || msg_type == FORWARD)	 % 				/* Lets ask for a subject then */ 4     get_string("Subject: ", subj, &input_id, &rlen);-   else {			/* We are replying to a message */ 4 				/* Make sure there is no Re: in there already */0     if (!strstr(message_data->subject, "Re:")) {J       strcpy(subj, "Re: ");	/* Insert the Re: in front of original subj */*       strcat(subj, message_data->subject);      }				/* End of if (!str.. */#   }				/* End of if (!reply else */ 7   if ((attr_in[0].buffer_length = strlen(subj)) != 0) { # 				/* Give VMS MAIL the subject */ N     if (!vms_ok(mail$send_add_attribute(&send_context, attr_in, null_list))) {J       fprintf(stderr, "Error in mail$send_add_attribute [get_subject]\n");       exit(SS$_NORMAL); $     }				/* End of error checking */	   } else  J   {	/* no subject... maybe ask if user still wants to send the message? */   }    return(1); }				/* End of get_subject() */    /*M  get_message will get the message from the user and put it in a file. It will A  read from a file in case we are replying or forwarding a message  */@ int get_message(char *infile, char *outfile, user_info *profile) {    s_desc s_filein;   s_desc s_tpufilein;    s_desc s_fileout;    s_desc s_option;
   FILE *f;   char tmp[NAM$C_MAXRSS+1];    char TPU[4];   char EDT[4];     strcpy(TPU,"TPU");   strcpy(EDT,"EDT");     s_filein.len  = 0;   s_filein.type = 0;   s_filein.addr = infile;      s_tpufilein.len  = 0;    s_tpufilein.type = 0;    s_tpufilein.addr = 0;      s_fileout.len  = 0;    s_fileout.type = 0;    s_fileout.addr = outfile;      s_option.len  = 0;   s_option.type = 0;#   s_option.addr = profile->editini;     =   cursor_on();			/* Make sure the cursor is on for editing */ # 				/* Set up string descriptors */ (   s_filein.len  = strlen(s_filein.addr);)   s_fileout.len = strlen(s_fileout.addr); (   s_option.len  = strlen(s_option.addr);( 				/* No editor set? or editor is EDT*/*   if (!strcmp(&profile->editor[0], TPU)) {'     sprintf(tmp, "TPU %s", &infile[0]);      s_tpufilein.addr = tmp; /     s_tpufilein.len = strlen(s_tpufilein.addr); )     if (!vms_ok(tpu$tpu(&s_tpufilein))) { :       fprintf(stderr, "Error in tpu$tpu [get_message]\n");       exit(SS$_NORMAL);      } (     copyfile(TEMPFILE_IN, TEMPFILE_OUT);   } else+   if ((strlen(&profile->editor[0]) == 0) || ,       (!strcmp(&profile->editor[0], EDT))) {0 				/* Use EDT to edit the input file, if any */>     if (!vms_ok(edt$edit(&s_filein, &s_fileout, &s_option))) {;       fprintf(stderr, "Error in edt$edit [get_message]\n");        exit(SS$_NORMAL); #     }				/* End of errorchecking */ $   } else {			/* Invalid editor... */+     print(&input_id, "Invalid editor", 1);  
     sleep(1);      cursor_off();      return(0);   }				/* End of if (.. else */    cursor_off();		 H   if (!(f=fopen(TEMPFILE_OUT, "r")))	/* If there is no output file... */5     return(0);			/* Assume the message got aborted */ *   fclose(f);			/* Close the output file */'   return(1);			/* And return an 'ok' */  }    /*K  This will be executed if the user hits CTRL-C (and CTRL-Y?) while VMS MAIL M  is sending the message. If this happens in time, the message will be aborted  */> unsigned long exit_handler(long *sigargs[], long *mechargs[5]) {    itemlist null_list[1];  )   null_list[0].buffer_length         = 0; )   null_list[0].item_code             = 0; )   null_list[0].buffer_address        = 0; *   null_list[0].return_length_address = 0;   7   mail$send_abort(&send_context, null_list, null_list);    return(SS$_RESIGNAL);   }				/* End of exit_handler() */     /*  >  send_mail will send a new mail message to a person or persons */p void send_mail(user_info *profile, msg_entry *message_data, alias_info *aliases, char *to_address, int msg_type) {       char filename[NAM$C_MAXRSS+1];   short terminator = 0;    short sigadded = 0, rlen = 0;    itemlist null_list[1];   itemlist begin_in[2];    itemlist body_in[2];   itemlist send_msg_in[4];  )   null_list[0].buffer_length         = 0; )   null_list[0].item_code             = 0; )   null_list[0].buffer_address        = 0; )   null_list[0].return_length_address = 0;   (   begin_in[0].buffer_length         = 0;(   begin_in[0].item_code             = 0;(   begin_in[0].buffer_address        = 0;(   begin_in[0].return_length_address = 0;(   begin_in[1].buffer_length         = 0;(   begin_in[1].item_code             = 0;(   begin_in[1].buffer_address        = 0;(   begin_in[1].return_length_address = 0;      clear(&input_id);   A   lib$establish(exit_handler);		/* Enable our own exit_handler */ E   if (!vms_ok(mail$send_begin(&send_context, begin_in, null_list))) { ?      fprintf(stderr, "Error in mail$send_begin [send_mail]\n");       exit(SS$_NORMAL);!   }				/* End of errorchecking */ F   if (profile->personal_name[0] == 0) 	/* Check for a personal name */4     begin_in[0].item_code = MAIL$_SEND_NO_PERS_NAME;)   else {			/* Use it if one is defined */ 1     begin_in[0].item_code = MAIL$_SEND_PERS_NAME; <     begin_in[0].buffer_address = &profile->personal_name[0];C     begin_in[0].buffer_length = strlen(&profile->personal_name[0]); #   }				/* End of if (pro... else */   				/* Get all the recipients */+   if (!get_to_users(aliases, to_address)) { ( 				/* No recipients? then return now */E    if (!vms_ok(mail$send_end(&send_context, null_list, null_list))) { =      fprintf(stderr, "Error in mail$send_end [send_mail]\n");       exit(SS$_NORMAL);"    }				/* End of errorchecking *//    return;			/* No recipients entered, leave */ !   }				/* End of if (!get_to.. */ +  				/* Do we need to ask for CC people? */ ^   get_cc_users(profile, aliases, profile->cc_prompt, msg_type);	/* If so, get all CC people */#  				/* Get (create) the subject */ 1   if (!get_subject(message_data, msg_type)) {  		 # 				/* Problems? then return now */ -     send_msg_in[0].buffer_length         = 4; B     send_msg_in[0].item_code             = MAIL$_SEND_ERROR_ENTRY;<     send_msg_in[0].buffer_address        = (void *) no_send;-     send_msg_in[0].return_length_address = 0; -     send_msg_in[1].buffer_length         = 4; D     send_msg_in[1].item_code             = MAIL$_SEND_SUCCESS_ENTRY;=     send_msg_in[1].buffer_address        = (void *) yes_send; -     send_msg_in[1].return_length_address = 0; -     send_msg_in[2].buffer_length         = 0; :     send_msg_in[2].item_code             = MAIL$_NOSIGNAL;-     send_msg_in[2].buffer_address        = 0; -     send_msg_in[2].return_length_address = 0; -     send_msg_in[3].buffer_length         = 0; -     send_msg_in[3].item_code             = 0; -     send_msg_in[3].buffer_address        = 0; -     send_msg_in[3].return_length_address = 0; H     if (!vms_ok(mail$send_end(&send_context, send_msg_in, null_list))) {>       fprintf(stderr, "Error in mail$send_end [send_mail]\n");       exit(SS$_NORMAL); #     }				/* End of errorchecking */ *     return; 			/* problems with subject */"   }				/* End of if (!get_sub.. */@   clear(&body_id);		/* Clear screen (so it doesnt get redrawn)*/8   clear(&full_screen_id);	/* Clear the message screen */" 				/* get (create) the message */I   if ((msg_type == FORWARD && 	/* _maybe_ edit message when forwarding */ V       (yesno(&input_id, "Would you like to edit the message before sending? [y/n] ")))B     || msg_type == SEND 	/* edit message if new message to send */:     || msg_type == REPLY)	/* edit message when replying */   { :   if (get_message(TEMPFILE_IN, TEMPFILE_OUT, profile)) {	 & 				/* if all went well we are here */F     smg$repaint_screen(&pboard_id);	/* repaint screen cuz of editor */A     if (profile->addsig) {	/* Automatically add the signature? */ 6      if (!add_sig(TEMPFILE_OUT, profile))	/* Add it */<       print(&input_id, "Error appending signature file", 1);      else { =       sigadded++;		/* set flag, that a sig. has been added */ 5       print(&input_id, "Signature file appended", 1); &      }				/* end of if (!add.. else */#     }				/* End of if (profile.. */ %     do {			/* start of 'menu' loop */ /       clear(&input_id);		/* Clear the window */ b       print(&input_id, "Choose e)dit message, a)dd signature, c)opy file, s)end, or f)orget.", 2);'       print(&input_id, "Command: ", 0); 4       smg$read_keystroke(&keyboard_id, &terminator);7       switch (terminator) {	/* What key was pressed? */ )         case 101:		/* "e" edit message */ .           print(&input_id, "Edit message", 1);;           get_message(TEMPFILE_OUT, TEMPFILE_OUT, profile); )           smg$repaint_screen(&pboard_id);            break;)         case 97:		/* "a" add signature */ :           if (sigadded) {	/* no sig has been added yet? */>             print(&input_id, "Signature already appended", 1);             sleep(2);              break;           } 5           print(&input_id, "Appending signature", 1); /           if (!add_sig(TEMPFILE_OUT, profile))  B             print(&input_id, "Error appending signature file", 1);           else {             sigadded++; ;             print(&input_id, "Signature file appended", 1); *           }			/* End of if (!add.. else */           sleep(2);            break;(         case 99:		/* "c" copy message */8           print(&input_id, "Copy message to a file", 1); 				/* Ask for a fileaname */ ?           get_string("Filename: ", filename, &input_id, &rlen); * 				/* copy the message to another file */1           if (!copyfile(TEMPFILE_OUT, filename))  6             print(&input_id, "Error copying file", 1);           else;             print(&input_id, "File copied succesfully", 1);            sleep(2);            break;*         case 105:		/* "i" spell checker */M           center(&input_id, "Loading spelling checker... Please wait...", 1); -           if (!vms_ok(spell(TEMPFILE_OUT))) { ?             print(&input_id, "Error running spell checker", 1);              sleep(1);            }            break;$       }				/* End of switch(ter.. */I     } while (terminator != 115 && terminator != 102 && terminator != 13);     }				/* End of if (!get_mes */
   } else {)      movefile(TEMPFILE_IN, TEMPFILE_OUT);       terminator = 115;   } 2 				/* If <return> or "S" were hit then send it */.   if (terminator == 115 || terminator == 13) {(     print(&input_id, "Send message", 1);( 				/* Tell VMS MAIL what file to use */<     body_in[0].buffer_length         = strlen(TEMPFILE_OUT);;     body_in[0].item_code             = MAIL$_SEND_FILENAME; 4     body_in[0].buffer_address        = TEMPFILE_OUT;)     body_in[0].return_length_address = 0; )     body_in[1].buffer_length         = 0; )     body_in[1].item_code             = 0; )     body_in[1].buffer_address        = 0; )     body_in[1].return_length_address = 0;   M     if (!vms_ok(mail$send_add_bodypart(&send_context, body_in, null_list))) { G       fprintf(stderr, "Error in mail$send_add_bodypart [send_mail]\n");        exit(SS$_NORMAL); #     }				/* End of errorchecking */ J     if (!vms_ok(mail$send_message(&send_context, null_list, null_list))) {B       fprintf(stderr, "Error in mail$send_message [send_mail]\n");       exit(SS$_NORMAL); #     }				/* End of errorchecking */ (     print(&input_id, "Message sent", 1);4   } else {			/* If "f"orget it was hit then abort */#     smg$repaint_screen(&pboard_id); .     print(&input_id, "Message aborted...", 1);   }    sleep(1); " 				/* Time to close everything */D   if (!vms_ok(mail$send_end(&send_context, null_list, null_list))) {<     fprintf(stderr, "Error in mail$send_end [send_mail]\n");     exit(SS$_NORMAL); !   }				/* End of errorchecking */ 8   delete(TEMPFILE_IN);		/* Delete the temp input file */:   delete(TEMPFILE_OUT);		/* Delete the temp output file */1   lib$revert();			/* Turn off our exit_handler */  }				/* End of send_mail() */      /*A  copy_msg will copy or move a message from one folder to another   */7 void copy_msg(msg_entry *msg_data, user_info *profile,  0   char *foldername, short delete, short newmail) {    itemlist null_list[1];   itemlist copy_in_list[6];    itemlist set_list[2];     )   null_list[0].buffer_length         = 0; )   null_list[0].item_code             = 0; )   null_list[0].buffer_address        = 0; )   null_list[0].return_length_address = 0;    				/* Set up item list */  A   copy_in_list[0].buffer_length         = strlen(&foldername[0]); ?   copy_in_list[0].item_code             = MAIL$_MESSAGE_FOLDER; 6   copy_in_list[0].buffer_address        = &foldername;,   copy_in_list[0].return_length_address = 0;,   copy_in_list[1].buffer_length         = 4;;   copy_in_list[1].item_code             = MAIL$_MESSAGE_ID; 8   copy_in_list[1].buffer_address        = &msg_data->id;,   copy_in_list[1].return_length_address = 0;G   copy_in_list[2].buffer_length         = strlen(profile->result_spec); E   copy_in_list[2].item_code             = MAIL$_MESSAGE_DEFAULT_NAME; ?   copy_in_list[2].buffer_address        = profile->result_spec; ,   copy_in_list[2].return_length_address = 0;,   copy_in_list[3].buffer_length         = 0;9   copy_in_list[3].item_code             = MAIL$_NOSIGNAL; ,   copy_in_list[3].buffer_address        = 0;,   copy_in_list[3].return_length_address = 0;,   copy_in_list[4].buffer_length         = 0;?   copy_in_list[4].item_code             = MAIL$_MESSAGE_DELETE; ,   copy_in_list[4].buffer_address        = 0;,   copy_in_list[4].return_length_address = 0;,   copy_in_list[5].buffer_length         = 0;,   copy_in_list[5].item_code             = 0;,   copy_in_list[5].buffer_address        = 0;,   copy_in_list[5].return_length_address = 0;  <   if (!delete) {		/* We want to COPY not MOVE the message */.     copy_in_list[4].buffer_length         = 0;.     copy_in_list[4].item_code             = 0;.     copy_in_list[4].buffer_address        = 0;.     copy_in_list[4].return_length_address = 0;   }   N   if (!vms_ok(mail$message_copy(&message_context, copy_in_list, null_list))) {?     fprintf(stderr, "Error in mail$message_copy [copy_msg]\n");      exit(SS$_NORMAL); !   }				/* End of errorchecking */   3   if (newmail) {		/* If we are in NEWMAIL folder */ " 				/* Lower the new_msgs count */'     if ((--profile->new_messages) < 0)          profile->new_messages = 0;  *     set_list[0].buffer_length         = 2;D     set_list[0].item_code             = MAIL$_USER_SET_NEW_MESSAGES;?     set_list[0].buffer_address        = &profile->new_messages; *     set_list[0].return_length_address = 0;*     set_list[1].buffer_length         = 0;*     set_list[1].item_code             = 0;*     set_list[1].buffer_address        = 0;*     set_list[1].return_length_address = 0;  J     if (!vms_ok(mail$user_set_info(&user_context, set_list, null_list))) {B       fprintf(stderr, "Error in mail$user_set_info [copy_msg]\n");       exit(SS$_NORMAL); #     }				/* End of errorchecking */    }				/* End of if (newmail */  }				/* End of copy_msg() */   /*  I  purge will take a linked list of messages and check all their flags and  2  either delete, move, copy or do nothing with them */= int purge(msg_entry *msgs, user_info *profile, short newmail)  {    msg_entry *tmp; "   int move = 0, copy = 0, del = 0;   char work[NAM$C_MAXRSS+1];   #   tmp = msgs;			/* First message */ 4   while (tmp != 0) {		/* We arent at the end yet? */<     if (tmp->flags & M_MOVE) {	/* We wanna move it, OK... */7       copy_msg(tmp, profile, tmp->dest, TRUE, newmail); *       move++;			/* increase the counter */
     } elseA     if (tmp->flags & M_COPY) {	/* We wanna copy it, no problem */ 8       copy_msg(tmp, profile, tmp->dest, FALSE, newmail);*       copy++;			/* increase the counter */
     } elseD     if (tmp->flags & M_DEL) {	/* Delete means MOVE to WASTEBASKET */B       copy_msg(tmp, profile, profile->wastebasket, TRUE, newmail);       del++;     } 4     tmp = tmp->next;		/* move to the next message */   }				/* End of while (!m */ (   if (del==0 && copy == 0 && move == 0) 8     return(FALSE);		/* Nothing done? just return then */' 				/* otherwise print fancy message */ 6   sprintf(work, "[Deleted %d and moved %d messages]",      del, move); ?   clear(&command_id);		/* Clear the input screen and show it */    center(&command_id, work, 1);    sleep(2);    return(TRUE);  }				/* End of purge_msgs() */   /*K  handle_msgs will call read_msgs and handle upon the keypresses returned by   that function.  */O void handle_msgs(msg_entry *tmp_msg, user_info *profile, struct list *folders,  ;  int *last, struct m_descriptor *menu_list, int msg_count,  "  alias_info *aliases, int newmail) { ?   int showheaders = FALSE, done = FALSE, result, direction = 0;    short terminator; "   char tempfolder[NAM$C_MAXRSS+1];  8   clear(&full_screen_id);	/* Clear the message screen */1   clear(&bottom_id);		/* Clear the status line */ @   paste(&full_screen_id, 1, 1);	/* Display the message_screen */9   paste(&bottom_id, 24, 1);	/* Display the status line */    do { 				/* read a message */B     terminator = read_msg(tmp_msg, *last, msg_count, showheaders);A     switch (terminator) {      	/* check what key was returned */         case 63:			/* "?" help! */         display_msgs_help();         break;       case 26:			/* CTRL-Z */ .       case 105:               	/* "i" index */.       case 120:                 /* "x" exit */,       case 113:              	/* "q" quit */.         if (newmail) {		/* reading NEWMAIL? */D           strcpy(tmp_msg->dest, "MAIL");	/* Move the file to MAIL */2           mark(*last, tmp_msg, menu_list, M_MOVE);$         }			/* End of if (newma.. */         done = TRUE;         break;(       case 115:			/* "s" save message */         clear(&body_id);         clear(&command_id); !         unpaste(&full_screen_id);          unpaste(&bottom_id);  				/* get folder or filename */B         result = get_folder_name(profile, folders, tempfolder, 1);?         if (result == T_FOLDER) {	/* Oh we got a folder back */ 3           mark(*last, tmp_msg, menu_list, M_MOVE);	 B                                         /* save the destination */,           strcpy(tmp_msg->dest, tempfolder);         } else@         if (result == T_FILE) {		/* Oh we got a filename back */           clear(&input_id); "           paste(&input_id, 15, 1);2 				/* Dump the message into file WITH headers */ 9           if (!dump_msg(tmp_msg, "", tempfolder, TRUE)) { ;             print(&input_id, "Error opening temp file", 1);              sleep(1);              unpaste(&input_id);              break;           } else {=             print(&input_id, "Message succesfully saved", 1);              sleep(1);              unpaste(&input_id); %           }			/* End of if (!dum.. */ -         }			/* End of if (result == T_FILE */          clear(&full_screen_id); %         paste(&full_screen_id, 1, 1); !         paste(&bottom_id, 24, 1);          clear(&body_id);         display_commands();          break;5       case 104:               	/* "h" show headers */          direction = 0;) 				/* Just toggle the showheader flag */ -         if (showheaders) showheaders = FALSE;           else showheaders = TRUE;         break;/       case 106:			/* "k" compatible with Elm */         case 274:			/* up arrow */?         if (newmail) {		/* Make sure we move NEWMAIL to MAIL */ (           strcpy(tmp_msg->dest, "MAIL");2           mark(*last, tmp_msg, menu_list, M_MOVE);#         }			/* End of if (newmai */          direction = -1;          break;+       case 32:               	/* <space> */  /*( 	mark(*last, tmp_msg, menu_list, M_SEL); 	direction = 1;  	break;  */-       case 110:               	/* "n" next */ /       case 107:			/* "j" compatible with Elm */ "       case 275:			/* down arrow */:         if (newmail) {         	/* move NEWMAIL to MAIL */(           strcpy(tmp_msg->dest, "MAIL");2           mark(*last, tmp_msg, menu_list, M_MOVE);$         }			/* End of if (newmail */         direction = 1;         break;0       case 100:                 /* "d" delete *//         mark(*last, tmp_msg, menu_list, M_DEL);          direction = 1;         break;        case 109:			/* "m" mail */         clear(&input_id);           paste(&input_id, 15, 1);7         send_mail(profile, tmp_msg, aliases, "", SEND);          unpaste(&input_id);          break;0       case 102:               	/* "f" forward */         clear(&input_id);           paste(&input_id, 15, 1);/         print(&input_id, "Loading message..."); + 				/* Dump the message into a temp file */ D         if (!dump_msg(tmp_msg, profile->quote, TEMPFILE_IN, TRUE)) {9           print(&input_id, "Error opening temp file", 1);            sleep(2);            unpaste(&input_id);            break;$         }			/* End of if (!dump.. */+ 				/* Now send mail using the temp file */ :         send_mail(profile, tmp_msg, aliases, "", FORWARD);9         unpaste(&input_id);	/* delete the input window */          break;)       case 112:			/* "p" print message */         clear(&input_id);         paste(&input_id, 15, 1); .        print(&input_id, "Loading message...");, 				/* dumping the message to a temp file */5        if (!dump_msg(tmp_msg, "", TEMPPRINT, TRUE)) { 9           print(&input_id, "Error opening temp file", 1);            sleep(1);            unpaste(&input_id);            break;"         }			/* End of if (!dump */! 				/* ok, print the temp file */ 5         if (!vms_ok(printfile(profile, TEMPPRINT))) { 8           print(&input_id, "Error printing message", 1);           sleep(1);          } else {:           print(&input_id, "Message is being printed", 1);           sleep(1); .         }     			/* End of if (!vms_ok else */         unpaste(&input_id);          break;6       case 114:                 /* reply to message */         clear(&input_id);           paste(&input_id, 15, 1);/         print(&input_id, "Loading message..."); $ 				/* Dump message to a tempfile */K         if (!dump_msg(tmp_msg, profile->quote, TEMPFILE_IN, showheaders)) { 9           print(&input_id, "Error opening temp file", 1);            sleep(2);            unpaste(&input_id);            break;$         }			/* End of if (!dump.. */* 				/* Send the message using temp file */D         send_mail(profile, tmp_msg, aliases, tmp_msg->reply, REPLY);         unpaste(&input_id); , /*      smg$repaint_screen(&pboard_id);   */         break;2     }                         	/* End of switch */E     if (direction == 1) {	/* Check which we are moving, up or down */ F       if (*last < msg_count) {	/* Make sure there is a next message */;         tmp_msg = tmp_msg->next;  	/* Go to next message */ B         (*last)++;		/* Update the cursor position in the folder */A       } else done = TRUE;       /* no more messages, then exit */ 
     } else			 4     if (direction == -1) {	/* Oh we are moving up */;       if (*last > 1) {		/* make sure we arent at the top */ =         tmp_msg = tmp_msg->prev;	/* Go to previous message */ B         (*last)--;		/* Update the cursor position in the folder */       } else done = TRUE; )     }				/* End of if (direction == -1 */ 4     direction = 0;		/* By default we arent moving */>     clear(&full_screen_id);    	/* clear old message screen *//   } while (!done);		/* keep reading messages */    clear(&body_id);		8   unpaste(&full_screen_id);    	/* delete read screen */   unpaste(&bottom_id); }				/* End of handle_msgs() */   & msg_entry *clear_msgs(msg_entry *msgs) {    msg_entry *tmp_msg;   G   while (msgs != 0) {       /* First give memory back if any is used */      tmp_msg = msgs;      msgs = tmp_msg->next;      free(tmp_msg);   }    return(msgs);  } 