/*
 screen.c
 This file contains all the functions that have something to with the screen
 or windows. Hence the name: screen.c  :-)
*/
#include "mail.h"
#include <descrip.h>
#include <maildef.h>
#include <smgdef.h>
#include <smg$routines.h>
#include <smgmsg.h>
#include <ssdef.h>
#include <stdio.h>
#include <stdlib.h>
#include <nam.h>
#include <string.h>
#include <ctype.h>

				/* Global variables used for windows */
extern long file_context, message_context, user_context, send_context;
extern long pboard_id, body_id, command_id, keyboard_id, error_id;
extern long full_screen_id, bottom_id, title_id, help1_id, help2_id;
extern long input_id;
/* 
 paste will put a certain window on the screen at the given row and column
*/
void paste(long *id, int row, int col)
{
  if (!vms_ok(smg$paste_virtual_display(id, &pboard_id, &row, &col))) {
    fprintf(stderr, "Error in smg$paste_virtual_display [paste]\n");;
    exit(SS$_NORMAL);
  }				/* End of errorchecking */
}				/* End of paste() */
 
/*
 unpaste will remove a window from the screen
*/
void unpaste(long *id)
{
  if (!vms_ok(smg$unpaste_virtual_display(id, &pboard_id))) {
    fprintf(stderr, "Error in smg$unpaste_virtual_display [unpaste]\n");
    exit(SS$_NORMAL);
  }				/* End of errorchecking */
}				/* End of unpaste() */

/*
 print will display a certain string at the given window and advance a certain
number of lines
*/
void print(long *id, char *s, int line_advance)
{
  s_desc s_work;

  s_work.len  = strlen(s);
  s_work.type = 0;
  s_work.addr = s;

  if (!vms_ok(smg$put_line(id, &s_work, &line_advance))) {
    fprintf(stderr, "Error in smg$put_line [print]\n");
    exit(SS$_NORMAL);
  }				/* End of errorchecking */
}				/* End of print() */

/*
 center will display a string on a window rigt in the middle of the screen, 
NOT the middle of the window... (assuming a 80 column screen) 
*/
void center(long *id, char *s, int line_advance)
{  
  char temp[NAM$C_MAXRSS+1];
  s_desc s_work;
  int i;

  s_work.len = 0;
  s_work.type = 0;
  s_work.addr = temp;

  strcpy(temp, ""); 
  for (i = 0; i < (40 - strlen(s)/2); i++)
   strcat(temp, " ");		/* add spacing in front to center it */
  strcat(temp, s);
  s_work.len = strlen(temp);
  if (!vms_ok(smg$put_line(id, &s_work, &line_advance))) {
    fprintf(stderr, "Error in smg$put_line [center]\n");
    exit(SS$_NORMAL);
  }				/* End of errorchecking */
}				/* End of center() */
	
/*
 clear will erase a certain window
*/
void clear(long *id)
{
  if (!vms_ok(smg$erase_display(id))) {
    fprintf(stderr, "Error in smg$erase_display(id) [clear]\n");
    exit(SS$_NORMAL);
  }				/* End of errorchecking */
}				/* End of clear() */

/*
 display_title will display the folder header with the foldername and number
of messages 
*/
void display_title(char *foldername, long msg_count)
{
  char work[81];

  sprintf(work, "Folder is '%s' with  %ld message%s  [PTmail v%d.%d.%d]",
    foldername, msg_count, ( msg_count > 1 ) ? "s" : "",
    VER_MAJOR,VER_MINOR,VER_PATCH);
  clear(&title_id);
  center(&title_id, work, 0);
}				/* End of display_title() */

/*
 display_alias_title will display the alias heading with the number of aliases 
loaded 
*/
void display_alias_title(long total)
{
  char work[81];
  
  sprintf(work,"Aliases, %ld loaded  [PTmail v%d.%d.%d]",
          total,VER_MAJOR,VER_MINOR,VER_PATCH);
  clear(&title_id);
  center(&title_id, work, 0);
}				/* End of display_alias_title() */

/* 
 display_setup_title will display the setup heading 
*/
void display_setup_title()
{
  char work[81];
  sprintf(work,"Setup screen  [PTmail v%d.%d.%d]",
	 	VER_MAJOR,VER_MINOR,VER_PATCH);
  clear(&title_id);
  center(&title_id, work, 0);
}				/* End of display_setup_title() */

/*
 display_setup_commands will print the setup commands at the bottom of the 
screen.
Note that if novice help is turned off this window is overwritten by body and
thus none of this is visible.
*/
void display_setup_commands()
{
  clear(&command_id);
  center(&command_id, "Use cursor keys to select option and <return> to change it", 1);
  center(&command_id, "Hit q)uit or e(x)it to return to the folder", 2);
  print(&command_id, "Command: ", 0);
}				/* End of display_setup_commands() */

/*
 display_commands will print the folder commands at the bottom of the screen
Note that if novice help is turned off this window is overwritten by body and
thus none of this is visible.
*/
void display_commands()
{
  clear(&command_id);
  center(&command_id, "?=help, <n>=set current to n, R)eread folder, a)liases", 1);
  center(&command_id, "o)ptions, c)hange folder, d)elete, f)orward, m)ail, <enter> read", 1);
  center(&command_id, "p)rint, q)uit, r)eply, s)ave, u)ndelete or e(x)it", 2);
  print(&command_id, "Command: ", 0);
}				/* End of display_commands() */

/* 
 display_changefolder_commands will display the change folder commands at the
bottom of the screen.
Note that if novice help is turned off this window is overwritten by body and
thus none of this is visible.
*/
void display_changefolder_commands()
{
  clear(&command_id);
  center(&command_id, "Select a folder with the cursor keys. ", 1);
  center(&command_id, "q)uit to return without a selection", 1);
  center(&command_id, "R)eread folders, <return> select folder", 1);
}				/* End of display_changefolder_commands() */

/* 
 display_alias_commands will display the alias commands at the bottom of the
screen.
Note that if novice help is turned off this window is overwritten by body and
thus none of this is visible.
*/
void display_alias_commands()
{
  clear(&command_id);
  center(&command_id, "a)dd alias    d)elete alias    q)uit", 1);
  center(&command_id, "<n> = set current to n   e(x)it", 1); 
}				/* End of display_alias_commands() */

/*
 display_msgs_help will simply paste a previously create helpwindow and wait
for a keypress
*/
void display_msgs_help()
{
  short terminator;
  int row, col;
  row = 4;
  col = 5;
  paste(&help1_id, row, col);
  smg$read_keystroke(&keyboard_id, &terminator);
  unpaste(&help1_id);
}				/* End of display_msgs_help() */

/*
 display_folder_help will simply paste a previously create helpwindow and wait
for a keypress
*/
void display_folder_help()
{
  short terminator;
  int row, col;
  row = 4;
  col = 5;
  paste(&help2_id, row, col);
  smg$read_keystroke(&keyboard_id, &terminator);
  unpaste(&help2_id);
}				/* End of display_folder_help() */

/*
 init_msgs_help creates a help window which may be pasted to the screen at a 
later point 
*/
void init_msgs_help()
{
  print(&help1_id, "	Command                Action", 2);
  print(&help1_id, "    <space>           Display next screen of current message", 1);
  print(&help1_id, "                      or if at the end of a message, the first", 1);
  print(&help1_id, "                      screen of the next message", 1);
  print(&help1_id, "      ?               This help screen", 1);
  print(&help1_id, "      d               Delete current message", 1);
  print(&help1_id, "      f               Forward current message", 1);
  print(&help1_id, "      h               Toggle header display", 1);
  print(&help1_id, "  j, <down arrow>     Go to the next message", 1);
  print(&help1_id, "   k, <up arrow>      Go to the previous message", 1);
  print(&help1_id, "      m               Mail a message", 1);
  print(&help1_id, "      n               Display next message", 1);
  print(&help1_id, "      p               Print current message", 1);
  print(&help1_id, "   i, x, q            Quit reading and return to folder screen", 1);
  print(&help1_id, "      r               Reply to current message", 1);
  print(&help1_id, "      s               Save current message to file or folder", 2);
  print(&help1_id,           "Hit any key to return to the current message", 0);
}				/* End of init_msgs_help() */
		
/*
 init_folder_help creates a help window which may be pasted to the screen at
some time
*/
void init_folder_help()
{
  print(&help2_id, "	Command              Action", 2);
  print(&help2_id, "     <return>           Read current message", 1);
  print(&help2_id, "        ?               This help screen", 1);
  print(&help2_id, "        *               Jump to last message in folder", 1);
  print(&help2_id, "        a               Alias menu", 1);
  print(&help2_id, "        c               Change folder", 1);
  print(&help2_id, "        d               Delete current message", 1);
  print(&help2_id, "        f               Forward current message", 1);
  print(&help2_id, "  <up & down arrow>     Select a message" , 1);
  print(&help2_id, "        m               Mail a message", 1);
  print(&help2_id, "        o               Options menu", 1);
  print(&help2_id, "        p               Print current message", 1);
  print(&help2_id, "        q               Quit and abondon all changes", 1);
  print(&help2_id, "        r               Reply to current message", 1);
  print(&help2_id, "        s               Save current message to file or folder", 1);
  print(&help2_id, "        u               Undelete current message", 1);
  print(&help2_id, "        x               Exit and save all changes", 2);
  print(&help2_id, "            Hit any key to return to the folder index. ", 0);
}				/* End of init_folder_help() */

/*
 get_broadcast gets executed each time there is an incoming broadcast message.
What PTMail does with it is send the output of those the one line window 
visible in the folder menu. That way it doesnt screw up the screen.
*/
long get_broadcast()
{
  long status, len;
  char message[81];
  s_desc s_msg, s_msg_out;
  int ONE = 1;

  s_msg.len = 80;
  s_msg.type = s_msg_out.type = 0;
  s_msg.addr = s_msg_out.addr = &message[0];
  do {
    status = smg$get_broadcast_message(&pboard_id, &s_msg, &len);
    if (status == SMG$_NO_MORMSG) return(1);
    if (!vms_ok(status)) {
      fprintf(stderr, "Error in smg$get_broadcast_message [get_broadcast]\n");
      exit(SS$_NORMAL);
    }				/* End of errorchecking */
    clear(&error_id);
    s_msg_out.len = len;
    if (!vms_ok(smg$put_chars(&error_id, &s_msg_out, &ONE, &ONE))) {
      fprintf(stderr, "Error in smg$put_chars [get_broadcast]\n");
      exit(SS$_NORMAL);
    }				/* End of errorchecking */
  } while (1);			/* do all the incoming messages */
}				/* End of get_broadcast() */

/* 
 init_screen creates all the windows 
*/
void init_screen(user_info *profile)
{
  int row, col;
  int SMG_FLAG;
					/* create pasteboard */
  if (!vms_ok(smg$create_pasteboard(&pboard_id))) {
    fprintf(stderr, "Error in smg$create_pasteboard [init_screen]\n");
    exit(SS$_NORMAL);
  }
					/* create title display */
  row = 1;
  col = 80;
  if (!vms_ok(smg$create_virtual_display(&row, &col, &title_id))) {
    fprintf(stderr, "Error in smg$create_virtual_display(title) [init_screen]\n");
    exit(SS$_NORMAL);
  }
  row = col = 1;
  paste(&title_id, row, col);

  row = 1;
  col = 80;
  if (!vms_ok(smg$create_virtual_display(&row, &col, &error_id))) {
    fprintf(stderr, "Error in smg$create_virtual_display(error) [init_screen]\n");
    exit(SS$_NORMAL);
  }
  row = 24;
  col = 1;
  paste(&error_id, row, col);
					/* create body display */
  if (profile->novice) {
    row = 14;
    col = 80;
    if (!vms_ok(smg$create_virtual_display(&row, &col, &body_id))) {
      fprintf(stderr, "Error in smg$create_virtual_display(body) [init_screen]\n");
      exit(SS$_NORMAL);
    }
    row = 3;
    col = 1;
    paste(&body_id, row, col); 
  					/* create command display */
    row = 5;
    col = 80;
    if (!vms_ok(smg$create_virtual_display(&row, &col, &command_id))) {
      fprintf(stderr, "Error in smg$create_virtual_display(command) [init_screen]\n");
      exit(SS$_NORMAL);
    }
    row = 18;
    col = 1;
    paste(&command_id, row, col);
  } else {
    row = 20;
    col = 80;
    if (!vms_ok(smg$create_virtual_display(&row, &col, &body_id))) {    
      fprintf(stderr, "Error in smg$create_virtual_display(body) [init_screen]\n");
      exit(SS$_NORMAL);
    } 
    row = 3;
    col = 1;
    paste(&body_id, row, col);
/* NOTE: If novice mode is turned off the body_id window is made extra large
and it does overwrites the command_id. This means that the body_id has 5
extra lines to display msgs and that the help commands are NOT displayed */
                                        /* create command display */
    row = 5;
    col = 80;
    if (!vms_ok(smg$create_virtual_display(&row, &col, &command_id))) {
      fprintf(stderr, "Error in smg$create_virtual_display(command) [init_screen]\n");
      exit(SS$_NORMAL);
    }
  }				/* End of if (profil */
  row = 7;
  col = 80;
  SMG_FLAG = SMG$M_BORDER;
  if (!vms_ok(smg$create_virtual_display(&row, &col, &input_id, &SMG_FLAG))) {
    fprintf(stderr, "Error in smg$create_virtual_display(input) [init_screen]\n");
    exit(SS$_NORMAL);
  }
					/* create fullscreen display */
  row = 23;
  col = 80;
  if (!vms_ok(smg$create_virtual_display(&row, &col, &full_screen_id))) {
    fprintf(stderr, "Error in smg$create_virtual_display(full_screen) [init_screen]\n");
    exit(SS$_NORMAL);
  }
  row = 1;
  col = 80;
  if (!vms_ok(smg$create_virtual_display(&row, &col, &bottom_id))) {
    fprintf(stderr, "Error in smg$create_virtual_display(bottom) [init_screen]\n");
    exit(SS$_NORMAL);
  }
  					/* create keyboard */
  if (!vms_ok(smg$create_virtual_keyboard(&keyboard_id))) {
    fprintf(stderr, "Error in smg$create_virtual_keyboard [init_screen]\n");
    exit(SS$_NORMAL);
  }
 					/* set broadcast trapping on */
  if (!vms_ok(smg$set_broadcast_trapping(&pboard_id, get_broadcast))) {
    fprintf(stderr, "Error in smg$set_broadcast_trapping [init_screen]\n");
    exit(SS$_NORMAL);
  }
  row = 19;
  col = 70;
  SMG_FLAG = SMG$M_BORDER;
  if (!vms_ok(smg$create_virtual_display(&row, &col, &help1_id, &SMG_FLAG))) {
    fprintf(stderr, "Error in smg$create_virtual_display(help) [init_screen]\n");
    exit(SS$_NORMAL);
  }
  init_msgs_help();
  row = 19;
  col = 70;
  SMG_FLAG = SMG$M_BORDER;
  if (!vms_ok(smg$create_virtual_display(&row, &col, &help2_id, &SMG_FLAG))) {
    fprintf(stderr, "Error in smg$create_virtual_display(help2) [init_screen]\n");
    exit(SS$_NORMAL);
  }
  init_folder_help();
}				/* End of init_screen() */


/*
 restore_screen will delete the pasteboard and clear the screen
*/
void restore_screen()
{
  if (!vms_ok(smg$delete_pasteboard(&pboard_id))) {
    fprintf(stderr, "Error in smg$delete_pasteboard [restore_screen]\n");
    exit(SS$_NORMAL);
  }
}				/* End of restore_screen() */
