      PROGRAM FPP_MAIN
C*
C*                  *******************************
C*                  *******************************
C*                  **                           **
C*                  **           FPP             **
C*                  **                           **
C*                  *******************************
C*                  *******************************
C*
C*     PROGRAM :
C*          FPP - FORTRAN PreProcessor
C*
C*     AUTHOR :
C*          Arthur E. Ragosta
C*          RAGOSTA@MERLIN.ARC.NASA.GOV  (Internet)
C*          MS 219-1
C*          NASA Ames Research Center
C*          Moffett Field, Ca.  94035
C*          (415) 604-5558
C*
C*     PURPOSE :
C*          The FORTRAN PreProcessor reads a FORTRAN source code and
C*          interprets embedded commands to enhance the maintainability
C*          of source codes.
C*
C*     SUBPROGRAM REFERENCES :
C*          GETFOR, EXIT, LEFT, BLANKS, SEARCH, GETFILEX, PARSE, FPP
C*
C*     LANGUAGE AND COMPILER :
C*          ANSI FORTRAN 77
C*
C*     CHANGE HISTORY :
C*          13-MAY-1991       INITIAL VERSION
C*          06-JAN-1992       Multiple /DEFINES
C*          07-JAN-1992       Added /SUPPRESS
C*          24-JAN-1995       Added /ATTENTION
C*           9-MAR-1995       Added %COUNTER
C*
C***********************************************************************
C*
      INCLUDE 'FPP.CMN'
      CHARACTER *127 FILES, OUTFILES, ONEFILE, EXFILE, OUTFILE
      CHARACTER *127 FNAME, INCFILE
      CHARACTER *80 P(3), Q(8)
      CHARACTER *255 DEFINEQ
      CHARACTER *3 CCHAR
C
      LOGICAL MATCHD, AMBIG, LIST, OUTWILD, DID_SOME, SUPPRESS
C
C --- THE QUALIFIER LIST MUST BE ALPHABETICAL !!!!
C
      PARAMETER (NQUALS=6)
      CHARACTER *20 QUALS(NQUALS)
      DATA QUALS/ 'ATTENTION',  'DEFINE',  'EXCLUDE',  'INCLUDE',
     $ 'OUTPUT',  'SUPPRESS'/
      DATA DID_SOME /.FALSE./
C
C --- GET USER PARAMETERS AND QUALIFIERS
C
      CALL GETFOR (NQ, Q, NP, P)
C
C --- IF THE USER DIDN'T ENTER A FILE LIST ON THE COMMAND LINE, ASK
C ---  FOR IT
C
      IF (NP .EQ. 0) THEN
         WRITE(6,900)
         READ(5,910) P(1)
      ENDIF
C
C --- MAYBE HE CHANGED HIS MIND?
C
      IF (P(1) .EQ. ' ') THEN
         WRITE(6,920)
         CALL EXIT(1)
      ENDIF
C
      CALL LEFT(P(1))
      FILES   = P(1)
      EXFILE  = ' '
      INCFILE = ' '
C
C --- GET OUTPUT FILE LIST, IF ANY
C
      IF (NP .GT. 1) THEN
         OUTFILES = P(2)
         IF ((INDEX(OUTFILES,',') .NE. 0) .AND.
     $       (INDEX(OUTFILES,'*') .NE. 0)) THEN
            WRITE(6,970) OUTFILES
            CALL EXIT(1)
         ENDIF
C
C ------ IF THE INPUT LIST HAS MORE THAN ONE FILE, SO MUST THE
C ------  OUTPUT FILE LIST
C
         IF ((INDEX(FILES,',') .NE. 0) .OR. (INDEX(FILES,'*') .NE. 0)) 
     $      THEN
            LIST = .TRUE.
            IF (INDEX(FILES,'*') .NE. 0) THEN
               IF (INDEX(OUTFILES,'*') .EQ. 0) THEN
                  WRITE(6,960) FILES(1:LENGTH(FILES))
                  CALL EXIT(1)
               ENDIF
            ELSE
               IF ((INDEX(OUTFILES,'*') .EQ. 0) .AND.
     $             (INDEX(OUTFILES,',') .EQ. 0)) THEN
                  WRITE(6,960) FILES(1:LENGTH(FILES))
                  CALL EXIT(1)
               ENDIF
            ENDIF
         ELSE
            LIST = .FALSE.
         ENDIF
      ELSE
         OUTFILES = ' '
         LIST = .FALSE.
      ENDIF
C
      I = INDEX(OUTFILES,'*')
      IF (I .NE. 0) THEN
         OUTFILES(I:I) = ' '
         CALL BLANKS (OUTFILES)
         OUTWILD = .TRUE.
      ELSE
         OUTWILD = .FALSE.
      ENDIF
      IPTR = 1
C
C --- OK, WE HAVE THE FILE LISTS NOW
C
C --- LET'S CHECK OUT THE QUALIFIERS
C
      DEFINEQ = ' '
      SUPPRESS = .FALSE.
      ACHAR = '%'
      DO 10 I = 1, NQ
         L = INDEX(Q(I),'=') - 1
         IF (L .LE. 0) L = LENGTH(Q(I))
         CALL SEARCH (QUALS, NQUALS, Q(I)(1:L), K,
     $            MATCHD, AMBIG)
C
         IF (AMBIG) THEN
            WRITE(6,930) Q(I)
            CALL EXIT(1)
         ENDIF
C
         IF (MATCHD) THEN
            IF (QUALS(K) .EQ. 'OUTPUT') THEN
               FNAME = Q(I)(L+2:)
               IF (FNAME .NE. ' ') THEN
                  CLOSE (UNIT=6)
                  OPEN (UNIT=6, FILE=FNAME, STATUS='NEW', ERR=1000)
               ENDIF
            ELSE IF (QUALS(K) .EQ. 'ATTENTION') THEN
               IEQ = INDEX(Q(I),'=')
               IF (IEQ .GT. 0) THEN
                  CCHAR = Q(I)(IEQ+1:)
                  CALL RIGHT (CCHAR)
                  READ(CCHAR,990,err=1001) IACHAR                  
                  IF ((IACHAR .LT. 33) .OR.
     $                (IACHAR .GT. 126)) go to 1001
                  ACHAR = CHAR(IACHAR)
               ENDIF
            ELSE IF (QUALS(K) .EQ. 'EXCLUDE') THEN
               EXFILE = Q(I)(L+2:)
            ELSE IF (QUALS(K) .EQ. 'INCLUDE') THEN
               IEQ = INDEX(Q(I),'=')
               IF (IEQ .GT. 0) INCFILE = Q(I)(IEQ+1:)
            ELSE IF (QUALS(K) .EQ. 'DEFINE') THEN
               IEQ = INDEX(Q(I),'=')
               IF (IEQ .NE. 0) THEN
                  IF (Q(I)(IEQ+1:IEQ+1) .EQ. '(') IEQ = IEQ + 1
                  LQ = LENGTH(Q(I))
                  IF (Q(I)(LQ:LQ) .EQ. ')') Q(I)(LQ:LQ) = ' ' 
                  IF (DEFINEQ .NE. ' ') THEN
                     DEFINEQ(LENGTH(DEFINEQ)+1:) = ',' // Q(I)(IEQ+1:)
                  ELSE
                     DEFINEQ = Q(I)(IEQ+1:)
                  ENDIF
               ENDIF
            ELSE IF (QUALS(K) .EQ. 'SUPPRESS') THEN
               SUPPRESS = .TRUE.
            ENDIF
         ELSE
            WRITE (6,950) Q(I)
         ENDIF
10    CONTINUE
C
C --- OK, NOW LET THE TOOL DO ITS STUFF
C
C --- EXTRACT FILE NAMES ONE AT A TIME
C
100   CALL GETFILEX ( FILES, ONEFILE, '.FPP', EXFILE )
C
C --- GENERATE NAME OF OUTPUT FILE FOR THIS INPUT FILE
C
      IF (ONEFILE .NE. ' ') THEN
         DID_SOME = .TRUE.
C
C ------ IF NO OUTLIST SPECIFIED, CREATE NEW VERSION OF INPUT FILE
C
         IF (OUTFILES .EQ. ' ') THEN
            CALL PARSE ('.FOR;', ONEFILE, 'FULL', OUTFILE)
C
C ------ IF THE INPUT(OUTPUT) FILE SPEC IS A LIST, FIGURE OUT NEXT 
C ------  FILE NAME FROM THE OUTLIST
C
         ELSE IF (LIST) THEN
            IF (OUTWILD) THEN
               CALL PARSE ( OUTFILES, ONEFILE, 'FULL', OUTFILE )
            ELSE
               I = INDEX (OUTFILES(IPTR:),',')
               IF (I .EQ. 0) THEN
                  WRITE(6,980)
                  CALL EXIT(1)
               ENDIF
               I = I + IPTR
               OUTFILE = OUTFILES(IPTR:I-1)
               IPTR = I + 1
            ENDIF
C
C --- SINGLE OUTPUT FILE SPECIFIED
C
         ELSE
            OUTFILE = OUTFILES
         ENDIF
C
C --- AT LAST! PROCESS A SINGLE FILE
C
         CALL FPP ( ONEFILE, OUTFILE, INCFILE, DEFINEQ, SUPPRESS )
         GO TO 100
      ENDIF
C
      IF (.NOT. DID_SOME) WRITE (6,925)
      CALL EXIT(1)
C
1000  WRITE(6,940) Q(I)
      CALL EXIT(1)
1001  write(6,935)
      call exit(1)
C
900   FORMAT(' File ? ',$)
910   FORMAT(A20)
920   FORMAT(' No file specified.')
925   FORMAT(' No files processed.')
930   FORMAT(' Ambiguous qualifier ',A)
935   FORMAT(
     $ ' Attention character must be an ASCII printable character...',/,
     $ ' /ATTENTION=ii, where ii is in the range of 33 to 126')
940   FORMAT(' Unable to open output file ',A)
950   FORMAT(' Unknown qualifier ignored, 'A)
960   FORMAT(
     $ ' ERROR - incompatible input and output file specifications :'/,
     $ X,A,5X,A,/
     $ ' When the input parameter is specified as a list, ',/,
     $ ' The output spec must contain a wildcard (e.g., *.TXT).')
970   FORMAT(
     $ ' ERROR - Illegal parameter ',A,/,
     $ ' A list with wildcards makes no sense on output.')
980   FORMAT(
     $ ' ERROR - There are more files in the input list than in ',
     $ 'the output list.')
990   FORMAT(I3)
      END
c
c---end fpp_main
c
      SUBROUTINE FPP (INFILE, OUTFILE, INCFILE, DEFINEQ, SUPPRESS)
C*
C*                  *******************************
C*                  *******************************
C*                  **                           **
C*                  **            FPP            **
C*                  **                           **
C*                  *******************************
C*                  *******************************
C*
C*     AUTHOR :
C*          Arthur E. Ragosta  
C*          RAGOSTA@MERLIN.ARC.NASA.GOV
C*          
C*          MS 219-1
C*          NASA Ames Research Center
C*          Moffett Field, Ca.  94035
C*          (415) 604-5558
C*
C*     DESCRIPTION :
C*          FORTRAN PREPROCESSOR - A SIMPLE PREPROCESSOR FOR FORTRAN
C*          PROGRAMS.
C*
C*     COMMON BLOCKS :
C*          DEFINES.CMN,   FPP.CMN
C*
C*     SUBPROGRAM REFERENCES :
C*          PARSE, FILE_PARTS, CTIME, DATE, GETUSER, DO_CARD
C*          GET_CARD, OUT_CARD
C*
C*     ASSUMPTIONS AND RESTRICTIONS :
C*
C*     LANGUAGE AND COMPILER :
C*          ANSI FORTRAN 77
C*
C*     CHANGE HISTORY :
C*          18-APR-1991  -  INITIAL VERSION
C*          16-MAY-1991  -  ADDED DEC "%" BUILTINS
C*
C***********************************************************************
C*
      INCLUDE 'DEFINES.CMN'
      INCLUDE 'FPP.CMN'
      CHARACTER *(*) INFILE, OUTFILE, INCFILE, DEFINEQ
      CHARACTER *120 P_FILE
      CHARACTER *80 FIELD
      CHARACTER *12 P_USER
      CHARACTER *11 P_DATE
      CHARACTER *8 P_TIME
      LOGICAL EOF, SUPPRESS, CMD
C
      INUNIT = 11
      OPEN (UNIT=INUNIT, FILE=INFILE, STATUS='OLD', ERR=1000)
      OPEN (UNIT=10, FILE=OUTFILE, STATUS='NEW',
     $    CARRIAGECONTROL='LIST', ERR=2000)
C
C --- CHECK FOR "/INCLUDE" FILE
C
      IF (INCFILE .NE. ' ') THEN
         INUNIT = INUNIT + 1
         OPEN (UNIT=INUNIT, FILE=INCFILE, STATUS='OLD', ERR=1)
         GO TO 2
1        WRITE(6,*)'Unable to open include file ' // 
     $               INCFILE(1:LENGTH(INCFILE))
         INUNIT = INUNIT - 1
      ENDIF
C
C --- DEFINE PREDEFINES
C
2     DEFINE(1)     = 'LINE'
      DEFINITION(1) = '0'
      CALL DATE ( P_DATE )
      DEFINE(2)     = 'DATE'
      DEFINITION(2) = P_DATE
      CALL CTIME ( P_TIME )
      DEFINE(3)     = 'TIME'
      DEFINITION(3) = P_TIME
      CALL FILE_PARTS ( 0, 0, 1, 1, 1, INFILE, P_FILE )
      DEFINE(4)     = 'FILE'
      DEFINITION(4) = P_FILE
      DEFINE(5)     = 'FFILE'
      DEFINITION(5) = INFILE
      CALL GETUSER ( P_USER )
      DEFINE(6)     = 'USER'
      DEFINITION(6) = P_USER
      DEFINE(7)     = 'COUNT'
      DEFINITION(7) = ' '
      NUM_DEF = 7
      IF (ACHAR .EQ. '%') THEN
         DEFINE(8)     = 'LOC'
         DEFINITION(8) = '%LOC'
         DEFINE(9)     = 'REF'
         DEFINITION(9) = '%REF'
         DEFINE(10)    = 'DESCR'
         DEFINITION(10)= '%DESCR'
         DEFINE(11)    = 'VAL'
         DEFINITION(11)= '%VAL'
         NUM_DEF  = 11
      ENDIF
      P_LINE   = 0
      IF_LEVEL = 1
      SKIP(1)  = .FALSE.
      ICOUNT   = 1
C
C --- DEFINITIONS ENTERED AS A QUALIFIER
C
C                 FIELD
C                  or
C           ( FIELD [,FIELD...])
C
C       FIELD  ::=  NOUN or NOUN=DEFINITION
C ---
C
      IF (DEFINEQ .NE. ' ') THEN
         ISD = 1
         IED = LENGTH(DEFINEQ)
         IF (DEFINEQ(1:1) .EQ. '(') THEN
            ISD = 2
            IF (DEFINEQ(IED:IED) .EQ. ')') IED = IED - 1
         ENDIF
C
C  ----  OKAY, EXTRACT SINGLE DEFINITION FIELD FROM DEFINEQ.
C  ----   MAKE THINGS EASY ON OURSELVES, LET "DO_CARD" DO THE WORK.
C
5        IF (ISD .LE. IED) THEN
            ICOM = INDEX(DEFINEQ(ISD:),',')
            IF (ICOM .EQ. 0) THEN
               FIELD = DEFINEQ(ISD:IED)
               ISD = IED+1
            ELSE
               FIELD = DEFINEQ(ISD:ICOM+ISD-2)
               ISD = ISD+ICOM
            ENDIF
            IEQ = INDEX(FIELD,'=')
            IF (IEQ .NE. 0) FIELD(IEQ:IEQ) = ' '
            CARD = ACHAR // 'DEFINE ' // FIELD
            CALL DO_CARD (CMD)
            GO TO 5
         ENDIF
      ENDIF
C
C --- LOOP UNTIL DONE !
C
10    CALL GET_CARD (EOF)
C
C --- IF WE REACHED AN END OF FILE, IT COULD BE THE END OF THE INPUT 
C     DECK, OR THE END OF AN INCLUDED FILE
C
      IF (EOF) THEN
         IF (INUNIT .GT. 11) THEN
            CLOSE (UNIT=INUNIT)
            INUNIT = INUNIT - 1
            IF ( .NOT. SUPPRESS) THEN
               CARD = 'C' // ACHAR // 'END INCLUDE'
               CALL OUT_CARD (SUPPRESS)
            ENDIF
            GO TO 10
         ENDIF
      ELSE
C
C --- CHECK THE CARD FOR COMMANDS OR DEFINITIONS
C
         CALL DO_CARD (CMD)
C
C --- OUTPUT THE CARD, UPDATE LINE COUNT
C
         IF (.NOT. CMD  .OR.  .NOT. SUPPRESS)
     $            CALL OUT_CARD (SUPPRESS)
         GO TO 10
      ENDIF
C
      CLOSE (UNIT=10)
      CLOSE (UNIT=11)       
      IF (IF_LEVEL .NE. 1) WRITE(6,*) 'Improperly nested IF statements.'
      RETURN
C
1000  WRITE(6,*)'Can''t open input file ' // INFILE(1:LENGTH(INFILE))
      RETURN
C
2000  WRITE(6,*)'Can''t open output file '// OUTFILE(1:LENGTH(OUTFILE))
      RETURN
      END
C
C---END FPP
C
      SUBROUTINE Get_Card (EOF)
C*
C*                  *******************************
C*                  *******************************
C*                  **                           **
C*                  **         Get_Card          **
C*                  **                           **
C*                  *******************************
C*                  *******************************
C*
C*     AUTHOR :
C*          Arthur E. Ragosta  
C*          RAGOSTA@MERLIN.ARC.NASA.GOV
C*          
C*          MS 219-1
C*          NASA Ames Research Center
C*          Moffett Field, Ca.  94035
C*          (415) 604-5558
C*
C*     DESCRIPTION :
C*          READ A CARD FROM AN INPUT (OR INCLUDED) FILE
C*
C*     OUTPUT ARGUMENTS :
C*          EOF - IF END OF FILE ON THIS UNIT
C*
C*     COMMON BLOCKS :
C*          FPP.CMN
C*
C*     LANGUAGE AND COMPILER :
C*          ANSI FORTRAN 77
C*
C*     CHANGE HISTORY :
C*          19-APR-1991  -  INITIAL VERSION
C*
C***********************************************************************
C*
      INCLUDE 'FPP.CMN'
      LOGICAL EOF
c
      READ(INUNIT,900,END=1000) CARD
      EOF = .FALSE.
      RETURN
C
1000  EOF = .TRUE.
      CARD = ' '
      RETURN
C    
900   FORMAT(A)
      END
C
C---END Get_Card
C
      SUBROUTINE Do_Card (CMD)
C*
C*                  *******************************
C*                  *******************************
C*                  **                           **
C*                  **          Do_Card          **
C*                  **                           **
C*                  *******************************
C*                  *******************************
C*
C*     AUTHOR :
C*          Arthur E. Ragosta  
C*          RAGOSTA@MERLIN.ARC.NASA.GOV
C*          
C*          MS 219-1
C*          NASA Ames Research Center
C*          Moffett Field, Ca.  94035
C*          (415) 604-5558
C*
C*     DESCRIPTION :
C*          CHECKS THE CARD FOR COMMANDS OR DEFINITIONS TO BE EXPANDED.
C*          SETS "SKIP" FLAGS FOR "OUT_CARD" WHEN NECESSARY.
C*          REPLACES DEFINED VARIABLES WITH THEIR DEFINITIONS (IF THIS
C*          CAUSES CARD TO BE TOO LONG, IT IS CORRECTED IN OUT_CARD.
C*
C*     COMMON BLOCKS :
C*          DEFINES.CMN,  FPP.CMN
C*
C*     SUBPROGRAM REFERENCES :
C*          CAPS, LEFT, ISALPHA, EXIT, GET_DEF
C*
C*     ASSUMPTIONS AND RESTRICTIONS :
C*
C*     LANGUAGE AND COMPILER :
C*          ANSI FORTRAN 77
C*
C*     CHANGE HISTORY :
C*          19-APR-1991  -  INITIAL VERSION
C*
C***********************************************************************
C*
      INCLUDE 'DEFINES.CMN'
      INCLUDE 'FPP.CMN'
      CHARACTER *124 REST, REST1, DUMMY
      CHARACTER *40 DEF
      CHARACTER *8 COMMAND
      LOGICAL ISALPHA, FOUND, EQUAL, CMD
      INTEGER GET_DEF
C
      CMD = .FALSE.
      IF ((CARD(1:1) .EQ. ACHAR) .OR. (CARD(1:2) .EQ. 'C'//ACHAR) .OR.
     $    (CARD(1:2) .EQ. 'c'//ACHAR) .OR. (CARD(1:2) .EQ. '!'//ACHAR))
     $  THEN
C
C  ----  COMMAND CARD
C
         CMD = .TRUE.
         IP = INDEX(CARD,ACHAR) + 1
         IF (IP .EQ. 2) THEN        ! ADD COMMENT INDICATOR TO CARD
            CARD = 'C' // CARD
            IP = 3
         ENDIF
         IE = INDEX(CARD,' ')       ! EXTRACT COMMAND VERB
         COMMAND = CARD(IP:IE)
         CALL CAPS(COMMAND)
         REST = CARD(IE+1:)         ! AND THE REST OF THE CARD (IF ANY)
         CALL LEFT(REST)
C
C  ----  GOT THE COMMAND VERB IN 'COMMAND' AND REST OF CARD IN 'REST'
C
C
C  ----     >>>  DEFINE  <<<
C
         IF (COMMAND .EQ. 'DEFINE') THEN
            IF (SKIP(IF_LEVEL)) THEN         ! IF SKIPPING REMOVE "C" PUT
               CARD = CARD(2:)               ! ON ABOVE BECAUSE "OUT_CARD"
            ELSE                             ! WILL DO IT ANYWAY
               IF (REST .EQ. ' ') THEN
                  WRITE(6,*) 'Nothing to define!'
               ELSE
                  IB = INDEX(REST,' ')
                  DEF = REST(1:IB)
                  CALL CAPS(DEF)
                  REST = REST(IB+1:)
                  CALL LEFT(REST)
               ENDIF
c
c  ------  if it's already defined replace the old definition; otherwise
c           add to the end of the list
c
               DO 10 I = 1, NUM_DEF
                  IF (DEF .EQ. DEFINE(I)) GO TO 20 
10             CONTINUE
C
C  ------  NOT PREVIOUSLY FOUND, ADD TO END
C
               IF (NUM_DEF .LT. MAX_DEF) THEN
                  NUM_DEF = NUM_DEF + 1
                  I = NUM_DEF
               ELSE
                  WRITE(6,*) 'Maximum number of definitions exceeded.'
                  CALL EXIT(1)
               ENDIF
20             DEFINE(I) = DEF
               DEFINITION(I) = REST
            ENDIF
C
C  ----     >>>  IFDEF / IFNDEF  <<<
C
         ELSE IF ((COMMAND .EQ. 'IFDEF') .OR.
     $            (COMMAND .EQ. 'IFNDEF')) THEN 
           IF (IF_LEVEL .GE. MAX_SKIP) THEN
               WRITE(6,*)'IF statements nested too deeply.'
               CALL EXIT(1)
            ENDIF
            IF_LEVEL = IF_LEVEL + 1
C
            IF (REST .EQ. ' ') THEN
               WRITE(6,*) 'IFDEF what?!'
            ELSE
C
C           +----------------------+
C           |    SKIPPING RULES    |
C           +----------------------+
C
C           IF WE ARE ALREADY SKIPPING, THEN WE MUST CONTINUE TO SKIP
C           REGARDLESS OF NEW "IF" CONDITION OR "ELSE" COMMAND.  IF WE
C           ARE NOT CURRENTLY SKIPPING, VALIDATE "IF" CONDITION TO SEE
C           IF WE SHOULD START SKIPPING; ON AN ELSE, NEGATE THE
C           VALUE FOR THE "IF" CONDITION.
C
               CALL CAPS(REST)
               CALL GET_DEF (REST, DUMMY, FOUND)
               IF (FOUND) THEN   
                  IF (COMMAND .EQ. 'IFDEF') THEN
                     SKIP(IF_LEVEL) = SKIP(IF_LEVEL-1)
                  ELSE
                     SKIP(IF_LEVEL) = .TRUE.
                     CARD = CARD(2:)
                  ENDIF
               ELSE
                  IF (COMMAND .EQ. 'IFDEF') THEN
                     SKIP(IF_LEVEL) = .TRUE.
                     CARD = CARD(2:)
                  ELSE
                     SKIP(IF_LEVEL) = SKIP(IF_LEVEL-1)
                  ENDIF
               ENDIF
            ENDIF
C
C  ----     >>>  UNDEF  <<<
C
         ELSE IF (COMMAND .EQ. 'UNDEF') THEN
            IF (REST .EQ. ' ') THEN
               WRITE(6,*) 'UNDEF what?!'
            ELSE
               CALL CAPS(REST)
               I = GET_DEF (REST, DUMMY, FOUND)
               IF (FOUND) THEN  
C
C   --------   IF NOT AT THE END OF THE LIST, SWITCH WITH THE LAST DEFINITION
C
                  IF (I .NE. NUM_DEF) THEN
                     DEFINE(I)=DEFINE(NUM_DEF)
                     DEFINITION(I)=DEFINITION(NUM_DEF)
                  ENDIF 
                  NUM_DEF = NUM_DEF - 1
               ENDIF
            ENDIF
C
C  ----     >>>  IF  <<<
C
         ELSE IF (COMMAND .EQ. 'IF') THEN
           IF (IF_LEVEL .GE. MAX_SKIP) THEN
               WRITE(6,*)'IF statements nested too deeply.'
               CALL EXIT(1)
            ENDIF
            IF_LEVEL = IF_LEVEL + 1
C
C   ----   SEE SKIPPING RULES, ABOVE
C
            IF (REST .EQ. ' ') THEN
               WRITE(6,*) 'IF what?!'
            ELSE
               CALL CAPS(REST)
C
C   ------   STRING EQUALITY AND INEQUALITY ONLY.  EITHER STRING
C             MAY BE EITHER A LITERAL OR A DEFINITION
C
               IF (INDEX(REST,'==') .NE. 0) THEN
                  EQUAL = .TRUE.
                  REST1 = REST(INDEX(REST,'==')+2:)
                  REST(INDEX(REST,'=='):) = ' '
               ELSE IF (INDEX(REST,'<>') .NE. 0) THEN
                  EQUAL = .FALSE.
                  REST1 = REST(INDEX(REST,'<>')+2:)
                  REST(INDEX(REST,'<>'):) = ' '
               ELSE
                  WRITE(6,*)'Illegal expression in IF statement.'
                  RETURN
               ENDIF  
               CALL LEFT(REST1)
C
C   ------   EXPAND DEFINITIONS IF NECESSARY
C
               IF (REST(1:1) .EQ. ACHAR) THEN
                  CALL GET_DEF (REST(2:), DUMMY, FOUND)
                  IF (FOUND) THEN
                     REST = DUMMY
                  ELSE
                     REST = ' '
                  ENDIF
               ENDIF
               IF (REST1(1:1) .EQ. ACHAR) THEN
                  CALL GET_DEF (REST1(2:), DUMMY, FOUND)
                  IF (FOUND) THEN
                     REST1 = DUMMY
                  ELSE
                     REST1 = ' '
                  ENDIF
               ENDIF
C
               IF (EQUAL) THEN
                  IF (REST .EQ. REST1) THEN   
                     SKIP(IF_LEVEL) = SKIP(IF_LEVEL-1)
                  ELSE
                     SKIP(IF_LEVEL) = .TRUE.
                     CARD = CARD(2:)
                  ENDIF
               ELSE
                  IF (REST .NE. REST1) THEN   
                     SKIP(IF_LEVEL) = SKIP(IF_LEVEL-1)
                  ELSE
                     SKIP(IF_LEVEL) = .TRUE.
                     CARD = CARD(2:)
                  ENDIF
               ENDIF
            ENDIF
C
C  ----     >>>  ELSE  <<<
C
C  ----  SEE SKIPPING RULES, ABOVE
C
         ELSE IF (COMMAND .EQ. 'ELSE') THEN
            SKIP(IF_LEVEL) = (.NOT. SKIP(IF_LEVEL)) .OR.
     $                       (SKIP(IF_LEVEL-1))
            IF (SKIP(IF_LEVEL)) CARD = CARD(2:)
C
C  ----     >>>  ENDIF  <<<
C
         ELSE IF (COMMAND .EQ. 'ENDIF') THEN
            IF_LEVEL = IF_LEVEL - 1
            IF (SKIP(IF_LEVEL)) CARD = CARD(2:)
C
C  ----     >>>  INCLUDE  <<<
C
         ELSE IF (COMMAND .EQ. 'INCLUDE') THEN
            IF (SKIP(IF_LEVEL)) THEN
               CARD = CARD(2:)
            ELSE
               IF (REST .EQ. ' ') THEN
                  WRITE(6,*) 'No file name on INCLUDE statement.'
               ELSE
                  IF (REST(1:1) .EQ. ACHAR) THEN
                     CALL GET_DEF (REST(2:), DUMMY, FOUND)
                     IF (FOUND) THEN
                        REST = DUMMY
                     ELSE
                        REST = REST(2:)
                     ENDIF
                  ENDIF
                  INUNIT = INUNIT + 1
                  OPEN (UNIT=INUNIT, FILE=REST, STATUS='OLD', ERR=1000)
               ENDIF
            ENDIF
C
C
         ELSE
            WRITE (6,*) 'Illegal command ' // COMMAND // 'ignored.'
         ENDIF
      ELSE
C
C
C  ----  NOT A COMMAND CARD, LOOK FOR DEFINED NAMES
C
C
         IC = 1
100      IP = INDEX(CARD(IC:),ACHAR)
C
C --- IF EMBEDDED COMMAND FOUND.... DO IT!
C
         IF (IP .GT. 0) THEN
            IF (CARD(IC+IP:IC+IP) .EQ. ACHAR) THEN      ! EMBEDDED ATTENTION
               CARD = CARD(1:IC+IP-1) // CARD(IC+IP+1:)
               IC = IC + IP
            ELSE                                      ! DEFINITION
C
C   -------   EXTRACT THE NOUN
C
               DEF = ' '
               ID = 1
               IPE = IC + IP
110            DEF(ID:ID) = CARD(IPE:IPE)
               ID = ID + 1
               IPE = IPE + 1
               IF ((ID .LE. 40) .AND. ISALPHA(CARD(IPE:IPE))) GO TO 110
               CALL CAPS(DEF)
C
C   -------   OKAY, FIND THE DEFINITION
C
               CALL GET_DEF (DEF, REST, FOUND)
C
C   -------   NOW UPDATE CARD
C
               IF (FOUND) THEN
                  CARD = CARD(1:IC+IP-2) // REST(1:LENGTH(REST)) //
     $                     CARD(IPE:)
                  IC = IC + IP - 1 + LENGTH(REST)
               ELSE 
                  IC = IC + 1
               ENDIF
            ENDIF
            GO TO 100
         ENDIF
      ENDIF
      RETURN
C
1000  WRITE(6,*) 'Unable to open file ' // REST
      INUNIT = INUNIT - 1
      RETURN
      END
C
C---END Do_Card
C
      SUBROUTINE Out_Card (SUPPRESS)
C*
C*                  *******************************
C*                  *******************************
C*                  **                           **
C*                  **         Out_Card          **
C*                  **                           **
C*                  *******************************
C*                  *******************************
C*
C*     AUTHOR :
C*          Arthur E. Ragosta  
C*          RAGOSTA@MERLIN.ARC.NASA.GOV
C*          
C*          MS 219-1
C*          NASA Ames Research Center
C*          Moffett Field, Ca.  94035
C*          (415) 604-5558
C*
C*     DESCRIPTION :
C*          OUTPUT A CARD.  IF EXPANSION CAUSED IT TO GO BEYOND
C*          72 COLUMNS, REWRAP IT.
C*
C*     COMMON BLOCKS :
C*          FPP.CMN, DEFINS.CMN
C*
C*     SUBPROGRAM REFERENCES :
C*          LENGTH, LEFT
C*
C*     ASSUMPTIONS AND RESTRICTIONS :
C*
C*     LANGUAGE AND COMPILER :
C*          ANSI FORTRAN 77
C*
C*     CHANGE HISTORY :
C*          19-APR-1991  -  INITIAL VERSION
C*          16-MAY-1991  -  FIXED CONTINUATION PRINTOUT
C*
C***********************************************************************
C*
      INCLUDE 'FPP.CMN'
      INCLUDE 'DEFINES.CMN'
      CHARACTER *8 TEMP
      LOGICAL IN_QUOTE, SUPPRESS
C
      LC = MAX(LENGTH(CARD),1)
      IF ((LC .LE. 72) .OR. (CARD(1:1) .EQ. 'C')  .OR.
     $    (CARD(1:1) .EQ. 'c')) GO TO 200
C
C  IF THE CARD IS GREATER THAN 72 COLUMNS THEN
C     IF THE CHARACTERS AFTER 72 ARE AN EXCL COMMENT, LET IT BE
C     ELSE WRITE FIRST CARD AND MAKE SECOND A CONTINUATION
C  ENDIF
C
      IEX = INDEX(CARD,'!') 
      IF (IEX .GT. 0) THEN
C
C  ----  COULD BE AN EXCLAMATION POINT COMMENT , BUT COULD JUST BE IN
C         A STRING
C
         IN_QUOTE = .FALSE.
         DO 10 I = 1, LC
            IF (CARD(I:I) .EQ. '''') IN_QUOTE = .NOT. IN_QUOTE
            IF ((CARD(I:I) .EQ. '!') .AND. (.NOT. IN_QUOTE)) THEN
               IF (I .LE. 72) GO TO 200 
               GO TO 100
            ENDIF
10       CONTINUE
      ENDIF
C
C --- PRINT THE FIRST PART OF THE CARD
C
100   IF (SKIP(IF_LEVEL)) THEN
         IF (.NOT. SUPPRESS) WRITE(10,910) CARD(1:72)
      ELSE
         WRITE(10,900) CARD(1:72)
      ENDIF
      P_LINE = P_LINE + 1
      CARD = '     $ ' // CARD(73:)       ! FALL THRU TO PRINT THIS
      LC = LENGTH(CARD)
C
C --- PRINT THE REST OF THE CARD
C
C --- IF WE ARE CURRENTLY SKIPPING, COMMENT OUT THIS CARD
C
200   IF (SKIP(IF_LEVEL)) THEN
         IF (.NOT. SUPPRESS) WRITE(10,910) CARD(1:LC)
      ELSE
         WRITE(10,900) CARD(1:LC)
      ENDIF
      P_LINE = P_LINE + 1
C
C --- UPDATE %LINE PREDEFINED VALUE
C
      WRITE(TEMP,920) P_LINE
      CALL LEFT(TEMP)
      DEFINITION(1) = TEMP       ! ALWAYS FIRST DEFINITION
      RETURN
C
900   FORMAT(A)
910   FORMAT('C',A)
920   FORMAT(I8)
      END
C
C---END Out_Card
C
      INTEGER FUNCTION GET_DEF ( DEF_IN, DEF_OUT, FOUND )
C*
C*                  *******************************
C*                  *******************************
C*                  **                           **
C*                  **          GET_DEF          **
C*                  **                           **
C*                  *******************************
C*                  *******************************
C*
C*     AUTHOR :
C*          Arthur E. Ragosta  
C*          RAGOSTA@MERLIN.ARC.NASA.GOV (Internet)
C*          
C*          MS 219-1
C*          NASA Ames Research Center
C*          Moffett Field, Ca.  94035
C*          (415) 604-5558
C*
C*     DESCRIPTION :
C*          SEARCH FOR A VARIABLE IN THE DEFINED LIST, IF FOUND RETURN
C*          THE DEFINED VALUE.  NOTE: FUNCTION VALUE = LOCATION IN LIST.
C*
C*     INPUT ARGUMENTS :
C*          DEF_IN  - VARIABLE NAME TO FIND
C*
C*     OUTPUT ARGUMENTS :
C*          DEF_OUT - ITS EXPANDED DEFINITION
C*          FOUND   - .TRUE. IF INDEED IT IS DEFINED, .FALSE. OTHERWISE
C*          GET_DEF - LOCATION IN THE LIST (IF FOUND)
C*
C*     COMMON BLOCKS :
C*          DEFINES.CMN
C*
C*     SUBPROGRAM REFERENCES :
C*          CAPS, LENGTH
C*
C*     ASSUMPTIONS AND RESTRICTIONS :
C*
C*     LANGUAGE AND COMPILER :
C*          ANSI FORTRAN 77
C*
C*     CHANGE HISTORY :
C*          15-MAY-1991  -  INITIAL VERSION
C*
C***********************************************************************
C*
      INCLUDE 'DEFINES.CMN'
      INCLUDE 'FPP.CMN'
      CHARACTER *(*) DEF_IN, DEF_OUT
      CHARACTER *7 INT
      LOGICAL FOUND
C
      CALL CAPS (DEF_IN)
      LD = LENGTH(DEF_IN)
      FOUND = .TRUE.
C
C --- BRUTE FORCE SEARCH (DEFINITIONS AREN'T ORDERED)
C
      DO 10 I = 1, NUM_DEF
         IF (DEFINE(I) .EQ. DEF_IN(1:LD)) THEN
C
            GET_DEF = I
            IF (DEF_IN .EQ. 'COUNT') THEN
               WRITE (INT,900) ICOUNT
               CALL LEFT(INT)
               DEF_OUT = INT
               ICOUNT = ICOUNT + 1
               RETURN
            ENDIF
            DEF_OUT = DEFINITION(I)
            RETURN
         ENDIF
10    CONTINUE
C
C --- NOT IN THE LIST
C
      FOUND = .FALSE.
      DEF_OUT = ' '
      GET_DEF = 0
      RETURN
900   FORMAT(I7)
      END
C
C---END GET_DEF
C
      SUBROUTINE FILE_PARTS ( IDEV, IDIR, INAM, ITYP, IVER, IN, OUT)
      CHARACTER *(*) IN, OUT
C
      OUT = ' '
      IOUT = 1
      IF (IDEV .NE. 0) THEN
         call parse (in, ' ', 'DEVICE', out)
         iout = length(out) + 1
      ENDIF
      IF (IDIR .NE. 0) THEN
         call parse (in, ' ', 'DIRECTORY', out(iout:))
         iout = length(out) + 1
      ENDIF
      IF (INAM .NE. 0) THEN
         call parse (in, ' ', 'NAME', out(iout:))
         iout = length(out) + 1
      ENDIF
      IF (ITYP .NE. 0) THEN
         call parse (in, ' ', 'TYPE', out(iout:))
         iout = length(out) + 1
      ENDIF
      IF (IVER .NE. 0) THEN
         call parse (in, ' ', 'VERSION', out(iout:))
      ENDIF
      RETURN
      END
C
C---END FILE_PARTS
C
