/****************************************************************************
 * NCSA Mosaic for the X Window System                                      *
 * Software Development Group                                               *
 * National Center for Supercomputing Applications                          *
 * University of Illinois at Urbana-Champaign                               *
 * 605 E. Springfield, Champaign IL 61820                                   *
 * mosaic@ncsa.uiuc.edu                                                     *
 *                                                                          *
 * Copyright (C) 1993, Board of Trustees of the University of Illinois      *
 *                                                                          *
 * NCSA Mosaic software, both binary and source (hereafter, Software) is    *
 * copyrighted by The Board of Trustees of the University of Illinois       *
 * (UI), and ownership remains with the UI.                                 *
 *                                                                          *
 * The UI grants you (hereafter, Licensee) a license to use the Software    *
 * for academic, research and internal business purposes only, without a    *
 * fee.  Licensee may distribute the binary and source code (if released)   *
 * to third parties provided that the copyright notice and this statement   *
 * appears on all copies and that no charge is associated with such         *
 * copies.                                                                  *
 *                                                                          *
 * Licensee may make derivative works.  However, if Licensee distributes    *
 * any derivative work based on or derived from the Software, then          *
 * Licensee will (1) notify NCSA regarding its distribution of the          *
 * derivative work, and (2) clearly notify users that such derivative       *
 * work is a modified version and not the original NCSA Mosaic              *
 * distributed by the UI.                                                   *
 *                                                                          *
 * Any Licensee wishing to make commercial use of the Software should       *
 * contact the UI, c/o NCSA, to negotiate an appropriate license for such   *
 * commercial use.  Commercial use includes (1) integration of all or       *
 * part of the source code into a product for sale or license by or on      *
 * behalf of Licensee to third parties, or (2) distribution of the binary   *
 * code or source code to third parties that need it to utilize a           *
 * commercial product sold or licensed by or on behalf of Licensee.         *
 *                                                                          *
 * UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR   *
 * ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED          *
 * WARRANTY.  THE UI SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY THE    *
 * USERS OF THIS SOFTWARE.                                                  *
 *                                                                          *
 * By using or copying this Software, Licensee agrees to abide by the       *
 * copyright law and all other applicable laws of the U.S. including, but   *
 * not limited to, export control laws, and the terms of this license.      *
 * UI shall have the right to terminate this license immediately by         *
 * written notice upon Licensee's breach of, or non-compliance with, any    *
 * of its terms.  Licensee may be held legally responsible for any          *
 * copyright infringement that is caused or encouraged by Licensee's        *
 * failure to abide by the terms of this license.                           *
 *                                                                          *
 * Comments and questions are welcome and can be sent to                    *
 * mosaic-x@ncsa.uiuc.edu.                                                  *
 ****************************************************************************/

#ifdef VMS   /* PGE */
#define STR_TOOLS_C
#include "str-tools.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#if defined(MULTINET) && defined(__DECC) && (__VMS_VER >= 70000000)
#define strdup  decc$strdup
#endif /* VMS V7.0 has, GEC */
#include <string.h>
#ifdef VMS   /* PGE */
#include <ctype.h>
#endif

/* Change from ifdef to support local copy of strdup. PGE */
#ifndef DEBUG

/* Use builtin strdup when appropriate -- code duplicated in tcp.h. */
#if defined(ultrix) || (defined(VMS) && (!defined(__DECC) || (__VMS_VER < 70000000) || (__DECC_VER <= 50230003))) || defined(NeXT)
extern char *strdup(char *str);
#endif /* DEC C V5.2 string.h has for VMS V7.0, GEC */

#else

#ifndef VMS  /* PGE, not needed with str-tools.h */
char *strstrdup(char *src,char *srch,char *rplc);
#endif

/* Copied from mo-www.c PGE */
/* VMS version 7.0 has strdup, GEC */
#if defined(ultrix) || (defined(VMS) && (!defined(__VMS_VER) || (__VMS_VER < 70000000))) || defined(NeXT) || defined(M4310)
char *strdup(char *str) {
  char *dup;

  if(!str)
    return NULL;

  dup = (char *)malloc(strlen (str) + 1);
  if(!dup)
    return NULL;

  dup = strcpy(dup, str);

  return dup;
}
#endif

int main() {

char *bob,*newstr;

	bob=strdup("This is test %d.");
	newstr=strstrdup(bob,"%d","1");

	printf("bob[%s]\nnew[%s]\n\n",bob,newstr);

	free(bob);
	free(newstr);

	bob=strdup("%d) This is test %d.");
	newstr=strstrdup(bob,"%d","2");

	printf("bob[%s]\nnew[%s]\n\n",bob,newstr);

	free(bob);
	free(newstr);

	bob=strdup("This is test %d.");
	newstr=strstrdup(bob,"%d","003");

	printf("bob[%s]\nnew[%s]\n\n",bob,newstr);

	bob=strdup("%d) This is test %d.");
	newstr=strstrdup(bob,"%d","004");

	printf("bob[%s]\nnew[%s]\n\n",bob,newstr);

#ifdef VMS
	bob=strdup("qwerty");
	printf("src[%s]\n",bob);
	newstr=my_chop (bob);
	printf("chopped[%s]\n\n",newstr);

	bob=strdup("qwerty  ");
	printf("src[%s]\n",bob);
	newstr=my_chop (bob);
	printf("chopped[%s]\n\n",newstr);

	bob=strdup("  qwerty  ");
	printf("src[%s]\n",bob);
	newstr=my_chop (bob);
	printf("chopped[%s]\n\n",newstr);
#endif

	exit(0);
}
#endif /* DEBUG */


char *getFileName(char *file_src) {

char *ptr;

	if (!file_src || !*file_src) {
		return(NULL);
	}

	ptr=strrchr(file_src,'/');

	if (!ptr || !*ptr) {
		return(file_src);
	}

	if (*ptr=='/' && *(ptr+1)) {
		ptr++;
	}
#ifdef VMS /* GEC */
        /*
        ** Handle special case of starting mosaic with an URL on the command
        ** line like "http://hostname/" in order to prevent a file name of
        ** "device:[directory]/".
        */
        if (*ptr=='/') {
           return("\0");
        }

        /*
        ** Handle case of filename having multiple dots, which is invalid on
        ** VMS. Remove all but the last dot (like unzip).
        */
        {
           char *ptr2, *ptr3;

           ptr3=strrchr(ptr,'.');   /* Pointer to last dot. */

           /* Handle special cases of compressed files, PGE */
           if ((ptr2 != ptr3) && (strcmp (ptr3, ".gz") == 0)) {
              *ptr3='-';               /* a.b.c.gz -> a_b.c-gz */
              ptr3=strrchr(ptr,'.');   /* Pointer to last dot. */
           }
           else if (strcmp (ptr3, ".Z") == 0) {
              *ptr3='_';               /* a.b.c.Z -> a_b.c_Z */
              ptr3=strrchr(ptr,'.');   /* Pointer to last dot. */
           }

           ptr2=strchr(ptr,'.');    /* Pointer to first dot. */
           while (ptr2 != ptr3) {
              *ptr2 = '_';
              ptr2=strchr(ptr,'.');
           }

           /* Remove version number of VMS files, PGE */
           ptr3=strrchr(ptr,';');   /* Pointer to last semicolon. */
           if (ptr3 != 0)
              *ptr3 = '\0';
        }
#endif

	return(ptr);
}


char *strstrdup(char *src, char *srch, char *rplc) {

char *dest=NULL,*local=NULL,*start=NULL,*found=NULL,*next=NULL;
int rplcLen=0,i,srchLen;

	if (!src || !*src || !srch || !*srch) {
		return(NULL);
	}

	if (rplc && *rplc) {
		rplcLen=strlen(rplc);
	}
	srchLen=strlen(srch);

	if (rplcLen>srchLen) {
		dest=(char *)calloc(1,sizeof(char));
	}
	else {
		dest=strdup(src);
	}
	*dest='\0';

	local=strdup(src);
	start=local;
	while (*start) {
		if (!(found=strstr(start,srch))) {
			if (rplcLen>srchLen) {
				realloc((void *)dest,((strlen(dest)+strlen(start)+4)*sizeof(char)));
				strcat(dest,start);
			}
			else {
				strcat(dest,start);
			}
			free(local);

			return(dest);
		}

		for (i=0,next=found; i<srchLen; i++,next++);
		*found='\0';
		if (rplcLen>srchLen) {
			realloc((void *)dest,((rplcLen+strlen(dest)+strlen(start)+4)*sizeof(char)));
			strcat(dest,start);
			if (rplcLen) {
				strcat(dest,rplc);
			}
		}
		else {
			strcat(dest,start);
			strcat(dest,rplc);
		}
		start=next;
	}

	return(dest);
}


char **string_to_token_array(char *str, char *delimiter)
{
  char **array, *tmp;
  int num=0, i=0;

  if(!str || !*str || !delimiter || !*delimiter)
    return NULL;

  /* first get number of tokens */
  tmp = strstr(str, delimiter);
  num++; tmp++;
  while((tmp = strstr(tmp, delimiter)) != NULL)
    {
      tmp++; num++;
    }

  array = malloc(sizeof(char *) * (num+2));
  array[0] = strdup(strtok(str, delimiter));

  i++;
  while((array[i++] = strdup(strtok((char *) NULL, delimiter))) != NULL);


  free(str);
  return array;
}

char *my_strndup(char *str, int num)
{
#ifdef VMS  /* fix memory leak PGE */
  char *nstr;
#else
  char *nstr = malloc(sizeof(char) * (num + 1));
#endif

  if(!str || !*str || !nstr)
    return NULL;

#ifdef VMS  /* fix memory leak PGE */
  nstr = malloc(sizeof(char) * (num + 1));
#endif

  strncpy(nstr, str, num);
  nstr[num] = '\0'; /* shouldn't strcpy do this ?? */
                    /* strcpy does but strncpy does not PGE */
  return nstr;
}

char *my_chop(char *str)
{
  char *ptr;

  if(!str || !*str)
    return str;

#ifdef VMS  /* Fix code too poorly written to live. PGE */
  /* Remove blank space from end of string. */
  ptr = str + strlen(str) - 1;
  while((ptr >= str) && isspace(*ptr))
    {
      *ptr = '\0';
      ptr--;
    }

  /* Remove blank space from start of string. */
  ptr = str;
  while(isspace(ptr[0]))
    ptr++;

  /*
  ** If there was blank space at start of string then move string back to the
  ** beginning. This prevents memory freeing problems later if pointer is
  ** moved. memmove is used because it is safe for overlapping regions.
  */
  if (ptr != str)
    memmove (str, ptr, strlen (ptr) + 1);

#else
  while(isspace(str[0]))
    str++;

  while(isspace(str[strlen(str)-1]) || isspace(str[strlen(str)-1]))
    {
      str[strlen(str)-1] = '\0';
    }
#endif

  return str;
}
