! MMS description file for Mosaic
! Bjorn S. Nilsson, Aleph, CERN, 21-Nov-1993
! (Mosaic version 2.0)
! Motif 1.2 support added on 3-Jun-1994
! Mosaic 2.4 on 20-Aug-1994
! Mosaic 2.6 on 21-Oct-1995 by George Cook
!
! This description file is intended to be invoked by the top level
! description file.  It should not be invoked directly.
!

.INCLUDE CONFIG.MMS_$(WORK)

WDIR = [.$(WORK)]

LIBTARGET = $(WDIR)src.olb

VMS_DEFS = $(VMS_DEF1)$(VMS_DEF2)

NAME = MOSAIC

.IFDEF NOWAIS
.ELSE
LIBWAIS = [-.freeWAIS-0_5.IR.$(WORK)]libWAIS.Olb
LIBWAISQ = ,$(LIBWAIS)/LIB
.ENDIF

.IFDEF DECC
.IFDEF PATHWAY
.INCLUDE [-.TWG]DECC_PREFIX_RULES.MMS		! GET OUR RULES
CQUALC=/DECC/Standard=VAXC $(CC_PREFIX_NO_SIN)
.ELSE
.IFDEF MULTINET
CQUALC=/DECC/Standard=VAXC/Prefix=ANSI
.ELSE
CQUALC=/DECC/Standard=VAXC
.ENDIF
.ENDIF
.ELSE	! VAX C
.IFDEF DECCVAXC
CQUALC=/VAXC
.ELSE
CQUALC=
.ENDIF
.ENDIF


.IFDEF MULTINET
CDEFS =/Define=($(VMS_DEFS)MULTINET)
OPTION_FILE = Multinet.Opt
TCP=MULTINET
.ELSE    ! Not MULTINET

.IFDEF PATHWAY
CDEFS =/Define=($(VMS_DEFS)WIN_TCP)
OPTION_FILE = PathWay.Opt
TCP=WIN_TCP
.ELSE  ! Not PATHWAY  BGT

.IFDEF SOCKETSHR ! BGT
CDEFS =/Define=($(VMS_DEFS)SOCKETSHR) ! BGT
OPTION_FILE = Socketshr.Opt ! BGT
TCP=SOCKETSHR ! BGT
.ELSE  ! Not SOCKETSHR, i.e. UCX  BGT

CDEFS =/Define=($(VMS_DEFS)UCX)
.IFDEF DECC
OPTION_FILE = UCX_ALPHA.Opt
.ELSE
OPTION_FILE = UCX_VAX.Opt
.ENDIF
TCP=UCX
.ENDIF

.ENDIF
.ENDIF


.IFDEF DEBUG
CFLAGS =$(CQUALC)$(CDEFS)/NoOpt/Debug
LOPTIONS =/Debug
.ELSE
CFLAGS =$(CQUALC)$(CDEFS)
LOPTIONS =/NoDebug/NoTrace
.ENDIF

.IFDEF MOTIF1_2
LIBS = $(OPTION_FILE)/Opt,Motif1_2.Opt/Opt
.ELSE
LIBS = $(OPTION_FILE)/Opt,Motif1_1.Opt/Opt
.ENDIF

.LAST
	@ Delete Config.mms_$(WORK);*
.FIRST
        @ If F$Search("$(LIBTARGET)") .EQS. "" Then Library/Create $(LIBTARGET)
	@ Define/NoLog Odir $(WDIR)
	@ Topdir = F$Environment("Default")-"SRC]"
	@ Define LIBWWW2  'Topdir'LIBWWW2]
	@ Define LIBXMX   'Topdir'LIBXMX]
	@ Define LIBHTMLW 'Topdir'LIBHTMLW]
	@ Define LIBJPEG  'Topdir'LIBJPEG]
	@ Define LIBNUT   'Topdir'LIBNUT]
	@ Define LIBPNG   'Topdir'LIBPNG]
	@ Define ZLIB     'Topdir'LIBPNG.ZLIB]
	@ Define LIBVMS   'Topdir'LIBVMS]
	@ Purge Config.mms_$(WORK)
.IFDEF PATHWAY
	@ @[-.TWG]DEF
.ELSE
	@ Define/NoLog Sys SYS$Library
.IFDEF DECC
.IFDEF ALPHA
	@ If F$TRNLNM("ALPHA$LIBRARY") .NES. "" Then Define/NoLog Sys Alpha$Library
.ELSE
	@ If F$TRNLNM("DECC$LIBRARY_INCLUDE") .NES. "" Then Define/NoLog Sys DECC$Library_Include
.ENDIF
.ENDIF
	@ Define Netinet SYS
.ENDIF
.IFDEF DECC
.IFDEF PATHWAY
	@ Define DECC$User_Include 'F$Environment("Default")',LIBWWW2, -
					LIBHTMLW,LIBXMX,LIBJPEG,LIBPNG,ZLIB
.ELSE
	@ Define DECC$User_Include 'F$Environment("Default")',LIBWWW2, -
					LIBHTMLW,LIBXMX,LIBJPEG,LIBPNG,ZLIB,SYS
	@ Define DECC$SYSTEM_Include 'F$Environment("Default")',LIBWWW2, -
					LIBHTMLW,LIBXMX,LIBJPEG,LIBPNG,ZLIB,SYS
.ENDIF
.ELSE	! VAX C compilation
.IFDEF PATHWAY
	@ Define C$Include 'F$Environment("Default")',LIBWWW2, -
					LIBHTMLW,LIBXMX,LIBJPEG,LIBPNG,ZLIB
.ELSE
	@ Define C$Include 'F$Environment("Default")',LIBWWW2, -
					LIBHTMLW,LIBXMX,LIBJPEG,LIBPNG,ZLIB,SYS
	@ Define VAXC$Include 'F$Environment("Default")',LIBWWW2, -
					LIBHTMLW,LIBXMX,LIBJPEG,LIBPNG,ZLIB,SYS
.ENDIF
.ENDIF

PROG_LIBS = [-.LIBHTMLW.$(WORK)]LIBHTMLW.OLB [-.LIBXMX.$(WORK)]LIBXMX.OLB \
  [-.LIBWWW2.$(WORK)]LIBWWW.OLB [-.LIBJPEG.$(WORK)]LIBJPEG.OLB \
  [-.LIBNUT.$(WORK)]LIBNUT.OLB [-.LIBPNG.$(WORK)]LIBPNG.OLB \
  [-.LIBPNG.ZLIB.$(WORK)]LIBZ.OLB [-.LIBVMS.$(WORK)]LIBVMS.OLB $(LIBWAIS)
PROG_LIBSQ = [-.LIBHTMLW.$(WORK)]LIBHTMLW.OLB/LIB,[-.LIBXMX.$(WORK)]LIBXMX.OLB/LIB,[-.LIBWWW2.$(WORK)]LIBWWW.OLB/LIB,[-.LIBJPEG.$(WORK)]LIBJPEG.OLB/LIB,[-.LIBNUT.$(WORK)]LIBNUT.OLB/LIB,[-.LIBPNG.$(WORK)]LIBPNG.OLB/LIB,[-.LIBPNG.ZLIB.$(WORK)]LIBZ.OLB/LIB,[-.LIBVMS.$(WORK)]LIBVMS.OLB/LIB$(LIBWAISQ)
 
OBJS = Odir:main.obj,Odir:gui.obj,Odir:gui-dialogs.obj,Odir:gui-menubar.obj,\
 Odir:gui-documents.obj,Odir:mo-www.obj,Odir:mo-dtm.obj,Odir:hotlist.obj,\
 Odir:techsupport.obj,Odir:history.obj,Odir:annotate.obj,Odir:pan.obj,Odir:grpan.obj,\
 Odir:grpan-www.obj,Odir:audan.obj,Odir:globalhist.obj,Odir:img.obj,\
 Odir:picread.obj,Odir:xpmhash.obj,Odir:xpmread.obj,Odir:gifread.obj,\
 Odir:pixmaps.obj,Odir:medcut.obj,Odir:mo-hdf.obj,Odir:accept.obj,Odir:bla.obj,\
 Odir:ccibindings.obj,Odir:ccibindings2.obj,Odir:cciserver.obj,Odir:child.obj,\
 Odir:comment.obj,Odir:gui-news.obj,Odir:hotfile.obj,Odir:kcms.obj,\
 Odir:mailto.obj,Odir:md5.obj,Odir:readjpeg.obj,Odir:support.obj,\
 Odir:proxy-dialogs.obj,Odir:proxy-misc.obj,Odir:gui-extras.obj,Odir:readpng.obj,\
 Odir:prefs.obj,Odir:newsrc.obj,Odir:gui-popup.obj,Odir:gui-ftp.obj

default : $(LIBTARGET) $(NAME).exe_$(WORK)
	@ Continue

$(NAME).exe_$(WORK) : $(LIBTARGET) $(PROG_LIBS)
    LINK$(LOPTIONS)/Exe=$(NAME).exe_$(WORK) $(LIBTARGET)/Lib/Inc=(main,mailto,md5),$(PROG_LIBSQ),[]$(LIBS)
    @ Write SYS$Output "Linking done.  Welcome to VMS Mosaic 2.7-4"

$(LIBTARGET) : $(LIBTARGET)($(OBJS))
        @ If F$Search("$(WDIR)work.mark") .NES. "" Then Delete $(WDIR)work.mark;*
        @ If F$Search("$(WDIR)work.done") .EQS. "" Then Copy Descrip.mms $(WDIR)work.done
	@ Write SYS$Output "Library src.olb built."

Odir:accept.obj :        accept.c [-.libwww2]tcp.h port.h accept.h \
                         memstuffforpipsqueeks.h
Odir:annotate.obj :      annotate.c mosaic.h [-.libxmx]xmx.h toolbar.h prefs.h \
                         prefs_defs.h pwd.h
Odir:audan.obj :         audan.c mosaic.h [-.libxmx]xmx.h toolbar.h prefs.h \
                         prefs_defs.h pwd.h [-.libnut]system.h
Odir:bla.obj :           bla.c cciserver.h cci.h port.h list.h \
                         memstuffforpipsqueeks.h [-.libwww2]htplain.h \
                         [-.libwww2]htstream.h [-.libwww2]htutils.h \
                         [-.libwww2]htstring.h [-.libwww2]htatom.h \
                         [-.libwww2]htanchor.h [-.libwww2]htlist.h \
                         [-.libwww2]htformat.h [-.libwww2]htaccess.h \
                         [-.libwww2]htext.h [-.libwww2]htfile.h \
                         [-.libwww2]tcp.h [-.libwww2]html.h \
                         [-.libwww2]htmldtd.h [-.libwww2]sgml.h \
                         [-.libwww2]htcompressed.h
Odir:ccibindings.obj :   ccibindings.c cci.h port.h mosaic.h [-.libxmx]xmx.h \
                         toolbar.h prefs.h prefs_defs.h [-.libhtmlw]html.h
Odir:ccibindings2.obj :  ccibindings2.c mosaic.h [-.libxmx]xmx.h toolbar.h \
                         prefs.h prefs_defs.h cciserver.h cci.h port.h \
                         list.h memstuffforpipsqueeks.h [-.libwww2]htformat.h \
                         [-.libwww2]htstring.h [-.libwww2]htstream.h \
                         [-.libwww2]htatom.h [-.libwww2]htlist.h \
                         [-.libwww2]htanchor.h [-.libwww2]htformat.h \
                         [-.libwww2]htutils.h
Odir:cciserver.obj :     cciserver.c mosaic.h [-.libxmx]xmx.h toolbar.h \
                         prefs.h prefs_defs.h memstuffforpipsqueeks.h cci.h \
                         port.h accept.h
Odir:child.obj :         child.c list.h
Odir:comment.obj :       comment.c mosaic.h [-.libxmx]xmx.h toolbar.h prefs.h \
                         prefs_defs.h comment.h pwd.h
Odir:gifread.obj :       gifread.c
Odir:globalhist.obj :    globalhist.c mosaic.h [-.libxmx]xmx.h toolbar.h \
                         prefs.h prefs_defs.h [-.libhtmlw]html.h \
                         [-.libnut]system.h
Odir:grpan.obj :         grpan.c mosaic.h [-.libxmx]xmx.h toolbar.h prefs.h \
                         prefs_defs.h
Odir:grpan-www.obj :     grpan-www.c mosaic.h [-.libxmx]xmx.h toolbar.h \
                         prefs.h prefs_defs.h
Odir:gui.obj :           gui.c mosaic.h [-.libxmx]xmx.h toolbar.h prefs.h \
                         prefs_defs.h proxy.h pwd.h [-.libwww2]htaautil.h \
                         [-.libhtmlw]html.h xresources.h cci.h port.h
Odir:gui-dialogs.obj :   gui-dialogs.c mosaic.h [-.libxmx]xmx.h toolbar.h \
                         prefs.h prefs_defs.h [-.libhtmlw]html.h \
                         [-.libnut]system.h
Odir:gui-documents.obj : gui-documents.c mosaic.h [-.libxmx]xmx.h toolbar.h \
                         prefs.h prefs_defs.h [-.libhtmlw]html.h cci.h port.h
Odir:gui-extras.obj :    gui-extras.c mosaic.h [-.libxmx]xmx.h toolbar.h \
                         prefs.h prefs_defs.h [-.libhtmlw]html.h \
                         [-.libnut]system.h
Odir:gui-ftp.obj :       gui-ftp.c mosaic.h [-.libxmx]xmx.h toolbar.h prefs.h \
                         prefs_defs.h gui-popup.h [-.libhtmlw]html.h hotlist.h \
                         [-.libnut]system.h
Odir:gui-menubar.obj :   gui-menubar.c mosaic.h [-.libxmx]xmx.h toolbar.h \
                         prefs.h prefs_defs.h [-.libhtmlw]html.h gui-popup.h \
                         hotlist.h cci.h port.h [-.libwww2]htaautil.h
Odir:gui-news.obj :      gui-news.c [-.libwww2]htnews.h [-.libwww2]htaccess.h \
                         [-.libwww2]htstring.h [-.libwww2]tcp.h \
                         [-.libwww2]htlist.h [-.libwww2]htatom.h \
                         [-.libwww2]htformat.h [-.libwww2]htstream.h \
                         [-.libwww2]htanchor.h [-.libwww2]htutils.h newsrc.h \
                         mosaic.h [-.libxmx]xmx.h toolbar.h prefs.h \
                         prefs_defs.h [-.libhtmlw]html.h pwd.h newsrc.h
Odir:gui-popup.obj :     gui-popup.c gui-popup.h mosaic.h [-.libxmx]xmx.h \
                         toolbar.h prefs.h prefs_defs.h [-.libhtmlw]html.h \
                         hotlist.h
Odir:history.obj :       history.c mosaic.h [-.libxmx]xmx.h toolbar.h prefs.h \
                         prefs_defs.h [-.libhtmlw]html.h [-.libwww2]htaautil.h
Odir:hotfile.obj :       hotfile.c hotlist.h mosaic.h [-.libxmx]xmx.h \
                         toolbar.h prefs.h prefs_defs.h [-.libhtmlw]html.h
Odir:hotlist.obj :       hotlist.c hotlist.h mosaic.h [-.libxmx]xmx.h \
                         toolbar.h prefs.h prefs_defs.h [-.libnut]system.h
Odir:img.obj :           img.c mosaic.h [-.libxmx]xmx.h toolbar.h prefs.h \
                         prefs_defs.h [-.libhtmlw]html.h cci.h port.h
Odir:kcms.obj :          kcms.c kcms.h
Odir:mailto.obj :        mailto.c mosaic.h [-.libxmx]xmx.h toolbar.h prefs.h \
                         prefs_defs.h [-.libnut]url-utils.h
Odir:main.obj :          main.c mosaic.h [-.libxmx]xmx.h toolbar.h prefs.h \
                         prefs_defs.h newsrc.h kcms.h
Odir:md5.obj :           md5.c mosaic.h [-.libxmx]xmx.h toolbar.h prefs.h \
                         prefs_defs.h md5.h
Odir:medcut.obj :        medcut.c
Odir:mo-dtm.obj :        mo-dtm.c mosaic.h [-.libxmx]xmx.h toolbar.h prefs.h \
                         prefs_defs.h
Odir:mo-hdf.obj :        mo-hdf.c mosaic.h [-.libxmx]xmx.h toolbar.h prefs.h \
                         prefs_defs.h
Odir:mo-www.obj :        mo-www.c [-.libwww2]htaautil.h [-.libwww2]htutils.h \
                         [-.libwww2]htstring.h [-.libwww2]tcp.h \
                         [-.libwww2]httcp.h [-.libwww2]htparse.h \
                         [-.libwww2]htaccess.h [-.libwww2]htanchor.h \
                         [-.libwww2]htatom.h [-.libwww2]htformat.h \
                         [-.libwww2]htstream.h [-.libwww2]html.h \
                         [-.libwww2]htmldtd.h [-.libwww2]sgml.h \
                         [-.libwww2]htext.h [-.libwww2]htlist.h \
                         [-.libwww2]htinit.h mosaic.h [-.libxmx]xmx.h \
                         toolbar.h prefs.h prefs_defs.h
Odir:newsrc.obj :        newsrc.c newsrc.h mosaic.h [-.libxmx]xmx.h toolbar.h \
                         prefs.h prefs_defs.h
Odir:pan.obj :           pan.c mosaic.h [-.libxmx]xmx.h toolbar.h prefs.h \
                         prefs_defs.h [-.libhtmlw]html.h
Odir:picread.obj :       picread.c mosaic.h [-.libxmx]xmx.h toolbar.h prefs.h \
                         prefs_defs.h readpng.h [-.libpng]png.h \
                         [-.libpng.zlib]zlib.h [-.libpng.zlib]zconf.h \
                         [-.libpng]pngconf.h
Odir:pixmaps.obj :       pixmaps.c mosaic.h [-.libxmx]xmx.h toolbar.h prefs.h \
                         prefs_defs.h pixmaps.h xpm.h
Odir:prefs.obj :         prefs.c mosaic.h [-.libxmx]xmx.h toolbar.h prefs.h \
                         prefs_defs.h pwd.h
Odir:proxy-dialogs.obj : proxy-dialogs.c proxy.h mosaic.h [-.libxmx]xmx.h \
                         toolbar.h prefs.h prefs_defs.h
Odir:proxy-misc.obj :    proxy-misc.c proxy.h
Odir:readjpeg.obj :      readjpeg.c mosaic.h [-.libxmx]xmx.h toolbar.h prefs.h \
                         prefs_defs.h [-.libjpeg]jpeglib.h \
                         [-.libjpeg]jconfig.h [-.libjpeg]jmorecfg.h
Odir:readpng.obj :       readpng.c mosaic.h [-.libxmx]xmx.h toolbar.h prefs.h \
                         prefs_defs.h readpng.h [-.libpng]png.h \
                         [-.libpng.zlib]zlib.h [-.libpng.zlib]zconf.h \
                         [-.libpng]pngconf.h
Odir:support.obj :       support.c cci.h port.h
Odir:techsupport.obj :   techsupport.c mosaic.h [-.libxmx]xmx.h toolbar.h \
                         prefs.h prefs_defs.h
Odir:xpmhash.obj :       xpmhash.c xpm.h
Odir:xpmread.obj :       xpmread.c mosaic.h [-.libxmx]xmx.h toolbar.h prefs.h \
                         prefs_defs.h xpm.h

.c.obj :
	$(CC)$(CFLAGS)/OBJECT=$@ $<

.obj.olb :
	$(LIBR) $(LIBRFLAGS) $(MMS$TARGET) $(MMS$SOURCE)

clean :
	Delete/Log $(WDIR)*.OBJ;*
