 /*  *			A R C H I V E  *  * Create an archive  *  */    /*)BUILD	$(TKBOPTIONS) = { 			TASK	= ...ARC 		}  */   #ifdef	DOCUMENTATION  & title	archc	text file archive creation! index		text file archive creation    synopsis   	archc file[s] >archiveR   description   = 	Archc manages archives (libraries) of source files, allowing9 	a large number of small files to be stored without using 8 	excessive system resources.  It copies the set of named, 	files to standard output in archive format.  ; 	The archx program will recreate the files from an archive./  : 	Note: there are no checks against the same file appearing 	twice in an archive.f   archive file formatf  @ 	Archive files are standard text files.  Each archive element is# 	preceeded by a line of the format:  	.s.nf" 	-h-	file.name	date	true_path_name 	.s.f @ 	Note that there is no line or byte count.  To prevent problems,B 	a '-' at the beginning of a record within a user file or embeddedE 	archive will be "quoted" by doubling it.  The date and true filename < 	fields are ignored.  On Dec operating systems, file.name isE 	forced to lowercase.  Certain bytes at the beginning of a record are ; 	also prefixed by '-' to prevent mailers from treating them 
 	as commands.    diagnostics   / 	Diagnostic messages should be self-explanatoryR   author  
 	Martin Minow	   #endif   #include	<stdio.h> #include	<ctype.h>
 #ifdef vms #include		<ssdef.h>0 #include		<stsdef.h>1 #define	IO_SUCCESS	(SS$_NORMAL | STS$M_INHIB_MSG)8 #define	IO_ERROR	SS$_ABORT #endif /*H  * Note: IO_SUCCESS and IO_ERROR are defined in the Decus C stdio.h file  */f #ifndef	IO_SUCCESS #define	IO_SUCCESS	0 #endif #ifndef	IO_ERROR #define	IO_ERROR	1 #endif #define EOS		0 #define	FALSE		0 #define	TRUE		1	  & char		text[513];		/* Working text			*/2 char		name[81];		/* Current archive member name	*/1 char		pathname[81];		/* Output for argetname()	*/ ) char		*timetext;		/* Time of day text		*/i/ int		verbose		= TRUE; /* TRUE for verbosity		*/e! FILE		*infd;			/* Input file			*/m   main(argc, argv) int		argc;			/* Arg count			*/" char		*argv[];		/* Arg vector			*/ {i' 	register int		i;	/* Random counter		*/[- 	register char		*fn;	/* File name pointer		*/)* 	register char		*argp;	/* Arg pointer			*/ 	int			nfiles; 	extern char		*ctime();) 	extern long		time();g 	long			timval;    	time(&timval);m 	timetext = ctime(&timval);	 	timetext[24] = EOS;
 #ifdef vms# 	argc = getredirection(argc, argv);e #endif 	if (argc <= 1)g/ 	    fprintf(stderr, "No files to archive?\n");; #ifdef	unix+ 	for (i = 1; i < argc; i++) {g. 	    if ((infd = fopen(argv[i], "r")) == NULL) 		perror(argv[i]); 	    else {i 		strcpy(pathname, argv[i]); 		import();i 		fclose(infd);  	    } 	} #else	 	/*	8 	 * Decus C supports fwild/fnext for explicit processing 	 * of wild-card filenames.g 	 */ 	for (i = 1; i < argc; i++) {o. 	    if ((infd = fwild(argv[i], "r")) == NULL) 		perror(argv[i]); 	    else {c3 		for (nfiles = 0; fnext(infd) != NULL; nfiles++) {e 		    fgetname(infd, pathname);- 		    import();a 		}i 		fclose(infd);; 		if (nfiles == 0): 		    fprintf(stderr, "No files match \"%s\"\n", argv[i]); 	    } 	} #endif }s   import() /*<  * Add the file open on infd (with file name in pathname) to  * the archive.   */o {+ 	unsigned int	nrecords;)   	fixname();( 	nrecords = 0;6 	printf("-h- %s\t%s\t%s\n", name, timetext, pathname);1 	while (fgets(text, sizeof text, infd) != NULL) {  	    switch (text[0]) {  	    case '-': 	    case '.': 	    case '~': 		putchar('-');				/* Quote	*/ 	    } 	    fputs(text, stdout);s 	    nrecords++; 	} 	if (ferror(infd)) { 	    perror(name);6 	    fprintf(stderr, "Error when importing a file\n"); 	} 	if (verbose) {h1 	    fprintf(stderr, "%u records read from %s\n",e 		nrecords, pathname); 	} }f  	 fixname()  /*@  * Get file name (in pathname), stripping off device:[directory]E  * and ;version.  The archive name ("file.ext") is written to name[].s:  * On a dec operating system, name is forced to lowercase.  */r {r 	register char	*tp;t 	register char	*ip;e 	char		bracket;m 	extern char	*strrchr();   #ifdef	unix) 	/*s+ 	 * name is after all directory information  	 */+ 	if ((tp = strrchr(pathname, '/')) != NULL)}
 	    tp++; 	elset 	    tp = pathname;  	strcpy(name, tp); #else	 	strcpy(name, pathname);' 	if ((tp = strrchr(name, ';')) != NULL)r 		*tp = EOS;) 	while ((tp = strchr(name, ':')) != NULL)e 		strcpy(name, tp + 1);a 	switch (name[0]) {s 	case '[':	bracket = ']';)	 			break;  	case '<':	bracket = '>'; 	 			break;{ 	case '(':	bracket = ')';		 			break;e 	default:	bracket = EOS;	 			break;i 	} 	if (bracket != EOS) {0 	    if ((tp = strchr(name, bracket)) == NULL) {1 		fprintf(stderr, "? Illegal file name \"%s\"\n",i 		    pathname); 	    } 	    else {m 		strcpy(name, tp + 1);h 	    } 	}$ 	for (tp = name; *tp != EOS; tp++) { 	    if (isupper(*tp)) 		*tp = tolower(*tp);s 	} #endif }    #ifdef	unix) char * strrchr(stng, chr) register char	*stng; register char	chr; /*,  * Return rightmost instance of chr in stng.0  * This has the wrong name on some Unix systems.  */b {m 	register char	*result;u   	result = NULL;t   	do {r 	    if (*stng == chr) 		result = stng; 	} while (*stng++ != EOS); 	return (result);v }  #endif e /*<  * getredirection() is intended to aid in porting C programs7  * to VMS (Vax-11 C) which does not support '>' and '<' 7  * I/O redirection.  With suitable modification, it may 1  * useful for other portability problems as well.   */   
 static int getredirection(argc, argv)
 int		argc;
 char		**argv;a /*=  * Process vms redirection arg's.  Exit if any error is seen.g:  * If getredirection() processes an argument, it is erased?  * from the vector.  getredirection() returns a new argc value.   *>  * Warning: do not try to simplify the code for vms.  The codeA  * presupposes that getredirection() is called before any data is (  * read from stdin or written to stdout.  *  * Normal usage is as follows:  *  *	main(argc, argv) 
  *	int		argc;+  *	char		*argv[];u  *	{&  *		argc = getredirection(argc, argv);  *	}  */: {/
 #ifdef	vms+ 	register char		*ap;	/* Argument pointer	*/  	int			i;	/* argv[] index		*/d 	int			j;	/* Output index		*/ # 	int			file;	/* File_descriptor 	*/s  : 	for (j = i = 1; i < argc; i++) {   /* Do all arguments	*/ 	    switch (*(ap = argv[i])) {  	    case '<':			/* <file		*/ * 		if (freopen(++ap, "r", stdin) == NULL) {( 		    perror(ap);		/* Can't find file	*/, 		    exit(IO_ERROR);	/* Is a fatal error	*/ 		}l  & 	    case '>':			/* >file or >>file	*/# 		if (*++ap == '>') {	/* >>file		*/m 		    /*3 		     * If the file exists, and is writable by us, 6 		     * call freopen to append to the file (using the7 		     * file's current attributes).  Otherwise, create)3 		     * a new file with "vanilla" attributes as if(/ 		     * the argument was given as ">filename".*3 		     * access(name, 2) is TRUE if we can write onl 		     * the specified file.	 		     */ ! 		    if (access(++ap, 2) == 0) {	( 			if (freopen(ap, "a", stdout) != NULL)' 			    break;	/* Exit case statement	*/l( 			perror(ap);	/* Error, can't append	*/* 			exit(IO_ERROR);	/* After access test	*/" 		    }			/* If file accessable	*/ 		}u 		/*8 		 * On vms, we want to create the file using "standard"5 		 * record attributes.  create(...) creates the filee3 		 * using the caller's default protection mask and;/ 		 * "variable length, implied carriage return"n8 		 * attributes. dup2() associates the file with stdout. 		 */j6 		if ((file = creat(ap, 0, "rat=cr", "rfm=var")) == -1) 		 || dup2(file, fileno(stdout)) == -1) {m* 		    perror(ap);		/* Can't create file	*/, 		    exit(IO_ERROR);	/* is a fatal error	*/ 		}			/* If '>' creation	*/n 		break;			/* Exit case test	*/g  
 	    default: ) 		argv[j++] = ap;		/* Not a redirector	*/n 		break;			/* Exit case test	*/) 	    } 	}				/* For all arguments	*/; 	return (j); #elseL 	/* 2 	 * Note: argv[] is referenced to fool the Decus C3 	 * syntax analyser, supressing an unneeded warning, 	 * message. 	 */3 	return (argv[0], argc);		/* Just return as seen	*/e #endif }i    