 /*  *			A R C H X  *  * Archive extraction   *  */    /*G  * Note: the )BUILD comment is extracted by a Decus C tool to construct +  * system-dependent compiler command lines.   *?  * Text inside #ifdef DOCUMENTATION is converted to runoff by a   * Decus C tool.  */    /*)BUILD	$(TKBOPTIONS) = { 			TASK	= ...ARX 		}  */   #ifdef	DOCUMENTATION  ) title	archx	text file archiver extraction $ index		text file archiver extraction   synopsis   	archx archive_files   description   = 	Archx manages archives (libraries) of source files, allowing 9 	a large number of small files to be stored without using ; 	excessive system resources.  Archx extracts all files from  	an archive.  > 	If no archive_name file is given, the standard input is read.: 	Archive header records are echoed to the standard output.   archive file format   @ 	Archive files are standard text files.  Each archive element is# 	preceeded by a line of the format:  	.s.nf 	-h-	file.name	date	true_name  	.s.f @ 	Note that there is no line or byte count.  To prevent problems,B 	a '-' at the beginning of a record within a user file or embeddedE 	archive will be "quoted" by doubling it.  The date and true filename = 	fields are ignored.  On some operating systems, file.name is = 	forced to lowercase.  The archive builder (archc) may prefix  	other characters by '-'.   6 	If the first non-blank line of an input file does not: 	begin with "-h", the text will be appended to "archx.tmp"3 	This is needed if archives are distributed by mail 9 	and arrive with initial routing and subject information.e   diagnosticsT  / 	Diagnostic messages should be self-explanatoryG   author  
 	Martin Minow	   bugs   #endif   #include	<stdio.h> #include	<ctype.h>
 #ifdef vms #include		<ssdef.h>C #include		<stsdef.h>1 #define	IO_SUCCESS	(SS$_NORMAL | STS$M_INHIB_MSG)  #define	IO_ERROR	SS$_ABORT #endif /*H  * Note: IO_SUCCESS and IO_ERROR are defined in the Decus C stdio.h file  */  #ifndef	IO_SUCCESS #define	IO_SUCCESS	0 #endif #ifndef	IO_ERROR #define	IO_ERROR	1 #endif   #define EOS		0 #define	FALSE		0 #define	TRUE		1    /*6  * The following status codes are returned by gethdr()  */  #define DONE	0 #define	GOTCHA	1 #define	NOGOOD	2  * char		text[513];		/* Working text line		*/2 char		name[81];		/* Current archive member name	*/- char		filename[81];		/* Working file name		*/O/ char		arfilename[81];		/* Archive file name		*/u1 char		fullname[81];		/* Output for argetname()	*/ / int		verbose		= TRUE;	/* TRUE for verbosity		*/d3 int		first_archive;		/* For mail header skipping	*/s l main(argc, argv) int		argc;			/* Arg count			*/" char		*argv[];		/* Arg vector			*/ {e' 	register int		i;	/* Random counter		*/m" 	int			status;	/* Exit status			*/  
 #ifdef	vms# 	argc = getredirection(argc, argv);e #endif 	status = IO_SUCCESS;7 	if (argc == 1)i 	    process();r 	else {m! 	    for (i = 1; i < argc; i++) { + 		if (freopen(argv[i], "r", stdin) != NULL)i 		    process(); 		else { 		    perror(argv[i]); 		    status = IO_ERROR; 		}2 	    } 	} 	exit(status); }   	 process()d /*   * Process archive open on stdin  */_ {d- 	register char		*fn;	/* File name pointer		*/  	register FILE		*outfd;m 	register int		i;    	text[0] = EOS;C! 	while ((i = gethdr()) != DONE) {^ 	    switch (i) {e 	    case GOTCHA:i+ 		if ((outfd = fopen(name, "w")) == NULL) {a 		    perror(name);e5 		    fprintf(stderr, "Can't create \"%s\"\n", name);e 		    arskip();8 		    continue;  		}e 		break;   	    case NOGOOD:E9 		fprintf(stderr, "Missing -h-, writing to archx.tmp\n");a1 		fprintf(stderr, "Current text line: %s", text);	 		strcpy(name, "archx.tmp");+ 		if ((outfd = fopen(name, "a")) == NULL) {n 		    perror(name);25 		    fprintf(stderr, "Cannot append to %s\n", name);	 		    arskip();l 		    continue;H 		}  		break; 	    } 	    arexport(outfd);O 	    fclose(outfd);y 	} }l a intL gethdr() /*C  * If text is null, read a record, returning to signal input state:L  *	DONE	Eof read=  *	NOGOOD	-h- wasn't first non-blank line.  Line is in text[]+&  *	GOTCHA	-h- found, parsed into name.  */G {  	register char	*tp;b 	register char	*np;y   again:	if (text[0] == EOSs- 	 && fgets(text, sizeof text, stdin) == NULL)E 	    return (DONE); ) 	if (text[0] == '\n' && text[1] == EOS) {n 	    text[0] = EOS;k 	    goto again; 	} 	if (text[0] != '-'i 	 || text[1] != 'h'R 	 || text[2] != '-') 	    return (NOGOOD);a( 	for (tp = &text[3]; isspace(*tp); tp++) 	    ;. 	for (np = name; !isspace(*tp); *np++ = *tp++) 	    ; 	*np = EOS;! 	return (GOTCHA);u }2 n arskip() /*  * Skip to next header  */  {n2 	while (fgets(text, sizeof text, stdin) != NULL) {< 	    if (text[0] == '-' && text[1] == 'h' && text[2] == '-')	 		return;E 	}$ 	text[0] = EOS;				/* EOF signal		*/ }! r arexport(outfd)e register FILE	*outfd;  /*>  * Read secret archive format, writing archived data to outfd.#  * Clean out extraneous <cr>,<lf>'s   */o {t 	register char	*tp;y 	unsigned int	nrecords;L  # 	printf("Creating \"%s\", ", name);k 	nrecords = 0;2 	while (fgets(text, sizeof text, stdin) != NULL) { 	    tp = &text[strlen(text)];; 	    if (tp > &text[1] && *--tp == '\n' && *--tp == '\r') {T 		*tp++ = '\n';f 		*tp = EOS; 	    } 	    if (text[0] == '-') { 		if (text[1] == 'h')e 		    goto gotcha; 		fputs(text+1, outfd);e 	    } 	    else {% 		fputs(text, outfd);o 	    } 	    nrecords++; 	} 	text[0] = EOS;E) gotcha:	printf("%u records\n", nrecords);y$ 	if (ferror(stdin) || ferror(outfd))? 	    printf("Creation of \"%s\" completed with error\n", name);	 }h e /*<  * getredirection() is intended to aid in porting C programs7  * to VMS (Vax-11 C) which does not support '>' and '<'i7  * I/O redirection.  With suitable modification, it mayb1  * useful for other portability problems as well.c  */l  
 #ifdef	vms
 static int getredirection(argc, argv)
 int		argc;
 char		**argv;  /*=  * Process vms redirection arg's.  Exit if any error is seen.y:  * If getredirection() processes an argument, it is erased?  * from the vector.  getredirection() returns a new argc value.R  *>  * Warning: do not try to simplify the code for vms.  The codeA  * presupposes that getredirection() is called before any data ise(  * read from stdin or written to stdout.  *  * Normal usage is as follows:  *  *	main(argc, argv) 
  *	int		argc;   *	char		*argv[];   *	{&  *		argc = getredirection(argc, argv);  *	}  */  { + 	register char		*ap;	/* Argument pointer	*/  	int			i;	/* argv[] index		*/  	int			j;	/* Output index		*/ # 	int			file;	/* File_descriptor 	*/   : 	for (j = i = 1; i < argc; i++) {   /* Do all arguments	*/ 	    switch (*(ap = argv[i])) {T 	    case '<':			/* <file		*/O* 		if (freopen(++ap, "r", stdin) == NULL) {( 		    perror(ap);		/* Can't find file	*/, 		    exit(IO_ERROR);	/* Is a fatal error	*/ 		}E  & 	    case '>':			/* >file or >>file	*/# 		if (*++ap == '>') {	/* >>file		*/S 		    /*3 		     * If the file exists, and is writable by us,C6 		     * call freopen to append to the file (using the7 		     * file's current attributes).  Otherwise, create 3 		     * a new file with "vanilla" attributes as if / 		     * the argument was given as ">filename". 3 		     * access(name, 2) is TRUE if we can write on  		     * the specified file.	 		     */ ! 		    if (access(++ap, 2) == 0) { ( 			if (freopen(ap, "a", stdout) != NULL)' 			    break;	/* Exit case statement	*/ ( 			perror(ap);	/* Error, can't append	*/* 			exit(IO_ERROR);	/* After access test	*/" 		    }			/* If file accessable	*/ 		}  		/*8 		 * On vms, we want to create the file using "standard"5 		 * record attributes.  create(...) creates the file 3 		 * using the caller's default protection mask and / 		 * "variable length, implied carriage return" 8 		 * attributes. dup2() associates the file with stdout. 		 */ 6 		if ((file = creat(ap, 0, "rat=cr", "rfm=var")) == -1) 		 || dup2(file, fileno(stdout)) == -1) { * 		    perror(ap);		/* Can't create file	*/, 		    exit(IO_ERROR);	/* is a fatal error	*/ 		}			/* If '>' creation	*/  		break;			/* Exit case test	*/   
 	    default: ) 		argv[j++] = ap;		/* Not a redirector	*/  		break;			/* Exit case test	*/  	    } 	}				/* For all arguments	*/  	return (j); }  #endif  