 /*		C O O K I Er  *  * Print a random cookie._  *  */    /*)BUILD */   #ifdef	DOCUMENTATION  $ title	cookie		Print a Random Message index			Print a Random Message   synopsis   	cookie [options]    description   2 	Cookie prints a fortune cookie.  The options are: 	.lm +8n 	.s.i- 8;-N	Output N cookies. ! 	.s.i- 8;N	Output the Nth cookie.N. 	.s.i- 8;-a	Output all cookies in entry order.4 	cookie -a -a appends %% to each cookie (so that the( 	output file may be fed back to coobld).6 	.s.i -8;-f file	Read cookies from this file.  (Ignore 	search list.)7 	.s.i- 8;-h	Eliminate Heinlien and Lazarus Long cookiesk4 	.s.i- 8;-v	Video mode -- Format for a VT52 or VT100 	(VT100 assumed).iA 	.s.i- 8;-vt52	Explicitly format for a VT52 or VT100 in VT52 modek: 	.s.i- 8;-vt100	Explicitly format for a VT100 in ANSI mode5 	.s.i- 8;-c	Continuous -- give lots of random cookies A 	.s.i- 8;-s N	Continuous with specified sleep interval.  This maydA 	also be specified "-sN".  If no number is given, "-s 60" will be*	 	assumed.t5 	.s.i -8;-w file	Write cookies to the file as well asr 	to the screen.F? 	.s.i -8;-d	Write cookies to the file as well as to the screen.s0 	(The file is assumed to be a DECtalk terminal.)6 	.s.i- 8;/HEINLIEN=NO##Same as -h, but for VMS systems	 	.s.lm -8eE 	To enable elimination of cookies by Robert A. Heinlien and his alter'B 	ego Lazarus Long, define "NOHEINLIEN".  If eliminated, a suitable 	anticookie will be presented. 	.saA 	Cookie uses the following search list to locate the cookie file: 	.s.nf 		[]cookie.fil 		sys_cookie:cookie.fil  		public:cookie.filf 		pub:cookie.fil 		sys$public:cookie.filn 		games:cookie.fil 		sys$games:cookie.fil 	.s.f  author  
 	Martin Minowr   bugs   #endif   #define	NOHEINLIEN	1   #include	<stdio.h> #include	<ctype.h>  
 #ifdef	vms extern int		errno; #define	IO_ERROR	errno #endif
 #ifdef	rsx #define	R_MODE		"run"  #else  #ifdef	rt11  #define	R_MODE		"rn" #else  #define	R_MODE		"r" #endif #endif #ifdef	decus( int	$$narg	= 1;		/* No argv> prompt			*/   extern int	$$rsts; #else  int		$$rsts = 0;' #define	streq(a,b)	((strcmp(a,b) == 0))  #endif extern long	rand();  extern long	seed;  extern long	time();   
 #define	EOS	0    int	doall		= 0;  int	video		= 0;  int	isvt52		= 0;' int	notLong		= 0;		/*  nor Heinlien		*/t int	continuous	= 0;h int	long_sleep	= 0;r FILE	*extrafd	= NULL;t FILE	*talkfd		= NULL;  int	cur_line	= 0;  int	linecount	= 0; char	*old_buff	= NULL; char	sc_buff[121]; char	temp_text[81];    FILE		*cookfd = NULL;0 char		*cookfile[] = {		/* Cookie search list		*/. 	"cookie.fil",			/* Current directory first	*/# 	"games:cookie.fil",		/* Some				*/$ 	"game:cookie.fil",		/*   games			*/0 	"sys$games:cookie.fil",		/*     directories		*/& 	"public:cookie.fil",		/* Various			*/$ 	"pub:cookie.fil",		/*   public			*/0 	"sys$public:cookie.fil",	/*     directories		*/ 	NULL, };   struct header {m' 	long	ncookie;	/* Number of cookies		*/m+ 	short	nindex;		/* Dimension of index[]		*/1 	short	subindex;	/* Number of subindex entries	*/m, 	short	sindex;		/* Sizeof index for alloc	*/, 	char	date[28];	/* Date cookie file built	*/	 } header;  ! #define	NCOOKIES	(header.ncookie) #define	TEXTSIZE	2048+ #define	INDEXMAX	(TEXTSIZE / sizeof (long))   union {1 	char text[TEXTSIZE];		/* Cookies stored here		*/m6 	long index[INDEXMAX];		/* Cookie sub index entries	*/ } t;   /*K  * If only one cookie is needed, topindex[] can be overlayed over t.index[]  */  2 long	topindex[INDEXMAX];		/* Top index entries		*/ m main(argc, argv)
 int		argc; char		*argv[]; {>, 	register int	howmany;		/* How many to do	*/ 	register char	*ap;O 	register int	outtime;
 #ifdef	rsx
 	int		noargs;r( 	extern int	$$pos;			/* TRUE on P/OS		*/ #endif
 	long		which;	 	long		when; 	long		atol();   	which = 0;n
 #ifdef	rsx( 	noargs = (argc <= 1);			/* For P/OS		*/ #endif 	while (argc > 1) {  	    ap = argv[1];8 	    if (isdigit(*ap) || (*ap == '-' && isdigit(ap[1]))) 		which = atol(ap);e 	    else if (*ap != '-') {O #ifdef	NOHEINLIEN= 		if (streq(ap, "/HEINLIEN=NO")2  		 || streq(ap, "/heinlien=no")) 		    notLong++; 		else #endif7 		    fprintf(stderr, "?Unknown command \"%s\"\n", ap);r 	    }! 	    else for (ap++; *ap; ap++) {_ 		if (isupper(*ap))o 		    *ap = tolower(*ap);N 		switch (*ap) { 		case 'a':t 		    doall++; 		    break;   		case 'c':L 		    continuous++;  		    break;   		case 'f':	6 		    if ((cookfd = fopen(argv[2], R_MODE)) == NULL) { 			perror(argv[2]);" 			exit(IO_ERROR); 		    }f
 		    argv++;e
 		    argc--;l 		    goto next_arg;   #ifdef	NOHEINLIENk 		case 'h': + 		    notLong++;			/* No (Lazarus) Longs	*/  		    break; #endif 		case 's':			/* Long sleep		*/  		    continuous++;/ 		    if (isdigit(ap[1])) {o 			long_sleep = atoi(&ap[1]);	 		    }b% 		    else if (isdigit(argv[2][0])) {r 			long_sleep = atoi(argv[2]);% 			argv++;			/* Skip next argument	*/  			argc--;			/* too.			*/; 		    }n 		    else { 			long_sleep = 60;e	 			break;r 		    }d 		    goto next_arg;   		case 'v':z 		    video = 1;) 		    if (ap[1] == 't' || ap[1] == 'T') {u 			video = atoi(&ap[2]); 			if (video == 52)n 			    isvt52 = 1; 			else if (video == 100)M 			    isvt52 = 0; 			else 6 			    fprintf(stderr, "?Unknown video \"%s\"\n", ap); 			goto next_arg;e 		    }X 		    break;   		case 'd':e3 		    if ((talkfd = fopen(argv[2], "w")) == NULL) {* 			perror(argv[2]);o 			exit(IO_ERROR); 		    }[
 		    argv++;y
 		    argc--;[ 		    goto next_arg;   		case 'w':	4 		    if ((extrafd = fopen(argv[2], "w")) == NULL) { 			perror(argv[2]);  			exit(IO_ERROR); 		    }*
 		    argv++;	
 		    argc--;h 		    goto next_arg;  
 		default:5 		    fprintf(stderr, "?Unknown option '%c'\n", *ap);o7 		    fprintf(stderr, "Option string is \"%s\"\n", ap);a 		}; 	    }	 next_arg:i 	    argc--; 	    argv++; 	} 	setup_cookie(); 	if (video)i 	    erpage(1, 1);
 	if (doall) {;2 	    for (which = 1; which <= NCOOKIES; which++) { 		docookie(which, time(NULL)); 	    } 	} 	if (continuous) 	    which = -1; 	if (which > 0) {E 	    if (which > NCOOKIES) {> 		sprintf(t.text, "Misfortune: there are only %ld cookies.\n", 		    NCOOKIES);$ 		output(which, t.text, time(NULL)); 	    }	 	    else* 		docookie(which, time(NULL)); 	} 	else {a! 	    if ((howmany = -which) == 0)a 		howmany = 1; 	    while (howmany-- > 0) { 		which = rand();' 		when = time(NULL);4 		which = ((which ^ when) & 0x3FFFFFFFL) % NCOOKIES; 		docookie(which + 1, when); 		if (continuous)+ 		    howmany = 1; 		if (howmany > 0) { 		    if (long_sleep > 0)e 			sleep(long_sleep);; 		    else {! 			outtime = (linecount + 1) * 2;f 			if (outtime > 0)n 			    sleep(outtime); 		    }  		}  	    } 	} finish:	if (extrafd != NULL) 	    fclose(extrafd);  	if (talkfd != NULL) 	    fclose(talkfd); }n l setup_cookie() /*8  * Initialize cookie file, finding it in the search list  */	 {  	register char	**namep;  	register int	temp;    	if (cookfd == NULL) {6 	    for (namep = cookfile; *namep != NULL; namep++) {1 		if ((cookfd = fopen(*namep, R_MODE)) != NULL) {[ 		    break; 		}= 	    } 	    if (cookfd == NULL) {. 		fprintf(stderr, "Can't open cookie file\n"); 		exit(IO_ERROR);d 	    } 	}
 #ifdef	rsxD 	if ((temp = fget(&header, sizeof header, cookfd)) != sizeof header)5 		rerror(sizeof header, temp, "Reading header file");fF 	if ((temp = fget(&topindex, header.sindex, cookfd)) != header.sindex)9 		rerror(header.sindex, temp, "Reading top-level index");n #else;< 	if ((temp = fread(&header, sizeof header, 1, cookfd)) != 1)5 		rerror(sizeof header, temp, "Reading header file"); > 	if ((temp = fread(&topindex, header.sindex, 1, cookfd)) != 1)9 		rerror(header.sindex, temp, "Reading top-level index");a #endif }    rerror(expected, got, why)$ int		expected;		/* Bytes in item		*/) int		got;			/* Unexpectedly isn't == 1	*/c char		*why;  /*  * Fatal read erroro  */h { 
 	perror(why);o
 #ifdef	rsx6 	fprintf(stderr, "expected %d bytes, read %d bytes\n", 		expected, got);v #else;@ 	fprintf(stderr, "expected 1 item of %d bytes, read %d items\n", 			expected, got); #endif% 	fprintf(stderr, "Can't continue\n");t 	exit(IO_ERROR); }d   docookie(which, when)i long		which; long		when;c /*=  * Read and output the Nth cookie.  Note: 1-origin addressing;  */  { 
 	long		index;u 	long		temp; 	register int	bytect;0 	register int	i; 	register char	*tp;p  	 	which--;  	temp = header.nindex; 	temp = which / temp;	
 	i = temp; 	if (i >= header.subindex) { 	    fprintf(stderr,. 		"Bug: Gone too far, index = %d, max = %d\n", 		i, header.subindex); 	    exit(IO_ERROR); 	} 	index = topindex[i];o$ 	if (fseek(cookfd, index, 0) != 0) { 	    perror("cookie file");  	    exit(IO_ERROR); 	}
 #ifdef	rsxI 	if ((bytect = fget(&t.index, header.sindex, cookfd)) != header.sindex) {	 #elsetA 	if ((bytect = fread(&t.index, header.sindex, 1, cookfd)) != 1) {s #endif; 		fprintf(stderr, "seek to sub-index %d, %ld. %06o %06o\n",o 				i, index, index);I8 		rerror(header.sindex, bytect, "Can't read sub_index"); 	} 	temp = header.nindex; 	temp = which % temp;	
 	i = temp; 	index = t.index[i];$ 	if (fseek(cookfd, index, 0) != 0) { 		perror("minor index seek");t8 		fprintf(stderr, "?Requesting cookie %ld, max = %ld\n", 				which, header.ncookie);U	 		return;p 	} 	tp = &t.text[0]; 
 #ifdef	rsx= 	while (fget(tp, (sizeof t.text) - (tp - t.text), cookfd) > 0  #else;B 	while (fgets(tp, (sizeof t.text) - (tp - t.text), cookfd) != NULL #endif 	 && !feof(cookfd) 	 && tp[0] != '%'; 	 && tp[1] != '%') { 		tp += strlen(tp);} 	}' 	*tp = EOS;			/* Remove trailing %%		*/P 	if (feof(cookfd)) {8 		rerror(tp - t.text, tp - t.text, "Can't read cookie"); 	} 	if (notLong && isLong(t.text))e  		antiheinlien(which + 1, when); 	else # 		output(which + 1, &t.text, when);  }o   static char *anti1[] = {& 	"A Heinlien Cookie you do distain,\n\( I'll say no more to soothe your brain.",5 	"I'd rather drink a gallon of overage Rhine wine,\n\r* Than read a quote by Robert A. Heinlien.",5 	"I'd rather bite boils from an elephant's behind,\n\.. Than read more quotes by Robert A. Heinlien.",+ 	"*I'd rather a tax audit found me wrong,",t- 	"*I'd rather be dribbled by old King Kong,",-) 	"*I'd rather find paraquat in my bong,", 1 	"*I'd rather Chuck Barris used me as the gong,",t) 	"*I'd rather do updates to Atari Pong,",81 	"*I'd rather write a \"User's Guide to Pong\",",  };   static char *anti2[] = {, 	"Than read another quote by Lazarus Long.",+ 	"Than have to read more of Lazarus Long.", 1 	"Than be forced to consider more Lazarus Long.",- };   isLong(text) register char	*text; /*@  * Return TRUE if the text contains "Heinlien" or "Lazarus Long"  */t {o 	register char	c;s   	while ((c = *text++) != EOS) {e 		switch (c) {   		case 'H':m 				if (streq(text, "einlien"))m 					return (TRUE);s
 				break;   		case 'L':b# 				if (streq(text, "azarus Long")). 					return (TRUE);e
 				break; 		}L 	} 	return (FALSE); }    static	char	antibuffer[257];   antiheinlien(which, when). long		which; long		when;i /*  * Output a non-Heinlien cookiei  */l {	 	register char	*tp;;    C 	tp = anti1[(rand() & 32767) % (sizeof anti1) / (sizeof (char *))];h 	if (*tp == '*') {* 	    sprintf(antibuffer, "%s\n%s", tp + 1,@ 		anti2[(rand() & 32767) % (sizeof anti2) / (sizeof (char *))]); 	} 	else {e 	    strcpy(antibuffer, tp); 	}! 	output(which, antibuffer, when);} }i x static int	nvoice; static char	*voices[] = {!B     "[:np]", "[:nb]", "[:nh]", "[:nu]", "[:nk]", "[:nf]", "[:nr]",     NULL };   output(which, out_text, when)n long		which; char		*out_text; long		when;i /*  * Output one cookie  */a {. 	register char	*tp;=   	startoutput(which, when); 	if (extrafd != NULL)%( 	    fprintf(extrafd, "%s\n", out_text); 	if (talkfd != NULL) 	    speak(out_text);r5 	printf("%s%s", out_text, (doall > 1) ? "%%\n" : "");h 	linecount = 1;= 	tp = out_text; * 	while ((tp = strchr(tp, '\n')) != NULL) { 	    linecount++;o
 	    tp++; 	}
 	endoutput();e }  e speak(out_text)l char		*out_text; /*  * Drive DECtalk  */  {	 	register char	*tp;t 	register int	c;   	if (voices[nvoice] == NULL) 	    nvoice = 0;( 	fprintf(talkfd, "%s ", voices[nvoice]);
 	nvoice++;+ 	for (tp = out_text; (c = *tp++) != EOS;) {d 	    switch (c) {f 	    case ',': 		putc(',', talkfd); 		if (!isspace(*tp)) 		    putc(' ', talkfd); 		break;   	    case '[':				/* [ => (		*/) 		putc('(', talkfd); 		break;   	    case ']':# 		putc(')', talkfd);		/* ] => )		*/g 		break;  ' 	    case '(':				/* (c.a. => ( c.a.	*/ % 		if (isalpha(*tp) && tp[1] == '.') {  		    putc(c, talkfd); 		    c = ' '; 		}C 		putc(c, talkfd); 		break;  & 	    case ')':				/* (44-22 BC)? =>	*/* 		if (tp > &out_text[1]		/* (44-22 BC)		*/ 		 && !isalpha(tp[-2]) 		 && *tp == '?') {e 		    putc(c, talkfd); 		    c = ' '; 		    tp++;n 		}  		putc(c, talkfd); 		break;   	    case '.':. 		if (tp > &out_text[3]		/* H. L. Menken =>	*/( 		 && isupper(tp[-2])		/* H L Menken		*// 		 && isspace(tp[-3])		/* so DECtalk doesn't	*/ " 		 && isspace(*tp))		/* pause.		*/ 		    continue;"0 		if (tp > &out_text[2]		/* ...foo => ... foo	*/ 		 && tp[-2] == '.'s 		 && isalpha(*tp)) {; 		    putc(c, talkfd); 		    c = ' '; 		}t 		putc(c, talkfd); 		break;   	    case '?': 		if (tp > &out_text[2]  		 && isalpha(tp[-2])o 		 && isspace(*tp))o 		    putc(c, talkfd); 		break;  
 	    default:* 		putc(c, talkfd);$ 		if (isdigit(c) && !isdigit(*tp)) { 		    switch (*tp) {" 		    case '?':			/* 1900?-1980	*/ 			if (tp[1] != '-')
 			    break;	 			tp++;			/* Skip ?	*/(  ! 		    case '-':			/* 1900-1910	*/) 			putc(',', talkfd);e 			putc(' ', talkfd);e 			tp++;" 			if (*tp == '?' && tp[1] == ')') 			    tp += 2;		/* 1900-?)	*/	 			break;  		    }a 		}i 	    } 	} 	putc('\f', talkfd); }h   startoutput(which, when) long		which; long		when;n /*  * Initialize output  */e {h   	register char	*timebuf; 	extern char	*ctime();  
 	if (video) { & 	    sprintf(temp_text, "%ld", which); 	    timebuf = ctime(&when); 	    timebuf[24] = EOS;  	    erpage(1, 1); 	    if (isvt52) { 		/*	 		 * VT52  		 */  		 vtout(1, 27, timebuf);} 		 vtout(3, 36, temp_text);w 	    } 	    else {c 		/*
 		 * VT100 		 */	 		if ($$rsts) { / 		    vtout(1, 8, "\233#3");	/* Double high		*/:, 		    vtout(0, 0,  timebuf);	/* Top half		*// 		    vtout(2, 8, "\233#4");	/* Double high		*/ . 		    vtout(0, 0, timebuf);	/* Bottom half		*/0 		    vtout(3, 18, "\233#6");	/* Double wide		*/ 		    vtout(0, 0, temp_text);  		}n 		else {/ 		    vtout(1, 8, "\033#3");	/* Double high		*/d, 		    vtout(0, 0,  timebuf);	/* Top half		*// 		    vtout(2, 8, "\033#4");	/* Double high		*/ . 		    vtout(0, 0, timebuf);	/* Bottom half		*/0 		    vtout(3, 18, "\033#6");	/* Double wide		*/ 		    vtout(0, 0, temp_text);  		}r 	    } 	    vtout(5, 1, "");a 	} }    endoutput()  /*  * Clear the rest of the screenv  */[ {i
 	if (video) {  	    erpage(0, 0); 	    fflush(stdout); 	} 	elsec 	    putchar('\n');t };   vtcurse(row, col)  int		row, col; {  	if (row == 0) 	    return; 	if (isvt52) {5 	    printf(($$rsts) ? "\r\233Y%c%c" : "\r\033Y%c%c",   		row + 040 - 1, col + 040 - 1); 	} 	else {;9 	    printf(($$rsts) ? "\r\233[%d;%dH" : "\r\033[%d;%dH",	 		row, col); 	} }    erpage(row, col) int		row, col; {	 	vtcurse(row, col);p 	if (isvt52)1 	    fputs(($$rsts) ? "\233J" : "\033J", stdout);p 	elsec3 	    fputs(($$rsts) ? "\233[J" : "\033[J", stdout);/ }	   erline(row, col) int		row, col; {/ 	vtcurse(row, col);2 	if (isvt52)1 	    fputs(($$rsts) ? "\233K" : "\033K", stdout);	 	else+3 	    fputs(($$rsts) ? "\233[K" : "\033[K", stdout);: }	   vtout(row, col, text)  int		row, col; char		*text; {( 	vtcurse(row, col);n 	fputs(text, stdout);- }	  