 /*  *				C R E F . C   *F  * This program was distributed to the Unix UUCP network by "cca!z" onC  * Wed Jun 23 14:19:25 1982.  It has not been converted for Decus C   */   $ /* cref - cross reference program */   #include <sys/types.h> #include <sys/stat.h>  #include <ctype.h> #include <stdio.h> #include <vadvise.h>   #define	HRATIO	30  #define	LBUFSIZ	2048 #define	LREFS	151 #define	NKEYS	(sizeof(keytab)/sizeof(struct key))  #define	RSEGSIZ	20 #define	SYMSIZ	64 ' #define	Perror()	perror("cref"),exit(1)	1 #define	issym(c)	(isalnum(c) || c=='_' || c=='#')o  . char	tflag;				/* Produce tags style output */ char	*lastext; char	*calloc();  char	prcom[80] = "pr -h ";9 char	linebuf[LBUFSIZ], *nextsym(), *putline(), *strcpy();y1 int	file1 = 1, hconst = 1, lastline, line, nsyms;  short	braces, bracks, parens;a# FILE	*fopen(), *fp, *popen(), *pfp;n   struct	{6 	unsigned blank1	  : 1;		/* First column is a blank */* 	unsigned casef	  : 1;		/* Case keyword *// 	unsigned comp	  : 1;		/* Compound statement */t6 	unsigned define	  : 1;		/* "Define" type statement */1 	unsigned indent	  : 1;		/* Statement indented */ 7 	unsigned qmark	  : 1;		/* Question mark encountered */ 3 	unsigned semic	  : 1;		/* Semicolon encountered */t3 	unsigned preproc  : 1;		/* Preprocessor keyword */n } flags;   struct	key	{ 	char	*keyword;E3 	unsigned cflag	: 1;		/* Compound statement flag */e) 	unsigned dflag	: 1;		/* Defining flag */  } keytab[] =	{ 	"#define",	0,1, 	"#else",	0,0, 	"#endif",	0,0,1
 	"#if",		0,0,s 	"#ifdef",	0,0,s 	"#ifndef",	0,0, 	"#include",	0,0,  	"#line",	0,1, 	"#undef",	0,0,:
 	"asm",		0,0,n 	"auto",		0,1, 	"break",	0,0, 	"case",		1,0, 	"char",		0,1, 	"continue",	0,0,  	"default",	0,0, 	"do",		1,0, 	"double",	0,1,g 	"else",		1,0, 	"entry",	0,0, 	"extern",	0,1,  	"float",	0,1,
 	"for",		1,0,k 	"goto",		0,0, 	"if",		1,0,
 	"int",		0,1,t 	"long",		0,1, 	"register",	0,1,  	"return",	0,0,l 	"short",	0,1, 	"sizeof",	0,0," 	"static",	0,1,	 	"struct",	0,1,0 	"switch",	1,0,0 	"typedef",	0,1, 	"union",	0,1, 	"unsigned",	0,1,0 	"void",		0,1,
 	"while",	1,0, };   struct	refseg	{ 4 	struct refseg	*nseg;		/* Pointer to next segment */	 	struct	{"* 		int	ref;		/* Line number of reference */6 		char	*text;		/* Text of line containing reference */5 		short	file;		/* File in which reference occurred */o! 		char	deflag;		/* Define flag */1 	} refs[RSEGSIZ];  } *pseg;   struct	symbol	{, 	char	name[SYMSIZ+1]; 
 	int	nref; 	struct	refseg	*firstseg;t 	struct	refseg	*curseg;1 } *htab;   main(argc, argv)	 int	argc;"
 char	*argv[];0 {" 	char	*p, symbol[SYMSIZ+1]; ' 	int	hcode, i, j, k, nslots, t, tchars;s 	short	nfile, nkey, rnum;m 	struct	stat statb;	   	tchars = 0; 	if (argc < 2) 		exit(1);		/* No filenames */ 	while (*argv[file1] == '-') { 		if (argv[file1][1] == 't') 			tflag++; / 		else if (!(hconst = atoi(&argv[file1][1]))) { ' 			fprintf(stderr, "cref: Bad option");m 			exit(1);	 		}S
 		file1++; 	}- 	for (nfile = file1; nfile < argc; nfile++) {s  		if (stat(argv[nfile], &statb))% 			Perror();	/* File doesn't exist */" 		tchars += statb.st_size; 	} 	vadvise(VA_ANOM);_ 	if (!(htab = (struct symbol *)calloc(nslots = hconst*tchars/HRATIO, sizeof(struct symbol)))) { 0 		fprintf(stderr, "cref: Not enough memory.\n");
 		exit(1); 	}  ( /* Main loop for crunching down files */  - 	for (nfile = file1; nfile < argc; nfile++) { < 		if (!(fp = fopen(argv[nfile], "r")))	/* Open input file */9 			fprintf(stderr, "cref: Can't open %s\n", argv[nfile]);e: 		strcpy(&prcom[6], argv[nfile]);	/* Put name in header */
 		if (!tflag)t: 			pfp = popen(prcom, "w"); /* Pipe output through "pr" */< 		while (fgets(linebuf, LBUFSIZ, fp)) {	/* Statement loop */
 			line++; 			if (!tflag) {  				fprintf(pfp, "%6d  ", line); 				fputs(linebuf, pfp); 			}H 			flags.blank1 = flags.define = flags.casef = flags.comp = flags.indent4 				= flags.semic = flags.qmark = flags.preproc = 0; 			p = linebuf;i& 			flags.blank1 = *p==' ' || *p=='\t'; 			while (p = nextsym(p)) {)- 				for (i = 0; i < SYMSIZ && issym(*p); i++)m 					symbol[i] = *p++; 				symbol[i] = '\0';p6 				if ((nkey = binary(symbol, keytab, NKEYS)) >= 0) {; 					if (!parens)	/* So casts don't count as definitions */ ) 						flags.define |= keytab[nkey].dflag; 5 					if (!strcmp(keytab[nkey].keyword, "#include")) {  						while (*p != '\n') 							p++;m
 						p++; 						break; 					}/ 					if (!strcmp(keytab[nkey].keyword, "case"))b 						flags.casef = 1; 				} else {  					if (!(braces|flags.blank1)) 						flags.define = 1;Y# 					flags.define |= !flags.indent;[ 					if (flags.define) 						parens = 0;(F 					for (j = 0, hcode = 1; j < strlen(symbol); hcode *= symbol[j++]);N 				scan:	for (hcode = abs(hcode) % nslots; hcode >= 0 && *htab[hcode].name &&1 						strcmp(htab[hcode].name, symbol); hcode--);) 					if (hcode < 0) {= 						hcode = nslots -1; 						goto scan; 					} 					if (!*htab[hcode].name) {' 						strcpy(htab[hcode].name, symbol); 7 						if (!(htab[hcode].firstseg = htab[hcode].curseg =	< 							(struct refseg *)calloc(1, sizeof(struct refseg)))) {1 							fprintf(stderr, "cref: Out of memory!\n");  							exit(1);  						}s- 						htab[hcode].curseg->refs[0].ref = line;h. 						if (!bracks && !parens || !flags.indent)> 							if (htab[hcode].curseg->refs[0].deflag = flags.define |4 								(*p == ':' && !flags.qmark && !flags.casef)) 								ctags(hcode, 0, nfile);  						htab[hcode].nref++;	 						nsyms++;
 					} else {o* 						if (!(htab[hcode].nref % RSEGSIZ)) {9 							if (!(htab[hcode].curseg->nseg = (struct refseg *)f, 								calloc(1, sizeof(struct refseg)))) {2 								fprintf(stderr, "cref: Out of memory!\n"); 								exit(1); 							}5 							htab[hcode].curseg = htab[hcode].curseg->nseg;  						}dO 						htab[hcode].curseg->refs[rnum = htab[hcode].nref++ % RSEGSIZ].ref = line; . 						if (!bracks && !parens || !flags.indent)A 							if (htab[hcode].curseg->refs[rnum].deflag = flags.define |+4 								(*p == ':' && !flags.qmark && !flags.casef))" 								ctags(hcode, rnum, nfile); 					} 					if (nsyms == nslots) {	8 						fprintf(stderr, "cref: Hash table overflowed!\n"); 						exit(1); 					}& 					if (*p == ':')	/* End of label */ 						flags.define = 0;  				}h 				flags.indent = 1;	 			} 		}	
 		fclose(fp);u
 		if (!tflag)  			pclose(pfp);f 	}   /* Now print the cref table */  
 	if (tflag) {s 		pfp = stdout;) 		sort(htab, nslots);]- 		for (i = nslots - nsyms; i < nslots; i++) {	 			pseg = htab[i].firstseg;a5 			for (j = 0, k = 0, t = 0; j < htab[i].nref; j++) {;9 				if (pseg->refs[k].ref != t && pseg->refs[k].deflag) {r 					t = pseg->refs[k].ref;dF 					fprintf(pfp, "%s	%s	?^", htab[i].name, argv[pseg->refs[k].file]);$ 					fputs(pseg->refs[k].text, pfp); 					fprintf(pfp, "$?\n"); 				}c 				if (++k == RSEGSIZ) { 0 					pseg = pseg->nseg;	/* Print next segment */ 					k = 0;t 				}s 			} 		}t
 		exit(0); 	}* 	pfp = popen("pr -h 'Cref listing'", "w"); 	sort(htab, nslots);, 	for (i = nslots - nsyms; i < nslots; i++) {
 		char lrefs;h  + 		lrefs = LREFS;		/* References per line */  		fprintf(pfp, "%s", 	mKuname); ( 		if ((t = strlen(htab[i].name)) > 12) { 			lrefs = LREFS - (t-5)/8;e$ 			for (j = 0; j < 7 - (t-5)%8; j++), 				putc(' ', pfp);	/* Space after symbol */ 		} else 			for (j = 0; j < 12-t; j++)Z, 				putc(' ', pfp);	/* Space after symbol */ 		pseg = htab[i].firstseg;. 		for (j=0, k=0, t=0; j < htab[i].nref; j++) {  			if (pseg->refs[k].ref != t) { 				if (!lrefs--) {( 					fprintf(pfp, "\n	    ");  					lrefs = LREFS;h 				}r/ 				fprintf(pfp, "%7d", t = pseg->refs[k].ref);t 				if (pseg->refs[k].deflag)( 					putc('#', pfp); 				else 					putc(' ', pfp); 			} 			if (++k == RSEGSIZ) {/ 				pseg = pseg->nseg;	/* Print next segment */t
 				k = 0; 			} 		}  		putc('\n', pfp); 	}E 	fprintf(pfp, "\nSymbols = %d		Hash table size = %d		Density = %f\n",f/ 		nsyms, nslots, (double)nsyms/(double)nslots); 
 	pclose(pfp);p }-        /* Create entry for tags file */   ctags(hcode, rnum, nfile)  register hcode, rnum, nfile; {r 	register len;   	if (!tflag)	 		return;. 	len = strlen(linebuf);s 	if (lastline != line) {& 		if (!(lastext = calloc(len+1, 1))) {- 			fprintf(stderr, "cref: Out of memory!\n");e 			exit(1);r 		}e" 		(void) strcpy(lastext, linebuf); 		lastext[--len] = '\0'; 		lastline = line; 	}/ 	htab[hcode].curseg->refs[rnum].text = lastext; - 	htab[hcode].curseg->refs[rnum].file = nfile;  }p      # /* Binary search for word in tab */    binary(word, tab, n) char	*word;i struct	key	tab[];e int	n; {l 	int	low, high, mid, cond;  	 	low = 0;	 	high = n - 1; 	while (low <= high) { 		mid = (low+high)/2;	2 		if ((cond = strcmp(word, tab[mid].keyword)) < 0) 			high = mid - 1; 		else if (cond > 0) 			low = mid + 1;) 		else 			return(mid);; 	} 	return(-1); }'      H /* Find next symbol in statement, and return a pointer to it.  If end of-  * statement is reached, return null pointer.   */    char	*
 nextsym(p) char	*p; {b 	static symline;  ) 	for (; !issym(*p) || isdigit(*p); p++) {  		switch (*p) {l 		case '{':, 			braces++;	 			break;g 		case '}':w 			braces--;	 			break;i 		case '\n':J 			if (!flags.semic && !flags.comp && symline == line && !flags.preproc ||& 				flags.preproc && *(p-1) == '\\') {% 				if (!fgets(linebuf, LBUFSIZ, fp))r 					return(0);  				p = linebuf - 1;/ 				flags.blank1 = *(p+1)==' ' || *(p+1)=='\t';f 				line++;t 				if (!tflag) { ! 					fprintf(pfp, "%6d  ", line);t 					fputs(linebuf, pfp);i 				}n
 				break;	 			} else) 				return(0); 		case '?':w 			flags.qmark = 1;'	 			break;a 		case ':':e 			flags.comp |= !flags.qmark;	 			break;i 		case ';':: 			flags.semic = 1; 	 			break;o 		case '\'':< 			while (*++p != '\'' || *(p-1) == '\\' && *(p-2) != '\\');	 			break;	 		case '"':n( 			while (*++p != '"' || *(p-1) == '\\') 				if (!(p = putline(p))) 					return(0);=	 			break;+ 		case '/':	 			if (*(p+1) != '*')l
 				break; 			p++;p' 			while (*++p != '*' || *(p+1) != '/')  				if (!(p = putline(p))) 					return(0);e 			p++; 	 			break;w 		case '(':a 			parens++; 			flags.indent = 1;	 			break;m 		case ')':m 			parens--;	 			break;' 		case '[':s 			bracks++;	 			break;  		case ']':  			bracks--;	 			break;  		case '0':' 			while (isalnum(*(p+1)))! 				p++;	/* Ignore hex numbers */!	 			break;p 		case ' ':  		case '\t': 			flags.indent = 1;	 			break;	
 		default: 			; 		}  	} 	if (*p == '#')l 		flags.preproc = 1;: 	symline = line;		/* Indicate symbol found on this line */ 	return(p);	 }r   char	*
 putline(p) char	*p; {	 	if (*p == '\n') {# 		if (!fgets(linebuf, LBUFSIZ, fp))m
 			return(0);  		p = linebuf - 1;	 		line++;e 		if (!tflag) {+ 			fprintf(pfp, "%6d  ", line);b 			fputs(linebuf, pfp);a 		}' 	}" 	if (*p == '\\' && *(p-1) == '\\')3 		*p = '\0';		/* Help out parsing quoted strings */  	return(p);  }f   sort(tab, n) struct	symbol	*tab;l int	n; {	 	int	gap, i, j;= 	struct	symbol	temp;  # 	for (gap = n/2; gap > 0; gap /= 2)y 		for (i = gap; i < n; i++)r& 			for (j = i-gap; j >= 0; j -= gap) {2 				if (strcmp(tab[j].name, tab[j+gap].name) <= 0) 					break;) 				temp = tab[j]; 				tab[j] = tab[j+gap]; 				tab[j+gap] = temp; 			} }f       .TH CREF 1 10/30/80f .CCl .SH NAME cref \- cross reference program& .SH SYNOPSIS .B cref= [0 .B - .I n ]  [s .B -tt ]s file...  .SH DESCRIPTIONf .I CreftP generates a complete cross reference listing of one or more C programs, printingO the result on the standard output.  A listing of the programs with line numbers N is printed first, followed by the actual cross reference listing.  This latterK contains all the programs's symbols alphabetically arranged, one to a line,tL with each line containing the numbers of the lines in the programs where theL symbol was referenced.  If the symbol was defined on a given line, that lineJ number will be followed by a `#'.  Symbols with more than approximately 15M references occupy multiple lines.  There is no limit on the number of symbols  that .I crefp8 will handle, nor on the number of references per symbol. .PPc .I Crefs> stores its symbols in a hash table whose size is determined by .I crefhJ based on the total number of characters in the files to be processed.  ForE almost all programs, this turns out to be an excellent approximation.sG However, for a few programs, generally short header files, there may beaC too many symbols for the hash table, and the diagnostic "Hash tablet6 overflowed!" will be printed out.  Since the output of .I crefI is piped through .I pr,L it is not really possible for cref to recover from this condition.  Instead, .I crefb should be rerun with the .B -nI
 option, wheren .B nJ is some number.  This will multiply the starting size of the hash table by .B n times. .PPu If .I crefc is invoked with thes .B -teH option, instead of its regular output it produces an output identical in form to that produced by the .I ctags(1)n program.  The advantage of the .I crefp output overS .I ctags is that  .I cref D will flag all variable and macro definitions as well as all function definitions.
 .SH AUTHOR Steve Zimmerman  .SH SEE ALSO ctags(1) .SH BUGS .I CrefhJ occasionally flags a reference as a definition when it really isn't.  This most frequently happens after af
 .B struct.  