 /*  *	entab <file >file  */    /*)BUILD	$(TKBOPTIONS) = { 			TASK	= ...ENT 		}  */   #ifdef	DOCUMENTATION  - title	entab	Replace blanks by tabs and blanks ( index		Replace blanks by tabs and blanks   synopsis   	entab [-t] infile outfile   description   6 	Copies input to output, replacing sequences of blanks; 	and tabs by the minimum number of tabs and blanks required   	to give the same visual effect. 	.s ! 	Trailing blank/tabs are removed.  	.s " 	<Return> overstrikes are handled. 	.s : 	If -t is given, a single blank will be output as <TAB> if$ 	valid.  For example, if the string: 	.sf 		1234567 8N 	.si= 	is given, the program will output a space following the '7'.a1 	If -t is given, the program will output a <TAB>.n 	e diagnosticse   	None    author  
 	Martin Minow, 	.sa3 	(Taken from Kernighan and Plauger, Software Tools)m 	.sf bugs  $ 	Tabs occur every eight column only.   #endif   #include <stdio.h> #define	BLANK	' 'v #define	TAB	'\t' #define	RETURN	'\r'a #define	NEWLINE	'\n' #define	FALSE	0  #define	TRUE	1   int	tflag = FALSE;   main(argc, argv)
 char *argv[];. {  	register int	c; 	register int	col; 	register int	newcol;e 	int		lastc;  . 	col = FALSE;			/* TRUE if input redirected	*/ 	for (c = 1; c < argc; c++) {N 		if (argv[c][0] == '-') {" 			if (tolower(argv[c][1]) == 't') 				tflag++;	 			else {s. 				fprintf(stderr, "Unknown option \"%s\"\n", 					argv[c]); 			} 		}e 		else { 			if (!col) {! 				freopen(argv[c], "r", stdin);U
 				col++; 			}	 			else {'" 				freopen(argv[c], "w", stdout); 			} 		}  	}	 	c = EOF;n, 	col = 0;	/* Tab stops at 0, 8, 16, ...			*/ 	for (;;) {e 		newcol = col;s 		for (;;) {
 			lastc = c;; 			switch (c = getchar()) {f 			case BLANK:	newcol++; 					continue;* 			case TAB:	newcol = nexttabstop(newcol); 					continue;' 			default:	break;	/* Exits for loop	*/  			}& 			break;		/* Neither BLANK nor TAB	*/ 		}	 		if (c == EOF) {	 			if (newcol > 0) { 				putchar(NEWLINE);v 			}	 			break;U 		}	) 		else if (c == RETURN || c == NEWLINE) {c 			col = 0;t 			putchar(c); 		}c 		else { 			/*04 			 * If -t was not given and the last character was2 			 * a blank and there's just one blank, don't do 			 * a tab here.  			 */5 			if (tflag || lastc == TAB || (col + 1) < newcol) {o( 				while (nexttabstop(col) <= newcol) { 					putchar(TAB); 					col = nexttabstop(col); 				}	 			} 			while (col < newcol) {	 				putchar(BLANK); 
 				col++; 			} 			putchar(c);	 			col++;  		}  	} }k     nexttabstop(col) register int	col;N /*5  * Return the next tab stop after col (col == 1 -> 8)	  */  {   	return (col + (8 - (col & 7))); }a  