A /*--- EDIT # 0042	15 Apr 1982   13:36:34	DB1:[21,14]FLAG.C;70  */ C /*--- PREVIOUS EDIT	13 Apr 1982   14:40:56	DB1:[21,14]FLAG.C;66  */ ' /************* flag.c ***************** E  * This is an example program to process & handle command-line flags. C  * Including boolean flags (specified or not), numeric value flags,   * ascii string value flags.A  * Note that flags may always be in any order, and that arguments &  * and flags may be freely intermixed.  * Also note that D  * redirection of stdin and/or stdout is transparent and the program&  * does not even know when it happens.  *>  * The command-line options can be any of the following forms:
  *     where:   *	a, b, c are individual flags   *	n	is a numeric value flag  *	NN	is the actual number3  *	f	is a file-spec flag (other than stdin, stdout,c3  *		infile) (for example, a wierd output file, work $  *		file, auxiliary input file, etc)  *	FF	is the actual file-speca"  *	-?	always gives long usage info  *	argn	is a parameter/argumentt  *  *	-a -b -c -d
  *	-ab -cd  *	-abcd  *	-anNN -cd
  *	-anNNcd  *	-aoFF  *	-bo FF -d  *	-a arg1 arg2 -bc   *	-abc arg1 arg2o  */  #include <stdio.h>  * int cntflag = 0;	/* numeric value flag		*/" int dflag = 0;		/* debug flag			*/# int nflag = 0;		/* negate flag			*/e2 char *ofn = NULL;	/* "-o" flag output-file flag	*/   main(argc, argv)	 int argc;l
 char *argv[];i { 	    int i;n:    char c;	/* 1st char of current command-line argument */+    char *cp;	/* current argument pointer */r/    FILE *ifp;	/* currently opened input file */b      printf("Command line: '");-    for (i=1; i<argc; ++i)r       printf("%s ", argv[i]);o    printf("'\n\n");i  @ /* Get all the flag arguments. After processing each one, set it,  * to NULL, so we know it isn't a file-spec. */    for (i=1; i<argc; ++i) {"       cp = argv[i];f       if (*cp == '-') {) 	 argv[i] = NULL;* 	 ++cp;  	 while (c = *cp++) {  	    switch (tolower(c)) {' 	    case 'c':	/* numeric value flag */u+ 	       /* convert to int & skip over it */c 	       cntflag = atoi(cp);b0 	       while (isdigit(c = *cp) || (c == '-') || 		    (c == '+')) cp++;f 	       break;   	    case 'd': 	       ++dflag; 	       break;   	    case 'n': 	       ++nflag; 	       break;   	    case 'o':3 	       if (*cp == NULL) { 	/* value is next arg */  		  if (++i >= argc)+ 		     usage(c);		/* no next arg, error! */   		  if (*(ofn = argv[i]) == '-')3 		     usage(c);		/* next arg is itself an arg!! */a+ 		  argv[i] = NULL;	/* eliminate the arg	*/p	 	       }c* 	       else {		/* value is in this arg */
 		  ofn = cp;*	 	       }=> 	       cp = argv[i];/* re-examine current arg (to skip it) */ 	       break;  
 	    default:r 	       usage(c);n 	    } 	 }+       }     },    printf("cnt flag value = %d\n", cntflag);'    printf("dflag value = %d\n", dflag);(3    printf("nflag = %s\n", nflag? "TRUE" : "FALSE");!  0    if (ofn != NULL) {	/* open the output file */.       printf("outfile string: '%s'\n\n", ofn);        /*ofp = fopen(ofn, "w");*/    }  D /********** get the file-name arguments and process each file. ****/G    for (i = 1; i < argc; argv[i++] = NULL) {/* find 1st non-flag arg *//#       if ((cp = argv[i]) != NULL) { ' 	 if ((ifp = fopen(cp, "r")) == NULL) { / 	    fprintf(stderr, "%s: cannot open.\n", cp);; 	 }p 	 process_file(ifp);       }a    } }p, /******************************************/ process_file(fp)	 FILE *fp;* {e-    if (dflag > 1) ;	/* do debug for type 1 */i-    if (dflag > 2) ;	/* do debug for type 2 */"#    if (dflag != 0) ;	/* do debug */i    fclose(fp); }n  , /******************************************/ usage(c)% char c;		/* The char of the option */* { D    printf("Usage: flag [-dn] [-cnnn] [-oOUTFILE] arg1 [argn...]\n");    if (c == '?') {<       printf("  -cn = count value ('n' is a signed int)\n");B       printf("  -d  = debug (type depends on # of occurences)\n");&       printf("  -n  = negate flag\n");5       printf("  -ox = 'x' is the output filespec, ");l%       printf("rather than stdout\n");     }
    exit(); } 