 /*  *		K A L E I D   *  *		Copyright (C) 1981, 1984  *		Martin Minow  *		Arlington, MA   *C  * In the screen output routines, row 1 is the top row, row 0 means H  * "don't move the cursor", Col 1 is left-margin;  col 0 is meaningless.,  * vtout(row, col, NULL) flushes the buffer.  */  * NOTE: You must set your terminal to "NOWRAP"   */    /*)BUILD */   #include <stdio.h>$ #define	EOS		0		/* End of string		*/ #ifdef	rt11 * int	$$narg		= 1;		/* Don't argv prompt		*/ #endif/ extern int	isvt52;			/* TRUE if vt52 output		*/   ( char	inline[513];			/* Argument line		*/   /*D  * Note: inline must be dimensioned longer than the longest possible.  * output string (20 * "longest move + 1") + 1  */    /*D  * The font.. strings select the characters written into the various$  * quadrants: ul  = upper left, etc.  */t  3 char	fontul[] =	"!#@$%:-+|=**..~ >< )( ][ `' \\/ ";<3 char	fontur[] =	"!#@$%:-+|=**..~ <> () [] '` /\\ ";f3 char	fontll[] =	"!#@$%:-+|=**..~ >< )( ][ '` /\\ ";e3 char	fontlr[] =	"!#@$%:-+|=**..~ <> () [] `' \\/ "; & #define	FONTSIZE	((sizeof fontul) - 1) int	verbose		= FALSE;l   /*F  * Define the kaleidiscope as a circle centered on the display screen.@  * The screen is 24 lines high.  Thus the vertical radius is 12.?  * For an aspect ratio (width:height) of 0.6, the correspondingp'  * horizontal radius, MAXX, will be 21.!  *D  * ytab[MAXX] entries give the maximum height for a given horizontal>  * distance from the center.  Values were tuned by inspection.  */   0 #define	MAXX	21			/* Max. horizontal distance	*/   /*A  * Y-axis table.  Change this to change the shape of the display.*  */n   int ytab[MAXX] = { 	12,	12,	12,	12, 	12,	12,	12,	11, 	11,	11,	10,	10, 	 9,	 9,	 8,	 8, 	 7,	 7,	 6,	 4, 	 1, };   main(argc, argv) register int	argc; register char	**argv;s {d 	register int	count;
 #ifndef	decusl 	extern char	*getenv();X #endif 	/*eB  	 * Determine the terminal type and initialize the screen handler 	 */
 #ifndef	decuse. 	isvt52 = (strcmp(getenv("TERM"), "vt52") == 00 	       || strcmp(getenv("TERM"), "VT52") == 0); #endif
 	if (argc > 1 $ 	  && (strcmp(argv[1], "-vt52") == 0* 	   || strcmp(argv[1] == "-VT52") == 0)) { 	    isvt52 = TRUE;, 	}) 	erpage(1, 1);			/* Erase entire page		*/ 	 	for (;;)a 	    kaleid(); }r t kaleid() /*  * Do one kaleidiscope vector   */o {; 	register int	x1;e 	register int	y1;) 	register int	x2;	 	register int	y2;r
 	int		whichc;i6 	extern int	irand();	/* Returns rand() mod argument	*/   	do {r 	    /*v8 	     * Get the starting and ending points of the vector 	     */ 	    x1 = irand(MAXX); 	    if ((y1 = ytab[x1]) != 0) 		y1 = irand(y1);s 	    x2 = irand(MAXX); 	    if ((y2 = ytab[x2]) != 0) 		y2 = irand(y2);;  	} while (x1 == x2 && y1 == y2); 	/*a# 	 * Plot the kaleidiscope pattern. *% 	 * Note that [x1,y1] and [x2,y2] are   	 * in the upper-left quadrant. ) 	 * Plot calls xymove with values for all	 	 * four quadrants.  	 */ 	whichc = irand(FONTSIZE); 	if (verbose) {	4 	    sprintf(inline, "[%2d, %2d]\r\n[%2d, %2d] %2d", 		x1, y1, x2, y2, whichc); 	    vtout(1, 1, inline);A 	    vtout(0, 0, NULL);[ 	}< 	xymove(40 + x1, 12 - y1, 40 + x2, 12 - y2, fontur[whichc]);< 	xymove(40 + x1, 13 + y1, 40 + x2, 13 + y2, fontlr[whichc]);< 	xymove(39 - x1, 12 - y1, 39 - x2, 12 - y2, fontul[whichc]);< 	xymove(39 - x1, 13 + y1, 39 - x2, 13 + y2, fontll[whichc]); }t   /*A  * There are two move strings per octant -- one for straight-line @  * movement, one for diagonals.  The octant numbering is defined:  * by a series of tests.  The numbering forms a gray code:  *  *		 -X  +X,  *3  *		\ 1 | 5 /	abs(Y-difference) > abs(X-difference),;  *	-Y     0 \  |  / 4	abs(Y-difference) < abs(X-difference),  *		  \ | /+  *	      ------+------  *		  / | \v;  *	+Y     2 /  |  \ 6	abs(Y-difference) < abs(X-difference)v3  *		/ 3 | 7 \	abs(Y-difference) > abs(X-difference);  *?  * In the following, \233 is a "parity escape."  By setting thea;  * parity bit, (some) operating systems will not notice therC  * control character.  The vt100 sequences follow the ANSI standardc  * for display control.*  */	   typedef struct move {e     char	*straight;,     char	*diagonal;  } MOVE;i   MOVE vt52move[] = {r/     { "\b\b",		"\b\b\233A" },	/* -X	-X -Y	0		*/	1     { "\b\233A",	"\b\b\233A" },	/* -Y	-X -Y	1		*/ /     { "\b\b",		"\b\b\233B" },	/* -X	-X +Y	2		*/e1     { "\b\233B",	"\b\b\233B" },	/* +Y	-X +Y	3		*/3'     { "",		"\233A" },	/* +X	+X -Y	4		*/ .     { "\b\233A", 	"\233A" },	/* -Y	+X -Y	5		*/'     { "",		"\233B" },	/* +X	+X +Y	6		*/v-     { "\b\233B",	"\233B" },	/* +Y	+X +Y	7		*/r };   MOVE vt100move[] = {, 	{ "\b\b",	"\b\b\233[A" },	/* -X	-X -Y	0		*/0 	{ "\b\233[A",	"\b\b\233[A" },	/* -Y	-X -Y	1		*/, 	{ "\b\b",	"\b\b\233[B" },	/* -X	-X +Y	2		*/0 	{ "\b\233[B",	"\b\b\233[B" },	/* +Y	-X +Y	3		*/% 	{ "",		"\233[A" },	/* +X	+X -Y	4		*/}- 	{ "\b\233[A", 	"\233[A" },	/* -Y	+X -Y	5		*/3% 	{ "",		"\233[B" },	/* +X	+X +Y	6		*/2, 	{ "\b\233[B",	"\233[B" },	/* +Y	+X +Y	7		*/ };     xymove(x1, y1, x2, y2, c)   int		x1, y1;		/* From here				*/ int		x2, y2;		/* To here				*/ char		c;		/* Spray me				*/v /*@  * Stockton's algorithm from CACM (Algorithm 162)  -- as revisedG  * (reinvented) by Bresenham (IBM Systems Journal vol. 4, no. 1, 1965).XG  * This implementation is based on one by Don North and closely follows\  * Bresenham's version.*  */{ {b& 	int		dx, dy;	/* X and Y distance			*/1 	int		smagic;	/* Magic straight move increment	*/31 	int		dmagic;	/* Magic diagonal move increment	*/x: 	register int	longer;	/* Long side of the plot triangle	*/: 	register int	dda;	/* Distance to hypotenuse (diagonal)	*/2 	char		*smove;	/* -> Straight line move string		*/2 	char		*dmove;	/* -> Diagonal line move string		*/ 	register union { $ 	    char	*tp;	/* Text pointer				*/' 	    MOVE	*index;	/* Octant index				*/  	} r;\= 	extern char	*cpystr(); /* Copy string, return ptr. to end	*/d   	/*	 	 * Determine which octant.s 	 */3 	r.index = (isvt52) ? &vt52move[0] : &vt100move[0];  	if ((dx = x2 - x1) >= 0)e 	    r.index += 4; 	if ((dy = y2 - y1) >= 0)	 	    r.index += 2; 	/* " 	 * Determine the move parameters:6 	 * 	r.index	The octant in which the move takes place.< 	 *	longer	The longer of the two sides of the right triangle2 	 *		[x1,y1], [x1, y2], [x2, y2].  The computation6 	 * 		calculation uses absolute distances, normalizing. 	 *		the triangle to the upper right quadrant.7 	 *	shorter	The other side (not explicitly calculated).=; 	 *	smagic	A magic number for straight moves: (shorter * 2)1- 	 *	dmagic	A magic number for diagonal moves:1 	 *			(2 * (smagic - longer))/7 	 *	dda	The distance to the diagonal.  The intial valueo# 	 *		is:  ((2 * smagic) - shorter). + 	 *	smove	-> the string for straight moves. + 	 *	dmove	-> the string for diagonal moves.y< 	 * The magic numbers are explained (somewhat) in Bresenham.< 	 * Stockton's algorithm does the same thing in an even less 	 * transparent manner.i 	 */( 	if ((dx = abs(dx)) >= (dy = abs(dy))) {- 	    longer = dx;		/* dx is the long side		*/  	    smagic = dy * 2;e 	} 	else {l- 	    longer = dy;		/* dy is the long side		*/d 	    smagic = dx * 2;i- 	    r.index++;			/* Finialize the octant		*/g 	}3 	dda = smagic - longer;		/* Initial error value		*/v4 	dmagic = dda - longer;		/* Diagonal magic value		*/< 	smove = r.index->straight;	/* Output smove on a straight	*/> 	dmove = r.index->diagonal;	/* and dmove on a diagonal move	*/ 	/*p 	 * Do the pen moves.i 	 */3 	r.tp = inline;			/* Store pen moves into inline	*//% 	while (*r.tp++ = c, --longer >= 0) {  	    if (dda < 0) { - 		r.tp = cpystr(r.tp, smove);		/* Straight	*/* 		dda += smagic; 	    } 	    else {x- 		r.tp = cpystr(r.tp, dmove);		/* Diagonal	*/s 		dda += dmagic; 	    } 	}/ 	*r.tp = EOS;			/* Terminate pen move string	*/n9 	vtout(y1, x1, inline);		/* and write it to the screen	*/m }  a /*  * Random stuff=  */d  
 #ifndef	decusa into
 irand(max) register int	max;  /*"  * Return a value from 0 to max-1.  */	 {* 	register long	temp;    	temp = (rand() & 32767L) * max; 	return (temp / 32768L); }<   char * cpystr(out, in)p register char	*out, *in; /*8  * Copy in to out, return a pointer to the trailing EOS.  */v {	  	while ((*out++ = *in++) != EOS) 	    ; 	return (out - 1); }* #endif p /*1  *		S i m p l e   S c r e e n   F u n c t i o n st  *D  * All functions work in terms of [row, column] where the upper-leftA  * corner is [1, 1].  Note that, in all routines, if row is zero,m?  * the cursor will not be moved before the operation commenses.   *B  * Set global isvt52 non-zero if running on that vernerable beast.  *7  * You may need to call vtout(0, 0, NULL) occasionally.o  */    int		isvt52 = FALSE;   #ifdef	decus> extern int	$$rsts;		/* On RSTS/E, we must set ESC's 8th bit	*/ #endif  
 vtcurse(r, c) 
 int		r, c; /*0  * Move the cursor to [r,c].  r == 0 is a no-op.  */o {r 	if (r == 0) 	    return; #ifdef	decus 	if (isvt52) {5 	    printf(($$rsts) ? "\r\233Y%c%c" : "\r\033Y%c%c",o 		r + 040 - 1, c + 040 - 1); 	} 	else {m< 	    printf(($$rsts) ? "\233[%d;%dH" : "\033[%d;%dH", r, c); 	} #else  	if (isvt52) {5 	    printf("\r\033Y%c%c", r + 040 - 1, c + 040 - 1);* 	} 	else {v! 	    printf("\033[%d;%dH", r, c);n 	} #endif }*   erpage(r, c)
 int		r, c; /*F  * Erase the page from [r,c].  If r == 0, erase from current position.  */c {  	vtcurse(r, c);. #ifdef	decus 	if (isvt52)1 	    fputs(($$rsts) ? "\233J" : "\033J", stdout);t 	elset3 	    fputs(($$rsts) ? "\233[J" : "\033[J", stdout);c #else- 	if (isvt52) 	    fputs("\033J", stdout); 	else; 	    fputs("\033[J", stdout);} #endif }i   erline(r, c)
 int		r, c; /*B  * Erase to end of line from [r,c].  If r == 0, don't move cursor.  */% {, 	vtcurse(r, c);d #ifdef	decus 	if (isvt52)1 	    fputs(($$rsts) ? "\233K" : "\033K", stdout);0 	else 3 	    fputs(($$rsts) ? "\233[K" : "\033[K", stdout);i #elsec 	if (isvt52) 	    fputs("\033K", stdout); 	else\ 	    fputs("\033[K", stdout);f #endif }s   vtout(r, c, text)J
 int		r, c; char		*text; /*@  * Write text starting at [r, c].  If r == 0, don't move cursor.  */) {  	vtcurse(r, c);i 	fputs(text, stdout);* }*