   #  /*   *	Amazing demonstration program  **  *	Rewritten from a Pascal program marked:  *		"Copyright 1976,)  *		Oregon Museum of Science and Industry   *		4015 SW Canyon Road   *		Portland Oregon 97221   *		(503) 248-59236  *	"Permission is hereby granted to republish (but not8  *	for profit) any or all of this program, provided that&  *	this copyright notice is included."  *  *	This version by:   *		Martin Minow  *		Digital Equipment Corp.   *		146 Main St.  *		Maynard, MA  01754  *6  * Maze may be compiled for RSTS/E RT11 or VMS-native.6  * On VMS, maze must be linked with kbgetc and kbputb.  *  */    /*)BUILD */   #include <stdio.h>
 #ifdef	rsx	 FILE	*fd;n #endif  7 #define	WSIZE		((80 / 2) - 1)	/* Maximum maze width		*/i8 #define LSIZE		((24 / 2) - 1)	/* Maximum maze length		*/ /*B  * Conroy's compiler does not permit constant expressions in array8  * definitions, so the sizes must be worked out by hand:  */i- #define WSIZE		39		/* Columns in the maze		*/n* #define LSIZE		11		/* Rows in the maze		*/  0 #define	LINESIZE	82		/* Input text line size		*/   /*B  * Character definitions (and constants for video terminal output)  */.   #define	BELL	0007* #define BS	0010d #define ESC	0233   #define	UP		ESC, 'A' #define	DOWN		ESC, 'B' #define	RIGHT		ESC, 'C'x #define	LEFT		BS< #define ONGRAPH		ESC, 'F'	/* VT52 graphics mode, not used	*/< #define OFFGRAPH	ESC, 'G'	/* VT52 graphics mode, not used	*/ #define	HOME		ESC, 'H' #define	ERASEEOS	ESC, 'J'e #define	ERASEEOL	ESC, 'K'1 #define	DOT		'o' #define SOUTHWARD	LEFT, DOWN #define WESTWARD	LEFT, LEFT/ #define NORTHWARD	LEFT, UP" char	eraseline[]	{ ERASEEOL , 0 };   /*!  * Fake some datatype definitionsd  */    #define	BOOLEAN		int; #define	DIRECTION	int	/* VAX compiler dies if these are 	*/I) #define	FLAG		int	/* defined as char			*/N #define TRUE		1* #define FALSE		0   /*  * Define maze directionsE  */G   #define EAST	 0		/* Do					*/	  #define SOUTH	 1		/*   NOT				*/$ #define WEST	 2		/*     change				*/% #define NORTH	 3		/*       this				*/O$ #define	UNKNOWN	 4		/*	   order			*/5 #define NORTHP1	 4		/* NORTH+1 for wall dimension		*/]   /*)  * Define mask values for square[][].flage  */i   #define	EBIT	001 #define	SBIT	002 #define	WBIT	004 #define	NBIT	010 #define	HERE	020   /*  * Define maze items  */d   struct square {f0 	FLAG		flag;	/* Has walls and "beenhere" bit		*/7 	DIRECTION	path;	/* Link to next square on this path	*/d };   struct sqrptr {T	 	int	row;f	 	int	col;	 };   /*  * Define the maze  */	  ! struct square maze[LSIZE][WSIZE];N  4 int	length;			/* Actual length (rows) of the maze	*/3 int	width;			/* Actual width  (cols) of the maze	*/ 4 int	minimum;		/* How many squares in the solution	*/3 int	moves;			/* Actual number of squares visited	*/n  = struct sqrptr	start;		/* The starting square (lower right)	*/ ; struct sqrptr	finish;		/* The ending square (upper left)	*/p; struct sqrptr	current;	/* Used by buildmaze and findpath	*/r3 BOOLEAN		showoff;	/* True to show maze building		*/h4 BOOLEAN		showxpath;	/* True to show backtracking		*/   /*>  * The reverse vector qives the reverse sense of any direction<  * Wall and rwall are used to set and clear the maze "walls"  */a  3 /*	    	argument =	EAST	SOUTH	WEST	NORTH	UNKNOWN	*/fA static DIRECTION reverse[] {	WEST,	NORTH,	EAST,	SOUTH,	UNKNOWN };e7 static FLAG rwall[]	   {	WBIT,	 NBIT,	EBIT,	 SBIT,	0 };s6 static FLAG wall[]	   {	EBIT,	 SBIT,	WBIT,	 NBIT,	0 };   /*,  * Note the following use of wall and rwall:  *B  *	square[x][y].flag &   wall[direction]	TRUE if a wall is presentE  *	square[x][y].flag |=  wall[direction]	SET a wall in this directionyA  *	square[x][y].flag &= ~wall[direction]	REMOVE a wall if presenta  *K  * The HERE bit may be set and cleared in the same manner.  Also, note thatI  *<  *	rwall[direction] is identical to wall[reverse[direction]]  */[     /*D  *	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
  *	*								* "  *	*		M a i n   P r o g r a m				*
  *	*								* D  *	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  */r   main(argc, argv)' int		argc;		/* Number of arguments			*/y, char		*argv[];	/* Argument pointer array		*/ {   
 #ifdef	rsx( 	if ((fd = fopen("ti:", "wun")) == NULL) 		error("Can't open ti:"); #endif  	 	erase(); 
 #ifdef	vms, 	printf("\n");			/* Prime the I/O package	*/ #endif0 	length = getvalue(23, "Maze length", 2, LSIZE);1 	width  = getvalue(22, "Maze width",  2, WSIZE);	*# 	start.row  = 0;			/* The maze			*/	. 	start.col  = width - 1;		/*   starts here		*/+ 	finish.row = length-1;		/*     and it			*/a* 	finish.col = 0;			/*       ends here.		*/  E 	showoff = getyesno(21, "Show internal maze building process", "No");r  9 	if (getyesno(20,"Do you want to solve the mazes", "No"))o 		yousolve();		f 	else {e9 		showxpath = getyesno(19, "Show backtrack paths", "No");	 		isolve();l 	} }    isolve() /*?  * The computer builds and solves the maze (without cheating!).W  */; {   " 	for (;;) {			/* Forever, ...			*/
 		erase();  $ 		resetmaze();		/* Clean it out			*/) 		buildmaze(showoff);	/* Make a maze			*/f 	s& 		showmaze();		/* Display the maze		*/1 		findpath(TRUE);		/* Find a path (display it)	*/g 	o2 		if (showxpath) {	/* If the display is unclean	*/& 			showmaze();	/* Display the maze		*/& 			showreverse();	/* And the path			*/ 		}w+ 		sleep(10);		/* Show the amazing result	*/  	} }s     static char *dirname[] {
 	"East  ",
 	"South ",
 	"West  ",	 	"North "  };  
 yousolve() /*  * The human solves the maze.s  */  {	   	register DIRECTION	compass; 	register struct square	*mp; 	register BOOLEAN	errflag; 	DIRECTION		getmove(); 	struct square		*movesquare(); 	d" 	for (;;) {			/* Forever, ...			*/
 		erase();  $ 		resetmaze();		/* Clean it out			*/) 		buildmaze(showoff);	/* Make a maze			*/v& 		showmaze();		/* Display the maze		*/# 		mp = &maze[start.row][start.col];*6 		mp->flag |= SBIT;	/* Set the south wall (no exit)	*/ 		current.row = start.row; 		current.col = start.col; 		moves = 0; 		blob(&start, 0); #ifdef	rt11g+ 		enbspc();		/* Set for single char. i/o	*/u #endif% 		while (!equal(&current, &finish)) {N4 			move(&current);	/* Move cursor to current col.	*/ 			compass = getmove();	" 			if (compass == UNKNOWN) return; #ifdef	rt11u% 			ttyout(' ');	/* Erase the blob		*/  #else*( 			ttyput(" ", 1);	/* Erase the blob		*/ #endif) 			if ((mp->flag & wall[compass]) == 0) {| 				if (errflag) { 					dca(23,0);t) 					ttyput(eraseline, sizeof eraseline);. 					errflag = FALSE;e 				} $ 				moves++;	/* It's a valid move	*/2 				maze[current.row][current.col].path = compass;1 				mp = movesquare(&current, &current, compass);e 			}	 			else {o 				dca(23,0); 				errflag = TRUE;t& 				ttyput("Possible moves are ", 19); 				for (compass = EAST;# 						compass <= NORTH; compass++) s) 					if ((mp->flag & wall[compass]) == 0)/" 						ttyput(dirname[compass], 6); 			} 			blob(&current, 0);f 		}{  ( 		sleep(2);		/* Let it stand as shown	*/ 	o0 		move(&finish);		/* Now, build the true path	*/ #ifdef	rt11 + 		ttyout(' ');		/* First erase exit blob	*/u #elseo. 		ttyput(" ", 1);		/* First erase exit blob	*/ #endif0 		showpath();		/* And show the amazing result	*/ 		sleep(10); 	} }  	   /*D  *	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
  *	*								*s)  *	*		C o n s t r u c t   a   M a z e			* 
  *	*								*tD  *	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *//     buildmaze(display). BOOLEAN		display;	/* Show handiwork if set		*/ /*   * Maze builder driving program.  *B  * The algorithm builds a simply-connected reasonably random maze.E  * (Simply-connected means that there is exactly one path between any/  * two cells of the maze.)  *D  *	1. Starting in the middle, execute the loop (size-1) times (since;  *		the algorithm must connect the current cell to (size-1) ?  *		other cells.  The "pathlen" variable defines the randomness*:  *		of the maze and was apparently set by trial and error.A  *	2. We are at a new cell.  Mark "this one visited" and spin then/  *		compass looking for an unvisited neighbour.cB  *	3. If all the neighbours have been visited (compass == UNKNOWN)5  *		or if this path has gone on long enough, go to 5.hI  *	4. Move to the neighbour (drawing a path on the screen for debugging), 5  *		increment the path length and continue at step 2. A  *	5. We can't extend the path any further.  Jump randomly aroundr:  *		in the maze until we find a cell that is the neighbour7  *		of a cell on the path.  Break down the wall betweeni>  *		these two cells and start a new path.  Continue at step 2.  *  */* { 4 	register int	count;		/* How many squares visited	*/4 	register int	size;		/* How many squares to visit	*/ 	register DIRECTION compass;* 	int		pathmax;	/* Possible path maximum	*/) 	int		pathlen;	/* Current path length		*/n/ 	int		somewhere;	/* Random place in the maze	*/ 6 	BOOLEAN		virgin();	/* Check func. for randompath()	*/7 	BOOLEAN		visited();	/* Check func. for randompath()	*/l 	DIRECTION	randompath(); 	struct square	*movesquare();w  
 	pathlen = 0;  	somewhere = 0;i 	current.row = length / 2; 	current.col = width  / 2;) 	pathmax = width;		/* "For no reason"		*/i 	size = length * width;t 	clearmarks();) 	for (count = 1; count < size; count++) { / 		mark(&current);		/* We're here, we're here	*/n) 		compass = randompath(&current, virgin);d0 		if (compass == UNKNOWN || pathlen > pathmax) {& 			do {		/* Jump around in the maze	*/0 				somewhere = (somewhere + LARGEPRIME) % size;$ 				current.row = somewhere / width;$ 				current.col = somewhere % width;- 				compass = randompath(&current, &visited);c  			} while (compass == UNKNOWN);, 			if (display) drawpath(&current, compass);! 			removewall(&current, compass);r 			pathlen = 1;t 		}z) 		else {			/* No place to go from here	*/ , 			if (display) drawpath(&current, compass);! 			removewall(&current, compass);=+ 			movesquare(&current, &current, compass); 
 			pathlen++;t 		}z 	}* 	maze[start.row][start.col].flag &= ~SBIT;+ 				/* Remove the South wall in order to	*/ * 				/* Leave space for the maze printer	*/ }s   removewall(x, d). struct sqrptr	*x;		/* The current element			*/* DIRECTION	d;		/* Which wall to remove			*/ /*I  * We've found (made) a connection.  Mark the path in the current element 4  * and in the reverse direction from the connection.  */r {, 	struct sqrptr		nearby;( 	struct square		*movesquare();  ' 	maze[x->row][x->col].flag &= ~wall[d];l7 	(movesquare(&current, &nearby, d))->flag &= ~rwall[d];I }      BOOLEAN visited(x, d)l. struct sqrptr	*x;		/* The current element			*/+ DIRECTION	d;		/* The possible direction		*/s /*C  * Visited() is called from within randompath() to determine if themE  * neighbour (in the indicated direction) has already been processed.   */n {l 	struct sqrptr	nearby; 	struct square	*movesquare();t   	if (marked(x)) return(FALSE); 	movesquare(x, &nearby, d);s2 	return(!outofbounds(&nearby) && marked(&nearby)); }(   BOOLEAN virgin(x, d). struct sqrptr	*x;		/* The element to test			*/" DIRECTION	d;		/* Where to go				*/ /*E  * Virgin() is called from within randompath() to determine if we can*#  * move in the indicated direction.r  */p {( 	struct sqrptr	nearby; 	struct square	*movesquare();d   	movesquare(x, &nearby, d);e4 	return(!(outofbounds(&nearby) || marked(&nearby))); }* e /*  *D  *	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
  *	*								*nA  *	*    F i n d   a   P a t h   T h r o u g h   t h e   M a z e	*t
  *	*								* D  *	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  */s   findpath(display)a. BOOLEAN		display;	/* Show the maze if set			*/ /*"  * Solve the maze (driver program)  * A note on the algorithm.q  *	1. Begin at the beginning.u7  *	2. We are at a new square, exit if we're at the end.a'  *		Note that we've been to this square*5  *		Choose a random path to a square connected to us.*3  *		The new square must be inside the maze, have no &  *		wall between us, and be unvisited.@  *	3. If we are connected, move to this square (make it current)5  *		and, in the new current square, remember where we	#  *		came from.  Then, go to step 2./<  *	4. If no connection could be made (we are blocked), then,2  *		Exit (no solution) if we're back at the start.6  *		Use the "where we came from" information to backup1  *		one step (but "beenhere" will prevent furthero7  *		attempts to use this square) and go back to step 2.m  *		  */d {h 	register DIRECTION	compass; 	register BOOLEAN	soluble; 	register struct square	*mp; 	struct square		*movesquare(); 	BOOLEAN			clearahead(); 	DIRECTION		randompath();e   	clearmarks(); 	current.row = start.row;* 	current.col = start.col;b 	moves = 0;e
 	minimum = 0;,> 	if (display) blob(&start, -1);	/* Note where we start from	*/, 	soluble = TRUE;			/* Well, hopefully...		*/  / 	while (!equal(&current, &finish) && soluble) { + 		mark(&current);		/* Well, here we are		*/t
 		moves++;- 		compass = randompath(&current, clearahead);r 		if (compass != UNKNOWN) {g, 			if (display) drawpath(&current, compass);0 			mp = movesquare(&current, &current, compass); 			mp->path = reverse[compass]; 
 			minimum++;s 		}r* 		else {			/* Not here, backup one step	*/& 			soluble = !equal(&current, &start);/ 			if (soluble) {	/* Still hope for the maze	*/b$ 				if (display) crossout(&current); 				compass = mp->path;n 				mp->path = UNKNOWN; 1 				mp = movesquare(&current, &current, compass);o 				minimum--; 			} 		}a 	} 	if (display) {a/ 		blob(&finish, 1);	/* Note where we end up		*/y 		report();u 	} }c     BOOLEAN clearahead(x, d)( struct sqrptr		*x;	/* Where we are				*/1 DIRECTION		d;	/* Where we are trying to get to	*/{ /*2  * Test whether we can go in the desired direction  */e {  	register BOOLEAN	blocked; 	register struct square	*mp; 	struct square		*movesquare(); 	struct sqrptr		nearby;>  6 	blocked = (maze[x->row][x->col].flag & wall[d]) != 0; 	if (!blocked) {! 		mp = movesquare(x, &nearby, d);a! 		blocked = outofbounds(&nearby);i 		if (!blocked)h1 			blocked = (mp->flag & (rwall[d] | HERE)) != 0;A 	} 	return(!blocked); }s t /*  *D  *	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
  *	*								* *  *	*	    M a n g l e   t h e   M a z e			*
  *	*								*sD  *	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  */(     resetmaze()r /*I  * Initialize the maze (slightly ugly since C lacks structure assignment)c  */{ {	 	register struct square	*mp; 	 > 	for (mp = &maze[0][0]; mp <= &maze[LSIZE-1][WSIZE-1]; mp++) {' 		mp->flag = EBIT | SBIT | WBIT | NBIT;  		mp->path = UNKNOWN;  	} }    clearmarks() /*:  * Make sure nobody thinks we've been anywhere in the maze  */	 {	 	register struct square	*mp; 	 < 	for (mp = &maze[0][0]; mp <= &maze[LSIZE-1][WSIZE-1]; mp++) 		mp->flag &= ~HERE; }*     BOOLEAN equal(x, y)  struct sqrptr	*x;* struct sqrptr	*y;e /*  * True if they're equal  */t { 2 	return((x->row == y->row) && (x->col == y->col)); }      mark(x)& struct sqrptr	*x;m /*   * Mark we've visited this place  */= {I# 	maze[x->row][x->col].flag |= HERE;= }K     BOOLEAN marked(x)m struct sqrptr	*x;  /*  * True if we've been here  */e { 1 	return((maze[x->row][x->col].flag & HERE) != 0);  }f     BOOLEAN outofbounds(x) struct sqrptr	*x;E /*.  * True if we're off the edge of the universe.  */, {  	return(		(x->row <  0)u 		|| 	(x->row >= length) 		|| 	(x->col <  0)* 		||	(x->col >= width)); }>    " /*				EAST, SOUTH, WEST, NORTH		*/; static DIRECTION rowchange[] {     0,    -1,    0,     1 };a; static DIRECTION colchange[] {     1,     0,   -1,     0 };O  " struct square *movesquare(x, y, d) struct sqrptr	*x;e struct sqrptr	*y;  DIRECTION	d; /*:  * On return y will be x moved in the indicated direction.2  * movesquare returns a pointer to the new square.4  * Note that there is not check for "out of bounds."  */0 {   	y->row = x->row + rowchange[d];  	y->col = x->col + colchange[d]; 	return(&maze[y->row][y->col]);W },      7 static DIRECTION paths[4] { NORTH, EAST, SOUTH, WEST };   ! DIRECTION randompath(x, goodpath)] struct sqrptr	*x;-8 BOOLEAN		(*goodpath)();		/* Function called from here	*/ /*C  * Move in a random direction, calling the caller-supplied functione&  * to test for a reasonable direction.  */s {r   	register int i; 	register int j; 	register DIRECTION temp;   8 	for (i = 1; i < 4; i++) {	/* Shuffle the path vector	*/0 		j = irand(i);		/* Locate a random one to do	*/ 		temp = paths[j]; 		paths[j] = paths[i]; 		paths[i] = temp; 	}  8 	for (i = 0; i < 4 && !((*goodpath)(x, paths[i])); i++);' 	return((i >= 4) ? UNKNOWN : paths[i]);o }t ) /*D  *	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
  *	*								*-   *	*		M a z e   O u t p u t				*
  *	*								*iD  *	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  */e  
 showpath() /*L  * Write the path through the maze (The maze is linked from start to finish)  */  {  	register DIRECTION	d; 	struct sqrptr		next;s: /*	struct square		*movesquare();	-- A compiler objected	*/   	current.row = start.row;  	current.col = start.col;:
 	minimum = 0;t* 	blob(&start, -1);			/* At the entrance	*/# 	while(!equal(&current, &finish)) {** 		d = maze[current.row][current.col].path; 		if (d == UNKNOWN) {*
 			dca(23,0);* 			printf("Dead at [%d, %d]\n",* 					current.row, current.col);a
 			exit(); 		}e 		minimum++; 		drawpath(&current, d);$ 		movesquare(&current, &current, d); 	}' 	blob(&finish, 1);			/* At the exit		*/t
 	report(); }q  
 showreverse()( /*L  * Write the path through the maze (The maze is linked from finish to start)  */  {n 	register DIRECTION	d; 	register struct square	*mp; 	struct sqrptr		next;t; /*	struct square		*movesquare();	-- A compiler complaint	*/	   	current.row = start.row;2 	current.col = start.col;[
 	minimum = 0;	* 	blob(&start, -1);			/* At the entrance	*/# 	while(!equal(&current, &finish)) {n# 		for (d = EAST; d <= NORTH; d++) {n' 			mp = movesquare(&current, &next, d);e7 			if (!outofbounds(&next) && mp->path == reverse[d]) {e 				minimum++; 				drawpath(&current, d);& 				movesquare(&current, &current, d);
 				break; 			} 		}g* 		if (d > NORTH) {		/* Note: never true	*/
 			dca(23,0);  			printf("Dead at [%d, %d]\n",l 					current.row, current.col);=
 			exit(); 		}r 	}' 	blob(&finish, 1);			/* At the exit		*/(
 	report(); }/    
 showmaze() /*  * Write the maze on the screen)  */  {o 	register int	i;  	 	erase();n   	for (i = 0; i < length; i++)e 		horizontal(i, SOUTH);u 	horizontal(length-1, NORTH);s   	for (i = 0; i < width; i++) 		vertical(i, WEST); 	vertical(width-1, EAST);u }n   horizontal(i, dir)  int		i;		/* The current row			*/2 DIRECTION	dir;		/* Which wall (SOUTH or NORTH)		*/ /*"  * Draw the horizontal information  */o {= 	register int		j;  	register int		k;1 	register DIRECTION	d;  	 	d = dir;  	for (j = 0; j < width;) {9 		while ((j < width) && (maze[i][j].flag & wall[d]) == 0)  			j++;n 		if (j < width) {
 			k = j + 1;  			while ((k < width)u) 					&& (maze[i][k].flag & wall[d]) != 0)  				k++; 			if (d == NORTH)! 				drawfloor(i,   j, k-1, TRUE);S& 			else	drawfloor(i-1, j, k-1, FALSE);	 			j = k;r 		}			 	} }I   vertical(i, dir)  int		i;		/* The current col			*/2 DIRECTION	dir;		/* Which wall (SOUTH or NORTH)		*/ /*   * Draw the vertical information  */  {E 	register int		j;r 	register int		k;< 	register DIRECTION	d;  	 	d = dir;m 	for (j = 0; j < length;) {0: 		while ((j < length) && (maze[j][i].flag & wall[d]) == 0) 			j++;h 		if (j < length) {k
 			k = j + 1;] 			while ((k < length)) 					&& (maze[k][i].flag & wall[d]) != 0)T 				k++; 			if (d == EAST), 				drawwall(j, i,   k-1); 			else	drawwall(j, i-1, k-1);	 			j = k;i 		}			 	} }n    ; char eastpath[]	   { DOT,            DOT,            DOT };*; char southpath[]   { DOT, SOUTHWARD, DOT, SOUTHWARD, DOT };j; char westpath[]	   { DOT, WESTWARD,  DOT, WESTWARD,  DOT }; ; char northpath[]   { DOT, NORTHWARD, DOT, NORTHWARD, DOT };j char unknownpath[] { '?' };	 static char *pathstring[] {  	&eastpath,] 	&southpath, 	&westpath,	 	&northpath,
 	&unknownpath[ };   static int pathlen[] { 	sizeof eastpath,w 	sizeof southpath, 	sizeof westpath,  	sizeof northpath, 	sizeof unknownpath  };   drawpath(x, d) struct strptr	*x;T DIRECTION	d; /*-  * Extend the path in the indicated directionO  */R {D' 	move(x);				/* Move to box's center	*/D; 	ttyput(pathstring[d], pathlen[d]);	/* and draw the path	*/R }D    ' char unxeast[]	{ 'X',            'X' };'( char unxsouth[]	{ 'X', SOUTHWARD, 'X' };' char unxwest[]	{ 'X', WESTWARD,  'X' };o( char unxnorth[]	{ 'X', NORTHWARD, 'X' };  & char uneast[]	{ ' ',            ' ' };' char unsouth[]	{ ' ', SOUTHWARD, ' ' };o& char unwest[]	{ ' ', WESTWARD,  ' ' };' char unnorth[]	{ ' ', NORTHWARD, ' ' };O   struct undraw {  	char	*str;h	 	int	len;  };   static struct undraw xout[] {  	{ &unxeast,	sizeof unxeast	},  	{ &unxsouth,	sizeof unxsouth }, 	{ &unxwest,	sizeof unxwest	},  	{ &unxnorth,	sizeof unxnorth	}, };  ! static struct undraw whiteout[] {X 	{ &uneast,	sizeof uneast	}, 	{ &unsouth,	sizeof unsouth }, 	{ &unwest,	sizeof unwest	}, 	{ &unnorth,	sizeof unnorth	}, };     crossout(x)] struct sqrptr	*x;' /**  * Mark the path "visited with a dead end"  */u {r
 	DIRECTION	d;T   	d = maze[x->row][x->col].path; 	 	move(x);h 	if (showxpath) # 		ttyput(xout[d].str,	xout[d].len);&/ 	else	ttyput(whiteout[d].str,	whiteout[d].len);u   }t     move(x)w struct sqrptr	*x;	 /*L  * Move the cursor to the center of the square  (zero, zero is bottom left).  */a {	! 	dca(x->row*2 + 1, x->col*2 + 1);o }n     char blobstring[]	{ DOT };   blob(x, offset), struct sqrptr	*x; 4 int		offset;		/* Which row offset from the center	*/ /*D  * Put a blob in the entrance/exit of the maze.  Note that this code!  * must change if move() changes.   */s {x* 	dca(x->row*2 + 1 + offset, x->col*2 + 1);' 	ttyput(blobstring, sizeof blobstring);d }e      char floorstring[]	{ '_', '_' };  char hack1string[]	{ '_', ' ' }; char hack2string[]	{ '_' };r  ' drawfloor(oldrow, oldcol, newcol, hack)>5 int	oldrow;		/* Row, may range from -1 to width-1		*/ 8 int	oldcol;		/* Column, may range from -1 to width-1		*/ int	newcol;r4 BOOLEAN	hack;		/* Special case for the top line.		*/ /*D  * Draw a floor (or ceiling) from [oldrow,oldcol] to [oldrow,newcol]:  * The hack flag leaves an opening at the top of the maze.  */  {y 	register int	i;   	dca(oldrow*2 + 2, oldcol*2);f 	if (hack) {* 		ttyput(hack1string, sizeof hack1string);% 		for (i = oldcol+1; i<= newcol; i++)w+ 			ttyput(floorstring, sizeof floorstring);r* 		ttyput(hack2string, sizeof hack2string); 	}( 	else	for (i = oldcol; i <= newcol; i++)+ 			ttyput(floorstring, sizeof floorstring);/ }p    3 char wallstring[] { '|', LEFT, UP, '|', LEFT, UP };     drawwall(oldrow, oldcol, newrow)5 int	oldrow;		/* Row, may range from -1 to width-1		*/ 8 int	oldcol;		/* Column, may range from -1 to width-1		*/ int	newrow;o /*:  * Draw a sidewall from [oldrow,oldcol] to [newrow,oldcol]  */o {i   	register int	i;   	dca(oldrow*2, oldcol*2 + 2);,# 	for (i = oldrow; i <= newrow; i++)2( 		ttyput(wallstring, sizeof wallstring); }i     report() /*F  * Note how many moves were needed.  To avoid being hassled by the I/O/  * system, we must do the conversion ourselves!   */a {o  ) 	dca(finish.row*2 + 3, finish.col*2 + 3);m" 	ttyput("The solution took ", 18); 	intput(moves);u  	ttyput(" moves, best is ", 16); 	intput(minimum);* }*  
 intput(value)f# int		value;		/* What to output			*/] /*D  * Convert the (positive) integer to ascii, and output it via ttyput  */r {  	char		line[6];2 	char		*lp;l 	int		i;  8 	lp = &line[6];		/* Do it backwards to fake recursion	*/ 	do {r 		*--lp = (value % 10) + '0';e 		value /= 10; 	} while (value > 0);  	ttyput(lp, &line[6] - lp);  }  d   DIRECTION getmove()n /*=  * Read a move from the terminal (using the VT52 arrow keys).)9  * Note: this requires single-character input (enbspc()).*-  * Return UNKNOWN if CTRL/C or CTRL/Z struck.p  */* {  	register int	c; 	BOOLEAN		flag;e  + 	flag = TRUE;			/* Looking for an ESCAPE	*/  	for (;;) {] #ifdef	rt11p 		c = ttyin() & 0177;l #endif
 #ifdef	vms 		c = kbgetc();e #endif/ 		if (c == ('C' - 0100) || c == ('Z' - 0100)) {u #ifdef	rt11w 			disspc(); #endif 			return(UNKNOWN);l 		} $ 		if (c == 0 || c == 0177) continue;" 		if (flag && c == (ESC & 0177)) { 			flag = FALSE; 			continue; 		}i 		switch (c) { 		case 'A':	return(NORTH);   		case 'B':	return(SOUTH);   		case 'C':	return(EAST);    		case 'D':	return(WEST);	
 		default: 				flag = TRUE; 		}g 	} }  A   /*D  *	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
  *	*								*c"  *	*		T e r m i n a l   I / O				*
  *	*								*-D  *	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  */f       getvalue(row, text, min, max)f) int		row;		/* Which row on the screen		*/A% char		*text;		/* What to ask for			*/{3 int		min;		/* Minimum value to accept, see below	*/U3 int		max;		/* Maximum value to accept, see below	*/u /*D  * Input a number from the terminal, first prompting the text on theB  * indicated row.  min and max force "good" values to be returned.<  * Note:  getvalue(row, text, 1, 0) accepts any input value.  */* {* 	register BOOLEAN	allok; 	register int		value;* 	char			line[LINESIZE];   8 	allok = (min == 1) && (max == 0);	/* Accept anything	*/
 	for(;;) { 		dca(row, 0); 		if (allok)% 			printf("%s%s: ", eraseline, text);u 		else. 			printf("%s%s, (minimum %d, maximum %d): ",  				eraseline, text, min, max);I
 #ifdef	vms 		fflush(stdout);, #endif/ 		if (fgetss(line, sizeof line, stdin) == NULL)a
 			exit(); 		value = atoi(line);t. 		if (allok || (value >= min && value <= max)) 			return(value);. 	} }   % BOOLEAN getyesno(row, prompt, assume)n& int		row;		/* Where on the screen			*/) char		*prompt;	/* A message of sorts			*/t% char		*assume;	/* Assumed answer			*/; /*!  * Prompt and get a yes/no answers  */, {x 	register char	*lp;t 	char		line[LINESIZE];   	for (;;) {  		dca(row, 0);3 		printf("%s? <%s> %s", prompt, assume, eraseline);d
 #ifdef	vms 		fflush(stdout);i #endif, 		if (fgetss(line, LINESIZE, stdin) == NULL)
 			exit();# 		for (lp = line; lp == ' '; lp++);) 		if (*lp == 0) *lp = *assume;- 		if (*lp == 'y' || *lp == 'Y') return(TRUE);w. 		if (*lp == 'n' || *lp == 'N') return(FALSE); 	} }s  ( char dcastring[] { ESC, 'Y', '?', '?' }; #define DCAROW	2 #define DCACOL	3   dca(vtrow, vtcol)*& int	vtrow;		/* Row on the screen				*/) int	vtcol;		/* Column on the screen				*/; /*D  * Move the cursor to the indicated position.  Note that, unlike theH  * vt52 hardware, [0,0] is at the bottom left hand corner of the screen.  */  {o  	dcastring[DCAROW] = 55 - vtrow;  	dcastring[DCACOL] = 32 + vtcol;% 	ttyput(dcastring, sizeof dcastring);U }w    ! char	clrscr[]	{ HOME, ERASEEOS };n   erase()} /*  * Clear the screen{  */  {, 	ttyput(clrscr, sizeof clrscr);d }n  
 #ifdef	rsx ttyput(buffer, buflen)% char		*buffer;	/* What to output			*/	. int		buflen;		/* Number of bytes to output		*/ /*%  * Output to the terminal.  RSX mode.N  */h {  	fput(buffer, buflen, fd); }0 #endif  
 #ifdef	vms ttyput(buffer, buflen)% char		*buffer;	/* What to output			*/5. int		buflen;		/* Number of bytes to output		*/ /*#  * Output to the terminal, VMS mode   */h {c 	register int	i; 	register char	*bp;}  
 	bp = buffer;e* 	for (i = buflen; i-- > 0; kbputb(*bp++)); 	kbflush();  }i #endif   #ifdef	foort11   /*C  * RT11 I/O interface routines.  These should be rewritten in MacrobK  * and put in the library.  They assume that you have the system subroutineu  * library installed.   */e   struct	MEM_WORD {t 	int	mem_word; };   #define	JSW	044  extern	int	ittinr(); extern	int	ittour();   enbspc() /*  * Enable special mode  */e {r 	JSW->mem_word |= 010100;  }g   disspc() /*  * Disable special mode   */f {e 	JSW->mem_word &= ~010100; }p   ttyin(); /*"  * Read one byte from the terminal  */  {* 	register int	c;  $ 	while ((c = call(&ittinr, 0)) < 0); 	return (c); }a   ttyinr() /*<  * Read a byte from the terminal, return -1 if nothing ready  */y {s 	register int	c;   	c = call(&ittinr, 0); 	return ((c < 0) ? -1 : c);4 }   	 ttyout(c)t char		c; /*"  * Output one byte to the terminal  */  {c" 	while (call(&ittour, 1, c) != 0); }1   ttyput(buffer, count)* register char	*buffer; register int	count;e /*  * Write a buffer to the tty  */  {R 	while (--count >= 0) {m) 		while (call(&ittour, 1, *buffer) != 0);( 		buffer++;t 	} }	 #endif