 #  /*  *		M O Z A R T . C   *H  * This is an implementation of the "Melody Dicer," attributed to MozartD  * that generates an "infinite" number of short minuettes.  The noteB  * tables have not been included as I have not been able to find aG  * public-domain source.  If you are interested, you should try to find K  * a copy of the "Melody Dicer" game, available at music stores everywhere.   *H  * As implemented, this program generated music tables that were used toC  * drive a home-made synthesizer board attached to an RT-11 system. D  * Converting to other synthesizers should not be too great a chore.  *G  * The documentation file, mozart.rno, describes a similar algorithm by D  * Kirnberger.  Unfortunately, we haven't gotten around to typing in  * the notes yet.   *2  * [And you thought programmers weren't sadistic.]  *  */   & #define	NMEASURE	200	/* Measures				*/@ #define	NVOICES		1800	/* Voice information (n_voice * m_meas)	*/3 #define	NNOTES		4000	/* Notes in compiled music		*/ 4 #define	NPNOTES		256	/* Play notes in each voice		*/< #define	NPBYTES		768	/* Bytes in each voice (NPNOTES * 3)	*/1 #define NPVOICE		6	/* Voices for each measure		*/ > #define	MULTIPLIER	12	/* Multiply duration to get play dur.	*/   /*  * Special "notes"  */   ' #define	REST	192		/* "Rest" note 				*/ 3 #define	GAP	193		/* Descriptor for voice header		*/  #define	XPOSE	194		/*	""				*/ #define	ATACK	195		/*	""				*/ #define	DECAY	196		/*	""				*/ #define	VOL	197		/*	""				*/ #define	SUSTN	198		/*	""				*/ #define	RELSE	199		/*	""				*/2 #define	STOP	203		/* End of other voice tables		*/0 #define	END	205		/* End of first voice table		*/   /*  * RT11 definitions   */ + #define	JSW		   044	/* Job status word			*/ ; #define	SPECMODE	010100	/* Bit 12, console special mode		*/    struct { 	int	mem_word; }    /*  * Structure definitions  */    struct measure {9 	struct voice	*m_voice[2];	/* Points to NPVOICE voices	*/ 5 	int		m_vcount[2];	/* Number of voices for measure	*/  };   struct voice {1 	struct note	*v_note;	/* Notes for this voice		*/ . 	int		v_count;	/* Number of notes for voice	*/ };  
 struct note { 
 	char	n_note;  	char	n_dur; };   /*  * Tables for compilation   */    char *special[] { , "REST ", "GAP  ", "XPOSE", "ATACK", "DECAY",, "VOL  ", "SUSTN", "RELSE", "?200 ", "?201 ",# "?202 ", "STOP ", "?204 ", "END  ",  };   /**  * ttab translates notes (A-G) to numbers.  */    int ttab[] { 	 0,  1,	/* A	A#	*/  	 2, -1,	/* B		*/  	 3,  4,	/* C	C#	*/  	 5,  6,	/* D	D#	*/  	 7, -1,	/* E		*/  	 8,  9,	/* F	F#	*/  	10, 11,	/* G	G#	*/  };   /*,  * dtab translates durations to length codes  */   
 struct dtab {  	int	d_val;  	int	d_dur; 
 } dtab[] { 	{ 64, 1 },  	{ 32, 3 },  	{ 16, 6 },  	{  8,12 },  	{  4,24 },  	{  2,48 },  	{  1,96 },  	{  0, 0 },  };  @ #define	RESTDUR	(3 * 12)	/* A missing voice = 3 1/8 note rest	*/. 				/* 1/8 notes have 12 duration in dtab[]	*/$ int	restword = (RESTDUR)*MULTIPLIER;B char	*restbyte = &restword;	/* Pointer to restword as two bytes	*/   char	*ntext[] { H   "AN", "AS", "BN", "CN", "CS", "DN", "DS", "EN", "FN", "FS", "GN", "GS" };   /*F  * Mtab has measure numbers (from the text).  It is stored as printed.;  * I.e, first all numbers for dice 2, then for dice 3, etc.   */    int	mtab[11][16] {B  96, 22,141, 41,105,122, 11, 30,   70,121, 26,  9,112, 49,109, 14,B  32,  6,128, 63,146, 46,134, 81,  117, 39,126, 56,174, 18,116, 83,B  69, 95,158, 13,153, 55,110, 24,   66,139, 15,132, 73, 58,145, 79,B  40, 17,113, 85,161,  2,159,100,   90,176,  7, 34, 67,160, 52,170,B 148, 74,163, 45, 80, 97, 36,107,   25,143, 64,125, 76,136,  1, 93,B 104,157, 27,167,154, 68,118, 91,  138, 71,150, 29,101,162, 23,151,B 152, 60,171, 53, 99,133, 21,127,   16,155, 57,175, 43,168, 89,172,B 119, 84,114, 50,140, 86,169, 94,  120, 88, 48,166, 51,115, 72,111,B  98,142, 42,156, 75,129, 62,123,   65, 77, 19, 82,137, 38,149,  8,B   3, 87,165, 61,135, 47,147, 33,  102,  4, 31,164,144, 59,173, 78,A  54,130, 10,103, 28, 37,106,  5,   35, 20,108, 92, 12,124, 44,131  };   struct voice	voice[NVOICES];< struct voice	*p_voice = voice;	/* Free pointer into voice	*/? struct measure	measure[NMEASURE];	/* Voices for this measure	*/o struct note	note[NNOTES];e; struct note	*p_note = note;		/* Free pointer into note[]	*/ 3 char voice0[NPBYTES];		/* Voices are stored here	*/e char voice1[NPBYTES];n char voice2[NPBYTES];e char voice3[NPBYTES];a char voice4[NPBYTES];r char voice5[NPBYTES];l char **voices[NPVOICE] {5 	&voice0, &voice1, &voice2, &voice3, &voice4, &voice5a };7 char	**pvoices[NPVOICE];		/* -> voice's current note	*/t char	**voicetop[NPVOICE] {6 	&voice0[NPBYTES], &voice1[NPBYTES], &voice2[NPBYTES],6 	&voice3[NPBYTES], &voice4[NPBYTES], &voice5[NPBYTES]  };   struct psetup {t& 	int	ps_note;		/* Funny note to do		*/$ 	int	ps_value;		/* Default value		*/+ 	int	ps_index;		/* index into psetval[]		*/ - 	char	*ps_text;		/* Name of this parameter	*/  } psetup[] { 	{ GAP,		65535,	0,	"Gap"		}," 	{ XPOSE,	65024,	1,	"Transpose"	}, 	{ ATACK,	 8192,	2,	"Attack"	},	 	{ DECAY,	   50,	3,	"Decay"		},y 	{ VOL,		55000,	4,	"Volume"	},  	{ SUSTN,	20000,	5,	"Sustain"	},  	{ RELSE,	   50,	6,	"Release"	}, 	{ 0,		    0,	0,	""		},  };  > int	psetval[7][NPVOICE];	/* First index is value, 2nd voice	*/   /*/  * Handy variables for byte <-> word conversion1  */*   int	intword; char	*byteword = &intword;  , int	iobuf[260];			/* 520 byte i/o buffer		*/& char	line[133];			/* Input buffer			*/) int	end_file	= 0;		/* End file marker		*/f int	line_count	= 0;	 int	curr_meas	= 0; int	curr_voice	= 0;n int	echoflag	= 0;	   main() {	 	extern int	play();t 	int	dmusic; 	int	pmusic; 	int	doctal;  ; 	printf("Mozart Dice Dance composer, compiling grammar\n"); ( 	if (fopen("mozart.txt", iobuf) == -1) {$ 		printf("Can't open mozart.txt\n");	 		exit();e 	}/ 	echoflag = getyesno("Echo input lines", "No"); & 	compile();			/* Compile the music		*/+ 	if (getyesno("Dump measure tables", "No"))n% 	 	d_meas();		/* Dump the buffers		*/t. 	setpreset();			/* Initialize preset buffer	*/ 	for (;;) {{( 		dmusic = getyesno("Dump music", "No");
 		if (dmusic)t, 			doctal = getyesno("Dump in octal", "No");) 		pmusic = getyesno("Play music", "Yes");_
 		getsetup(); + 		printf("Type any key to stop playing\n");c 		for (;;) { 			JSW->mem_word |= SPECMODE;  			if (ittinr() >= 0)T
 				break;
 			getplay();  			if (dmusic)& 				dump(doctal);	/* Dump the music	*/ 			if (pmusic) { 				/*! 				 * play runs the synthesizer.  				 *//- 				call(&play, 6, &voice0, &voice1, &voice2,#! 						&voice3, &voice4, &voice5);, 			} 		}  		JSW->mem_word &= (~SPECMODE);  	} }    setpreset()d /*3  * Called once to initialize the voicing parametersd  */  {i 	register struct psetup	*ps; 	register int		vindex;  % 	for (ps = psetup; ps->ps_note; ps++){. 		for (vindex = 0; vindex < NPVOICE; vindex++)1 			psetval[ps->ps_index][vindex] = ps->ps_value;	o }   
 getsetup() /*   * Modify the playing parameters  */n {a 	register struct psetup	*ps; 	register int		vindex; 	y 	for (;;) {d6 		printf("Enter voice number (0 .. %d), <CR> exits: ", 				NPVOICE - 1);  		if (getcommand())"
 			exit(); 		if (line[0] == '\0')
 			return; 		vindex = atoi(line);( 		if (vindex < 0 || vindex >= NPVOICE) {( 			printf("Illegal voice %d\n", vindex); 			continue; 		}e; 		printf("Current control values, enter <CR> to retain\n");,( 		for (ps = psetup; ps->ps_note; ps++) {$ 			printf("%s = %l ? ", ps->ps_text,$ 					psetval[ps->ps_index][vindex]); 			if (getcommand()) 				exit();, 			if (line[0] != '\0') {1/ 				psetval[ps->ps_index][vindex] = atoi(line);6 			} 		}  	} },   			 getplay()3 /*)  * Compile music into the playing buffers5  */, {,) 	register int	meas;		/* Which measure		*/23 	register int	vindex;		/* Voice index for finish	*/,+ 	int		saveroll[17];	/* Saves dice rolls		*/,& 	int		mindex[17];	/* Measure index		*/  & 	getinit();			/* Initialize voices		*/ 	printf("\nMeasure:      ");% 	for (meas = 1; meas <= 16; meas++) {  		vindex = roll(); 		saveroll[meas] = vindex;( 		mindex[meas] = mtab[vindex-2][meas-1]; 		printf("%4d", meas); 	} 	printf("\nDice:         ");# 	for (meas = 1; meas <= 16; meas++)o  		printf("%4d", saveroll[meas]); 	printf("\nTable measure:");# 	for (meas = 1; meas <= 16; meas++)  		printf("%4d", mindex[meas]); 	printf("\n");" 	for (meas = 1; meas <= 8; meas++)0 		p_meas(mindex[meas], meas, 0, saveroll[meas]);" 	for (meas = 1; meas <= 7; meas++)0 		p_meas(mindex[meas], meas, 0, saveroll[meas]);A 	p_meas(mindex[8], 8, 1, saveroll[8]);	/* Get alternate ending */2# 	for (meas = 9; meas <= 16; meas++)r0 		p_meas(mindex[meas], meas, 0, saveroll[meas]);/ 	pstuff(0, REST, restbyte[1], restbyte[0], 17);,6 	pstuff(0, END, 0, 0, 17);	/* Stuff the end signals	*// 	for (vindex = 1; vindex < NPVOICE; vindex++) {t5 		pstuff(vindex, REST, restbyte[1], restbyte[0], 17);t! 		pstuff(vindex, STOP, 0, 0, 17);i 	} }n  	 getinit()x /*  * Initialize the playing field	  */a {o 	register int		vindex; 	register struct psetup	*ps;  / 	for (vindex = 0; vindex < NPVOICE; vindex++) {A# 		pvoices[vindex] = voices[vindex];Y( 		for (ps = psetup; ps->ps_note; ps++) {+ 			intword = psetval[ps->ps_index][vindex];	 			pstuff(vindex, ps->ps_note," 					byteword[1], byteword[0], 0); 		}	 	} }[   p_meas(mindex, meas, altvoice)1 int		mindex;		/* Which measure table to output	*/ / int		meas;		/* Which measure we're doing now	*/*3 int		altvoice;	/* Alternate voice index (0 or 1)	*/  /*%  * Output all voices for this measureb  */	 {/6 	register struct voice	*vp;	/* Voice table pointer		*/: 	register struct measure	*mp;	/* Minuette measure to do	*/4 	register int		vcount;	/* Voices for this measure	*// 	int			mcount;	/* Voices in minuette measure	*/M  4 	mp = &measure[mindex];		/* Here's the one to do		*/ 	vp = mp->m_voice[altvoice];! 	mcount = mp->m_vcount[altvoice];. 	if (mcount != NPVOICE) {e; 		printf("Wrong number of voices (%d) for table measure, ",	 			mcount, mindex);	' 		printf("alternate %d\n", altvoice+1);" 		if (mcount > NPVOICE)D 			mcount = NPVOICE; 	}. 	for (vcount = 0; vcount < mcount; vcount++) {' 		getvoice(vp, vcount, altvoice, meas);" 		vp++;  	}# 	for (; vcount < NPVOICE; vcount++)p7 		pstuff(vcount, REST, restbyte[1], restbyte[0], meas);s }_  & getvoice(vptr, vcount, altvoice, meas). struct	voice	*vptr;		/* Voice to generate			*// int		vcount;		/* Which one to stuff it into		*/r  int		altvoice;	/* Selector				*/0 int		meas;		/* Measure number (for debugging)	*/ /*   * Output notes for this measure  */n {s 	register struct note	*np; 	register int		ncount; 	register int		count;i   	np	= vptr->v_note;, 	ncount	= vptr->v_count;+ 	for (count = 0; count < ncount; count++) {  		intword = (np->n_dur & 255);! 		intword = intword * MULTIPLIER; = 		pstuff(vcount, np->n_note, byteword[1], byteword[0], meas);s 		np++;; 	} }_  1 pstuff(vindex, notebyte, highbyte, lowbyte, meas)n* int		vindex;		/* Voice number (0 - 5)			*/" char		notebyte;	/* Note byte				*/, char		highbyte;	/* High byte of duration		*/+ char		lowbyte;	/* Low byte of duration			*/v /*I  * Enter the next note for this voice.  This is the only routine to enter,  * data into pvoices[].f  */c {a 	register char		*pp;   	pp = pvoices[vindex]; 	if (pp >= voicetop[vindex]) {5 		printf("Too many notes for voice %d, measure %d\n",l 			vindex, meas);i4 		fatal("Voice", voicetop[vindex] - voices[vindex]); 	} 	*pp++ = notebyte; 	*pp++ = highbyte; 	*pp++ = lowbyte;n 	pvoices[vindex] = pp; }    dump(doctal)* int	doctal;		/* Dump in octal if set				*/ /*"  * Dumb routine to dump some music  */l {[   	register int		vindex;+ 	int			anything;	/* Set if a note prints	*/  	register int		temp; 	register char		*pp; 	char			**sptr;   - 	for (vindex = 0; vindex < NPVOICE; vindex++)/3 		pvoices[vindex] = voices[vindex];	/* Init ptrs	*/     	for (anything = 1; anything;) {$ 		anything = 0;			/* Nothing yet		*/2 		for (vindex = 0; vindex < NPVOICE; vindex++) {		+ 			pp = pvoices[vindex];	/* Do this one		*/ $ 			temp		= *pp++ & 0377;	/* note		*/* 			byteword[1]	= *pp++ & 0377;	/* hidur	*/* 			byteword[0]	= *pp++ & 0377;	/* lodur	*/ 			if (doctal) {# 				printf(":%03o %03o %03o", temp,: 					byteword[1] & 0377, 					byteword[0] & 0377);	 			}	 			else {e 				if (temp > REST) 					printf("%s %6l",f# 						special[temp-REST], intword);	 				else if (temp == REST) 					printf("R  %9d",( 						intword / MULTIPLIER);
 				else { 					temp /= 2;0) 					printf("%s%d %8d", ntext[temp % 12],  						temp / 12, 						intword / MULTIPLIER); 				}a 			}. 			printf((vindex == NPVOICE-1) ? "\n" : " ");# 			if (temp == STOP || temp == END)e
 				continue;+ 			anything = 1; 			pvoices[vindex] = pp; 		}] 	} }t   d_meas() /*  * Dump the measure table.  */t {( 	register struct measure	*mp;  	register struct voice	*vp;=  1 	if (getyesno("Dump selective measures", "No")) {R 		for (;;) { 			printf("Measure, 0 ends: ");v 			if (getcommand()) 				return;  			curr_meas = atoi(line); 			if (curr_meas <= 0) 				return;s 			if (curr_meas >= NMEASURE) {t1 				printf("Bad measure number %d\n", curr_meas);  				continue;		v 			} 			mp = &measure[curr_meas]; 			printf(".%d\n", curr_meas);( 			if (mp->m_voice[0] == mp->m_voice[1])0 				d_voice(mp->m_voice[0], mp->m_vcount[0], 0);	 			else { 0 				d_voice(mp->m_voice[0], mp->m_vcount[0], 1);0 				d_voice(mp->m_voice[1], mp->m_vcount[1], 2); 			} 		}t 	} /*  * Dump all measures  */w 	curr_meas = -1;4 	for (mp = measure; mp < &measure[NMEASURE]; mp++) { 		curr_meas++; 		if (mp->m_vcount[0] == 0) , 			continue;	/* No entry for this measure	*/ 		printf(".%d\n", curr_meas);t 		vp = mp->m_voice[0]; 		if (vp != mp->m_voice[1]) {e# 			d_voice(vp, mp->m_vcount[0], 1);s/ 			d_voice(mp->m_voice[1], mp->m_vcount[1], 2);u 		}M' 		else	d_voice(vp, mp->m_vcount[0], 0);e 	} }    d_voice(vptr, mcount, altflag)* struct voice	*vptr;		/* Voice pointer			*/& int		mcount;		/* Number of voices			*/& int		altflag;	/* Alternate signal			*/ /*6  * Dump all voices for the current measure.  altflag =  *	0	No alternationt  *	1	Dump alternate 1   *	2	Dump alternate 2c  */= {  	register struct note	*np; 	register int		nvoice; 	register int		ncount;  
 	if (altflag)  		printf("]%d\n", altflag); ) 	printf("* measure %d, [%d] %d voices\n",e 			curr_meas, altflag, mcount);,. 	for (nvoice = 0; nvoice < mcount; nvoice++) { 		np = vptr->v_note;? 		printf("* voice %d has %d notes\n", nvoice+1, vptr->v_count);c4 		for (ncount = 0; ncount < vptr->v_count; ncount++) 			d_note(np++);	 		vptr++;u 	} 	printf("\n"); }e   d_note(nptr) struct note	*nptr; /*  * Dump a note  */; {r 	register int		nval; 	register struct	dtab	*dp;   	nval = nptr->n_note & 255;n 	if (nval == REST) 		printf("R ,"); 	else {  		nval /= 2;1 		printf("N %s%d,", ntext[nval % 12], nval / 12);v 	}C 	for (dp = dtab; dp->d_dur != 0 && dp->d_dur != nptr->n_dur; dp++);  	printf("%d\n", dp->d_val);b },  	 compile()s /*  * Compile the music  */e {04 	register struct measure	*mp;	/* Measure pointer		*/ 	register int		mcount; 	register int		vcount;	b 	char			*skipbl();   	mcount = 0;& 	skipline(1);			/* Find first line		*/ 	while (!end_file) { 		if (line[0] != '.') { ! 		bug("Expecting a new measure");e 			skipline(1);p 			continue; 		};% 		curr_meas = atoi(skipbl(&line[1]));n 		mcount++;n0 		if (curr_meas <= 0 || curr_meas >= NMEASURE) {. 			bug1("Illegal (or missing) measure [%d]\n", 					curr_meas); 			skipline(1);  			continue; 		}  		mp = &measure[curr_meas];v 		if (mp->m_vcount[0] != 0) {). 			bug1("You've entered measure %d already\n", 				curr_meas);  		}m 		if (skipline(1)) {# 			bug("Eof after measure number");y 			continue; 		}n, 		if (line[0] != ']') {			/* No alternate	*/ 			mp->m_voice[0] = p_voice; 			mp->m_voice[1] = p_voice; 			vcount = in_voice(0); 			mp->m_vcount[0] = vcount; 			mp->m_vcount[1] = vcount; 			if (vcount != NPVOICE)	2 				bug1("Wrong number of voices (%d) in measure", 						vcount); 		}v 		else {					/* Alternate 1	*/ 			if (line[1] != '1') {+ 				bug1("Expecting ]1, got ]%c", line[1]);t
 				continue;+ 			} 			skipline(1);	 			mp->m_voice[0] = p_voice; 			vcount = in_voice();) 			mp->m_vcount[0] = vcount; 			if (vcount != NPVOICE)]0 				bug1("Wrong number of voices (%d) in alt 1",
 					vcount);e 			if (skipline(0)) {(! 				bug("Eof after alternate 1");]
 				continue;	 			}* 			if (line[0] != ']' || line[1] != '2') {+ 				bug("Illegal alternate, expecting ]2");	
 				continue;	 			} 			skipline(1);t 			mp->m_voice[1] = p_voice; 			vcount = in_voice();T 			mp->m_vcount[1] = vcount; 			if (vcount != NPVOICE) 0 				bug1("Wrong number of voices (%d) in alt 2",
 					vcount);+ 		}a 	}+ 	printf("* %d measures entered\n", mcount);  }   
 in_voice() /*<  * Enter the next voices for this measure/alternate.  Return   * the number of voices entered.  *(  * On entrance, line -> first voice line'  * Return on blank line or . or ] seen.e  * nB  * Warning: the input file must have one of the following formats:$  *	notes (both normal and alternate)  *	<blank line>_  * or   *	notes
  *	]alternate"  */e {r 	register struct	voice	*vp;  	register int		nnotes; 	char			*skipbl(); 	struct	voice		*nextvoice();   	curr_voice = 0; 	while (!skipline(0)) {i' 		if (line[0] == ']' || line[0] == '.')_	 			break;0 		curr_voice++;	* 		vp = nextvoice();		/* Vp -> voice box	*/ 		vp->v_note = p_note;% 		while (!end_file && line[0] != 0 &&t' 				line[0] != ']' && line[0] != '.') {r 			vp->v_count = in_note();u 		}p 	} 	return(curr_voice); }{  	 in_note()+ /**  * Read the notes, return the number read.  */e {y 	register char	*lp;  	register struct	dtab	*dp; 	register int	c; 	struct 	note	*np;
 	int		ncount;] 	struct	note	*nextnote();v 	char		*skipbl();d 	i 	ncount = 0; /*  * Note line format:  *	N AN0,len  * ore	  *	R ,lenv  *H  * Where N is note, R is rest.  len is the length (must be in the table)D  * Each note is given as [A-G] followed by N (natural) or S (sharp),D  * followed by the octave number [0-9].  AN0 (the lowest note) is 0.  */a$ 	while (!end_file && line[0] != 0 &&' 				line[0] != ']' && line[0] != '.') {n 		np = nextnote(); 		ncount++;t 		lp = skipbl(line); 		if ((c = *lp++) == 'R') {n 			np->n_note = REST;  		}r 		else if (c == 'N') { 			lp = skipbl(lp);% 			c = *lp++ - 'A';e" 			if (c < 0 || c > ('G' - 'A')) {. 				bug1("Illegal character '%c'\n", c + 'A');
 				continue;n 			}& 			c += c;			/* Times two for index	*/ 			if (*lp == 'S') {$ 				c++;		/* Fix index for sharps	*/" 				lp++;		/* Eat the character	*/ 			} 			else if (*lp == 'N');# 				lp++;		/* Eat natural chars.	*/t 			/*  			 * Assuming 7 octaves?? 			 */  			if (*lp < '0' || *lp > '7') {' 				bug1("Illegal octave '%c'\n", *lp); 
 				continue;  			}5 			np->n_note = (ttab[c] + (12 * (*lp++ - '0'))) * 2;  		}[ 		else {. 			bug1("Expecting note/rest, got '%c'\n", c);+ 			np->n_note = REST;	/* stuff something	*/i 		}% 		/*( 		 * Got the note, now for the duration. 		 */e 		lp = skipbl(lp); 		if (*lp++ != ',')e6 			bug1("Expecting comma before duration, got '%c'\n", 					*--lp);( 		c = atoi(lp);			/* Compile duration	*/5 		for (dp = dtab; dp->d_val && dp->d_val != c; dp++);d 		if (dp->d_val == 0) $ 			bug1("Unknown duration %d\n", c); 		np->n_dur = dp->d_dur; 		getline(); 	} 	return(ncount); }i   struct voice *nextvoice()t /*  * Update voice pointer   */m {   	if (p_voice >= &voice[NVOICES]) 		fatal("voice", NVOICES); 	return(p_voice++);	 }i   struct note *nextnote()	 /*  * Update notes pointer]  */	 {( 	if (p_note >= &note[NNOTES])g 		fatal("note", NNOTES); 	return(p_note++); }r   char *skipbl(lineptr)p char	*lineptr; /*0  * Skip over blanks, return updated line pointer  */( {e 	register char	*lp;   - 	for (lp = lineptr; *lp && *lp <= ' '; lp++);- 	return(lp); }o   skipline(flag)' int		flag;		/* 1 to read initially			*/; /*D  * Skip blank lines, flag is non-zero to read a line before checking(  * for blanks.  Return 1 on end of file.  */u {;
 	if (flag) 		line[0] = 0;" 	while (!end_file && line[0] == 0)% 		getline();			/* Skip blank lines	*/e 	return(end_file); }   	 getline()l /*+  * Read text (from iobuf) to global line[]. '  * Return 1 on end of file, zero on ok.n  */	 {  	register char	*t; 	register char	c;u   reread:	t = line;n 	line_count++;! 	while ((c = getc(iobuf)) >= 0) {	0 		if (c == 0 || c == '\r')	/* Skip CR or NULL	*/# 			continue;		/* Rt11 last block	*/] 		if (c == '\n') { 			/*l! 			 * Squeeze out trailing blankso 			 */( 			while (t > line && t[-1] == ' ') t--;
 			*t = 0;- 			if (line[0] == '*')	/* Allow * comments	*/= 				goto reread; 			if (echoflag)  				printf(">> \"%s\"\n", line);
 			return(0);, 		}	 		*t++ = c;	 	} 	if (echoflag) 		printf("End of file\n");
 	line[0] = 0;v 	end_file = 1; 	return(1);  }c   getyesno(prompt, normal)$ char	*prompt;		/* Prompt string			*/2 char	*normal;		/* Default answer "Yes" or "No"		*/ {*/ 	printf("%s? (Yes/No) <%s>: ", prompt, normal);W 	if (getcommand())- 		return(0);	/* End of file is very false		*/n 	if (line[0] == 0) 		line[0] = normal[0];  	return((line[0] | 040) == 'y'); }t   getcommand() /*,  * Read text from keyboard to global line[].H  * Return 1 on end of file, zero on ok.  Note: rt11 probably trashes the+  * job so you'll never see the end of file.|  */e {  	register char	*t; 	register char	c;   
 	t = line; 	line_count++; 	while ((c = getchar()) >= 0) {t0 		if (c == 0 || c == '\r')	/* Skip CR or NULL	*/# 			continue;		/* Rt11 last block	*/	 		if (c == '\n') { 			/* ! 			 * Squeeze out trailing blanks  			 */( 			while (t > line && t[-1] == ' ') t--;
 			*t = 0;
 			return(0);s 		}h 		*t++ = c;g 	}
 	line[0] = 0;d 	end_file = 1; 	return(1);  }t   bug(s) char	*s; /*  * Bug printoutt  */) {  	printf("? %s\n", s); 6 	printf("? Input line %d \"%s\"\n", line_count, line);; 	printf("? Current measure is %d, current voice is %d\n\n",t 			curr_meas, curr_voice); })  
 bug1(s, i) char	*s; int	i; /*  * Bug printouta  */  {s 	printf(s, i);7 	printf("? Input line %d  \"%s\"\n", line_count, line); ; 	printf("? Current measure is %d, current voice is %d\n\n",= 			curr_meas, curr_voice);   }=   fatal(s, i)	 char	*s; int	i; /*  * Table overflowc  */p { 1 	printf("%s table overflow, max. is %d\n", s, i); ( 	printf("Input line is \"%s\"\n", line);# 	printf("Measure %d\n", curr_meas);'	 	exit(1);{ }	   roll() /*G  * Roll the dice twice, return their sum.  Note: a number between 2 ande  * 12 is always returned.*  */  {)! 	return(irand(6) + irand(6) + 2);p }/  