   /*  * 			O B J R E F   *G  * NOTE: this program has been superceded by additional capabilities in E  * nm.c (in tools).  It is included here as it offers a simple set of ,  * subroutines for processing symbol tables.  */    /*)BUILD	$(TKBOPTIONS) = { 			TASK	= ...REF 		}  */   #ifdef	DOCUMENTATION  ( title	objref	Object file cross reference" index		Object file cross reference   synopsis   	objref file_list    description   ? 	objref reads each file in the list, building a cross reference @ 	listing of symbols (where symbols were defined and referenced). 	.sr= 	The files in the file_list were output by nm.  The file_lists< 	arguments may contain wildcards.  The argument string to nm 	is as follows:b 	.sb 		nm "-1" file.obj >file.nmP   author  
 	Martin MinowF   bugs  . 	Superceded by additional capabilities in nm.c   #endif   #include <stdio.h> #define	FALSE	0f #define	TRUE	1
 #define	EOS	0i   typedef struct symbol {  	struct symbol	*s_next;n 	char		*s_name;n1 	struct module	*s_defn;	/* Where it's defined		*/m3 	struct refer	*s_refer;	/* Where it's referenced	*/i	 } SYMBOL;l   typedef struct module {  	struct module	*m_next;y 	char		*m_name;s 	int		m_index;	 } MODULE;m   typedef struct refer { 	struct refer	*r_next; 	struct module	*r_module;i } REFERENCE;   SYMBOL		*sfirst		= NULL; MODULE		*mfirst		= NULL; REFERENCE	*rfirst		= NULL;  
 FILE		*fd; char		line[133]; char		name[133]; char		value[133];m #define		CROSS_MAX	25*! int		cross[CROSS_MAX][CROSS_MAX];  char		*mname[CROSS_MAX]; int		cmax		= -1; extern char	*strsave();* extern char	*myalloc();i   Y main(argc, argv)
 int		argc; char		*argv[]; {e 	register int		nfiles; 	register int		i;;   	for (i = 1; i < argc; i++) {f+ 		if ((fd = fwild(argv[i], "r")) == NULL) {*2 			fprintf(stderr, "can't open wild card file: "); 			perror(argv[i]);N 			continue; 		}i1 		for (nfiles = 0; fnext(fd) != NULL; nfiles++) {	
 			process();r 		}u 		if (nfiles == 0) {7 			fprintf(stderr, "no files match \"%s\"\n", argv[i]);a 		}O 	}
 	mnames();
 	output(); }e  	 process()a /*  * For each file ...  */i {  	register MODULE		*mp; 	register SYMBOL		*sy; 	extern	MODULE		*newmodule();r 	extern	SYMBOL		*lookup();   	getfilename(fd, line);f 	mp = newmodule(line);/ 	while (fgets(line, sizeof line, fd) != NULL) {w) 		sscanf(line, "%s%*s%s", &name, &value);	 		sy = lookup(name); 		if (value[0] == '*') {( 			addref(sy, mp);		/* Undefined here	*/ 		}f 		else {				/* Defined here		*/r 			if (sy->s_defn != NULL) {1 				printf("** symbol %s defined in %s and %s\n", & 					sy->s_name, (sy->s_defn)->m_name, 					mp->m_name);O 				fprintf(stderr, + 					"** symbol %s defined in %s and %s\n", & 					sy->s_name, (sy->s_defn)->m_name, 					mp->m_name);  			}	 			else {; 				sy->s_defn = mp; 			} 		}, 	} }    output() {a 	register SYMBOL		*sy; 	register int		nsy;l 	register REFERENCE	*rp; 	int			i, j;   	/*e% 	 * Pass 1 for "library" symbols only  	 */, 	printf("The following are not defined:\n");	 	nsy = 0; 1 	for (sy = sfirst; sy != NULL; sy = sy->s_next) {  		if (sy->s_defn == NULL) {- 			printf("%c%s",m0 				((nsy & 7) == 0) ? '\n' : '\t', sy->s_name);	 			nsy++;  		}d 	} 	printf("\n\n"); 	/*() 	 * Pass 2 for symbols not used elsewhere	 	 */A 	printf("The following are not used outside of their module:\n"); 	 	nsy = 0;Y1 	for (sy = sfirst; sy != NULL; sy = sy->s_next) {C2 		if (sy->s_defn != NULL && sy->s_refer == NULL) { 			printf("%c%s\t%s", # 				((nsy & 3) == 0) ? '\n' : '\t',d' 					sy->s_name, (sy->s_defn)->m_name); 	 			nsy++;  		}> 	} 	/*  	 * Pass 3 -- all the rest 	 */> 	printf("\n\nThe following are defined and used elsewhere\n");1 	for (sy = sfirst; sy != NULL; sy = sy->s_next) { 2 		if (sy->s_defn == NULL || sy->s_refer == NULL) { 			continue; 		}a 		i = (sy->s_defn)->m_index;8 		printf("\n%s\t%s:", sy->s_name, (sy->s_defn)->m_name);
 		nsy = 0;7 		for (rp = sy->s_refer; rp != NULL; rp = rp->r_next) {{ 			printf("%s%s",%) 				((++nsy % 6) == 0) ? "\n\t\t" : "\t",  				(rp->r_module)->m_name); 			j = (rp->r_module)->m_index;  			cross[i][j]++;  		}h 	} 	printf("\n"); 	/*\ 	 * Now for the mapf 	 */ 	printf("\nmodule"); 	for (i = 0; i <= cmax; i++) { 		printf("\n%s\t", mname[i]);> 		for (j = 0; j < i; j++) { , 			printf("%4d", cross[i][j] + cross[j][i]); 		}> 		printf("   %s", mname[i]); 	} }_ e /*  * Manage symbol table  */  MODULE * newmodule(text); /*   * Make this a new module entry.  */( {% 	register MODULE		*mp; 	register MODULE		**mplast;	 	register MODULE		*new; 	 	int			i;>    	new = myalloc(sizeof (MODULE)); 	new->m_name = strsave(text); G 	for (mplast = &mfirst; (mp = *mplast) != NULL; mplast = &mp->m_next) { ) 		if ((i = strcmp(text, mp->m_name)) < 0)>	 			break;= 		else if (i == 0) {4 			fprintf(stderr, "duplicate module name \"%s\"\n",
 				text); 			return(mp); 		}  	} 	new->m_next = mp; 	*mplast = new;U 	cmax++; 	if (cmax >= CROSS_MAX)  		error("too many modules");
 	return(new);  }U   addref(sy, mp) SYMBOL		*sy; MODULE		*mp; /*%  * The module references this symbol.a  */s {o 	register REFERENCE	*rp;  	REFERENCE		**rplast; 	register REFERENCE	*new;m 	register int		i;a  # 	new = myalloc(sizeof (REFERENCE));( 	new->r_module = mp; 	for (rplast = &sy->s_refer; 			(rp = *rplast) != NULL; 			rplast = &rp->r_next) {> 		if ((i = strcmp(mp->m_name, (rp->r_module)->m_name)) == 0) {6 			fprintf(stderr, "\"%s\" references \"%s\" twice\n", 				sy->s_name, mp->m_name); 		}( 		else if (i < 0) {s	 			break;B 		}s 	} 	new->r_next = rp; 	*rplast = new;e }s   SYMBOL * lookup(text) char		*text; /*/  * Return pointer to this symbol, insert if newC  */w {  	register SYMBOL		*sy;  	SYMBOL			**sylast; 	register SYMBOL		*new;u 	register int		i;a  G 	for (sylast = &sfirst; (sy = *sylast) != NULL; sylast = &sy->s_next) { , 		if ((i = strcmp(text, sy->s_name)) == 0) { 			return(sy); 		}f 		else if (i < 0) {"	 			break;  		}" 	}  	new = myalloc(sizeof (SYMBOL)); 	new->s_name = strsave(text);  	new->s_next = sy; 	*sylast = new;r 	return (new); }e   mnames() /*  * Build mname[] vectorx  */* {* 	register int		i;t 	register MODULE		*mp;   	i = 0; 6 	for (mp = mfirst; mp != NULL; mp = mp->m_next, i++) { 		mname[i] = mp->m_name; 		mp->m_index = i; 	} }= f /*  * Support routinesU  */y getfilename(filedes, buffer) FILE	*filedes;
 char	*buffer;= {) 	register char *tp;	 	register char c;0   	fgetname(filedes, buffer);w 	/*a 	 * Skip over device namew 	 */7 	for (tp = buffer; (c = *tp) != EOS && c != ':'; tp++);r
 	if (c)	tp++;; 	else	tp = buffer; 	/*B 	 * Skip over [UIC] or 	 * or [PPN] if presentt 	 */  	if (*tp == '[' || *tp == '(') { 		while ((c = *tp++) 				&& c != ']'_ 				&& c != ')');m 		if (c == 0) {; 			error("Can't happen");= 			tp--; 		}p 	} 	strcpy(buffer, tp); 	/*m 	 * Don't include versioni 	 */0 	for (tp = buffer; (c = *tp) && c != ';'; tp++);	 	*tp = 0;0 	/*f 	 * Don't include .ext 	 */0 	for (tp = buffer; (c = *tp) && c != '.'; tp++);	 	*tp = 0;  	/*!" 	 * Now, buffer has the file name, 	 * tp - buffer, its length. 	 */ 	return(buffer); }    char *
 strsave(text)  char		*text; /*  * Save this text{  */h {  	register char	*p;  , 	if ((p = malloc(strlen(text) + 1)) == NULL)% 		error("No room for string alloc.");  	strcpy(p, text);u 	return (p); }    char *
 myalloc(size)i
 int		size; /*  * Allocate or die  */  {' 	register char	*p;  % 	if ((p = calloc(1, size)) == NULL) {f5 		fprintf(stderr, "Can't allocate %d bytes\n", size);0 		error("Fatal");b 	} 	return (p); }m  