   /*  * mc.c   *)  * Convert a file to multi column format.   *	  * Usage:   *	mc [-option value]... files.   *  * Options:   *						Default   *	-c	number of columns		   2 &  *	-h	number of lines on the page	  60  *	-w	width of the page		 132   */    /*)BUILD	$(TKBOPTIONS) = { 			TASK	= ...MUL 		}  */   #ifdef	DOCUMENTATION   title	mc	Multi-column Filter index		Multi-column Filter   synopsis   	mc [-options] file__list    description   B 	Mc converts its input files to a multi-column format, writing allA 	output to the standard output.  If no input files are specified,m 	the standard input is read. 	.s*1 	The following options may be used to control mc:n 	.lm +164 	.s.i-16;-c value (  2)	Number of columns to output.0 	.s.i-16;-h value ( 60)	Height (lines per page).1 	.s.i-16;-w value (132)	Width (columns per line).I 	.lm -16   diagnosticsm   	.lm +8n/ 	.s.i -8;Unreasonable -c (value) or -w (value).i$ 	.s.i -8;Bad (option) specification.! 	.s.i -8;(Filename): cannot open.t 	.lm -8f   author  
 	David Conroy    bugs   #endif   #include <stdio.h>   #define	WMAX	132 #define HMAX	60u   int	wmax	= WMAX; int	hmax	= HMAX;
 int	ncol	= 2;t   int	row; int	col;	 int	lmax;6   char	line[128];b char	page[HMAX][WMAX];   main(argc, argv)
 char *argv[];i {  	register char *p; 	register c, i;i 	int nf;
 	FILE *fp;  
 	nf = argc-1;i 	for(i=1; i<argc; ++i) { 		p = argv[i]; 		if(*p == '-') {w 			argv[i] = 0;  			--nf; 			for(++p; c = *p++; ). 				switch(c) {c  
 				case 'c':m
 				case 'C':  					if(++i >= argc) 						usage(); 					ncol = atoi(argv[i]); 					if(ncol == 0) 						bad(ncol, "column"); 					argv[i] = 0; 
 					--nf; 					break;;  
 				case 'h':m
 				case 'H':n 					if(++i >= argc) 						usage(); 					hmax = atoi(argv[i]); 					if(hmax > HMAX) 						bad(hmax, "height"); 					argv[i] = 0; 
 					--nf; 					break;   
 				case 'w':	
 				case 'W':	 					if(++i >= argc) 						usage(); 					wmax = atoi(argv[i]); 					if(wmax > WMAX) 						bad(wmax, "width");e 					argv[i] = 0; 
 					--nf; 					break;    				default:
 					usage();	 				}l 		}) 	} 	lmax = wmax/ncol - 1;
 	if(lmax < 1)=: 		error("Unreasonable -c (%d) or -w (%d).\n", ncol, wmax); 	if(nf == 0) 		process(stdin);	 	else; 		for(i=1; i<argc; ++i)] 			if(p = argv[i]) {$ 				if((fp=fopen(p, "r")) == NULL) {* 					fprintf(stderr, "%s: cannot open.\n",
 							p); 					continue; 				}i 				process(fp); 				fclose(fp);	 			} }t   process(fp)		 FILE *fp;> {A 	register char *p1, *p2; 	register c;  	 	row = 0;		 	col = 0;		 	blank();  	while(get(fp)) {	 		if(++row >= hmax) {) 			if(++col >= ncol) {
 				output();< 				col = 0; 				blank(); 			} 			row = 0;\ 		}c 		p1 = line;# 		p2 = &page[row][(wmax*col)/ncol];; 		while(c = *p1++)
 			*p2++ = c;  	}
 	output(); }f   output() {r 	register char *p1, *p2; 	register i;   	if(row==0 && col==0)		 		return;c 	putchar('\f');  	for(i=0; i<hmax; ++i) { 		p1 = &page[i][0];  		p2 = p1 + wmax;* 		while(p2>p1 && p2[-1]==' ')p 			--p2; 		while(p1 < p2) 			putchar(*p1++); 		putchar('\n'); 	} }	   blank()w {  	register char *p1, *p2; 	register i;   	for(i=0; i<hmax; ++i) { 		p1 = &page[i][0];w 		p2 = p1 + wmax;= 		while(p1 < p2) 			*p1++ = ' ';) 	} };   get(fp) 	 FILE *fp;	 {2 	register char *p; 	register c, h;t  
 	p = line; 	h = 0;*& 	while((c=getc(fp))!=EOF && c!='\n') { 		if(c == '\b') {c
 			if(h) { 				--p; 				--h; 			} 		} else if(c == '\t') { 			do {= 				*p++ = ' ';h 			} while((++h&07) != 0); 		} else if(c>=' ' && c<='~') {t 			*p++ = c; 			++h;( 		}; 	} 	*p = 0; 	line[lmax] = 0; 	return(c == '\n');r }s  	 bad(n, s)r char *s; { , 	error("%d: bad %s specification.\n", n, s); }    usage()< {)5 	error("Usage: mc [-c #] [-h #] [-w #] [file ...].\n\ % 	-c Number of columns          <2>\n\ % 	-h Height (lines per page)   <60>\n\)' 	-w Width (columns per line) <132>\n");  }i