 #define	TESTING  /*#  * Overstrike and blank/tab manager   *H  * This subroutine removes overstrikes from lines containing <BACKSPACE>H  * or <RETURN>.  It attempts to "do the right thing" for underlining andE  * overstriking. It also normalizes <FORMFEED> sequences, terminating G  * the previous line and returning the <FORMFEED> by itself in a record !  * containing only <FF><LF><EOS>.   *K  * Note that overstriking may be implemented either by <BACKSPACE><CHAR> or G  * <RETURN><spaces><CHAR>.  As long as there are no <TAB> characters in .  * the line, either method will work properly.  *	  *	char *k  *	overst(line, outbuf)<%  *	char		*line;		-- Text line to fix.s#  *	char		*outbuf;	-- Output buffer.i  *B  * On return, the line is copied to outbuf.  overst() returns NULLB  * when the line has been exhausted.  (This is needed for FORMFEED  * processing.)c  *@  * The output buffer is always terminated by <LF><EOS>. Any <CR>  * has been removed.  *C  * If FORMFEED is not the first character on the line, the previous -  * line will have been terminated by NEWLINE.d  *=  * The input buffer is assumed to be terminated by <NL><EOS>.c/  * All overstrike information is lost on <EOS>.b  *A  * This module does not properly handle tabs and overstrikes that   * span tab sequences.  *,  * overst() is used in the following manner:  *  *	char		*linep;  *  *	linep = NULL;		-- initializer  *	for (;;) {		-- read loop<D  *	    if ((linep = fgets(inbuffer, sizeof inbuffer, infd)) == NULL)#  *		break;		-- exit if no more datau  *	    do {		-- overst loopr%  *		linep = overst(linep, outbuffer);b-  *		if (linep != NULL || outbuffer[0] != EOS)c  *		    output(outbuffer);  *	    } while (linep != NULL);i  *	}  *  */o  * #define	NULL		(0)		/* The null pointer		*/& #define EOS		(0)		/* End of string		*/$ #define	RETURN		('\r')		/*	<CR>			*/% #define	NEWLINE		('\n')		/*	<LF>			*/	! #define	TAB		('\t')		/*	<HT>			*/e& #define	BACKSPACE	('\b')		/*	<BS>			*/% #define	FORMFEED	('\f')		/*	<FF>			*/ # #define	BLANK		(' ')		/*	space			*/    char * overst(inbuffer, outbuffer) ( char		*inbuffer;	/* Line to process			*/' char		*outbuffer;	/* Output buffer			*/  /*B  * Overstrike formatting routine.  Returns NULL when line empty or4  * pointer to first byte in the partial output line.  *;  * outbuffer must hold at least strlen(inbuffer) + 1 bytes.	  */d {n+ 	register char	c;		/* Current character		*/	- 	register char	*ccpos;		/* Buffer pointer		*/)+ 	register char	*rmargin;	/* Buffer end			*/F   	ccpos = rmargin = outbuffer;* 	for (;;) { < 	    switch (c = *inbuffer++) {	/* Look at next character	*/  + 	    case EOS:			/* End of input string		*/  		/*: 		 * The input line didn't end with <LF> (which happens if= 		 * the fgets() argument was shorter than the input record).p2 		 * Terminate output buffer and return to caller., 		 * Note that pending overstrikes are lost. 		 *// 		*rmargin = EOS;	 		return (NULL);   	    case BACKSPACE: 		/* 		 * Move printhead back 		 */  		if (ccpos > outbuffer) 		    ccpos--; 		break;   	    case TAB: 		/*1 		 * Tabs aren't handled correctly -- just put it 0 		 * in the buffer.  This doesn't work if you do2 		 * sequences of <backspace> or <return> followed
 		 * by tabs.* 		 */e 		*ccpos++ = TAB;h 		if (ccpos > rmargin) 		    rmargin = ccpos; 		break;   	    case FORMFEED:. 		if (rmargin > outbuffer) { 		    /*= 		     * Terminate previous line and setup so we are recalleds9 		     * with the FORMFEED at the start of the next line.(	 		     */b 		    *rmargin++ = NEWLINE;a 		    *rmargin = EOS;	1 		    return (inbuffer - 1);	/* Reget FORMFEED	*/i
 	        } 		/*= 		 * Formfeed at start of line.  Output becomes <FF><NL><EOS>e# 		 * Continue with <LF> processing.* 		 */e 		*rmargin++ = FORMFEED;   	    case NEWLINE: 		/*2 		 * Terminate the line, output, and reinitialize. 		 */r 		*rmargin++ = NEWLINE;  		*rmargin = EOS;a1 		if (*inbuffer == EOS)		/* If at end of input	*/ . 		    return (NULL);		/*  take normal exit.	*/$ 		else				/* Otherwise, there are	*/1 		    return (inbuffer);		/*  multiple <LF>'s.	*/n   	    case RETURN:  		/*/ 		 * Return the carriage for <CR> overstriking.o 		 */  		ccpos = outbuffer; 		break;  
 	    default:h 		/*= 		 * Plant the character unless underline or space overwritesL6 		 * a "real" datum.  Then move the printhead forward,' 		 * updating the right edge as needed.  		 */g+ 		if (iscntrl(c))			/* If a control char	*/ ' 		    break;			/*  just exit switch.	*/*4 		else if (ccpos >= rmargin	/* If at right margin	*// 		      || visibility(*ccpos) <= visibility(c))F) 			*ccpos = c;		/* Stuff the new char.	*/R% 		ccpos++;			/* Move the printhead	*/g0 		if (ccpos > rmargin)		/*  and maybe update 	*/0 		    rmargin = ccpos;		/*  the right margin.	*/ 		break;				/* Exit switch.		*/	 	    } 	} }u   #include <ctype.h>  
 static int
 visibility(c)  register int	c;  /*0  * Return our interest in seeing this character:3  *	control/blank/tab	== 0	-- tab might be a problem	  *	punctuation		== 1  *	others			== 2  */i {/ 	if (iscntrl(c) || isspace(c))
 		return (0);) 	else if (ispunct(c))S
 		return (1);a 	else	return (2);	 }    t #ifdef	TESTING /*  * Test program for overst()  */    #include <stdio.h>   char	inline[133];  char	outline[133];   main() { 	register char	*linep;    	linep = NULL;u 	for (;;) { ? 	    if ((linep = fgets(inline, sizeof inline, stdin)) == NULL)  		break;	 	    do {i! 		linep = overst(linep, outline);=) 		if (linep != NULL || outline[0] != EOS)i 		    fputs(outline, stdout);i 	    } while (linep != NULL);e 	} }	 #endif