 /*  	 FACILITY:        'C' utility programs.   	 ABSTRACT:   H     Detects overstriking, as in RUNOFF output, and uses the  VT100  boldF     and underscore character attributes to indicate these overstrikes.   ENVIRONMENT:  C     PDP-11 user mode, under RT-11 and VAX/VMS RSX-11 compatability.   3 AUTHOR:	Brian Hetrick, DATE WRITTEN: 17 August 1981    MODIFIED BY:   */   /* INCLUDE FILES: */   #include <stdio.h>   /* MACROS:  */   /* EQUATED SYMBOLS: */   #define MAX_OUT_REC 512    #define CHR_IGN 0I #define CHR_BS 1 #define CHR_HT 2 #define CHR_VER 3  #define CHR_CR 4 #define CHR_SP 5 #define CHR_PRN 6h #define CHR_UND 7  #define MASK_CHAR 0177 #define MASK_BOLD 0200 #define MASK_UNDR 0400 #define MASK_BLOB 01000u   #define SI 017 #define SO 016 #define ESC 033i   /* OWN STORAGE: */   static FILET     * in_file,     * out_file;B   static char*     chr_type [128] = {Z 	CHR_IGN, CHR_IGN, CHR_IGN, CHR_IGN, CHR_IGN, CHR_IGN, CHR_IGN, CHR_IGN,		/* NUL to BEL */Z 	CHR_BS,  CHR_HT,  CHR_VER, CHR_VER, CHR_VER, CHR_CR,  CHR_IGN, CHR_IGN,		/* BS  to SI  */Z 	CHR_IGN, CHR_IGN, CHR_IGN, CHR_IGN, CHR_IGN, CHR_IGN, CHR_IGN, CHR_IGN,		/* DLE to ETB */Z 	CHR_IGN, CHR_IGN, CHR_IGN, CHR_IGN, CHR_IGN, CHR_IGN, CHR_IGN, CHR_IGN,		/* CAN to US  */Z 	CHR_SP,  CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN,		/* SP  to  '  */Z 	CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN,		/*  (  to  /  */Z 	CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN,		/*  0  to  7  */Z 	CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN,		/*  8  to  ?  */Z 	CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN,		/*  @  to  G  */Z 	CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN,		/*  H  to  O  */Z 	CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN,		/*  P  to  W  */Z 	CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_UND,		/*  X  to  _  */Z 	CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN,		/*  `  to  g  */Z 	CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN,		/*  h  to  o  */Z 	CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN,		/*  p  to  w  */[ 	CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_PRN, CHR_IGN },	/*  x  to DEL */R
 #ifdef rsx     cr_needed, #endif     memo_heading,R     old_attr_mask = 0,     span_whitespace,!     term_commands [] = {1,4,5,7};_   /*! WEAK AND VALIDATION DECLARATIONS:, */ N main (argc, argv)  intR	     argc;t char     * argv [];   /*   FUNCTIONAL DESCRIPTION:   H     Reads a file, detects overstrikes, and produces a file which  repre-H     sents the input file but with VT100 bolding and underlining in place     of overstrikes.R  H     On RSX, the input file must be variable sequential with maximum rec-C     ord size 512 and either carriage-return or no record attribute.p  <     On RT, the input file must be a standard RT stream file.  H     On both RSX and RT, control characters other than BS,  HT,  LF,  VT,H     FF,  and  CR  (i.e.,  backspace, horizontal tab, line feed, vertical5     tab, form feed, and carriage return) are ignored.-  H     On RSX, the output file is variable sequential with  maximum  recordH     size 512 and carriage-return record attribute;  except if the outputH     file is a terminal, the output file is variable sequential with max-0     imum record size 80 and no record attribute.  8     On RT, the output file is a standard RT stream file.   FORMAL PARAMETERS:  H     Argument_count.rw.v - The number of arguments in the Argument_vector" 	vector.  This must be at least 1.H     Argument_vector.rt.aa - A list of addresses of ASCIZ  strings,  eachA 	of  which  is  an  argument.  The first must be the name of thisrA 	program.  The second must be the name of the input  file  (which A 	may  contain  overstrikes).   The  third must be the name of themA 	output file (which is to contain VT100 escape  sequences).   TheiA 	optional fourth parameter must start with a hyphen, and may con-e: 	tinue with any combination of the following in any order:  A 	m   which indicates that a Digital logo and the words  "interof- A 	    fice  memo"  are  to  be  prefixed to the text of the outputu< 	    file.  The default is not to prefix the logo and words.  A 	s   which indicates that spaces separating two  characters  withsA 	    identical  bold/underline  are  not  to be bolded and under- A 	    lined.  The default is to bold and underline spaces separat-rA 	    ing non-space characters with identical  bold/underline  at-b 	    tributes.  A 	ex  which indicates that the first 'x' lines of the  input  filedA 	    are  not to appear in the output file.  'x' must be a singlet- 	    decimal digit.  The default is 'x' of 0.    IMPLICIT INPUTS:  	     None.d   IMPLICIT OUTPUTS:c  	     None.c   COMPLETION CODES:a  	     None.s  
 SIDE EFFECTS:   	     None.e   */   {      char 	* this_arg;       intd
 	cur_char, 	eat_lines,  	horiz_pos,  	i,s 	line_map [MAX_OUT_REC], 	this_char;r       intt 	* cur_map,d 	* high_water_mark;i  
 #ifdef rsx     extern int 	fd_cr;  #endif       if (argc < 3) @ 	fprintf (stderr, "Usage: %s infile outfile -mse9\n", argv [0]);     else     {c #ifdef rt11T0 	if (NULL == (in_file = fopen (argv [1], "rn"))) #elsed/ 	if (NULL == (in_file = fopen (argv [1], "r")))N #endif> 	    fprintf (stderr, "Cannot open %s, aborting\n", argv [1]); 	else* 	{
 #ifdef rsxI 	    /*  If the input file has recordattr none, then tell C about it.  */CA 	    if (0 == ((in_file -> io_fdb [0]) & (((int) & fd_cr) << 8)))  		in_file -> io_flag |= IO_NOS;r #endif4 	    if (NULL == (out_file = fopen (argv [2], "w"))) 	    {; 		fprintf (stderr, "Cannot open %s, aborting\n", argv [2]);  		fclose (in_file);  	    }	 	    else" 	    {
 #ifdef rsx 		cr_needed = 0; 		if (ftty (out_file)) 		{e4 		    out_file = freopen (argv [2], "wn", out_file); 		    cr_needed = 1; 		}  #endif@ 		memo_heading = 0;			/*  Argument default - no memo heading  */@ 		span_whitespace = 1;			/*  Argument default - span spaces.  */J 		eat_lines = 0;				/*  Argument default - eat no lines of first page.  */ 		for (i = 3; i < argc; i++) 		{  		    this_arg = argv [i]; 		    if ('-' != *this_arg++)gA 			fprintf (stderr, "Argument %s illegal, ignored.\n", argv [i]);r
 		    else 		    { , 			while ('\0' != (this_char = *this_arg++)) 			{ 			    if (this_char == 'M') 				memo_heading = 1; ! 			    else if (this_char == 'S')	 				span_whitespace = 0;! 			    else if (this_char == 'E')  			    { 				if ('0' == *this_arg)aA 				    fprintf (stderr, "No argument for e, switch ignored.\n");f 				else& 				    eat_lines = *this_arg++ - '0'; 			    } 			    elsegN 				fprintf (stderr, "Character %c unknown as switch, ignored.\n", this_char); 			}						/*  End of while  */! 		    }							/*  End of else  */  		}							/*  End of for  */  / 		/*  Make ready to process the input file.  */=   		line_initialize (line_map);= 		cur_map = line_map;p 		high_water_mark = cur_map; 		if (memo_heading)  		    put_memo_heading (); 		while (eat_lines > 0)r 		{o! 		    this_char = getc (in_file);) 		    if (this_char == EOF)e 			eat_lines = 0;0! 		    else if (this_char == '\n')i 			eat_lines --; 		}   - 		while (EOF != (this_char = getc (in_file)))	 		{	? 		    switch (this_char > 127 ? CHR_IGN : chr_type [this_char])	 		    {n 			case CHR_IGN :*
 			    break;    			case CHR_BS : 			{ 			    cur_map --;
 			    break;= 			}   			case CHR_HT : 			{? 			    cur_map = line_map + 8 * ((cur_map - line_map) / 8 + 1);i
 			    break;  			}   			case CHR_VER :  			{, 			    put_line (line_map, high_water_mark);
 #ifdef rsx 			    if (cr_needed)  				putc ('\r', out_file); #endif" 			    putc (this_char, out_file);" 			    line_initialize (line_map); 			    cur_map = line_map;! 			    high_water_mark = cur_map;]
 			    break;	 			}   			case CHR_CR : 			{ 			    cur_map = line_map;
 			    break;- 			}   			case CHR_SP : 			{ 			    cur_map ++;
 			    break;= 			}   			case CHR_PRN :  			{- 			    if (cur_char = (*cur_map & MASK_CHAR))  			    { 				if (cur_char == this_char) 				    *cur_map |= MASK_BOLD; 				else 				    *cur_map |= MASK_BLOB; 			    } 			    else 4 				*cur_map = (*cur_map & ~ MASK_CHAR) | this_char; 			    cur_map ++;% 			    if (cur_map > high_water_mark)_ 				high_water_mark = cur_map;
 			    break;s 			}   			case CHR_UND :r 			{ 			    *cur_map |= MASK_UNDR;} 			    cur_map ++;% 			    if (cur_map > high_water_mark)k 				high_water_mark = cur_map;
 			    break;  			}! 		    }					/*  End of switch  */  		}					/*  End of while  */ 	    }						/*  End of else  */B 	}						/*  End of else  */m     }							/*  End of else  */ # }							/*  End of main program  */M _ line_initialize (line_map) intp     line_map [MAX_OUT_REC];g   /*   FUNCTIONAL DESCRIPTION:r  *     Initializes a line to all null/spaces.   FORMAL PARAMETERS:  2     Line_map.mw.ra - The map of the line contents.   IMPLICIT INPUTS:  	     None.    IMPLICIT OUTPUTS:   	     None.    FUNCTION VALUE:	  	     None.   
 SIDE EFFECTS:   	     None.    */   {e     int  	i;	  %     for (i = 0; i < MAX_OUT_REC; i++)f 	line_map [i] = 0;   }* n put_memo_heading ()	   /*   FUNCTIONAL DESCRIPTION:_  H     Writes the logo and the words "interoffice memo" to the output file.   FORMAL PARAMETERS:  	     None.a   IMPLICIT INPUTS:  *     out_file - the FDB of the output file.H     cr_needed - the  flag  indicating  whether  the  output  file  needs& 	explicit carriage returns (RSX only).   IMPLICIT OUTPUTS:   	     None.    FUNCTION VALUE:   	     None./  
 SIDE EFFECTS:   	     None.o   */   { 
     char * 	logo;       putc (ESC, out_file);n     fputs ("(B", out_file);      putc (ESC, out_file);      fputs (")0", out_file);      putc (SO, out_file);     set_attr (MASK_BOLD);L     putc (ESC, out_file);      fputs ("#6", out_file);_(     fputs ("lqwqwqwqwqwqwqk", out_file);
 #ifdef rsx     if (cr_needed) 	putc ('\r', out_file);l #endif     putc ('\n', out_file);     logo = "digital";T     putc (ESC, out_file);      fputs ("#6", out_file);/     while (*logo != '\0')o     {  	putc ('x', out_file); 	putc (SI, out_file);o 	putc (*logo++, out_file); 	putc (SO, out_file);(     }t     putc ('x', out_file);o     putc (SI, out_file);     set_attr (0);_     fputs ("    ", out_file);S     set_attr (MASK_BOLD);")     fputs ("INTEROFFICE MEMO", out_file);q
 #ifdef rsx     if (cr_needed) 	putc ('\r', out_file);r #endif     putc ('\n', out_file);     putc (ESC, out_file);"     fputs ("#6", out_file);t     putc (SO, out_file);(     fputs ("mqvqvqvqvqvqvqj", out_file);     putc (SI, out_file);     set_attr (0);t
 #ifdef rsx     if (cr_needed) 	putc ('\r', out_file);) #endif     putc ('\n', out_file); }    put_line (line_map, high_point)r int_     * line_map,      * high_point;    /*   FUNCTIONAL DESCRIPTION:   ,     Writes a single line to the output file.   FORMAL PARAMETERS:  7     Line_map.rw.ra - The map of the line to be written. H     High_point.ra.v - The address of the last element in Line_map  which 	is to be written.   IMPLICIT INPUTS:  *     out_file - The FDB of the output file.H     span_whitespace - The flag indicating whether spaces separating  twoA 	characters with identical bold/underline attributes are to bold-t 	ed and underlined.m   IMPLICIT OUTPUTS:t  	     None.U   FUNCTION VALUE:N  	     None.t  
 SIDE EFFECTS:t  	     None.f   */   {M     intT 	attr_to_carry,m 	* last_ptr, 	this_char,i 	* this_ptr;       if (span_whitespace)     {rW 	/*  Start off with no attributes.  Look for the first character with an attribute.  */  	this_ptr = line_map;h% 	/*  Process the whole line, now.  */h 	while (this_ptr < high_point) 	{G 	    while ((this_ptr < high_point) && (0 == (*this_ptr & ~MASK_CHAR)))  		this_ptr ++;Z 	    /*  Found something with attributes.  Now, look for something without attributes.  */ 	    if (this_ptr < high_point)M 	    {D 		while ((this_ptr < high_point) && (0 != (*this_ptr & ~MASK_CHAR))) 		    this_ptr ++;e 		/*  Set the attribute mask to whatever the last attribute was, and look for the next non-blank.  */i 		if (this_ptr < high_point) 		{e 		    last_ptr = this_ptr;4 		    attr_to_carry = *(this_ptr - 1) & ~ MASK_CHAR;9 		    while ((this_ptr < high_point) && (0 == *this_ptr))p 			this_ptr ++;Fh 		    /*  If some subset of the attributes match, extend that subset through the intervening blanks.  */  		    if (this_ptr < high_point) 		    {_ 			attr_to_carry &= *this_ptr; 			if (attr_to_carry != 0) 			{" 			    while (last_ptr < this_ptr)" 				*last_ptr ++ |= attr_to_carry; 			} 		    }n 		}k 	    } 	}     }p  !     while (line_map < high_point)r     {_ 	this_char = *line_map; $ 	set_attr (this_char & ~ MASK_CHAR);# 	this_char = this_char & MASK_CHAR;03 	putc (0 != this_char ? this_char : ' ', out_file); 
 	line_map ++;t     }s     set_attr (0);  }s t set_attr (new_attr_mask) int      new_attr_mask;   /*   FUNCTIONAL DESCRIPTION:t  B     Outputs an escape sequence to change the character attributes.   FORMAL PARAMETERS:  H     New_attr_mask.rw.v - The mask indicating the attributes to  be  set.A 	The bits MASK_BOLD and MASK_UNDR control bolding and underliningi 	respectively.   IMPLICIT INPUTS:  *     out_file - The FDB of the output file.   IMPLICIT OUTPUTS:c  	     None.a   FUNCTION VALUE:   	     None.+  
 SIDE EFFECTS:e  	     None.    */   {_     int_ 	attr_mask,n 	clear_necessary,s 	command_count,I 	i;D       attr_mask = new_attr_mask;     clear_necessary = 1;     command_count = 0;  #     if (attr_mask != old_attr_mask)s     {-2 	if (old_attr_mask == (old_attr_mask & attr_mask)) 	{" 	    attr_mask &= ~ old_attr_mask; 	    clear_necessary = 0;r 	}   	putc (ESC, out_file); 	putc ('[', out_file);   	if (clear_necessary)  	{ 	    putc ('0', out_file); 	    command_count = 1;  	}   	if (attr_mask & MASK_BOLD)  	{ 	    if (command_count > 0)t 		putc (';', out_file);y 	    putc ('1', out_file); 	    command_count = 1;r 	}   	if (attr_mask & MASK_UNDR)  	{ 	    if (command_count > 0)t 		putc (';', out_file);s 	    putc ('4', out_file); 	}   	putc ('m', out_file); 	old_attr_mask = new_attr_mask;t     }; } 