 /* #define	DEBUG */  /*  *				p h b o o k . c   */    /*)BUILD */   #ifdef	DOCUMENTATION   title	phbook	Phone Book Search index		Phone book search   synopsis 	.s.nf 	phbook [-f file] arg[s] 	.s.f  description   7 	Phbook searches a user-defined phone book file for any 6 	entry that matches any argument in the argument list.; 	The phone book, normally stored in file phbook.txt, may be 3 	created by any standard editor.  It contains lines  	of text, such as:  ' 	  Digital Equipment	DEC	(617) 897-5111e  9 	Note that phbook does not impose any format on the text, : 	only that the text consist of words, separated by blanks.7 	If a line starts with whitespace (blank or tab), it is-6 	considered to be a continuation of the previous line:  ' 	  Digital Equipment	DEC	(617) 897-5111e' 	    146 Main Street, Maynard, MA 01754u  , 	The example line would be printed by, e.g.,   	    phbook digy   	orc   	    phbook 617a  ) 	(Searches skip over continuation lines).h7 	In a search argument, two "wild-cards" are recognized:  	.lm +4o6 	.s.i-2;* matches any string of characters, even null.. 	.s.i-2;? matches a single non-null character.	 	.s.lm -4s7 	Note that "phbook *" will print the entire phone book. : 	Each match argument will be implicitly terminated by '*'.5 	Thus, a search argument of "ma" will match "Martin".r2 	Upper- and lower-case are ignored in comparisons.  7 	If no wild-card characters are present in an argument, 5 	a "Soundex" match will be used. This permits matchesh4 	even if you have (slightly) misspelled the name for 	which you are searching.i  2 	If phbook is invoked without an argument, it will2 	prompt for arguments, outputting all matches.  If; 	the standard input is redirected and no argument is given,t  	phbook may be used as a filter.  : 	If a "-f filename" argument is given on the command line,< 	phbook searches the indicated file.  Otherwise, it tries to: 	locate a phone book file using the following search list:   	(On DEC operating systems):" 	  getenv("PHBOOK") (Vax/VMS only)
 	  phbook:
 	  phbook.txtf 	  phbook:phbook.txt 	  root:phbook.txt- 	  getenv("HOME")+"phbook.txt" (Vax/VMS only)o
 	(On Unix) 	  getenv("PHBOOK") 
 	  phbook.txtt 	  getenv("HOME")+"phbook.txt"  6 	Note that, on Vax/VMS, your login.com file can assign6 	any file to logical PHBOOK:, allowing you to override 	the file name specification.i   Acknowledgements  < 	The Soundex algorithm was invented by Margaret K. Odell and< 	Robert C. Russell.  U.S. patents 1261167 (1918) and 1435663? 	(1922).  The version used here was modified from one describedk( 	in Donald Knuth, Sorting and Searching.   Author  
 	Martin Minowy   #endif   #include	<stdio.h> #include	<ctype.h>
 #ifdef	vms #include	<ssdef.h> #include	<stsdef.h>x0 #define	IO_NORMAL	(SS$_NORMAL | STS$M_INHIB_MSG) #define	IO_ERROR	SS$_ABORT #endif /*G  * Note: IO_NORMAL and IO_ERROR are defined in the Decus C stdio.h fileg  */m #ifndef	IO_NORMALr #define	IO_NORMAL	0R #endif #ifndef	IO_ERROR #define	IO_ERROR	1 #endif   #ifdef	tolower /*<  * Note: tolower is wrong on some Unix systems.  This one isA  * correct, but requires that the argument not have side-effects.   */c #undef	tolower7 #define tolower(c)	(isupper(c) ? (c + ('a' - 'A')) : c)u #endif #ifdef	isprint #ifndef	isgraphR+ #define	isgraph(c)	(isprint(c) && c != ' ')A #endif #endif   #ifdef	decus, int	$$narg	=	1;			/* Don't require arg's.	*/ #endif   #define	TRUE		1	 #define	FALSE		0 #define	EOS		0   #define	NFIELDS		100 #define	LINESIZE	257  + char		*search[NFIELDS];		/* search text		*/i0 char		*word[NFIELDS];			/* file text split up	*/0 int		issoundex[NFIELDS];		/* TRUE for soundex	*/6 unsigned int	hash[NFIELDS];			/* soundex hash value	*// char		line[LINESIZE];			/* text line as read	*/f0 char		work[LINESIZE];			/* text line in words	*/- char		argtext[LINESIZE];		/* prompted text	*/f# FILE		*fd;				/* Phone book file	*/q int		debug = 0;e   #ifndef	unix /*5  * This search list is used to locate the phone book.D  */0   static char	*searchlist[] = {s) 	"phbook.txt",				/* Current directory	*/	
 #ifdef	vms% 	"phbook:",				/* Assigned logical	*/s0 	"phbook:phbook.txt",			/* Logical, this file	*/+ 	"root:phbook.txt",			/* User login dir.	*// #endif
 #ifdef	rsx 	"[userfiles]phbook.txt",* 	"lb:[1,2]phbook.txt", 	"lb:[1,1]phbook.txt", #endif #ifdef	rt11I 	"sy:phbook.txt",e #endif 	NULLE }; #endif   /*  * Usage message  */b static char	*helpmessage[] = {- 	"Search phone book for an argument string.",o7 	"  '*' in a string matches any string of characters.",t5 	"  '?' in a string matches any non-null character.",	8 	"Any left-most match will succeed and multiple search",; 	"arguments are permitted.  Soundex (match if names sound",*6 	"similar) will be used if you don't use '*' or '?'.", 	NULL, }; t main(argc, argv)
 int		argc; char		*argv[]; {  	openphonebook(argc, argv);N 	if (argc > 1) { 	    findargs(argc, argv); 	    setsoundexflag(); 	    findmatch();p 	} 	else {  	    /*n1 	     * No arguments were given.  Prompt and readg& 	     * arguments from standard input. 	     */! 	    if (isatty(fileno(stdin))) {t 		fprintf(stderr,c8 		    "Phone book search program, <return> for help\n"); 	    } 	    while (!feof(stdin)) {i 		if (isatty(fileno(stdin))) {& 		    fprintf(stderr, "search for: "); 		    fflush(stderr);  		}	 		if (gets(argtext) == NULL) 		    break; 		if (argtext[0] == EOS) { 		    usage(); 		}  		else {  		    packtext(argtext, search); 		    setsoundexflag();  		    findmatch(); 		    rewind(fd);r 		}  	    } 	} 	exit(IO_NORMAL);  }u   openphonebook(argc, argv)i1 int		argc;		/* Arg count from operating system	*/b= register char	*argv[];	/* Arg vector from operating system	*/( /*9  * Open the phone book file -- exit to system if failure.(  */r {s 	register char	**namep;u 	register char	*cp;	 #ifdef	unixe 	extern char	*getenv();; 	char		working_filename[81]; #endif
 #ifdef	vms 	extern char	*getenv();t 	char		working_filename[81]; #endif   	while (--argc > 0) {; 	    cp = *++argv; 	    if (*cp++ == '-') { #ifdef	DEBUG3 		if ((*cp == 'd' || *cp == 'D') && cp[1] == EOS) {g 		    debug++; 		    *argv = NULL;i
 	        } 		else #endif3 		if ((*cp == 'f' || *cp == 'F') && cp[1] == EOS) {  		    *argv++ = NULL;s 		    cp = *argv;* 		    if (--argc <= 0) {; 			fprintf(stderr, "-f must be followed by a file name\n");e 			exit(IO_ERROR); 		    }m/ 		    else if ((fd = fopen(cp, "r")) == NULL) {) 			perror(cp); 			fprintf(stderr,7 			    "Phbook could not open your phone book file\n");i 			exit(IO_ERROR); 		    }B 		    else { 			*argv = NULL;
 			return; 		    }  		}	 	    } 	} #ifdef	unix  	/*L? 	 * Look for getenv("PHBOOK"), then getenv("HOME")+"phbook.txt"& 	 */% 	if ((cp = getenv("PHBOOK")) != NULL)	 	    return (openit(cp, TRUE));c& 	else if (openit("phbook.txt", FALSE)) 	    return;* 	else if ((cp = getenv("HOME")) != NULL) {" 	    strcpy(working_filename, cp);- 	    strcat(working_filename, "/phbook.txt");d) 	    if (openit(working_filename, FALSE))o	 		return;e 	} #elsee 	/*O: 	 * On VMS, RSTS, RSX, or whathaveyou, try the search list 	 */
 #ifdef	vms% 	if ((cp = getenv("PHBOOK")) != NULL)o 	    return (openit(cp, TRUE));e #endif4 	for (namep = searchlist; *namep != NULL; namep++) { 	    if (openit(*namep, FALSE)) 	 		return;e 	}
 #ifdef	vms% 	if ((cp = getenv("HOME")) != NULL) {s" 	    strcpy(working_filename, cp);, 	    strcat(working_filename, "phbook.txt");) 	    if (openit(working_filename, FALSE)) 	 		return;i 	} #endif #endif? 	fprintf(stderr, "Could not locate phone book (phbook.txt)\n");  	exit(IO_ERROR); }s  
 static int openit(filename, fatal)=/ char	*filename;		/* Actual filename to open		*/(, int	fatal;			/* TRUE if failure is fatal		*/ /*D  * Open the indicated file.  Return TRUE if success.  If failure andB  * fatal is TRUE, exit to the operating system with an appropriate%  * error message, else, return FALSE.o  */_ {e) 	if ((fd = fopen(filename, "r")) != NULL)n 	    return (TRUE);  	else if (!fatal)d 	    return (FALSE); 	else {o 	    perror(filename);: 	    fprintf(stderr, "Couldn't open phone book, fatal\n"); 	    exit(IO_ERROR); 	} }* e findargs(argc, argv)1 int		argc;		/* Arg count from operating system	*/s5 char		*argv[];	/* Arg vector from operating system	*/E /*)  * Build the search arguments in field[].   */t {h 	register char		*cp; 	register int		fieldindex; 	register char		c;   	fieldindex = 0; 	while (--argc > 0) {m 	    cp = *++argv; 	    if (cp == NULL) 		continue;t 	    search[fieldindex] = cp;s 	    while ((c = *cp) != EOS) {  		*cp++ = tolower(c);n 	    } 	    fieldindex++; 	}5 	search[fieldindex] = NULL;		/* terminate the list	*/  	setsoundexflag(); }t o setsoundexflag() /*B  * Examine the search arguments (in search[]), setting issoundex[]E  * appropriately.  If this argument should be "soundex'ed", calculater  * the hash value.  */  {g 	register char		*cp; 	register int		fieldindex; 	register char		c; 	extern unsigned int	soundex();	  H 	for (fieldindex = 0; (cp = search[fieldindex]) != NULL; fieldindex++) {" 	    issoundex[fieldindex] = TRUE;! 	    while ((c = *cp++) != EOS) {i 		if (c == '*' || c == '?') { $ 		    issoundex[fieldindex] = FALSE; 		    break; 		}* 	    } 	    if (issoundex[fieldindex])r1 		hash[fieldindex] = soundex(search[fieldindex]);h 	} }m   findmatch()u /*'  * Read the file, print matching lines.   */  {g. 	register int		fieldindex;	/* Field pointer	*/* 	register char		**wp;		/* Word pointer		*// 	register int		matchcount;	/* Counts matches	*/d 	extern unsigned int	soundex();    	matchcount = 0; 	line[0] = EOS;  	for (;;) {=B 	    if (line[0] == EOS && fgets(line, sizeof (line), fd) == NULL) 		break; 	    if (isspace(line[0])) {- 		line[0] = EOS;			/* Force read next time	*/a 		continue;] 	    } 	    strcpy(work, line); 	    packtext(work, word);E 	    for (fieldindex = 0; search[fieldindex] != NULL; fieldindex++) {e& 		for (wp = word; *wp != NULL; wp++) {( 		    if (issoundex[fieldindex] != FALSE+ 		     && soundex(*wp) == hash[fieldindex])t 			goto gotcha;s- 		    if (matchtest(*wp, search[fieldindex]))  			goto gotcha;  		}  	    }0 	    line[0] = EOS;			/* Force read next time	*/" 	    continue;				/* Not found		*/   gotcha:	    matchcount++;o	 	    do {x 		fputs(line, stdout);- 		if (fgets(line, sizeof (line), fd) == NULL)x 		    goto done;  	    } while (isspace(line[0])); 	} done:	if (matchcount == 0)  	    printf("No match found\n"); }+ { packtext(text, wordlist)5 register char	*text;			/* This text line is packed	*/n9 register char	**wordlist;		/* Into this array of words	*/i /*"  * Build wordlist.  Modifies text.  */  {  	register char		c;   	c = *text;t 	while (c != EOS) {u. 	    while ((c = *text) != EOS && !isgraph(c))' 		++text;				/* Skip over whitespace	*/  	    if (c == EOS) 		break;2 	    *wordlist++ = text;			/* Start of new word	*/$ 	    while ((c = *text), isgraph(c)) 		*text++ = tolower(c);N. 	    *text++ = EOS;			/* Terminate the word	*/ 	} 	*wordlist = NULL; }	   intt matchtest(name, pattern). register char	*name;		/* What to look for			*/1 register char	*pattern;	/* May have wildcard			*/* /*7  * Recursive routine to match "name" against "pattern". 0  * Returns TRUE if successful, FALSE if failure.  *F  * pattern follows Dec filename wildcard conventions:  '*' matches any>  * string (even null), '?' matches any single (non-null) byte.  *  */, {g 	register char	pattbyte;   	for (;;) {*H 	    /* fprintf(stderr, "(%s) (%s), namebyte = '%c', pattbyte = '%c'\n"," 		name, pattern, *name, *pattern); 	    */	 #ifdef	FAIL_AT_END_OF_PATTERN/ 	    /*rA 	     * First check for one-byte pattern "*" -- this must succeede 	     */; 	    if ((pattbyte = *pattern++) == '*' && *pattern == EOS)L 		return (TRUE); 	    /*eA 	     * If not, then if both strings finish equally, it succeeds.s 	     */) 	    if (*name == EOS && pattbyte == EOS)b 		return (TRUE); #elses 	    /*p< 	     * Assume that patterns are terminated -- implicitly --5 	     * by '*', allowing all left-matches to succeed.* 	     */' 	    if ((pattbyte = *pattern++) == EOSA. 	     || (pattbyte == '*' && *pattern == EOS)) 		return (TRUE); #endif 	    /*e& 	     * Not at end of the name string. 	     */ 	    switch (pattbyte) { #ifdef	FAIL_AT_END_OF_PATTERN 0 	    case EOS:			/* End of pattern -> failure	*/ 		return (FALSE);/ #endif0 	    case '*':			/* Wild card means "advance"	*/ 		do {# 		    if (matchtest(name, pattern))a 			return (TRUE);e 		} while (*name++ != EOS);y' 		return (FALSE);		/* Did our best			*/d  & 	    case '?':			/* One byte joker		*/( 		break;			/* succeeds with this byte	*/  / 	    default:			/* Others much match exactly	*// 		if (*name != pattbyte) 		    return (FALSE);  		break; 	    }' 	    name++;			/* Advance name byte		*/  	} }c   /*  * soundex(string)  *9  * Return the soundex hash value for the argument string. %  * S_V should be zero for efficiency.	  */f  6 #define	S_V	0	/* Vowels: a e i o u (maybe y, h, w)		*/4 #define	S_SK	1	/* "hard" consonants: s c z x k q		*/) #define	S_TD	2	/* Dental stops: t d				*/k #define	S_FV	3	/* f v 						*/ #define	S_GJ	4	/* g j						*/t #define	S_B	5	/* b						*/ #define	S_L	6	/* l						*/ #define	S_M	7	/* m						*/ #define	S_N	8	/* n						*/ #define	S_P	9	/* p						*/ #define	S_R	10	/* r						*/u2 #define	S_MAX	11	/* "radix" of soundex values			*/   /*5  * The following are the hash values for each letter.y  */*   static char	sx_letters[] = { /*	 a	 b	 c	 d	 e	 f	 g	 h	*/d, 	S_V,	S_B,	S_SK,	S_TD,	S_V,	S_FV,	S_GJ,	S_V, /*	 i	 j	 k	 l	 m	 n	 o	 p	*/s* 	S_V,	S_GJ,	S_SK,	S_L,	S_M,	S_N,	S_V,	S_P, /*	 q	 r	 s	 t	 u	 v	 w	 x	*/	- 	S_SK,	S_R,	S_SK,	S_TD,	S_V,	S_FV,	S_V,	S_SK,	 /*	 y	 z							*/n 	S_V,	S_SK,	 };   /*?  * The first letter of the following consonant pairs is silent.	  */   2 static char	*sx_leading_silent = "tstzghknpnptpf";   unsigned int soundex(string)a register char		*string;c /*4  * Compute the soundex hash for the argument string.4  * -- somewhat modified from the original algorithm.2  * "Margaret K. Odell and Robert C. Russell.  U.S.2  * patents 1261167 (1918) and 1435663 (1922)."  as4  * reprinted in Donald Knuth, Sorting and Searching.  */	 {K* 	register int	c;	/* Current character			*/4 	register char	*sxp;	/* -> leading silent string		*/0 	int		last;	/* Previous character for doubles	*// 	int		next;	/* Next character in the string		*/(" 	int		value;	/* Soundex value			*/* 	int		temp;	/* Hash for this character		*/* 	int		count;	/* Want only three digits		*/   #ifdef	DEBUG
 	if (debug) {g! 	    printf("\"%s\" = ", string);. 	} #endif% 	while (c = *string++, !isalpha(c)) {) 	    if (c == EOS)
 		return (0);h 	} 	last = c = tolower(c);	> 	value = c - 'a' + 1;	/* Initial hash == first letter value	*/ #ifdef	DEBUG
 	if (debug) {t! 	    printf("(%c %d)", c, value);h 	} #endif 	next = *string++; 	next = tolower(next);2 	count = 3;		/* Maximum times through this loop	*/, 	while (--count >= 0 && (c = next) != EOS) { 	    next = *string++; 	    next = tolower(next); 	    if (next != EOS) {  		/*. 		 * Ignore the first letter in a silent-pair. 		 */r5 		for (sxp = sx_leading_silent; *sxp != EOS; sxp++) {)( 		    if (*sxp++ == c && *sxp == next) {0 			goto reject;	/* reject silent first letter	*/ 		    }d 		}B 		/* 		 * Change 'ph' to 'f'( 		 */)  		if (c == 'p' && next == 'h') { 		    c = 'f'; 		    next = *string++;u 		    next = tolower(next);o 		}h 	    } 	    if (islower(c)) {9 		if ((temp = sx_letters[c - 'a']) != S_V && c != last) {  		    value *= S_MAX;i 		    value += temp; #ifdef	DEBUG 		    if (debug) {( 			printf("(%c=%d %d)", c, temp, value); 		    }i #endif 		}  		last = c;) 	    }, reject:	;				/* Jump here on silent pairs	*/ 	}5 	while (--count >= 0)		/* Finish off the hash code	*/* 	    value *= S_MAX; 	return (value); }  ' usage()t /*  * Help message   */  {  	register char		**hp;	  , 	for (hp = helpmessage; *hp != NULL; hp++) {" 	    fprintf(stderr, "%s\n", *hp); 	} }c  