 /*  *			R S E N T  *6  * Generates random text messages.  From James Gimpel,.  * "Algorithms in SNOBOL4".  Calling sequence:  *%  *	rsent(text, rules, outfun, fildes) +  *	char		*text;		-- generate from this text /  *	RS_RULE		*rules;		-- compiled rule structure '  *	int		(*outfun)();	-- output function 1  *	FILE		*fildes;	-- file descriptor for outfun()   *E  * The text line is copied to the output file, with commands expanded G  * using the rule vector.   The rules are built and tested by rsmake.c.   *  * outfun() is defined:G  *  *	outfun(words, fildes)'  *	char		*words;		-- a string to outputN*  *	FILE		*fildes;	-- the file to output to  *  * Note:4  *	outfun(NULL, fildes)		-- flush partial by writing  *					-- a newline to fildes.  */d   #include <stdio.h> #define	EOS		'\0'  #define	EOL		'\n'* #define	FALSE		0 #define	TRUE		1f   typedef struct rule {t! 	char	*r_name;		/* Rule name			*/l, 	int	r_weightsum;		/* Sum of all weights		*/# 	char	**r_term;		/* Rule terms			*/t
 } RS_RULE;  " rsent(text, rules, outfun, fildes), char		*text;			/* generate from this text	*/0 RS_RULE		*rules;			/* compiled rule structure	*/) int		(*outfun)();		/* output function		*/L2 FILE		*fildes;		/* file descriptor for outfun()	*/ /*8  * Generate text from the indicated pattern - recursive.  */  {f4 	register char	*start;		/* Start of current stuff	*/1 	register char	*end;		/* End of current stuff		*/e/ 	register char	*tp;		/* Random text pointer		*/	$ 	RS_RULE		*rp;		/* Rule pointer			*/, 	short		weight;		/* Weight for randomness	*/( 	char		**termp;	/* Rule term pointer		*/* 	char		*workp;		/* Temp buffer pointer		*// 	extern char	*malloc();	/* Buffer allocator		*/f #ifndef	nomacarg /*%  * Decus does this with a subroutine.	  */*; #define irand(max)	(((((short) rand()) & 32767)*max)/32768)* #endif  % 	for (start = text; *start != EOS;) {n 	    /*/( 	     * Look for <rule> in input string. 	     *// 	    end = (start == text) ? start : start + 1;	' 	    while (*end != EOS && *end != '<')s 		end++; 	    /*e3 	     * Output start .. end-1 (even if null string)p 	     */F 	    if (end > start && (workp = malloc((end - start) + 1)) != NULL) {) 	        for (tp = workp; start < end;) {* 		    *tp++ = *start++;  		}r 		*tp = EOS; 		(*outfun)(workp, fildes);r 		free(workp); 	    } 	    if (*end++ == EOS)( 		break;				/* All done		*/  	    /*/5 	     * (else scan stopped at '<'.  Output the <rule>  	     */: 	    for ((rp = rules); (tp = rp->r_name) != NULL; rp++) { 		/*/ 		 * Look for the <rule> in the rule name tablet 		 */.3 		for (start = end; *tp != EOS && *start == *tp;) {d 		    start++; 		    tp++;e 		}s7 		if (*tp == EOS && *start == '>') {	/* Found a rule	*/ & 		    weight = irand(rp->r_weightsum);: 		    for (termp = rp->r_term; *termp != NULL; *termp++) {, 			if ((weight -= (termp[0][0] & 0377)) < 0)
 			    break;* 		    }/ 		    if (termp == NULL) {4 			(*outfun)("\n(bug, weight messup in \"", fildes);! 			(*outfun)(rp->r_name, fildes);L 			(*outfun)("\".)\n", fildes);h 		    }i
 		    else. 			rsent(&termp[0][1], rules, outfun, fildes);% 		    break;		/* Exit rule search 	*/; 		}  	    } 	    if (tp == NULL) { 		/*0 		 * No match for this rule.  It was a real '<'. 		 */r 		(*outfun)("<", fildes); & 		start = end;			/* start at "foo>"	*/ 	    }	 	    elsee" 		start++;			/* start after '>'	*/ 	} }b