 /*.  * units -- do multiplicative unit conversions  * td 80.09.049  * Modified to keep the intermediate format in a file and /  * update it automatically when it has changed.   *$  * Modified for Decus C 82-05-12 MM.  */    /*)BUILD	$(PROGRAM)	= units  		$(FILES)	= { units atof }  		$(DTOA)		= 1 		$(TKBOPTIONS) = {  			TASK	= ...UNI 		}  */   #ifdef	DOCUMENTATION   title	units	Units Conversion$ index		Convert between various units   synopsis   	units [-u]    description   > 	Units converts between various scales to their equivalents in' 	other scales.  It works interactively:e 	.s.nf 		You have: inches 		You want: cm 		* 2.54 		/ 3.93701y 	.s.ftD 	Quantities are specified as multiplicative combinations, optionallyE 	preceeded by a numeric multiplier.  Powers are indicated by suffixed $ 	positive integers, division by '/'. 	.s @ 	Units does only multiplicative conversions;  it cannot convert, 	e.g., Farenheit to Celsius. 	.s > 	The units conversion table is stored in binary format.  If it? 	cannot be found, or if units is invoked using the '-u' switch,r= 	a binary table will be built, slowly, from the source table. * 	The tables are found using a search list.   diagnosticss   	.lm +8t 	.s.i -8;Conformabilityl 	.sp? 	The measures are not interconvertable, for example, you cannote 	convert inches to pounds. 	.lm -8/   author  
 	David Conroym   bugs  = 	This version does not understand about file dates.  The onlyu< 	way to rebuild the binary data file is to use the -u switch* 	(or to delete all versions of units.dat).   #endif     #include <stdio.h> #define	FALSE	0i #define	TRUE	1
 #define	EOS	0o   #define	unix
 #ifdef	vms #undef	unix  #endif #ifdef	decus int	$$narg = 1;+ #define	BINARY_READ	"rn" #define	BINARY_WRITE	"wn"  #undef	unixe #else  #define	BINARY_READ	"r"  #define	BINARY_WRITE	"w" #endif   #define NDIM    12 #define NUNITS  900T< #define NBUF    256             /* Length of longest line */K #define UMAGIC  0123456         /* Magic number written in binary header */a   /*  * Header for the units file. "  * This  tells that it is the real!  * thing and how much to read in.o  */d   typedef struct  HDR {u         unsigned h_magic;d         unsigned h_nunits;?         unsigned h_ssize;               /* String space size */e }       HDR;   HDR     hdr;   typedef struct  UNIT {         char    *u_name;         double  u_val;         char    u_dim[NDIM];
 }       UNIT;    UNIT    *units;  #ifdef	decus0 char	ufile[]		= "units.txt";	/* Source file			*/3 char	binufile[]	= "units.dat";	/* Compiled file		*/* char    buf[NBUF]; #else ! char	ufile[]		= "/usr/lib/units"; & char	binufile[]	= "/usr/lib/binunits"; char    inbuf[BUFSIZ]; #endif   int nunits;n= int     uflag;                  /* Update information only */i	 FILE *fd;  int peekc = EOF; int lastc = EOF; int lineno = 1;    #ifdef	decus char	*searchlist[] = {( 	"",				/* Current directory -- first	*/ 	"bin:", 	"pub:",
 	"games:", 	"c:", 	"lb:",r 	NULL, }; #endif   extern char    *getname(); extern char    *prefix();/ extern char    *alloc(); extern double	atof();    main(argc, argv)	 int argc;"
 char *argv[];l {	         UNIT have, want;         register int i;d  
 #ifndef	decusn         setbuf(stdout, NULL);          setbuf(stderr, NULL);i #endif/         if (argc>1 && strcmp(argv[1], "-u")==0)e                 uflag++;         init();]
 #ifndef	decus*"         setbuf(fd = stdin, inbuf); #else" 	fd = stdin; #endif Again:)         if (!getunit(&have, "You have: ") )         || !getunit(&want, "You want: "))x                 exit(0);         for (i=0; i!=NDIM; i++),5                 if (have.u_dim[i] != want.u_dim[i]) {v3                         printf("Conformability\n"); %                         punit(&have); %                         punit(&want); #                         goto Again;0                 } + 	printf("* %g\n", have.u_val / want.u_val); 2         printf("/ %g\n", want.u_val / have.u_val);         goto Again;  }    /*-  * Initialise by reading in units informationu.  * either in binary or ascii form and updating  * the binary information.  */i init() {          if (uflag || !binary())n                 update(); %         printf("%d units\n", nunits);          peekc = EOF;   #ifdef	unix)
         /*,          * Throw away super-user information          */o         setuid(getuid());  #endif }*   /*(  * Attempt to read in the already-stored*  * binary information.  Return non-zero if  * successful.  */  binary() {i #ifdef unixi         register char *sstart;         register int n;r         register int bfd;r         time_t timeasc;t  !         if (stat(ufile, &sb) < 0))                 return (0);          timeasc = sb.st_mtime;=         if ((bfd = open(binufile, 0))<0 || fstat(bfd, &sb)<0)                  return (0);i:         if (timeasc > sb.st_mtime)      /* Out of date? */                 goto bad1;8         if (read(bfd, &hdr, sizeof(hdr)) != sizeof(hdr))                 goto bad1;"         if (hdr.h_magic != UMAGIC)                 goto bad1;         nunits = hdr.h_nunits;$         sstart = alloc(hdr.h_ssize);:         if (read(bfd, sstart, hdr.h_ssize) != hdr.h_ssize)                 goto bad; 7         units = (UNIT *)alloc(n = nunits*sizeof(UNIT)); %         if (read(bfd, units, n) != n)                  goto bad; !         for (n=0; n!=nunits; n++)O0                 units[n].u_name += (long)sstart;         close(bfd);          return (1);f bad:         brk(sstart); bad1:          close(bfd);i         return (0);  #else  	/*b 	 * Binary readin for Decus Cn 	 */         register char		*sstart;e         register int		n;         register FILE		*bfd;  * 	for (n = 0; searchlist[n] != NULL; n++) { 		strcpy(buf, searchlist[n]);s 		strcat(buf, binufile);. 		if ((bfd = fopen(buf, BINARY_READ)) != NULL)	 			break;  	} 	if (bfd == NULL)t 		return (FALSE); A 	printf("(reading pre-compiled units table from \"%s\")\n", buf); + 	if (fread(&hdr, sizeof(hdr), 1, bfd) != 1)a 		goto bad1;"         if (hdr.h_magic != UMAGIC)                 goto bad1;         nunits = hdr.h_nunits;%         sstart = malloc(hdr.h_ssize);t 	units = NULL;4         if (fread(sstart, hdr.h_ssize, 1, bfd) != 1)                 goto bad;b8         units = (UNIT *)malloc(n = nunits*sizeof(UNIT));)         if (fread(units, 1, n, bfd) != n)e                 goto bad;t!         for (n=0; n!=nunits; n++)d0                 units[n].u_name += (long)sstart;         fclose(bfd);         return (TRUE); bad: 	free(sstart); 	if (units != NULL)= 		free(units); bad1:          close(bfd);          return (FALSE);  #endif }t /**  * Update units information by reading the  * units file.  */d update() {          register char *name;         register int i; %         register char *sstart, *send;; #ifdef	decus 	FILE		*bfd; 	int		temp;n #else          int		bfd;d #endif     #ifdef	decus* 	for (i = 0; searchlist[i] != NULL; i++) { 		strcpy(buf, searchlist[i]);o 		strcat(buf, ufile);n% 		if ((fd = fopen(buf, "r")) != NULL)i	 			break;= 	} 	if (fd == NULL) {= 		fprintf(stderr, "Can't locate units file \"%s\"\n", ufile);*
 		exit(1); 	}3 	printf("Building units table from \"%s\"\n", buf);p #else -         if ((fd = fopen(ufile, "r")) == NULL)t9                 cerr("can't open unit file `%s'", ufile);d5 	printf("Building units table from \"%s\"\n", ufile);b 	setbuf(fd, inbuf);d #endif3         units = (UNIT *)alloc(NUNITS*sizeof(UNIT));y!         sstart = (char *)sbrk(0);f2         for (nunits=0; nunits!=NUNITS; nunits++) {!                 name = getname(); )                 for (i=0; i!=nunits; i++)\?                         if (strcmp(units[i].u_name, name) == 0) L                                 fprintf(stderr, "`%s' redefined, line %d\n",6                                         name, lineno);,                 units[nunits].u_name = name;3                 if (!getunit(&units[nunits], NULL))                          break;A /* printf("%s = ", name); printf("%g\n", units[nunits].u_val); */t	         }!         send = (char *)sbrk(0);          if (!feof(fd))'                 cerr("too many units");\         fclose(fd); 
         /*)          * Write out, if possible, binary 5          * information for faster response next time.l          */  #ifdef	decus5 	if ((bfd = fopen(binufile, BINARY_WRITE)) != NULL) { @ 		printf("Creating compiled units table on \"%s\"\n", binufile); 		hdr.h_magic = UMAGIC;  		hdr.h_nunits = nunits; 		hdr.h_ssize = send - sstart;. 		if (fwrite(&hdr, sizeof (hdr), 1, bfd) != 1) 			goto bad;/ 		if (fwrite(sstart, hdr.h_ssize, 1, bfd) != 1)  			goto bad;+                 for (i = 0; i!=nunits; i++) J                         units[i].u_name -= (long)sstart;/* Rel. address */B                 temp = fwrite(units, nunits*sizeof(UNIT), 1, bfd);)                 for (i=0; i!=nunits; i++) 8                         units[i].u_name += (long)sstart; 		if (temp == 1)
 			return;3 bad:		printf("Couldn't create \"%s\"\n", binufile);d 		fclose(bfd); 	} #elsed1         if ((bfd = creat(binufile, 0644)) >= 0) {(%                 hdr.h_magic = UMAGIC;1&                 hdr.h_nunits = nunits;*                 hdr.h_ssize = send-sstart;A                 if (write(bfd, &hdr, sizeof(hdr)) != sizeof(hdr)) !                         goto bad;eC                 if (write(bfd, sstart, hdr.h_ssize) != hdr.h_ssize) !                         goto bad;=)                 for (i=0; i!=nunits; i++);J                         units[i].u_name -= (long)sstart;/* Rel. address */7                 write(bfd, units, nunits*sizeof(UNIT));()                 for (i=0; i!=nunits; i++) 8                         units[i].u_name += (long)sstart;         bad:                 close(bfd);(	         }& #endif }(   nextc()z {(         register int c;            if (peekc != EOF) {                  c = peekc;                 peekc = EOF;                 return (c);d	         }          if (lastc == '\n')                 lineno++;          lastc = getc(fd);g3         if (lastc == '#') {     /* Eat a comment */,                 do {)                         lastc = getc(fd);t3                 } while(lastc!='\n' && lastc!=EOF);(	         };         return (lastc);  }    char *	 getname()  {&         register char *s, *t;          register int c;          register char *v;            do {                 c = nextc();.         } while(c==' ' || c=='\n' || c=='\t');         s = buf;7         while(c!=' ' && c!='\t' && c!='\n' && c!=EOF) {t                 *s++ = c;(                 c = nextc();	         }          *s = '\0';         peekc = c;%         v = t = alloc(strlen(buf)+1);          s = buf;         while (*t++ = *s++)                  ;(         return (v);* }e   punit(u) register UNIT *u;c {          register int i;r           printf("%g", u->u_val);          for (i=0; i!=NDIM; i++) %                 if (u->u_dim[i] == 1) 7                         printf(" %s", units[i].u_name);')                 else if (u->u_dim[i] > 0) G                         printf(" %s+%d", units[i].u_name, u->u_dim[i]); )                 else if (u->u_dim[i] < 0) H                         printf(" %s-%d", units[i].u_name, -u->u_dim[i]);         printf("\n");  }    double
 ipow(d, n)	 double d;e {t         double v;            v = 1.;i         if (n < 0) {                 d = 1./d;o                 n = -n; 	         }          while (n) {1                 v *= d;                  --n;	         }'         return (v);e }    struct{]         char *prefix;          double factor; }pre[]={ "femto",        1e-15, "pico",         1e-12, "nano",         1e-9,  "micro",        1e-6,n "milli",        1e-3,_ "centi",        1e-2,  "deci",         1e-1,  "hemi",         .5,) "demi",         .5,  "semi",         .5,  "sesqui",       1.5, "deka",         1e1, "hecto",        1e2,4 "hekto",        1e2,    /* common (?) misspelling */ "kilo",         1e3, "myria",        1e5, "mega",         1e6, "giga",         1e9, "tera",         1e12,h NULL,           1. }; /*$  * Return the string stripped of its  * prefix (if any).  Set factorn,  * to the multiplicative factor indicated by  * the prefix found.  */i char * prefix(str, factor) 
 char *str; double *factor;5 {          register char *s, *t;          register int i;   -         for (i=0; pre[i].prefix!=NULL; i++) {,"                 s = pre[i].prefix;                 t = str;"                 while (*s != '\0'))                         if (*s++ != *t++),&                                 break;!                 if (*s == '\0') {s:                         *factor = *factor * pre[i].factor;#                         return (t);*                 } 	         }*         return(NULL);  }r   getunit(u, prompt) UNIT *u;
 char *prompt;c {          register int c;r         register char *s;0         register int i;+&         int j, expon, digit, div, pow;         double factor;   Again:         if (prompt != NULL) %                 printf("%s", prompt);+         u->u_val = 1.;!         for (i=0; i != NDIM; i++)                   u->u_dim[i] = 0;         div = 0;         pow = 1;"         for(;;) switch(c=nextc()){         case ' ':          case '\t':                 break;         case '\n':                 return (1);m         case EOF:e                 return (0);t5         case '0':case '1':case '2':case '3':case '4':e5         case '5':case '6':case '7':case '8':case '9'::#         case '.':case '-':case '+':                  /*$                  * a palpable number                  */=                 s = buf;                 if (c == '+')i$                         c = nextc();                 digit = 0;*                 while (c>='0' && c<='9') {!                         *s++ = c; $                         c = nextc();                          digit++;                 }e                 if (c == '.') {a!                         *s++ = c;:<                         while ((c=nextc())>='0' && c<='9') {)                                 *s++ = c;*(                                 digit++;                         }                  }                  if (!digit) {                  Badnumber:"                         *s = '\0';B                         fprintf(stderr, "Bad number `%s'\n", buf);!                         goto Bad;                  }i'                 if (c=='e' || c=='E') { #                         *s++ = 'e'; $                         c = nextc();%                         if (c == '+'){,                                 c = nextc();,                         else if (c == '-') {)                                 *s++ = c; ,                                 c = nextc();                         } +                         if (c<'0' || '9'<c) /                                 goto Badnumber;                          do {)                                 *s++ = c;',                                 c = nextc();2                         } while('0'<=c && c<='9');                 }                  *s = '\0';                 peekc = c; 		factor = atof(buf); 6 /* printf("[%s == ", buf); printf("%g]\n", factor); */                 if (div) {+                         if (factor == 0.) { B                                 fprintf(stderr, "Divide check\n");)                                 goto Bad;                          }{+                         u->u_val /= factor;                           div = 0;                 } else+                         u->u_val *= factor;                  break;  1         case '/':       /* divide by next unit */r                 if (div) {                 Baddiv:]I                         fprintf(stderr, "Two division signs in a row\n");a!                         goto Bad;                  }(                 div++;                 break;  ,         case '!':       /* primitive unit */                 i = 0;1                 if ((c = nextc())<'0' || c>'9') {iG                         fprintf(stderr, "`!' must precede a number\n");r!                         goto Bad;                  }*                 do {'                         i = i*10+c-'0'; $                         c = nextc();*                 } while('0'<=c && c<='9');                 peekc = c;%                 if (i<0 || NDIM<=i) { O                         printf("Primitive unit out of range [0,%d]\n", NDIM-1);i!                         goto Bad;                  }(                 u->u_dim[i]++;                 break;           default:                 s = buf;                 do {!                         *s++ = c;*$                         c = nextc();C                 } while(c!=EOF && !anyc(c, "/0123456789+-. \t\n"));                  *s = '\0';                 s = buf;,                 if (strcmp(s, "per") == 0) {                          if (div),                                 goto Baddiv;                         div++;                         break;                 }-C                 if (strcmp(s, "square")==0 || strcmp(s, "sq")==0) { !                         pow *= 2;                          break;                 } B                 if (strcmp(s, "cubic")==0 || strcmp(s, "cu")==0) {!                         pow *= 3;                          break;                 }                  factor = 1.;                 do {1                         for (i=0; i!=nunits; i++)oA                                 if (eqplural(s, units[i].u_name)) .                                         break;C                 } while(i==nunits && (s=prefix(s, &factor))!=NULL); "                 if (i == nunits) {G                         fprintf(stderr, "Unrecognised unit %s\n", buf); !                         goto Bad;                  }='                 if (c=='+' || c=='-') { %                         if (c == '-')=+                                 div = !div; "                         expon = 0;9                         if ((c = nextc())<'0' || c>'9') {mN                                 printf("+ or - must be followed by digits\n");)                                 goto Bad;                          }n                         do {7                                 expon = expon*10+c-'0'; ,                                 c = nextc();2                         } while('0'<=c && c<='9');                 } else"                         expon = 1;                 expon *= pow;                  pow = 1;                 peekc = c;                 if (div) {'                         expon = -expon;"                          div = 0;                 } ?                 u->u_val *= ipow(factor*units[i].u_val, expon); '                 for (j=0; j!=NDIM; j++) ?                         u->u_dim[j] += units[i].u_dim[j]*expon; 	         }t Bad:!         while (c!='\n' && c!=EOF)<                 c = nextc();         if (prompt!=NULL)                  goto Again; -         fprintf(stderr, "line %d\n", lineno);          return (1);  }    /*  * Check for any occurrences of #  * the character `c' in string `s'.   */ 
 anyc(c, s) register char c; register char *s;  {          while (*s != '\0')                 if (c == *s++)#                         return (1);          return (0);- }d   /*'  * Return non-zero if string `s' is the    * same or plural as string `t'.  */< eqplural(s, t) register char *s, *t;  {(         while (*t != '\0')!                 if (*s++ != *t++)t#                         return (0); 5         return (*s=='\0' || (*s++=='s' && *s=='\0'));  }*   /*  * Diagnostics  */g
 /* VARARGS */n cerr(x)  {i+         fprintf(stderr, "units: %r\n", &x);          exit(1); }    /*$  * Use (char *)sbrk for alloc to get  * contiguous memory.   */  char *	 alloc(nb)  unsigned nb; {o         register char *rp;  ,         if ((rp = (char *)sbrk(nb)) == NULL)&                 cerr("out of memory");         return (rp); }   