 #include	<stdio.h> #include	<ctype.h>   /*)BUILD */   #ifdef	DOCUMENTATION  0 title	untar	Read tar (tape archive) format tapes+ index		Read tar (tape archive) format tapes    Synopsis  , 	untar [- options] [-d directory] [tar_file]   Description   7 	untar extracts the contents of a Unix tar format tape, 7 	simplifing transfer of files from Unix to VMS or other 8 	similar operating systems.  (Untar runs on VMS, RSTS/E, 	RSX, or RT11.)   9 	If the tar_file is missing, untar will read "tartap.dat"  	in your current directory.u   Options>  ( 	Untar recognizes the following options: 	.lm +4a@ 	.s.i -4;-a##Create all files in "ascii" (readable text) format.1 	.s.i -4;-b##Create all files in "binary" format.]C 	.s.i -4;-d##(Requires a file name argument).  Scan the tar archivet: 	for directories, writing a VMS command file to create the> 	directories.  (On-the-fly creation has not been implemented.)> 	.s.i -4;-h##(Requires a string argument).  If specified, this6 	string is prepended to all filenames before creation.) 	For example, assume untar was invoked asi   	    untar -h "dskz:":  4 	A filename "foo.bar" would be created as if it were3 	written "dskz:foo.bar".  See also the "-n" option.n1 	.s.i -4;-n##Ignore directory path information ina7 	the archive filename, writing all files to the currentr 	directory.oC 	.s.i -4;-q##Query.  Inquire whether to create each archive member. . 	.s.i -4;-t##List the contents of the archive.? 	.s.i -4;-v##Verbose -- list each file as it is processed.  -v2i 	lists more information.	 	.s.lm -4e< 	If neither -a nor -b are given, untar decides on the output: 	format by examining the filetype.  Files with no filetype= 	or whose filetype is included in a built-in list are createdr: 	in "binary" mode, others in ascii mode.  The -a/-b option> 	is uninteresting on Unix, but important on RSTS/E and similar 	operating systems.    Reading the Archiveb  ' 	The following procedure is reommended: 	 	.s.lm +4.9 	Read the tape onto a disk file, converting from the tapev? 	format (which may contain 10240 byte records) to "fixed-block,r6 	512-byte" records.  The Decus C distribution contains; 	two Basic-Plus programs (rdmt.bas for RSTS/E and vrdmt.basi= 	for VMS) that read tar files onto disk.  While the procedureo; 	is generally straight-forward, different operating systemsU 	have different requirements.d  ; 	Use untar to list all directories (-d option) and build anf! 	appropriate directory structure.     	Use untar to extract the files. 	.lm -4c   Assumed Filetypesp  4 	The following filetypes are assumed to be "binary":   	  tsk olb mlb sys sml ulb obj 	  stb bin lda exe sav   o   a  6 	Also, any file with no filetype will be assumed to be
 	"binary".   Operating-system Notes  # 	Untar has not been tested on Unix.e  > 	On RSTS/E and RT11, Untar will not create a file that already 	exists in your directory.  < 	If untar cannot create a file, it prompts for a replacement$ 	file name.  (If run interactively.)   #endif c /*0  *	D e f i n i t i o n s   a n d   G l o b a l s  */i   #define	FALSE		0 #define	TRUE		1y- #define	EOS		'\0'		/* End of string marker	*/n #ifdef	decus #define	OPENMODE	"rn"l #elsen #define	OPENMODE	"r" #endif   /*   * Specify the operating system.  */U   #define	UNIX	0
 #define	RSX	1e
 #define	VMS	2a #define	RT11	3  
 #ifdef	rsx #define	OPSYS	RSXy #endif #ifdef	rt11e #define	OPSYS	RT11 #endif #ifdef	unix  #define	OPSYS	UNIX #endif
 #ifdef	vms #define	OPSYS	VMSi #endif
 #ifndef	OPSYS*- 	<< error, operating system wasn't defined >>l #endif   #if	OPSYS == UNIX  #define	IO_SUCCESS	0 #define	IO_ERROR	1 #endif  ! #if	OPSYS == RSX || OPSYS == RT11	 extern int	$$rstss #endif   #if	OPSYS == VMS* #include	ssdef		/* System status codes		*/( #include	iodef		/* I/O request codes		*/+ #include	descrip		/* String descriptors		*/  #include	errno #define	IO_SUCCESS	SS$_NORMALn. #define	IO_ERROR	errno	/* Use global value		*/? typedef struct dsc$descriptor_s STRING;	/* string descriptor	*/P /*C  * The following macro builds a descriptor from an argument string.   */I #define	descrip(text, p)			\ 	((p)->dsc$a_pointer = text,		\Y$ 	(p)->dsc$w_length = strlen(text),	\$ 	(p)->dsc$b_dtype = DSC$K_DTYPE_T,	\" 	(p)->dsc$b_class = DSC$K_CLASS_S)   #endif  
 #ifdef	vms /*&  * Create files in vanilla rms on vms.  */rN #define	CREATE(name, mode) (fdopen(creat(name, 0, "rat=cr", "rfm=var"), mode)) #elsee. #define	CREATE(name, mode) (fopen(name, mode)) #endif   #define	DEF_INPUT	"tartap.dat"3 #define	RSIZE		512		/* Probably shouldn't change	*/f0 #define	FNSIZE		100		/* Filename string size		*/   /*8  * This structure defines the header of an archive file.5  * headers are always aligned on a 512 byte boundary. 6  * All information in the header is in readable ascii.4  * All numbers are stored in octal.  The checksum is4  * calculated differently on different Unix systems.1  * The file create date is in Unix "time" format.m  *0  * If the last character of the name is '/', the1  * entry is a directory (there is no other data).h2  * Similar magic (unimplemented here) is needed to  * recognize "special files".i  */u   typedef struct header { )     char	name[100];		/* Unix file name	*/g,     char	protmode[8];		/* Protection bits	*/%     char	userid[8];		/* User i.d.		*/ *     char	nlinks[8];		/* Number of links	*/0     char	filesize[11];		/* File size in bytes	*/*     char	date[13];		/* File create date	*/*     char	checksum[8];		/* Random number	*/0     char	linkflag[1];		/* '1' (one) if a link	*/,     char	linkpath[100];		/* Link to file		*/	 } HEADER;l   /*  * Global variables   */c  * int	debug;			/* Set for debug printouts	*/ int	verbose;		/* Log file			*/- int	nocreate;		/* Don't create files/dir's	*/	 int	nopath;n$ int	list;			/* List tar contents		*/, int	ascii;			/* Ascii option (not binary)	*/- int	binary;			/* Binary output (not ascii)	*/i' int	isbinary;		/* Mode of this file		*/r( int	query;			/* Ask about each file.		*/+ int	nooutput;		/* TRUE to skip this file	*/ # FILE	*infd;			/* Tar input file		*/[0 FILE	*outfd;			/* Archive member written here	*/+ FILE	*dirfd;			/* Directory command file	*/ 7 char	*dirfile = NULL;	/* Set (-d file) to do direct.	*/n0 char	*header = "";		/* Set by -h to do header	*/! union {				/* Tar data record		*/o%     HEADER	h;		/* Tar file header		*/n1     char	b[RSIZE + 1];	/* Input record buffer		*/o	 } record;i  5 char	arch_name[FNSIZE+1];		/* Filename in tar file	*//2 char	filename[FNSIZE+1];		/* Filename to create	*/< char	*archivefilename = DEF_INPUT;	/* Tar file to process	*/1 char	subdir[FNSIZE+1];		/* For vms [...] hacks	*/E0 char	work[FNSIZE+1];			/* String scratch area	*/( char	line[257];			/* For user prompts	*/( char	filetype[4];			/* For ascii test	*/& long	protmode;			/* For Unix create	*/( long	filesize;			/* File size (bytes)	*/( long	blocks;				/* File size (blocks)	*/* int	bytes_in_last;			/* left over bytes	*/+ long	inrecords;			/* Read from tar input	*/   ( char	*types[] = {			/* Assumed binary	*/* 	"tsk", "olb", "mlb", "sys", "sml", "ulb",* 	"obj", "stb", "bin", "lda", "exe", "sav", 	"o",   "a", 	NULL] }; * main(argc, argv)
 int		argc; char		*argv[]; /*  * Untar main program.  */u {  	register int		i;l   	getoptions(argc, argv); 	for (i = 1; i < argc; i++) {n 	    if (argv[i] != NULL) {	 		archivefilename = argv[i]; 		break; 	    } 	} 	/*l 	 * Process the file.l 	 */9 	if ((infd = fopen(archivefilename, OPENMODE)) == NULL) {i 	    perror(archivefilename);	< 	    fprintf(stderr, "Can't open tar format input file.\n"); 	    exit(IO_ERROR); 	} 	if (dirfile != NULL) {"2 	    if ((dirfd = CREATE(dirfile, "w")) == NULL) { 		perror(dirfile); 		fprintf(stderr,r5 		    "Can't open directory command output file.\n");c 		exit(IO_ERROR);  	    } 	    nocreate = TRUE;a 	}
 	if (list) 	    nocreate = TRUE;  	inrecords = 0L;/ 	while (feof(infd) == 0 && ferror(infd) == 0) {  	    if (getheader())i 		getfile(); 	} 	if (ferror(infd)) { 	    perror(archivefilename);  	    exit(IO_ERROR); 	} }t f int  getheader()" /*B  * Read and parse a tar header.  Return TRUE if ok, FALSE to skip.,  * getheader() sets up lots of global stuff.  */e {  	extern long	octal_to_long();t   	/*i6 	 * Read the next record -- it is a tar member header. 	 */ 	if (!readrecord())E 	    return (FALSE); 	/*c# 	 * Process the archive name field.i 	 */> 	copystring(arch_name, record.h.name, sizeof (record.h.name));. 	if (arch_name[0] == EOS)		/* "end of tape"	*/ 	    return (FALSE);/ 	if (arch_name[strlen(arch_name) - 1] == '/') {e> 	    arch_name[strlen(arch_name) - 1] = EOS;	/* Drop signal	*/ 	    if (list || verbose > 1)t/ 		printf("\"%s\" is a directory\n", arch_name);g 	    if (!nocreate)  		getdirectory();n 	    if (dirfd != NULL)  		dircomfile();  	    return (FALSE); 	} 	/*r 	 * Process the link flagr 	 */# 	if (record.h.linkflag[0] == '1') {s #if	OPSYS == UNIXc 	    /*e 	     * Do links someday 	     */E 	    copystring(work, record.h.linkpath, sizeof (record.h.linkpath));_ 	    if (list || verbose) {=. 		printf("\"%s\" links to \"%s\", ignored.\n", 		    arch_name, work);  	    } #else|E 	    copystring(work, record.h.linkpath, sizeof (record.h.linkpath));i 	    if (list || verbose) {y. 		printf("\"%s\" links to \"%s\", ignored.\n", 		    arch_name, work);} 	    } #endif 	    return (FALSE); 	}   	/*r) 	 * Save the protection mode for Unix andI  	 * process the file size field. 	 */A 	copystring(work, record.h.protmode, sizeof (record.h.protmode));.  	protmode = octal_to_long(work);A 	copystring(work, record.h.filesize, sizeof (record.h.filesize));h. 	if ((filesize = octal_to_long(work)) == 0L) { 	    if (list || verbose)z: 		printf("\"%s\" has zero length, skipped.\n", arch_name); 	    return (FALSE); 	} 	blocks = filesize / RSIZE;h" 	bytes_in_last = filesize % RSIZE; 	if (list || verbose > 1) {rA 	    printf("\"%s\", %ld bytes (%ld blocks, %d bytes in last)\n",s. 		arch_name, filesize, blocks, bytes_in_last); 	} 	/*z+ 	 * All processed.  Try to create the file._ 	 */  	if (nocreate || !open_output()) 	    nooutput = TRUE;c 	else nooutput = FALSE;( 	return (TRUE);t }o w getdirectory() /*  * Create a directory entry.  */" {" #if	OPSYS == UNIXk% 	int		status;		/* fork/wait status	*/L" 	int		cstatus;	/* Child status		*/   	strcpy(filename, arch_name);S& 	filename[strlen(filename) - 1] = EOS; 	/*t* 	 * How does a mundane create a directory? 	 * Maybe this will work:f 	 */ 	if ((status = vfork()) != 0) {/ 	    /*l% 	     * Parent -- wait for the child.  	     */& 	    if (status = wait(&cstatus)) < 0), 		perror("make directory: child went away"); 	    else if (cstatus != 0) {y 		fprintf(stderr, ' 			"error creating directory \"%s\"\n",U
 			filename);t 	    } 	} 	else {t; 	    status = execl("/bin/mkdir", "mkdir", filename, NULL);e 	    if (status == -1) 		perror("execl of mkdir");; 	} #else  #if	OPSYS == VMS && FALSE  	/*t$ 	 * Note: this doesn't seem to work. 	 */% 	int		status;		/* fork/wait status	*/ " 	int		cstatus;	/* Child status		*/ 	register char	*np;  	extern char	*vms_etext();   	strcpy(filename, arch_name);l 	squishfilename(filename);/ 	while ((np = strchr(filename, '/')) != NULL) {  	    *np = '.';y 	    if (np[1] == EOS) 		*np = EOS; 	} 	if (filename[0] == EOS) 	    return;" 	sprintf(work, "[.%s]", filename); 	strcpy(filename, work); 	/*x* 	 * How does a mundane create a directory? 	 * Maybe this will work:e 	 */ 	if (verbose > 1)rA 	    printf("Attempting to create directory \"%s\"\n", filename);  	if ((status = vfork()) != 0) {* 	    /*t% 	     * Parent -- wait for the child.a 	     */' 	    if ((status = wait(&cstatus)) < 0)e, 		perror("make directory: child went away"); 	    else if (cstatus != 0) {= 		fprintf(stderr,;, 			"error (%d) creating directory \"%s\"\n", 			cstatus, filename);. 		fprintf(stderr, "%s\n", vms_etext(cstatus)); 	    } 	} 	else {eC 	    if ((status = execl("$create", "/dir", filename, NULL)) == -1)r  		perror("execl of create/dir"); 	} #else  	/*"5 	 * Can't create directories on RSTS/E, RSX, or RT11.  	 */
 	if (verbose)-< 	    printf("\"%s\" is a directory, skipped.\n", arch_name); #endif #endif }r " dircomfile() /*2  * Create a vax command file to build a directory.  */t {t 	register char	*np;)   	strcpy(filename, arch_name);	 	squishfilename(filename);- 	while ((np = strchr(filename, '/')) != NULL)} 	    *np = '.'; / 	fprintf(dirfd, "$ cre/dir [.%s]\n", filename);e }U  	 getfile()  /*%  * Process the current archive member   */" {  	register long	count;i  , 	for (count = 1; count <= blocks; count++) { 	    if (readrecord()) 		output(RSIZE); 	    else {c 		perror(archivefilename);1 		fprintf(stderr, "reading \"%s\"\n", arch_name);e 		filesize = 0L; 	    } 	} 	if (bytes_in_last > 0) {  	    if (readrecord()) 		output(bytes_in_last); 	    else {i 		perror(archivefilename);3 		fprintf(stderr, "reading last block of \"%s\"\n",c 		    arch_name);l 	    } 	} 	if (!nooutput)* 	    fclose(outfd);e }a i intm
 open_output()  /*B  * Create the current tar member.  Munging it as necessary for the8  * opeating system.  TRUE if ok, FALSE to skip the file.  */r {c 	register char	*np;i 	register int	fileid;%  
 	if (query) {)/ 	    sprintf(work, "Create \"%s\"", arch_name);a  	    if (!getyesno(work, "Yes")) 		return (FALSE);_ 	} 	strcpy(filename, arch_name);i #if	OPSYS == UNIXi 	/*t 	 * Create the file on Unix. 	 */ 	if (nopath) {1 	    while ((np = strchr(filename, '/')) != NULL)( 		strcpy(filename, np + 1);o 	}: 	sprintf(work, "%s%s", header, filename);	/* Add header	*/ 	strcpy(filename, work); 	for (;;) {T 	    if (verbose) 4 		printf("\"%s\" => \"%s\"\n", arch_name, filename);A 	    if (outfd = fdopen(creat(filename, protmode), "w")) != NULL)\ 		break; 	    perror(filename);A 	    fprintf(stderr, "Can't create \"%s\" (archive is \"%s\")\n",m 		filename, arch_name); 1 	    if (!isatty(fileno(stdin)) || feof(stdin)) {t1 		printf("Skipping archive \"%s\"\n", arch_name);U 		return (FALSE);n 	    }: 	    fprintf(stderr, "New file, <return> to skip file: ");+ 	    if (!getcommand() || line[0] == EOS) {; 		return (FALSE);o 	    } 	    strcpy(filename, line);. 	    protmode = 0666;			/* Get default mode	*/ 	} #endif r #if	OPSYS == VMS 	/*\ 	 * Create the file on VMS 	 *;5 	 * First, convert any directory paths to VMS flavor: = 	 *	"foo/bar/file_name.extension" => "[.foo.bar]filename.ext"( 	 */: 	squishfilename(filename);	/* Remove non-filename stuff	*/7 	testbinary(filename);		/* Check (fix) .ext filetype	*/d3 	subdir[0] = EOS;		/* Build subdirectory strings	*/!/ 	while ((np = strchr(filename, '/')) != NULL) {S 	    *np = EOS; . 	    sprintf(work, "%s.%s", subdir, filename); 	    strcpy(subdir, work); 	    strcpy(filename, np + 1); 	}# 	if (!nopath && subdir[0] != EOS) { / 	    sprintf(work, "[%s]%s", subdir, filename);r 	    strcpy(filename, work); 	}: 	sprintf(work, "%s%s", header, filename);	/* Add header	*/ 	strcpy(filename, work); 	for (;;) {  	    if (verbose)e4 		printf("\"%s\" => \"%s\"\n", arch_name, filename); 	    if (isbinary) 		outfd = fopen(filename, "w");t 	    else {,3 		fileid = creat(filename, 0, "rat=cr", "rfm=var");r6 		outfd = (fileid == -1) ? NULL : fdopen(fileid, "w"); 	    } 	    if (outfd != NULL); 		break; 	    perror(filename);A 	    fprintf(stderr, "Can't create \"%s\" (archive is \"%s\")\n",r 		filename, arch_name); 1 	    if (!isatty(fileno(stdin)) || feof(stdin)) {a1 		printf("Skipping archive \"%s\"\n", arch_name);  		return (FALSE);r 	    }: 	    fprintf(stderr, "New file, <return> to skip file: ");+ 	    if (!getcommand() || line[0] == EOS) {  		return (FALSE);t 	    } 	    strcpy(filename, line); 	} #endif i! #if	OPSYS == RSX || OPSYS == RT11" 	/* # 	 * Create the file on RSTS or RSX.a 	 * 3 	 * Strip out any directory paths.  (Note that thisa4 	 * isn't quite correct as paths are legal on P/OS.) 	 */3 	squishfilename(filename);		/* Remove funny text	*/ - 	while ((np = strchr(filename, '/')) != NULL)) 	    strcpy(filename, np + 1);: 	sprintf(work, "%s%s", header, filename);	/* Add header	*/ 	strcpy(filename, work); 	for (;;) {S 	    /*e6 	     * RSTS and RT11 don't have file version numbers.1 	     * Make sure the file doesn't exist already./ 	     */ 	    testbinary(filename); 	    if (verbose) 4 		printf("\"%s\" => \"%s\"\n", arch_name, filename); #if	OPSYS == RT11t" 	    outfd = fopen(filename, "r"); #elsem 	    if ($$rsts) 		outfd = fopen(filename, "r"); 	 	    elsel 		outfd = NULL;U #endif 	    if (outfd == NULL)13 		outfd = fopen(filename, (isbinary) ? "wn" : "w");h 	    else {r 		fclose(outfd);, 		fprintf(stderr, "File already exists.  "); 		outfd = NULL;l 	    } 	    if (outfd != NULL)s' 		break;			/* File is open correctly	*/  	    else {s 		fprintf(stderr, 4 		    "Can't create \"%s\", (archive is \"%s\").\n", 		    filename, arch_name); . 		if (!isatty(fileno(stdin)) || feof(stdin)) {5 		    printf("Skipping archive \"%s\"\n", arch_name);  		    return (FALSE);  		}U7 		fprintf(stderr, "New file, <return> to skip file: ");a& 		if (!getcommand() || line[0] == EOS) 		    return (FALSE);  		strcpy(filename, line);e 	    } 	} #endif 	return (TRUE);  }}   output(nbytes) int		nbytes; /*+  * Output the first nbytes from the record.   */i {( 	if (nooutput) 	    return; 	if (isbinary)4 	    fwrite(record.b, sizeof (char), nbytes, outfd); 	else {i 	    /*n+ 	     * On RSTS/E, RSX, RT11, and VMS, thisa( 	     * outputs "vanilla ascii" records. 	     */ 	    record.b[nbytes] = EOS; 	    fputs(record.b, outfd); 	} }    intg readrecord() /*J  * Read one 512 byte record from the archive.  TRUE if ok, FALSE if error.  */d { : 	if (fread(record.b, sizeof (char), RSIZE, infd) != RSIZE) 	    return (FALSE); 	else {  	    inrecords++;  	    return (TRUE);  	} }r   testbinary(name) char		*name; /*  * Set isbinary flag.,  */d {  	register char	*np;  	register char	**tp;  " 	if (ascii)				/* Always ascii		*/ 	    isbinary = FALSE;' 	else if (binary				/* Always binary	*/ 7 	      || (np = strchr(name, '.')) == NULL	/* no dot	*/)( 	      || *++np == EOS)				/* no type	*/( 	    isbinary = TRUE;			/* is binary		*/ 	else {i/ 	    if (strlen(np) > 3)			/* Long filetype?	*/ $ 		np[3] = EOS;			/* Trim filetype	*/- 	    strcpy(filetype, np);		/* Get a copy		*/ , 	    for (np = filetype; *np != EOS; np++) { 		if (isupper(*np))  		    *np = tolower(*np);p 	    }* 	    for (tp = types; *tp != NULL; tp++) {! 		if (strcmp(*tp, filetype) == 0) " 		    break;			/* Found a type		*/ 	    } 	    if (*tp != NULL)m% 		isbinary = TRUE;		/* Known type		*/|	 	    elseE+ 		isbinary = FALSE;		/* Others are ascii	*/	 	} }i   long octal_to_long(in)  register char	*in; /*)  * Convert octal string to a long result.f  */p {/ 	long		result;  
 	result = 0L;G# 	while (*in >= '0' && *in <= '7') {p 	    result <<= 3; 	    result += (*in++ - '0');  	} 	return (result);  }}   copystring(out, in, size)N register char	*out;t register char	*in;
 int		size; /*9  * Does Basic-Plush cvt$$(in, 1+2+4) which drops garbage,   * blanks, and tabs.  */n {p 	char		*inend; 	int		c;   	inend = &in[size];s 	while (in < inend) { ) 	    c = *in++ & 0177;			/* Eat parity	*/i  	    if (isprint(c) && c != ' ')
 		*out++ = c;f 	} 	*out = EOS; }s   squishfilename(string) char		*string; /*F  * Removes non rad-50 characters (except '/' and all but the last '.')  * from the argument.   */o {t 	register char	*inp; 	register char	*outp;e  1 	for (inp = outp = string; *inp != EOS; *inp++) {  	    if (isalpha(*inp) 	     || isdigit(*inp) 	     || *inp == '/' 	     || *inp == '.')	 		*outp++ = *inp;s 	}
 	*outp = EOS;< 	/*d 	 * Remove all but the last '.'  	 */* 	if ((inp = strrchr(string, '.')) != NULL)* 	    *inp = '~';			/* Remember last '.'	*/6 	for (inp = string; (inp = strchr(inp, '.')) != NULL;)1 	    strcpy(inp, inp + 1);	/* Erase other dots	*/.) 	if ((inp = strchr(string, '~')) != NULL)s+ 	    *inp = '.';			/* Fix last one again	*/r }n   /*  *			G E T O P T I O N S  *>  * Generalized command line argument processor.  The following!  * types of arguments are parsed: 3  *	flags		The associated int global is incremented:o  *			-f	f-flag set to 1 +  *			-f123	f-flag set to 123 (no separator)L'  *			-fg	f-flag and g-flag incremented..3  *	values		A value must be present.  The associated #  *			int global receives the value:   *			-v123	value set to 123n  *			-v 123	value set to 1230  *	arguments	The associated global (a char *) is  *			set to the next argument:!  *			-f foo	argument set to "foo"l  */r   #define	FLAG	0 #define	VALUE	1*
 #define	ARG	2e #define	ERROR	3    typedef struct argstruct { 	char	opt;		/* Option byte			*/-" 	char	type;		/* FLAG/VALUE/ARG		*/- 	int	*name;		/* What to set if option seen	*/-, 	char	*what;		/* String for error message	*/ } ARGSTRUCT;   static ARGSTRUCT arginfo[] = {/ 	{	'a',	FLAG,	&ascii,		"always ascii output"	},*0 	{	'b',	FLAG,	&binary,	"always binary output"	},- 	{	'd',	ARG,	&dirfile,	"directory command"	},t+ 	{	'h',	ARG,	&header,	"file name header"	},l0 	{	'n',	FLAG,	&nopath,	"ignore archive paths"	},+ 	{	'q',	FLAG,	&query,		"query each file"	},a, 	{	't',	FLAG,	&list,		"list entries only"	},% 	{	'v',	FLAG,	&verbose,	"verbose"		},t 	{	EOS,	ERROR,	NULL,		NULL			},  };   static char *argtype[] = {( 	"flag", "takes value", "takes argument" }; T static getoptions(argc, argv)
 int		argc;
 char		**argv;t /*  * Process arg's  */n {, 	register char		*ap; 	register int		c;& 	register ARGSTRUCT	*sp;	 	int			i;' 	int			helpneeded;   	getredirection(argc, argv); 	helpneeded = FALSE; 	for (i = 1; i < argc; i++) {	0 	    if ((ap = argv[i]) != NULL && *ap == '-') { 		argv[i] = NULL;n# 		for (ap++; (c = *ap++) != EOS;) {o 		    c = tolower(c);, 		    sp = arginfo;;, 		    while (sp->opt != EOS && sp->opt != c) 			sp++; 		    switch (sp->type) {t% 		    case FLAG:			/* Set the flag	*/; 			if (!isdigit(*ap)) {P 			    ++(*sp->name); 
 			    break;	 			} 		    case VALUE:			/* -x123	*/S 		        if (isdigit(*ap)) {h& 			    *((int **)sp->name) = atoi(ap); 			    *ap = EOS;A 			}' 			else if (*ap == EOS && ++i < argc) {(+ 			    *((int **)sp->name) = atoi(argv[i]);v 			    argv[i] = NULL; 			}	 			else {  			    fprintf(stderr, 				"Bad option '%c%s' (%s)",  				c, ap, sp->what); & 			    fprintf(stderr, ", ignored\n"); 			    helpneeded++; 			}	 			break;/   		    case ARG:			/* -x foo	*/ 			if (++i < argc) {' 			    *((char **) sp->name) = argv[i];  			    argv[i] = NULL; 			}	 			else {( 			    fprintf(stderr,$ 				"Argument needed for '%c' (%s)", 				c, sp->what);}& 			    fprintf(stderr, ", ignored\n"); 			    helpneeded++; 			}	 			break;r   		    case ERROR:[ 			fprintf(stderr,, 			    "Unknown option '%c', ignored\n", c); 			helpneeded++;	 			break;, 		    }) 		}	 	    } 	} 	if (helpneeded > 0) {/ 	    for (sp = arginfo; sp->opt != EOS; sp++) { & 		fprintf(stderr, "'%c' -- %s (%s)\n",, 		    sp->opt, sp->what, argtype[sp->type]); 	    } 	} }[ = int; getyesno(prompt, normal)$ char	*prompt;		/* Prompt string			*/2 char	*normal;		/* Default answer "Yes" or "No"		*/ /*  * Asks a yes/no question.  */n {e 	register char	*lp;r   	for (;;) {E< 	    fprintf(stderr, "%s? (Yes/No) <%s>: ", prompt, normal); 	    if (!getcommand())+1 		return(FALSE);	/* End of file is very false		*/l 	    if (line[0] == EOS) 		strcpy(line, normal);E( 	    for (lp = line; *lp != EOS; lp++) { 		if (isupper(*lp))> 		    *lp = tolower(*lp);t 	    }! 	    if (strcmp(line, "yes") == 0p! 	     || strcmp(line, "ye")  == 0r" 	     || strcmp(line, "y")   == 0) 		return (TRUE);% 	    else if (strcmp(line, "no") == 0e! 	     || strcmp(line, "n")  == 0)p 		return (FALSE); 7 	    fprintf(stderr, "Please answer 'yes' or 'no'.\n");l 	} }    inte getcommand() /*,  * Read text from keyboard to global line[].@  * Return FALSE on end of file.  Note: rt11 probably trashes the+  * job so you'll never see the end of file.l  */  {  	register char	*lp;t 	register char	c;s   	lp = line;s! 	while ((c = getchar()) != EOF) {"6 	    if (c == EOS || c == '\r')		/* Skip CR or NULL	*/# 		continue;			/* Rt11 last block	*/o 	    if (c == '\n') {m 		/*  		 * Squeeze out trailing blanks 		 */f* 		while (lp > line && lp[-1] == ' ') lp--;
 		*lp = 0; 		return(TRUE);m 	    } 	    *lp++ = c;f 	} 	line[0] = EOS;l 	return(FALSE);r }A     e /*<  * getredirection() is intended to aid in porting C programs7  * to VMS (Vax-11 C) which does not support '>' and '<' 7  * I/O redirection.  With suitable modification, it may)1  * useful for other portability problems as well.k  */    #include	<stdio.h>   getredirection(argc, argv)
 int		argc;
 char		**argv;  /*=  * Process vms redirection arg's.  Exit if any error is seen.-D  * If getredirection() processes an argument, argv[i], it is changed  * to NULL.[  *>  * Warning: do not try to simplify the code for vms.  The codeA  * presupposes that getredirection() is called before any data isd(  * read from stdin or written to stdout.  *  * Normal usage is as follows:  *  *	main(argc, argv)t
  *	int		argc;   *	char		*argv[];   *	{  *		register int		i;  *		int			nargs;  *4  *		getredirection(argc, argv);	** setup redirection+  *		for (nargs = 0, i = 1; i < argc, i++) {n1  *		    if (argv[i] == NULL)	** skip if processedr&  *			continue;		** by getredirection())  *		    nargs++;			** here is an argument !  *		    ...				** process argv[i]t  *		}r,  *		if (nargs == 0) {		** no arguments given  *		    ...d  *		}r  *	}  */d {.
 #ifdef	vms+ 	register char		*ap;	/* Argument pointer	*/r 	int			i;	/* argv[] index		*/*# 	int			file;	/* File_descriptor 	*/ - 	extern int		errno;	/* Last vms i/o error 	*/a  4 	for (i = 1; i < argc; i++) {	/* Do all arguments	*/0 	    if (*(ap = argv[i]) == '<') {  /* <file		*/* 		if (freopen(++ap, "r", stdin) == NULL) {( 		    perror(ap);		/* Can't find file	*/) 		    exit(errno);	/* Is a fatal error	*/  		}i+ 		goto erase_arg;		/* Ok, erase argument	*/m 	    }3 	    else if (*ap++ == '>') {	/* >file or >>file	*/ ! 		if (*ap == '>') {	/* >>file		*/i 		    /*3 		     * If the file exists, and is writable by us,d6 		     * call freopen to append to the file (using the7 		     * file's current attributes).  Otherwise, createt3 		     * a new file with "vanilla" attributes as if// 		     * the argument was given as ">filename". 3 		     * access(name, 2) is TRUE if we can write ono 		     * the specified file.	 		     */e! 		    if (access(++ap, 2) == 0) {m* 			if (freopen(ap, "a", stdout) == NULL) { 			    perror(ap); 			    exit(errno);* 			} 			else goto erase_arg;*" 		    }			/* If file accessable	*/( 		    else ;		/* Else it's just >file	*/ 		}e 		/*8 		 * On vms, we want to create the file using "standard"5 		 * record attributes.  create(...) creates the filee3 		 * using the caller's default protection mask andm/ 		 * "variable length, implied carriage return"w8 		 * attributes. dup2() associates the file with stdout. 		 */e6 		if ((file = creat(ap, 0, "rat=cr", "rfm=var")) == -1) 		 || dup2(file, fileno(stdout)) == -1) {r* 		    perror(ap);		/* Can't create file	*/) 		    exit(errno);	/* is a fatal error	*/; 		}			/* If '>' creation	*/ 6 erase_arg:	argv[i] = NULL;		/* red. erases argument	*/ 	    }				/* If redirection	*/ 	}				/* For all arguments	*/f #endif }u g
 #ifdef	vms /*  * VMS error formatter  */	  7 static char		errname[257];	/* Error text stored here	*/uA static $DESCRIPTOR(err, errname);	/* descriptor for error text	*/      char * vms_etext(errorcode) int		errorcode;2 {l 	char		*bp;o* 	short		errlen;		/* Actual text length		*/  0 	lib$sys_getmsg(&errorcode, &errlen, &err, &15); 	/*; 	 * Trim trailing junk.n 	 */0 	for (bp = &errname[errlen]; --bp >= errname;) {$ 	    if (isgraph(*bp) && *bp != ' ') 		break; 	}
 	bp[1] = EOS;f 	return(errname);i }f #endif  