!### makefile for XVMSUTILS object library

TARGET = XVMSUTILS
TARGET_TYPE = object library

CC_DEFINES = /DEF=(VMS) 

.ifdef __DECC__
CC_QUALIFIER = /NODEB/prefix=all/EXT=COMM
.ifdef __alpha__
MACRO_QUAL = /MIGRATION/NOFLAG/NODEB
.else
MACRO_QUAL = /NODEB
.endif
.endif

.ifdef __VAXC__
CC_QUALIFIER = /NODEB/OPT=(D,I)
MACRO_QUAL = /NODEB
.endif

!### X11 Rules and Macros

!### OpenVMS AXP #############################################################

.ifdef __alpha__
PLATFORM      = OpenVMS AXP ''f$getsyi(""VERSION"")'
OBJ_EXT       = OBJ_Alpha
EXE_EXT       = EXE_Alpha
MAP_EXT       = MAP_Alpha
MAR_EXT       = MAR_Alpha
OLB_EXT       = OLB_Alpha
OPT_EXT       = OPT_Alpha
.endif

!### OpenVMS VAX #############################################################

.ifdef __vax__
PLATFORM      = OpenVMS VAX ''f$getsyi(""VERSION"")'
OBJ_EXT       = OBJ
EXE_EXT       = EXE
MAP_EXT       = MAP
OLB_EXT       = OLB
OPT_EXT       = OPT
.endif

!### Compiler Specifications #################################################

.ifdef __DECC__
CC_COMMAND = $(__DECC__)
CC_COMPILER = DEC C
.endif

.ifdef __VAXC__
CC_COMMAND = $(__VAXC__)
CC_COMPILER = VAX C
.endif

.SUFFIXES :
.SUFFIXES : .$(EXE_EXT) .$(OLB_EXT) .$(OBJ_EXT) .c .mar

!### Linker Specifications ###################################################

.ifdef __DECC__
RTL_LIBRARY = SYS$SHARE:DECC$SHR.EXE/SHARE
.endif

.ifdef __VAXC__
RTL_LIBRARY = SYS$SHARE:VAXCRTL.EXE/SHARE
.endif

!### X11 Release Specifications ##############################################

.ifdef X11R5
IF_R4 = if "?" .eqs. "" then
IF_R5 = 
.endif

.ifdef X11R4
IF_R4 =
IF_R5 = if "?" .eqs. "" then
.endif

!### First Action ############################################################

.FIRST
   @		write_ sys$output ""
   @		write_ sys$output "  Target:       $(TARGET)"
   @ $(IF_R4)	write_ sys$output "  Platform:     X11 Release 4 on $(PLATFORM)"
   @ $(IF_R5)	write_ sys$output "  Platform:     X11 Release 5 on $(PLATFORM)"
   @		write_ sys$output "  Compiler:     $(CC_COMPILER) invoked by $(__DECC__)$(__VAXC__)"
   @		write_ sys$output "  CC Qualifier: $(CC_QUALIFIER)"
   @            mms_temp := $(CC_DEFINES)
   @		write_ sys$output "  CC Defines:   ",mms_temp
   @		write_ sys$output "  Current default: ''f$environment(""default"")'"
   @		write_ sys$output ""
   @		write_ sys$output "  Starting production of $(TARGET) $(TARGET_TYPE)"

!### Compiler Instructions ###################################################

.C.$(OBJ_EXT)
 @ write_ sys$output "  compiling: $(MMS$SOURCE)	-> $(MMS$TARGET)"
 @ $(CC_COMMAND)$(CC_QUALIFIER)$(CC_DEFINES) /obj=$(MMS$TARGET) $(MMS$SOURCE)

.MAR.$(OBJ_EXT)
 @ write_ sys$output "  compiling: $(MMS$SOURCE)	-> $(MMS$TARGET)"
 @ MACRO_ $(MACRO_QUAL) /OBJ=$(MMS$TARGET) $(MMS$SOURCE)   


!### Objects ###################################################################

OBJS =\
CHOOSE_WINDOW.$(OBJ_EXT),\
GETOPT.$(OBJ_EXT),\
GETHOSTNAME.$(OBJ_EXT),\
PRINT_EVENT.$(OBJ_EXT),\
PSEUDO_ROOT.$(OBJ_EXT),\
RANDOM.$(OBJ_EXT),\
TEMPNAM.$(OBJ_EXT),\
TIMER.$(OBJ_EXT),\
UNIX_TIMES.$(OBJ_EXT),\
UNLINK.$(OBJ_EXT),\
DIRECTORY.$(OBJ_EXT),\
CREATE_DIR.$(OBJ_EXT),\
VALIDATE.$(OBJ_EXT),\
HPWD.$(OBJ_EXT),\
VMS_STAT.$(OBJ_EXT),\
USLEEP.$(OBJ_EXT),\
LNM.$(OBJ_EXT),\
STRINGS.$(OBJ_EXT)

.ifdef X11R5
OBJS2 =
OBJS3 =
.else
OBJS2 =\
XMISC.$(OBJ_EXT)
OBJS3 =\
,$(OBJS2)
.endif


!### Targets ##################################################################

DEFAULT       :  $(TARGET).$(OLB_EXT)
   @  write_ sys$output ""
   @  write_ sys$output "  $(TARGET).$(OLB_EXT) available"
   @  write_ sys$output ""

GETPWNAM.$(OBJ_EXT) : getpwnam.c
 @ write_ sys$output "  compiling: $(MMS$SOURCE)	-> $(MMS$TARGET)"
 @ $(CC_COMMAND)$(CC_QUALIFIER)$(CC_DEFINES)/stand=vaxc /obj=$(MMS$TARGET) $(MMS$SOURCE)
$(TARGET).$(OLB_EXT) :  $(OBJS) $(OBJS2) getpwnam.$(OBJ_EXT)
   @ WRITE_ SYS$OUTPUT "  creating library $(TARGET).$(OLB_EXT) ..."
   @ LIBRARY_/OBJECT/CREATE $(TARGET).$(OLB_EXT) $(OBJS) $(OBJS3),getpwnam.$(OBJ_EXT)
