$! Program:	Operating-system dependent routines -- VMS version
$!
$! Author:	Yehavi Bourvine, The Hebrew University of Jerusalem.
$!		Internet: Yehavi@VMS.huji.ac.il
$!
$! Date:	2 August 1994
$! Last Edited:	6 October 1994
$!
$! Copyright 1994 by the University of Washington
$!
$!  Permission to use, copy, modify, and distribute this software and its
$! documentation for any purpose and without fee is hereby granted, provided
$! that the above copyright notice appears in all copies and that both the
$! above copyright notice and this permission notice appear in supporting
$! documentation, and that the name of the University of Washington not be
$! used in advertising or publicity pertaining to distribution of the software
$! without specific, written prior permission.	This software is made available
$! "as is", and
$! THE UNIVERSITY OF WASHINGTON DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
$! WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED
$! WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN
$! NO EVENT SHALL THE UNIVERSITY OF WASHINGTON BE LIABLE FOR ANY SPECIAL,
$! INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
$! LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT
$! (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION
$! WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
$!
$! VMSBUILD.COM for C-CLIENT.
$ CREATE LINKAGE.H
$ DECK
extern DRIVER imapdriver, nntpdriver, vmsmaildriver;
$ EOD
$ CREATE LINKAGE.C
$ DECK
    mail_link((DRIVER *)&imapdriver);
    mail_link((DRIVER *)&nntpdriver);
    mail_link((DRIVER *)&vmsmaildriver);
$ EOD
$ PURGE LINKAGE.*
$
$!
$ if (P2 .eqs. "DEBUG")
$   then
$     CC = "CC/DEBUG/NOOPT"
$     LINK = "LINK/DEBUG"
$   else
$     CC = "CC"
$     LINK= "LINK"
$ endif
$
$ COPY OS_VMS.H OSDEP.H;	! Get the VMS specific header file in place
$ purge osdep.h
$
$! Set things up for the appropriate C compiler
$ CC_PREF = ""
$ LINK_OPT = ""
$ IF F$SEARCH("SYS$SYSTEM:DECC$COMPILER.EXE") .NES. ""
$ THEN
$! Don't want to access include files from sys$library in case VAXC exists!!
$	IF F$TRNLNM("SYS")     .NES. "" THEN $ DEASSIGN SYS
$	IF F$TRNLNM("NETINET") .NES. "" THEN $ DEASSIGN NETINET
$	IF F$TRNLNM("ARPA")    .NES. "" THEN $ DEASSIGN ARPA
$
$	CC_PREF = CC_PREF + "/PREFIX=(ALL,EXCEPT=(SOCKET,CONNECT,BIND,LISTEN,SOCKET_READ,SOCKET_WRITE,SOCKET_CLOSE,SELECT,ACCEPT,BCMP,BCOPY,BZERO,GETHOSTBYNAME,"
$	CC_PREF = CC_PREF + "GETHOSTBYADDR,GETPEERNAME,GETDTABLESIZE,HTONS,HTONL,NTOHS,NTOHL,SEND,SENDTO,RECV,RECVFROM))"
$	CC_PREF = CC_PREF + "/STANDARD=VAXC"
$	CC_PREF = CC_PREF + "/DEFINE=(_DECC_V4_SOURCE,_XOPEN_SOURCE_EXTENDED,VMSIO,''P1')"
$	CC_PREF = CC_PREF + "/WARNING=DISABLE=TOOFEWACTUALS
$!	CC_PREF = CC_PREF + "/LIST/SHOW=ALL"
$ ELSE
$       DEFINE SYS     SYS$LIBRARY
$	DEFINE NETINET SYS$LIBRARY
$	DEFINE ARPA    SYS$LIBRARY
$	CC_PREF  = CC_PREF + "/NOWARNINGS"
$	CC_PREF  = CC_PREF + "/DEFINE=(VMSIO,''P1')"
$	LINK_OPT = LINK_OPT + ",VMS_LINK/OPTION"
$	COPY SYS$LIBRARY:CTYPE.H *.*;
$ ENDIF
$
$
$!
$! DETERMINE NETWORK SUPPORT
$!
$ COPY TCP_VMSN.C TCP_VMS.C;	! Default - no TcpIp support.
$ purge tcp_vms.c
$
$ IF F$LOCATE("MULTINET", P1) .LT. F$LENGTH(P1)
$ THEN
$	COPY TCP_VMSM.C TCP_VMS.C;	! Multinet support.
$       purge tcp_vms.c
$	DEFINE SYS     MULTINET_ROOT:[MULTINET.INCLUDE.SYS]
$	DEFINE NETINET MULTINET_ROOT:[MULTINET.INCLUDE.NETINET]
$	DEFINE ARPA    MULTINET_ROOT:[MULTINET.INCLUDE.ARPA]
$       CC_PREF    = CC_PREF + "/INCLUDE=([],MULTINET_ROOT:[MULTINET.INCLUDE])"
$	LINK_OPT   = ",[---]VMS_MULTINET_LINK/OPTION" + LINK_OPT
$ ENDIF
$ IF F$LOCATE("NETLIB", P1) .LT. F$LENGTH(P1)
$ THEN
$	COPY TCP_VMSL.C TCP_VMS.C;	! Netlib support.
$       purge tcp_vms.c
$       CC_PREF    = CC_PREF + "/INCLUDE=([])"
$	LINK_OPT   = ",[---]VMS_NETLIB_LINK/OPTION" + LINK_OPT
$ ENDIF
$!
$
$ SET VERIFY
$ CC/NOOPTIMIZE'CC_PREF' OS_VMS
$ CC/NOOPTIMIZE'CC_PREF' vms_mail
$ CC/NOOPTIMIZE'CC_PREF' MAIL
$ CC/NOOPTIMIZE'CC_PREF' SMTP
$ CC/NOOPTIMIZE'CC_PREF' RFC822
$ CC/NOOPTIMIZE'CC_PREF' NEWSRC
$ CC/NOOPTIMIZE'CC_PREF' NNTP
$ CC/NOOPTIMIZE'CC_PREF' nntpcvms
$ CC/NOOPTIMIZE'CC_PREF' MISC
$ CC/NOOPTIMIZE'CC_PREF' IMAP2
$ CC/NOOPTIMIZE'CC_PREF' SM_VMS
$!
$ CC/NOOPTIMIZE'CC_PREF' MTEST
$ CC/NOOPTIMIZE'CC_PREF'/OBJ=[]IMAPD.OBJ [-.IMAPD]IMAPD
$!
$ LIBRARY/OBJECT/CREATE/INSERT C-CLIENT OS_VMS,vms_mail,MAIL,SMTP,RFC822,-
	NEWSRC,NNTP,nntpcvms,MISC,IMAP2,SM_VMS
$ PURGE C-CLIENT.OLB
$!
$ SET NOVERIFY
$ LINK MTEST,IMAP2,MAIL,MISC,NNTP,newsrc,nntpcvms,OS_VMS,RFC822,SMTP,-
  SM_VMS,VMS_MAIL,SYS$INPUT:/OPTION'LINK_OPT'
PSECT=_CTYPE_,NOWRT
$ LINK IMAPD,IMAP2,MAIL,MISC,NEWSRC,NNTP,nntpcvms,OS_VMS,RFC822,SMTP,-
   SM_VMS,VMS_MAIL'LINK_OPT'
$ IF F$SEARCH("CTYPE.H") .NES. "" THEN $ DELETE CTYPE.H;*
$ PURGE *.OBJ
$ PURGE *.EXE
$ EXIT
