/*
CONLDR.C -- Win32 app to interface with FILEMON.VXD
File I/O monitor for Windows 95
Rename to FILEMON.EXE
Stan Mitchell

See Stan Mitchell, "Monitoring Windows 95 File Activity in Ring 0,"
Windows/DOS Developer's Journal, July 1995, pp. 6-24.

Also see ftp://ftp.ora.com/pub/examples/windows/win95.update/regwiz.html
*/

/*****       Listing 5    CONLDR.C       *****/
#include <stdio.h>
#include <windows.h>
/* OpenVxDHandle */
typedef HANDLE (WINAPI * OVH)( HANDLE ring3 ); 

char *pszBase = "FILEMON"; /* Name of device */
char szVxDName[MAX_PATH];
HANDLE hVxD, hEvent, hEventRing0, hMap;

#define DIOC_REQEVENTS 1
#define DIOC_SHUTDOWN  2
#define DevOut(hDev,nAPI,Data) \
    DeviceIoControl( hDev, nAPI, (LPVOID)Data, \
        sizeof(Data), NULL, 0, NULL, NULL )

typedef char LINE[128]; /* up to 128 char */
#define MAXLINE 254 /* 255 line circular buffer */
#define BUFSIZE (sizeof(LINE)*(MAXLINE+2))
LINE* pLineBuf; /* buffer filled by FILEMON */
LPDWORD pdw; /* first line used for line ptrs */

#define PRTLINE( l ) puts(l)  

/* Control-C Termination Handler */
BOOL WINAPI CtrlHandler( DWORD fdwCtrlType ) {
    DevOut( hVxD, DIOC_SHUTDOWN, NULL ); 
    if ( CloseHandle( hVxD ) )
        printf("%s unloaded\n",pszBase);
    else  
        printf("Failed unloading %s\n",pszBase);

    UnmapViewOfFile( pdw );
    CloseHandle( hMap );
    CloseHandle( hEvent );
	FlushFileBuffers(GetStdHandle(STD_OUTPUT_HANDLE));
    return FALSE; /* call ExitProcess */
    }

/* Load FILEMON.VXD and display its output buffer */
void main( int argc, char* argv[] ) {
    DWORD   SendInfo[2];
	OVH lpfn = (OVH)GetProcAddress( 
		GetModuleHandle("kernel32"),"OpenVxDHandle");
	if (lpfn == NULL) {
		printf("Requires Windows 95\n");
		exit(1);
		}
    wsprintf( szVxDName, "\\\\.\\%s", pszBase );
    hVxD = CreateFile( szVxDName, 0, 0, 0, 0, 0, 0 );

    if ( hVxD == INVALID_HANDLE_VALUE ) {
        strcat( szVxDName, ".vxd" );
        hVxD = CreateFile( szVxDName, 0, 0, 0, 
           CREATE_NEW, FILE_FLAG_DELETE_ON_CLOSE, 0 );
        if ( hVxD == INVALID_HANDLE_VALUE ) {
            printf( "Failed loading %s\n", pszBase );
            exit(1);
            }
        else printf( "%s is loaded\n", pszBase );
        }
    else {
        printf("%s is already loaded\n", pszBase);
        exit(0);
        }

    hMap = CreateFileMapping( (HANDLE)0xffffffff, 
            NULL, PAGE_READWRITE, 0, BUFSIZE, NULL );
    if (hMap == NULL) goto error; 
    pdw = MapViewOfFile( hMap,FILE_MAP_WRITE,0,0,0 );
    if (pdw == NULL) goto error;
    pLineBuf = ((LINE*)(pdw))+1;

    SetConsoleCtrlHandler(CtrlHandler,TRUE);
    /* event signaled by FILEMON */
    hEvent = CreateEvent(NULL,FALSE,FALSE,"FMEvent");
    hEventRing0 = (*lpfn)( hEvent );

    while( 1 ) {
        int justAdd, prevOut, k;

        SendInfo[0] = (DWORD)hEventRing0; 
        SendInfo[1] = (DWORD)pdw;
        /* Request lines from FILEMON */
        DevOut( hVxD, DIOC_REQEVENTS, SendInfo );        
        /* FILEMON signals when output ready */
        switch(WaitForSingleObject(hEvent,INFINITE)) {
        case WAIT_OBJECT_0:
            justAdd = *pdw;
            prevOut = *(pdw+1);
            if ( justAdd < prevOut ) { // wrap
                for (k=prevOut+1;k<=MAXLINE;k++)
                    PRTLINE( pLineBuf[k] );
                for (k=0;k<=justAdd;k++)
                    PRTLINE( pLineBuf[k] );
                }
            else if ( justAdd > prevOut )
                for (k=prevOut+1;k<=justAdd;k++)
                    PRTLINE( pLineBuf[k] );

            *(pdw+1) = justAdd;
            break;
            }
        } // while
    error:
        GenerateConsoleCtrlEvent(CTRL_C_EVENT,0);
    }
/******************* end of file ********************/

