      REAL*8 FUNCTION STAT_NORM_ACC(X)
      REAL*8 X
C
      REAL*8 ZERO,HALF,ONE,TWO,FOUR,TEN
      PARAMETER (ZERO=0.0D0,HALF=0.5D0,ONE=1.0D0,
     +           TWO=2.0D0,FOUR=4.0D0,TEN=10.0D0)
C
C     Local variables
      INTEGER*4 I
      REAL*8 TMP,ADD
C
C     Functions
      REAL*8 STAT_NORM_DENS
C
C     Test if x=0
      IF(X.EQ.0) THEN
        STAT_NORM_ACC=HALF
        RETURN
      ENDIF
C
C     Test if x very small/large
      IF(X.LT.-6) THEN
        STAT_NORM_ACC=ZERO
        RETURN
      ELSE IF(X.GT.6) THEN
        STAT_NORM_ACC=ONE
        RETURN
      ENDIF
C
C     Compute F(x)=INTG(f(t),t=-INF,x)
      IF(ABS(X).GT.2.5D0) THEN
        TMP=ABS(X)
        DO 100 I=10,1,-1
          TMP=ABS(X)+I/TMP
100     CONTINUE
        IF(X.GE.ZERO) THEN
          STAT_NORM_ACC=ONE-STAT_NORM_DENS(X)/TMP
        ELSE
          STAT_NORM_ACC=STAT_NORM_DENS(X)/TMP
        ENDIF
      ELSE
        TMP=ZERO
        ADD=ABS(X)
        DO 200 I=1,11
          TMP=TMP+ADD
          ADD=ADD*X*X/(2*I+1)
200     CONTINUE
        IF(X.GE.ZERO) THEN
          STAT_NORM_ACC=HALF+STAT_NORM_DENS(X)*TMP
        ELSE
          STAT_NORM_ACC=HALF-STAT_NORM_DENS(X)*TMP
        ENDIF
      ENDIF
C
      RETURN
      END
C*******************
      REAL*8 FUNCTION STAT_NORM_DENS(X)
      REAL*8 X
C
C     Global variables
      REAL*8 PI
      PARAMETER (PI=3.141592653589793D0)
C
      REAL*8 ZERO,HALF,ONE,TWO,FOUR,TEN
      PARAMETER (ZERO=0.0D0,HALF=0.5D0,ONE=1.0D0,
     +           TWO=2.0D0,FOUR=4.0D0,TEN=10.0D0)
C
C     Compute f(x)=1/sqrt(2*pi)*exp(-x^2/2)
      STAT_NORM_DENS=EXP(-(X*X)/TWO)/SQRT(2*PI)
C
      RETURN
      END
C*******************
      REAL*8 FUNCTION STAT_NORM_INVACC(X)
      REAL*8 X
C
      REAL*8 ZERO,HALF,ONE,TWO,FOUR,TEN
      PARAMETER (ZERO=0.0D0,HALF=0.5D0,ONE=1.0D0,
     +           TWO=2.0D0,FOUR=4.0D0,TEN=10.0D0)
C
C     Local variables
      REAL*8 Z,ZNEW,RELCHA
C
C     Functions
      REAL*8 STAT_NORM_DENS,STAT_NORM_ACC
C
C     Test if x=0.5
      IF(X.EQ.HALF) THEN
        STAT_NORM_INVACC=ZERO
        RETURN
      ENDIF
C
C     Compute z=z-(f(z)-x)/f'(z)
      IF(X.LT.HALF) THEN
        Z=-ONE
      ELSE IF(X.GT.HALF) THEN
        Z=ONE
      ENDIF
100   ZNEW=Z-(STAT_NORM_ACC(Z)-X)/STAT_NORM_DENS(Z)
      RELCHA=ZNEW/Z
      IF(RELCHA.LT.ONE-1.0D-4.OR.RELCHA.GT.ONE+1.0D-4) THEN
        Z=ZNEW
        GOTO 100
      ENDIF
      STAT_NORM_INVACC=ZNEW
C
      RETURN
      END
