C C FILFIX - Routine to do the grunt work of handling file "get ready  C to Open" processing. C By Glenn C. Everhart3 C Copyright 1992 Raxco, Inc.   All rights reserved.  c  c Modifications: (V3B)G c  1. Open ISAM file for shared access so access from multiple nodes in - c     a cluster will only see locked records. D c  2. Delay for awhile and retry opens where we find a record lockedB c     so that opens during expansion/replacement of a file will be; c     delayed until that is complete or has totally failed. H c  3. Delete the ISAM record only when we know we'll remove the markingsE c     on the file, so the record lock held here will stay until we're  c     totally done with it.  c F c This version handles authentication requests also. These are flagged8 c by the datafile having the usedfg flag 2 or above. The% c copy mode may be NONE in this case.  c; Data sent to us is:+ c;	.long LDT address	;(LOTS of info in LDT) . c;				;(At this point the LDT is not truncated- c;				; so all info about user's original IRP  c;				; is there too.)8 c;	.long S-KAST address	; should force special kast hereA c;	.long VR-UCB address	; may be handy to have the ucb addr there 8 c;	.long ACE address	; pointer at our ACE for easier use c u_arg:	 c	.long	9  c ubfad: .long	0	;buffer addr  c	.address	bfsz 2 c	.address	jddfnm	; descriptor of journal filename4 c	.address	jnm	;flag if nonzero that filename exists c	.address	ufid	;file ID- c	.address	uopnmd	;open mode from FIB$l_acctl  c	.address	uace	;our ACE- c	.address	udvc	;device name (count byte 1st)  c	.address	uunit	;unit no.;  c;% c;Now we call routine filfix. Call is L c;  call filfix(argbuf,bufsz,jnlfil,jnlflg,ufid,uopnmd,uace,udvc,uunit,nfre) c;where ; c;	argbuf has LDT addr., SKAST addr, UCB addr, and ACE addr  c;	bfsz is always 16 bytes= c;	jnlfil passes on the command line's file descriptor if any . c;	jnlflg is 1 if jnlfil has data, 0 otherwise" c;	ufid is file ID, 6 bytes' worth5 c;	uopnmd is open mode, from the FIB...tells how open 7 c;	uace is our ACE, all of it, copied to a local buffer ; c;	udvc is a counted ASCII string of device name (e.g. VRA)  c;	uunit is binary unit number c  c  c A c  Note: If ACE copy returned to us does not have ascii "RAXC" as > c  bytes 9-12 and has a number >512 in its' start, and has the< c  flag long at ace+4 has the 262144 bit set, this flags theB c  ACE is not ours, but vrdriver could not read the entire ACL andB c therefore the ACL must be read here and checked for our ACE, andD c the ACE acted upon if called for and written to the LDT (which our( c caller will do if we fill in uace...). C D C  Note that the ISAM file we deal with here is indexed basically byD C the complete file ID of the target file. This simplifies a cleanup@ C pass which can go through the file and remove all entries thatC C correspond to files which were deleted without having been opened B C and thus whose entries here can dangle. The key is declared as 8@ C characters, but used as integers, since VAX Fortran lacks an 8D C byte integer. (Alpha will fix that!). If the file is opened first,G C the ISAM record gets deleted at that time, of course. It is not clear H C what exactly the policy should be toward deletes. On the one hand, oneF c could specify that a delete operation deletes the "archived" copy ofI c the file also. On the other hand, it is feasible to argue that a delete E c merely is a form of placing the file further offline, and that some A c "expunge" operation should be required to remove archived files H c which were being made to appear resident. My development leans in thisG c direction, since I view VRdriver as a place for making archived files H c appear local. In the interests of allowing delete to proceed faster onD c the virtual disk, I am disinclined to require an ISAM operation toC c delete them, but prefer that a periodic cleanup be done to handle F c removing records which don't have pointers on the original disks anyF c more. This cleanup should also address whatever other indexing mightC c be wanted for making the archived file copies available via other E c access channels, if any; it is possible the information in the ISAM . c file might be needed for this. - GCE 6/15/92 c B c This version of the open daemon move command uses a command fileC c raxvr_root:filmov.com to do the work of moving files. This allows 1 c more flexible interfacing of archiving systems.  c GCE, 10/92B 	integer*4 function filfix(argbuf,bufsz,jnlfil,jnlflg,ufid,uopnmd,B      1     uace, udvc, uunit, muace,nfree,iepid,ipriv,iunam,iacbw) 	include '($FORIOSDEF)'  	include '($JPIDEF)' 	include '($OPCDEF)' c Mask to check UOPNMD against 	parameter NOWRITFIB = 1E c assume this is FIB$M_NOWRITE, which is true in my $fibdef currently  	integer*4 iepid,ipriv(2),iacbw # c iunam is counted ascii user name.  	integer*1 iunam(16) 	integer*1 xiunam(16)  	character*15 cunam  	equivalence (xiunam(1),cunam) 	integer*4 sys$getjpiw 	external sys$getjpiw  	integer*4 sys$sndopr  	external sys$sndopr 	Integer*4 argbuf(4) 	Integer*4 bufsz,nfree 	Character jnlfil  	integer*4 jnlflg  	Integer*2 uufid(4)  	integer*2 ufid(4) 	integer*4 u4fid(2)  	equivalence(uufid(1),u4fid(1))  	Integer*4 uopnmd  	Logical*1 uace(256) 	integer*4 vlen  	external vlen 	Logical*1 muace(256)  	Logical*1 udvc(16)  	Integer*4 uunit,cmdidx(2) 	character*64 latprt 	character*32 dvcnam 	integer*4 dvcchn  	common/dchn/dvcchn,dvcnam 	character*8 ccmdid  	equivalence(ccmdid,cmdidx(1))! 	integer*4 lib$spawn,status,istat  	external lib$spawn  	character*16 usrnam c	integer for$ios_spereclock 	integer*4 idxcmd  	character*16 fidstr 	character*80 dbnam  	character*80 cln1,cln2  	character*80 fidasc,wf5 	character*132 wrkfnm,wfn2,wdvc  	character*255 oprbc 	integer*4 oprbuf(3) 	character*240 oprmsg  	equivalence(oprmsg,oprbuf(3)) 	equivalence(oprbc,oprbuf(1)) 
 	real*8 xsecs  	integer*4 iios(2)D c The acchk structure is the contents of an ISAM file indexed by FID? c which controls the structure of file access checks done here. ' c Basic checks provided allow checks on # c  Users allowed to access the file  c  Users disallowed access& c  Images permitted access to the file& c  Images forbidden access to the fileC c  Hours the file may be used (and some control on which checks are & c		applied during each of those hours)/ c  Privilege mask max permitted for file access D c (note: for backup, one should disable check, or include the backup# c  account in permitted user list.)  	structure /acchk/	 c file ID  	  integer*4 index(2)  	character*128 fnamidxC c ichk1,2 are checksums. If nonzero, these ust match file checksums E c or access gets denied. Useful for preventing a bogus, say, loginout A c from running. (loginout & set are most common targets of mods.) B c (actually, loginout always starts from system, so not so useful   c there :-( but possible anyhow) 	integer * 4 ichk1 	integer * 4 ichk2F c privs he's allowed to have. If he has more (i.e. clr these ==>non-0) c disallow access. 	  integer*4 privs(2)  c permitted ttys 	  character*128 ttyok+ c list of images the user can have. * = all  	  character*256 imgok3 c list of forbidden images (e.g. "COPY". Omit .exe.  	  character*256 imgko$ c list of hours the access can be inA c use character so each hour can be encoded; for starters use the # c following encoding for the bytes: ( c  N - no access during this time period1 c  Y - access (provided other cuts are satisfied) A c  U - unconditional access, check no further about image or user B c  A - "any" access, don't check image but do check user, terminal 	  character*24 hrs  c list of users that may access  	  character*512 usrs # c list of users that may not access  	  character*512 fusrs; c list of "override" users (for backup, system etc. access) : c Usernames on this list are exempt from all other checks. 	  character*64 ousrs 1 c flags long is for stuff that needs other files. @ c For instance, we can use it for a "virtual softlink" that onlyA c works for denied access (so we allow access BUT edit the ACE to % c add a softlink to some other file).  	integer*4 jflags  	end structure1 c total record size = 1696+64+8 bytes = 442 longs  	record /acchk/accrec  	structure /idxstrc/ 	  integer*4 index(2)  	  character*80 cmd1 c cmd1 stores file spec  	  character*4 cmodeK c cmode= 'copy', 'zip', 'zoo', 'comp', etc. 'NONE' means access check only.  	  integer*4 usedfg Q c usedfg =0 if unused, 1 if used, 3 if used and has to pass access authentication  	  integer*4 filsiz  	end structure 	record /idxstrc/ idxrec 	structure /acerec/  	  integer*4 index(2)  	  integer*1 savace(64)  	end structure 	record /acerec/acebuf 	integer*4 iosb(2),jpiitm(3,4) 	integer*2 jp2itm(6,4)% 	equivalence(jpiitm(1,1),jp2itm(1,1))  c set up jpi itemlist  	character*40 ttyspc 	integer*1 ttyspb(40)  	equivalence(ttyspc,ttyspb(1)) 	character*200 imgspc  	integer*1 imgspb(200) 	equivalence(imgspc,imgspb(1)) 	integer*4 ipnow(2),ipnowl 	integer*4 ttyspl,imgspl 	do 1211 n=1,16  1211	xiunam(n)=iunam(n)  	jpiitm(1,4)=0 	jpiitm(2,4)=0 	jpiitm(3,4)=0 	jp2itm(1,1)=40  	jp2itm(2,1)=JPI$_TERMINAL 	jpiitm(2,1)=%loc(ttyspb(1)) 	jpiitm(3,1)=%loc(ttyspl)  	jp2itm(1,2)=200 	jp2itm(2,2)=JPI$_IMAGNAME 	jpiitm(2,2)=%loc(imgspb(1)) 	jpiitm(3,2)=%loc(imgspl)  	jp2itm(1,3)=8 	jp2itm(2,3)=JPI$_CURPRIV  	jpiitm(2,3)=%loc(ipnow(1))  	jpiitm(3,3)=%loc(ipnowl)  c first scan the ACE c Look for format as follows:  c .byte getctl c .byte getsiz (size of string)  c .ascii /real file loc index/ c c skip c  .byte newid  or .byte newprv 
 c  .blkb 3
 c  .long 0 c  .long 0,0 c  c also skip  c .byte jnlctl,jnlsiz  c .ascii /jnl-loc/% c newid=1, newprv=2,jnlctl=3,getctl=4  c E c first find if there's a file-move command here someplace in the ACE $ c assume success of result initially 	uufid(1)=ufid(1)  	uufid(2)=ufid(2)  	uufid(3)=ufid(3)  	uufid(4)=ufid(4)  	filfix = 1 
 	iacbw = 0 	cmdidx(1)=0 	cmdidx(2)=0 	do 50 n=1,256 	muace(n)=uace(n)  50	continue $ 	call lkpwrk(uace,cmdidx,muace,ufid) 	if (cmdidx(1).eq.0) return ' c cmdidx is index into our cmd datafile  c its' value is the fid.; c now get the filename for our database for this device and , c open that file and seek the cmdidx record. 	dbnam = 'opndb$dir:op' 
 	nlen=udvc(1)  	wdvc=char(udvc(2))  	ldb=ilen(dbnam)# 	dbnam=dbnam(:ldb) // char(udvc(2))  	wfn2=char(udvc(2))  	do 100 n=2,nlen# 	wdvc=wdvc(:n-1) // char(udvc(n+1))  	ldb=ilen(dbnam)% 	dbnam=dbnam(:ldb) // char(udvc(n+1)) % 	wfn2 = wfn2(:n-1) // char(udvc(n+1))  100	continue c wdvc is device name  	ldb=ilen(dbnam) 	dbnam = dbnam(:ldb) // '   ' 
 	nlen=nlen+13  c add unit number  	klen=nlen+2" 	write(dbnam(nlen:klen),1000)uunit 1000	format(i3.3)  	ndvc=ilen(wdvc) 	wdvc=wdvc(:ndvc) // '   '% 	write(wdvc(ndvc+1:ndvc+3),1000)uunit  	ndvc=ilen(wdvc) 	wdvc=wdvc(:ndvc) // ':'7 c now wdvc has a string we can use for the device name. & c now have a filename; add type suffix 	kdvc=ilen(wdvc)@ c set up a channel to dvcnam and delete it around call to redacl, c so this server can handle lots of devices. 	dvcnam=wdvc(:kdvc)  	ldb=ilen(dbnam) 	dbnam = dbnam(:ldb) // '.rxo' c (for Raxco Open)E c Lord only knows why DEC uses RECL in 4 byte units...a holdover from D C IBM mainframes which most other manufacturers have abandonned longC C ago. The last disk DEC sold that had this restriction in hardware F C was the RPR02; the last of those probably broke down 10 years ago... 	ldbn=ilen(dbnam) 6 	OPEN(UNIT=2,FILE=DBNAM(1:ldbn),ORGANIZATION='INDEXED'      1  ,ACCESS='KEYED',SHARED, 6      2  RECORDTYPE='FIXED',RECL=25,FORM='UNFORMATTED',6      3  KEY=(1:8:CHARACTER),STATUS='UNKNOWN',ERR=9999) c read our record if present
 	kount=100. c sanity timer...never wait more than 300 sec. 309	continue4 	read(unit=2,keyeq=ccmdid,keyid=0,iostat=kios)idxrec 	if(kios.eq.0)goto 311 	if(kios.eq.52)then $ c	if(kios.eq.for$ios_spereclock)then c delay, then retry 
 	xsecs=3.0 	call lib$wait(xsecs) " c wait 3 sec, then retry the read. 	kount=kount-1 	if(kount.gt.0)goto 309  	end if 8 c on any other err condition, assume the record os gone. 311	continue 	if(kios.ne.0) goto 10055 c normally fail read when we processed a file before. ! c	if(idxrec.usedfg.ne.0)goto 1005 7 c usedfg was 0 so we haven't pulled this file back yet. > c set it to 1 and write our so we can ensure we don't try this c a second time. ccc	idxrec.usedfg = 1  cccc write the record back out. 3 ccc	rewrite(unit=2,iostat=iios(1),error=9999)idxrec , c delete the record once we're done with it.= c (This acts as our method of ensuring that the file is moved  c  back only once!)  c	delete(unit=2)
 	goto 1006
 1005	continue A c This file was already replaced, so this must be another request A c for the file from someone else. Since it's already in place, we : c have nothing to do. This does require the database to be2 c set up with usedfg=0 when the file is moved out.> c We get here if the record is deleted, note, which means that6 c it is not access checked and the file was moved off. 	close(unit=2)= c If we fail to find the file entry, the ACL should have been 6 c fixed up by some other node, so leave it alone here. 	filfix = 2  	return 
 1006	continue 5 c delay delete & close till the end...only delete the < c record if the file move apparently completed successfully. c	close(unit=2)  	filfix = 1 / c if no error, we get the record of what to do. E c Now for simplicity we create and run a command file. It will assume F c the FILE utility exists and that cmd1 and cmd2 contain the filespecsB c respectively of the file and its' attribute output from the FILEA c utility, and that cmd3 contains the utility command to move the ? c file ("zoo e", "compress -d", "copy", "back/select=something" / c   or the like) so we can compose the request. ? c Much the same for "zip -e" but zip preserves file attributes! ; c Test two characters so we can tell "zip" and "zoo" apart!  c F c Before we do anything else, if there is too little free space on theA c volume for idxrec.filsiz, we must fire up a process to get more ! c space. Do this in a subprocess. @ c Form a command to get space, passing it the device name & unitB c and the number blks needed. This should only return when it getsA c space. It is not necessarily a good space-maker since it should < c run relatively fast, but should get space by moving files > c somewhere or by compressing them, adding ACEs to files it so7 c mungs so they in turn can be grabbed and pulled back.  c = c Check that file motion is even wanted; if copy mode is NONE  c then it isn't.' 	if(idxrec.cmode .eq. 'NONE') goto 2000 * c Add the following if removing file move: c	goto 2000  	nwf=jlen(wfn2) 3 	write(wrkfnm,6005)wfn2(1:nwf), uunit,idxrec.filsiz 3 6005	format('$@raxvr_root:freespace ',a,i3.3,1x,i9) 	 	status=1  	istat=1 	if(idxrec.filsiz.ge.nfree) +      1 	status=lib$spawn(wrkfnm,,,,,,istat) ? c on horrible errors, don't mess with the file; we can't get it A c back, so leave it marked. This will at least give us a fighting ; c chance to get it back later after the user has freed some  c storage by hand. 	if(.not.status)goto 9999  	if(.not.istat)goto 9999 c first formulate the file ID. 	nmx=ufid(3)/256 	nm1=ufid(1)+65536*nmx
 	nseq=ufid(2)  	nrvn=mod(ufid(3),256)  	write(fidasc,1010)nm1,nseq,nrvn. 1010	format(bn,'(',i9.9,',',i5.5,',',i3.3,')') 	write(fidstr,1070)u4fid 1070	format(2z8.8)6 c this generates (filnum,filseq,rvn) text into fidasc.? c Ideally we need to double check the file is what we want here F c by looking at the ace again and skipping out if the ace is gone now,/ c which indicates we fixed this one up already. A c However, we accomplish this here by setting and checking a flag ? c in our database which will allow a file to be moved only once > c until some other process resets it. This means that whatever= c process (a batch or cron job) compresses or moves a file to  c backing store, it must: . c  1. Get exclusive file access for that file.8 c  2. Make the copy of the file to backing store somehow: c  3. Update the database so it will reflect that the file( c	has been stored and how to get it back= c  4. Truncate the file and insert an ACE (or modify one that , c	exists) to indicate the index of the file.B c  In actuality it needs exclusive access only for step 4 provided: c	it is willing to back out steps 2 and 3 if when it tries> c	to get the access for 4 it finds the file is open somewhere.B c  The database record's "usedfg" field should be set to zero when; c	the backing copy is made, remembering that unless our ACE 4 c	is present the backing copy will not be looked at. c now open our scratch file. 	imov=1  	ndvc=ilen(wdvc) c wdvc(:ndvc) is device spec 	nfa=ilen(fidasc)   c fidasc(1:nfa) is file ID ascii 	ncm1=ilen(idxrec.cmd1)  	wf5=idxrec.cmd1(:ncm1)  	nwf5=ilen(wf5)  c wf5(:nwf5) is filename seed  c G c Code in VRDriver will automatically not interfere with our subprocess  c A c Use an externally defined command file to move the file in from > c the device. It is passed copymode, file ID, device name, andA c filename seed so it can pull things back from the storage area. C c The main reason for doing it this way however is that our code in A c the daemon should build in as few assumptions as possible about @ c the moving process, so if a file has to be pulled in from some# c archive, this can be easily done. 7 	write(wfn2,1200)idxrec.cmode,fidasc(:nfa),wdvc(:ndvc),       1  wf5(:nwf5) 	nwf2=jlen(wfn2)8 1200	format('$@raxvr_root:filmov ',a4,' ',a,' ',a,' ',a)) 	status=lib$spawn(wfn2(:nwf2),,,,,,istat)  	iis=istat.and.16 	if(iis.eq.1 .and. idxrec.usedfg .le.1) delete(unit=2)" c on return the job did its' best. c Now done. 
 9999	continue 1 	if(iis.eq.1 .and. idxrec.usedfg .ge.2) goto 2000 % c make sure the isam file gets closed  	close(unit=2)G c Return the status from the spawned job so we don't mess up if spawned @ c job runs into some problems. The archived file needs not to be c disturbed if that happens. 	filfix = istat  	return 
 2000	continue 6 c authenticate this file only, or authenticate access.5 c first ensure the database is set for any next time.  	idxrec.cmode = 'NONE' 	idxrec.usedfg = 2 	rewrite(unit=2,err=2001)idxrec 
 2001	continue = c we have the file id now and so on. Open another file to see . c what (if any) access controls to add for it. c set name to ACdevunit.RXO  	dbnam(11:12)='AC' 	filfix = istat = c Open the access check file readonly, since we write nothing @ c into it here and want to ensure that as many readers at a time c as want access can have it. 6 	OPEN(UNIT=3,FILE=DBNAM(1:ldbn),ORGANIZATION='INDEXED'!      1  ,ACCESS='KEYED',READONLY, 7      2  RECORDTYPE='FIXED',RECL=482,FORM='UNFORMATTED', 6      3  KEY=(1:8:CHARACTER),STATUS='UNKNOWN',ERR=9990)4 	read(unit=3,keyeq=ccmdid,keyid=0,iostat=kios)accrec
 c	filfix=kios ; c now do the actual authentication checks on our dear user. 4 c his PID is available via the LDT. Ditto his privs.' c ldt$l_orgprv (40) off ldt is privmask G c ldt$l_regs+8 = saved R4 =PCB address. pcb$l_epid has epid. ldt$l_regs 9 c value is 352, so offset 360 has saved R4 = pcb address.  c pcb$l_epid = 100 c pcb$l+jib = 120.> c jib$t_username = 12 byte counted ascii username, offset = 12 c B c These are loaded by our caller (from knl mode!) and passed to us c in the last 3 args. 3 c don't mess with the ACE, so put the original back 7 c Do this only if i/o status indicated we got a record! B c If we know that we were called for NO file movement, also ensure? c the record is kept, even if momentary file conflicts may keep   c the open or read from working.
 	iacbw = 0& 	if(idxrec.cmode .eq. 'NONE') goto 351 	if(kios.ne.0)goto 9990  351	continueI c Here, we know we have an access check record. Since we don't want those ? c ACE entries to get lost, ensure we put them back. Do so here. 
 	iacbw = 0 	do 350 n=1,256  	muace(n)=uace(n)  350	continue 	if(kios.ne.0)goto 9990  	do 9230 n=1,12  	nn=13-n% 	if (cunam(nn:nn) .gt. ' ') goto 9231 
 9230	continue 
 9231	lunam=nn H c iunam(1) has usernam size; usrnam=scratch string. cunam(1:iunam(1)) is c username.  c ipriv(2) is privmans? c iepid is epid of user process we need the current image from. @ c If this is an operator-user we allow the access to go normally c regardless of other tests.B c However if we find pseudo user RO in superusers, disallow access c for write by these users.  	iii = uopnmd .and. NOWRITFIB  	if (iii.ne.0)goto 8450 = c This is NOT a read-only open. Therefore do a different test  c first., 	if (index(accrec.ousrs,'RO').gt.0)goto 8450& c if the previous line's test is true,@ c the RO user IS there, so just test this user as if he were not0 c a superuser whether he is or not for r/o opens6 	if (index(accrec.ousrs,cunam(1:lunam)).gt.0)goto 9990
 8450	continue H c see if the file should be checksum tested. This is done early since itF c would be an antiviral measure, not an access control item. Note that- c we still let superusers get access however. 0 	if(accrec.ichk1.ne.0.or.accrec.ichk2.ne.0) then c accrec.fnamidx has filename. 	lfnam=vlen(accrec.fnamidx,128) + 	call filcs(accrec.fnamidx(:lfnam),ic1,ic2)  	if (ic1.ne.0.or.ic2.ne.0) then 4 	if (ic1.ne.accrec.ichk1.or.ic2.ne.accrec.ichk2)then> c he loses for checksum purposes. Cause the open to fail. This? c is better than preventing image activation; it does that, but @ c also prevents use of a system .com file that has been tampered  c with and so on...GOOD ability! 	iacbw=8
 	goto 9990 	endif 	endif 	endifD c get the hour of the day and check access type. If it's U this hour c we allow access. 	xx=secnds(0.0) 
 	ihr=xx/3600.  c ihr is hour since midnight. 
 	ihr=ihr+1 c (make it 1-24) 	if(ihr.lt.1.or.ihr.gt.24)ihr=1 E c N means no access now...don't care who (except always exempt users) & 	if(accrec.hrs(ihr:ihr) .eq. 'N') then 	iacbw=4! c set error...veto access by time 
 	goto 9990 	end if " c U means ok access by anyone now.+ 	if(accrec.hrs(ihr:ihr) .eq. 'U') goto 9990 $ c A or Y mean we do some other tests% 	if(accrec.hrs(ihr:ihr) .ne. 'A'.and. '      1  accrec.hrs(ihr:ihr).ne.'Y')then  	iacbw=8
 	goto 9990 	end if # c Y or A access mean we check more.  c See if this user may access.= c & in user list means ignore the test. * means anybody is OK * 	if (index(accrec.usrs,'&').gt.0)goto 8401
 	kkk=lunam) 	if (index(accrec.usrs,cunam(1:kkk)).le.0 .      1  .and. index(accrec.usrs,'*').le.0)then* c no username, nor * on ok list, so reject 	iacbw=4
 	goto 9990 	end if 
 8401	continue A c & in forbidden users means ignore test. * means forbid everyone ! c unless they are on the OK list. + 	if (index(accrec.fusrs,'&').gt.0)goto 8402 
 	kkk=lunam) 	if(index(accrec.fusrs,cunam(1:kkk)).gt.0 )      1  .or.(index(accrec.fusrs,'*').gt.0 8      1  .and.index(accrec.usrs,cunam(1:kkk)).le.0)) then0 c user's name is on forbidden list. Deny access. 	iacbw=8
 	goto 9990 	end if 
 8402	continue & c Must find the user's terminal now...' c accrec.ttyok has this. (* means any.) 0 c accrec.imgok & accrec.imgko are image strings.- c if access is ALL class, no tty/image check. + 	if(accrec.hrs(ihr:ihr) .eq. 'A') goto 9990 > c Now we need to check the terminal & images. Issue a $getjpiw= c to accomplish this. Note that special knl asts should be ok  c in the process at this point. - 	kk=sys$getjpiw(%val(1),iepid,,jpiitm,iosb,,)  c CHECK PRIVS TOO!!  	iii=.not.accrec.privs(1)  	iiii=.not.accrec.privs(2) 	iii=iii.and.ipriv(1)  	iiii=iiii.and.ipriv(2) E c if either iii or iiii have any bits set, it means there's some priv B c the process has that was not in the max-priv list. Reject access c if this is so. 	if(iii.ne.0.or.iiii.ne.0)then 	iacbw=8
 	goto 9990 	end if $ c If ok-term name has & we skip test* 	if(index(accrec.ttyok,'&').gt.0)goto 84212 	if(index(accrec.ttyok,ttyspc(1:ttyspl)).le.0.and.*      1  index(accrec.ttyok,'*').le.0) then% c terminal name not there...lose lose E c However, first, if this is a LAT terminal, try to match server/port  c ID. ) 	if(index(ttyspc(1:ttyspl),'LT').gt.0.or. -      1  index(ttyspc(1:ttyspl),'FT').gt.0.or. -      1  index(ttyspc(1:ttyspl),'TW').gt.0.or. /      1  index(ttyspc(1:ttyspl),'TZ').gt.0) then C c test lat server/port id. There are patches to enable this for FT, 3 c and some other terminal types, so try those also. D c This way we test both the normal terminal name and the server/port c so that either may be used. 5 	latprt='                                        ' // "      1  '                        ') 	call getlatport(ttyspc(1:ttyspl),latprt)  	llatp=vlen(latprt,64)5 	if(index(accrec.ttyok,latprt(:llatp)).gt.0)goto 9990  	end if  	iacbw=4
 	goto 9990 	end if 
 8421	continue = c leave image name intact; we WANT to specify it all to avoid  c work-arounds. % c ok image can be specific image or * 7 	if(index(accrec.imgok,imgspc(1:imgspl)).gt.0)goto 9990 * 	if(index(accrec.imgok,'*').gt.0)goto 99902 	if(index(accrec.imgko,imgspc(1:imgspl)).gt.0)then 	iacbw=8
 	goto 9990 	end if & 	if(index(accrec.imgko,'*').gt.0) thenH c if DISallowed images contain * then fail anything at this point unless7 c it was previously passed (would then skip this code.) B c This has the effect of limiting access (by normal users) to only c images specifically listed.  	iacbw=8
 	goto 9990 	end if 3 c default to all-ok if nothing rejected the access.  	iacbw=0 c 
 9990	continue 6 c iacbw flags success or failure. (Fail if nonzero...)/ c Send a msg to the operator when this happens.  c oprmsg (c*150) will be used. 	if(iacbw.eq.0)goto 9991 c	kkk=iunam(1) 	kkk=vlen(cunam,12)  	kkkk=vlen(accrec.fnamidx,128)- 	write(oprmsg,8990)cunam(1:kkk),accrec.index,       1  accrec.fnamidx(:kkkk) 9 8990	format('?Illegal access by ',a,' on fid (hex) ',2z9,       1  ' File:',a,       1  ' rejected by XACF') 	kkk=vlen(oprmsg,240)  	ii=opc$_rq_rqst 	iii=opc$m_nm_security 	oprbuf(1)=256*iii + ii  	oprbuf(2)=accrec.index(1) 	kvkv=kkk+8  	kiki=sys$sndopr(oprbc(:kvkv),) < c here if we specified a link in the flags entry (low bit=1) c try and fill that in here. 	iii=accrec.jflags 	iii = iii.and.1 	if(iii.eq.0) goto 9991 D c got the flag. Go get the faked-up ACE and return it to our caller.- c Just read it, don't do interpretation here.  	dbnam(11:12)='LK'6 	OPEN(UNIT=7,FILE=DBNAM(1:ldbn),ORGANIZATION='INDEXED'!      1  ,ACCESS='KEYED',READONLY, 6      2  RECORDTYPE='FIXED',RECL=18,FORM='UNFORMATTED',6      3  KEY=(1:8:CHARACTER),STATUS='UNKNOWN',ERR=9991)4 	read(unit=7,keyeq=ccmdid,keyid=0,iostat=kios)acebuf 	if(kios.ne.0)goto 9981 ) c file is indexed by FID like the others.  c overwrite muace  	do 8650 n=65,256  	muace(n)=0 
 8650	continue A c copy the ACE out of the index record to give our bogus link TO.  	do 8651 n=1,64  	muace(n)=acebuf.savace(n)
 8651	continue B c Allow the ACE to be used now by flagging things OK (else we junk c the user's I/O)  	iacbw=0
 9981	continue  	close(unit=7)
 9991	continue  	close(unit=3) 	close(unit=2) 	return  	end> C lkpwrk - find ACE entry parts that require file moving here.% 	subroutine lkpwrk(ace,idx,mace,ufid) ( 	logical*1 ace(256),mace(256),muace(256)G c mace gets a copy of the ACE minus the open stuff we deal with. Caller 0 c process must replace the original ACE by this. 	integer*4 idx(2) 
 	integer*4 i4  	logical*1 L1(4) 	equivalence(L1(1),i4) c	integer*4 iace(64),jace(64) 1 c	equivalence (iace(1),ace(1)),(jace(1),muace(1))  	integer*4 raxasc  	integer*4 ufid(2) 	data raxasc/'RAXC'/F c First check if this ACE indicates we have to look the "real" one up. 	igot=0  	do 2 n=1,4  2	L1(n)=ace(n+8) 	kk=i4 	do 3 n=1,4  3	L1(n)=ace(n+4)B c If the acl was too long for the driver alone to read, we read it) c here. Assume ufid is filled in at call. # 	if (kk.ne.raxasc.and.i4.eq.262144)       1    call filace(ufid,ace) ( c Now check that our ACE is a valid one. 	do 4 n=1,4  4	L1(n)=ace(n+8) 	kk=i4 	if(kk.eq.raxasc)goto 30 c The ACE lacks our flag.   c Return a null ace to the file., c (this also inhibits attempt to delete it.)
 	do 20 n=1,64  	muace(n)=0  20	continue  	return  30	continue 6 c skip 12 bytes since they're our header, bitflgs etc. c zero output edited ace first
 	do 40 n=1,12  40	muace(n)=ace(n) 	do 50 n=13,256  	muace(n)=0  50	continue  	k=13  	muk=13  100	continue
 	ii=ace(k)- c bad format or end if code out of 1..4 range   	if(ii.le.0.or.ii.gt.4)goto 9990 	if(ii.ne.4)goto 110 c found an entry...look no more  	kk=k  	k=k+1	 	L=ace(k)  	kkk=L+kk+2  c grab a 4 byte index  	if (L.gt.8)L=8  	if (L.le.0) goto 9990 	knn=min0(L,4) 	i4=0  	do 101 nn=1,knn 	k=k+1 	L1(nn)=ace(k) 101	continue C length should always be 8 
 	idx(1)=i4 	igot=i4 	i4=0 
 	knn=knn+1 	ll=1 ; c get the second long. (This gives enough space to store an  c entire file ID)  	do 1101 nn=knn,L  	k=k+1	  	L1(ll)=ace(k) 	ll=ll+1
 1101	continue 
 	idx(2)=i4D c Nevertheless return a zero if the flag word prohibits doing things c at open time. 
 	do 103 n=1,4  103	L1(n)=ace(n+4) 	iv=i4 	iv=iv.and.1 	if ((iv).eq.0)idx(1)=0 5 c keep looking so we copy the whole ACE after editing  	k=kkk 	if(kkk.gt.256)goto 9990	 	goto 100  110	continue 	if(ii.eq.3)goto 120  c newid or newpriv...same format 	do 112 nn=k,k+15  	muace(muk)=ace(nn) 
 	muk=muk+1 112	continue 	igot=igot+1 	k=k+16  	if(k.gt.256)goto 9990	 	goto 100  120	continue	 c jnl ctl  	nn=ace(k+1) 	kkk=k+nn+2  	do 122 nnn=k,kkk  	muace(muk)=ace(nnn)
 	muk=muk+1 122	continue 	igot=igot+1	 	k=k+nn+2  	if(k.gt.256)goto 9990	 	goto 100 
 9990	continue  	if(igot.eq.0)return+ c if we found an ACE, return the edited ACE  	do 200 n=1,256  200	mace(n)=muace(n) 	return  	end6 c filace is "glue" to call redacl macro routine, which; c does the reading of the acl one ACE at a time looking for  c one of our ACEs. 	subroutine filace(ufid,ace) 	logical*1 ace(256)  c	integer*4 iace(64) c	equivalence(iace(1),ace(1))  	integer*4 ufid(2),istat 	character*32 dvcnam 	integer*4 dvcchn  	common/dchn/dvcchn,dvcnam' 	integer*4 redacl,sys$assign,sys$dassgn & 	external redacl,sys$assign,sys$dassgn c Find our ACE if possible. " c otherwise return with it zeroed. c (use macro routine for this)# c first get a channel to the device  	kdv=ilen(dvcnam) 8 c assign a channel for redacl to use, then knock it down c when done.) 	kkk= sys$assign(dvcnam(:kdv),dvcchn,,,,)  	istat=redacl(ufid,ace,dvcchn) 	kkk=sys$dassgn(%val(dvcchn))  	if (istat.eq.1)return& c on nothing found return an empty ace 	do 100 n=1,256  100	ace(n)=0 	return  	end= c ilen(string) returns the length of the string with trailing  c whitespace ignored.  	integer*4 function ilen(arg)  	character*80 arg # c return length of printable string  	do 1 n=1,80 	k=81-n . c go back in loop looking for a printing char.  	if(ichar(arg(k:k)).gt.32)goto 2
 1	continue
 2	continue 	ilen=k  	return  	end6 c jlen is length function for longer strings (c * 132) 	integer*4 function jlen(arg)  	character*132 arg# c return length of printable string 
 	do 1 n=1,132  	k=133-n. c go back in loop looking for a printing char.  	if(ichar(arg(k:k)).gt.32)goto 2
 1	continue
 2	continue 	jlen=k  	return  	end! 	integer*4 function vlen(arg,len)  	integer*4 len 	character*(*) arg# c return length of printable string 
 	do 1 n=1,len 
 	k=len+1-n. c go back in loop looking for a printing char.  	if(ichar(arg(k:k)).gt.32)goto 2
 1	continue 	vlen=0  	return 
 2	continue 	vlen=k  	return  	end! 	subroutine filcs(fnam,ics1,ics2)  	character*(*) fnam  	integer*4 ics1,ics2 	integer*1 wrkbuf(2048)  	integer*4 wbl> c compute a couple checksums on a file fnam, returning them in c ics1, ics2 c glenn c. everhart . c (use to do file integ. chk on open for xacf. 	ics1=0  	ics2=0  c on error just return 0	 	irecl=80  	inquire(file=fnam,recl=irecl)2 	open(unit=10,file=fnam,readonly,form='formatted',)      1  status='old',err=9990,recl=irecl)  	ipar=1  100	continue* 	read(10,2000,end=9900,err=9900)wbl,wrkbuf> 2000	format(q,128a1,128a1,128a1,128a1,128a1,128a1,128a1,128a1,8      1  128a1,128a1,128a1,128a1,128a1,128a1,128a1,128a1) 	do 200 n=1,wbl B c ics1 is just a 32 bit checksum; ics2 is a random weirdo checksum' c which anuhowe should be reproducible.  	ics1=ics1+wrkbuf(n) 	ics2=ics2*2 + ipar * wrkbuf(n) 
 	ipar = -ipar  c wrap hi bit back in  	if(ics2.lt.0) ics2=ics2+1 200	continue	 	goto 100 
 9900	continue  	close(unit=10) 
 9990	continue  	return  	end