//========================================================================
//
// LTKMisc.cc
//
// Copyright 1996 Derek B. Noonburg
//
//========================================================================

#pragma implementation

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdarg.h>
#ifndef VMS
#include <pwd.h>
#else
#include "pwd.h"
#ifdef __DECCXX
#include <unixlib.h>
extern "C" struct passwd *getpwnam(char * name);
extern "C" struct passwd *getpwuid();
#endif
#endif
#include <LTKMisc.h>
#include <LTKWindow.h>
#include <LTKWidget.h>

String *ltkGetHomeDir() {
  char *s;
  struct passwd *pw;
  String *ret;

  if ((s = getenv("HOME"))) {
    ret = new String(s);
  } else {
    if ((s = getenv("USER")))
      pw = getpwnam(s);
    else
#ifndef VMS
      pw = getpwuid(getuid());
#else
      pw = getpwuid();
#endif
    if (pw)
      ret = new String(pw->pw_dir);
    else
      ret = new String(".");
  }
  return ret;
}

void ltkError(char *msg, ...) {
  va_list args;

  fprintf(stderr, "LTK Error: ");
  va_start(args, msg);
  vfprintf(stderr, msg, args);
  va_end(args);
  fprintf(stderr, "\n");
}
