//========================================================================
//
// FontInfo.h
//
// This file was automatically generated by makeFontInfo.
//
// Copyright 1996 Derek B. Noonburg
//
//========================================================================

#ifndef FONTINFO_H
#define FONTINFO_H

//------------------------------------------------------------------------
// Table for mapping PDF character names to ISO-8859 codes.
//------------------------------------------------------------------------

struct CharCode {
  char *name;			// PDF name
  ushort code;			// ISO-8859 encoding.
};

#define numNamedChars (sizeof(namedEncoding) / sizeof(CharCode))

static CharCode namedEncoding[] = {
  {"A",                  0x041},
  {"AE",                 0x0c6},
  {"Aacute",             0x0c1},
  {"Acircumflex",        0x0c2},
  {"Adieresis",          0x0c4},
  {"Agrave",             0x0c0},
  {"Aring",              0x0c5},
  {"Atilde",             0x0c3},
  {"B",                  0x042},
  {"C",                  0x043},
  {"Ccedilla",           0x0c7},
  {"D",                  0x044},
  {"E",                  0x045},
  {"Eacute",             0x0c9},
  {"Ecircumflex",        0x0ca},
  {"Edieresis",          0x0cb},
  {"Egrave",             0x0c8},
  {"Eth",                0x0d0},
  {"F",                  0x046},
  {"G",                  0x047},
  {"H",                  0x048},
  {"I",                  0x049},
  {"Iacute",             0x0cd},
  {"Icircumflex",        0x0ce},
  {"Idieresis",          0x0cf},
  {"Igrave",             0x0cc},
  {"J",                  0x04a},
  {"K",                  0x04b},
  {"L",                  0x04c},
  {"Lslash",             0x000},
  {"M",                  0x04d},
  {"N",                  0x04e},
  {"Ntilde",             0x0d1},
  {"O",                  0x04f},
  {"OE",                 0x000},
  {"Oacute",             0x0d3},
  {"Ocircumflex",        0x0d4},
  {"Odieresis",          0x0d6},
  {"Ograve",             0x0d2},
  {"Oslash",             0x0d8},
  {"Otilde",             0x0d5},
  {"P",                  0x050},
  {"Q",                  0x051},
  {"R",                  0x052},
  {"S",                  0x053},
  {"Scaron",             0x000},
  {"T",                  0x054},
  {"Thorn",              0x0de},
  {"U",                  0x055},
  {"Uacute",             0x0da},
  {"Ucircumflex",        0x0db},
  {"Udieresis",          0x0dc},
  {"Ugrave",             0x0d9},
  {"V",                  0x056},
  {"W",                  0x057},
  {"X",                  0x058},
  {"Y",                  0x059},
  {"Yacute",             0x0dd},
  {"Ydieresis",          0x000},
  {"Z",                  0x05a},
  {"Zcaron",             0x000},
  {"a",                  0x061},
  {"aacute",             0x0e1},
  {"acircumflex",        0x0e2},
  {"acute",              0x0b4},
  {"adieresis",          0x0e4},
  {"ae",                 0x0e6},
  {"agrave",             0x0e0},
  {"ampersand",          0x026},
  {"aring",              0x0e5},
  {"asciicircum",        0x05e},
  {"asciitilde",         0x07e},
  {"asterisk",           0x02a},
  {"at",                 0x040},
  {"atilde",             0x0e3},
  {"b",                  0x062},
  {"backslash",          0x05c},
  {"bar",                0x07c},
  {"braceleft",          0x07b},
  {"braceright",         0x07d},
  {"bracketleft",        0x05b},
  {"bracketright",       0x05d},
  {"breve",              0x000},
  {"brokenbar",          0x0a6},
  {"bullet",             0x100},
  {"c",                  0x063},
  {"caron",              0x000},
  {"ccedilla",           0x0e7},
  {"cedilla",            0x0b8},
  {"cent",               0x0a2},
  {"circumflex",         0x000},
  {"colon",              0x03a},
  {"comma",              0x02c},
  {"copyright",          0x0a9},
  {"currency",           0x0a4},
  {"d",                  0x064},
  {"dagger",             0x000},
  {"daggerdbl",          0x000},
  {"degree",             0x0b0},
  {"dieresis",           0x0a8},
  {"divide",             0x0f7},
  {"dollar",             0x024},
  {"dotaccent",          0x000},
  {"dotlessi",           0x000},
  {"e",                  0x065},
  {"eacute",             0x0e9},
  {"ecircumflex",        0x0ea},
  {"edieresis",          0x0eb},
  {"egrave",             0x0e8},
  {"eight",              0x038},
  {"ellipsis",           0x104},
  {"emdash",             0x02d},
  {"endash",             0x0ad},
  {"equal",              0x03d},
  {"eth",                0x0f0},
  {"exclam",             0x021},
  {"exclamdown",         0x0a1},
  {"f",                  0x066},
  {"fi",                 0x102},
  {"five",               0x035},
  {"fl",                 0x103},
  {"florin",             0x000},
  {"four",               0x034},
  {"fraction",           0x02f},
  {"g",                  0x067},
  {"germandbls",         0x0df},
  {"grave",              0x000},
  {"greater",            0x03e},
  {"guillemotleft",      0x0ab},
  {"guillemotright",     0x0bb},
  {"guilsinglleft",      0x000},
  {"guilsinglright",     0x000},
  {"h",                  0x068},
  {"hungarumlaut",       0x000},
  {"hyphen",             0x02d},
  {"i",                  0x069},
  {"iacute",             0x0ed},
  {"icircumflex",        0x0ee},
  {"idieresis",          0x0ef},
  {"igrave",             0x0ec},
  {"j",                  0x06a},
  {"k",                  0x06b},
  {"l",                  0x06c},
  {"less",               0x03c},
  {"logicalnot",         0x0ac},
  {"lslash",             0x000},
  {"m",                  0x06d},
  {"macron",             0x0af},
  {"minus",              0x02d},
  {"mu",                 0x0b5},
  {"multiply",           0x0d7},
  {"n",                  0x06e},
  {"nine",               0x039},
  {"ntilde",             0x0f1},
  {"numbersign",         0x023},
  {"o",                  0x06f},
  {"oacute",             0x0f3},
  {"ocircumflex",        0x0f4},
  {"odieresis",          0x0f6},
  {"oe",                 0x000},
  {"ogonek",             0x000},
  {"ograve",             0x0f2},
  {"one",                0x031},
  {"onehalf",            0x0bd},
  {"onequarter",         0x0bc},
  {"onesuperior",        0x0b9},
  {"ordfeminine",        0x0aa},
  {"ordmasculine",       0x0ba},
  {"oslash",             0x0f8},
  {"otilde",             0x0f5},
  {"p",                  0x070},
  {"paragraph",          0x0b6},
  {"parenleft",          0x028},
  {"parenright",         0x029},
  {"percent",            0x025},
  {"period",             0x02e},
  {"periodcentered",     0x0b7},
  {"perthousand",        0x000},
  {"plus",               0x02b},
  {"plusminus",          0x0b1},
  {"q",                  0x071},
  {"question",           0x03f},
  {"questiondown",       0x0bf},
  {"quotedbl",           0x022},
  {"quotedblbase",       0x000},
  {"quotedblleft",       0x105},
  {"quotedblright",      0x106},
  {"quoteleft",          0x060},
  {"quoteright",         0x027},
  {"quotesinglbase",     0x000},
  {"quotesingle",        0x027},
  {"r",                  0x072},
  {"registered",         0x0ae},
  {"ring",               0x0b0},
  {"s",                  0x073},
  {"scaron",             0x000},
  {"section",            0x0a7},
  {"semicolon",          0x03b},
  {"seven",              0x037},
  {"six",                0x036},
  {"slash",              0x02f},
  {"space",              0x020},
  {"sterling",           0x0a3},
  {"t",                  0x074},
  {"thorn",              0x0fe},
  {"three",              0x033},
  {"threequarters",      0x0be},
  {"threesuperior",      0x0b3},
  {"tilde",              0x000},
  {"trademark",          0x101},
  {"two",                0x032},
  {"twosuperior",        0x0b2},
  {"u",                  0x075},
  {"uacute",             0x0fa},
  {"ucircumflex",        0x0fb},
  {"udieresis",          0x0fc},
  {"ugrave",             0x0f9},
  {"underscore",         0x05f},
  {"v",                  0x076},
  {"w",                  0x077},
  {"x",                  0x078},
  {"y",                  0x079},
  {"yacute",             0x0fd},
  {"ydieresis",          0x0ff},
  {"yen",                0x0a5},
  {"z",                  0x07a},
  {"zcaron",             0x000},
  {"zero",               0x030}
};

//------------------------------------------------------------------------
// Mappings from predefined encodings to ISO-8859.
//------------------------------------------------------------------------

static ushort standardISOMap[256] = {
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x020, 0x021, 0x022, 0x023, 0x024, 0x025, 0x026, 0x027,
  0x028, 0x029, 0x02a, 0x02b, 0x02c, 0x02d, 0x02e, 0x02f,
  0x030, 0x031, 0x032, 0x033, 0x034, 0x035, 0x036, 0x037,
  0x038, 0x039, 0x03a, 0x03b, 0x03c, 0x03d, 0x03e, 0x03f,
  0x040, 0x041, 0x042, 0x043, 0x044, 0x045, 0x046, 0x047,
  0x048, 0x049, 0x04a, 0x04b, 0x04c, 0x04d, 0x04e, 0x04f,
  0x050, 0x051, 0x052, 0x053, 0x054, 0x055, 0x056, 0x057,
  0x058, 0x059, 0x05a, 0x05b, 0x05c, 0x05d, 0x05e, 0x05f,
  0x060, 0x061, 0x062, 0x063, 0x064, 0x065, 0x066, 0x067,
  0x068, 0x069, 0x06a, 0x06b, 0x06c, 0x06d, 0x06e, 0x06f,
  0x070, 0x071, 0x072, 0x073, 0x074, 0x075, 0x076, 0x077,
  0x078, 0x079, 0x07a, 0x07b, 0x07c, 0x07d, 0x07e, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x0a1, 0x0a2, 0x0a3, 0x02f, 0x0a5, 0x000, 0x0a7,
  0x0a4, 0x027, 0x105, 0x0ab, 0x000, 0x000, 0x102, 0x103,
  0x000, 0x0ad, 0x000, 0x000, 0x0b7, 0x000, 0x0b6, 0x100,
  0x000, 0x000, 0x106, 0x0bb, 0x104, 0x000, 0x000, 0x0bf,
  0x000, 0x000, 0x0b4, 0x000, 0x000, 0x0af, 0x000, 0x000,
  0x0a8, 0x000, 0x0b0, 0x0b8, 0x000, 0x000, 0x000, 0x000,
  0x02d, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x0c6, 0x000, 0x0aa, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x0d8, 0x000, 0x0ba, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x0e6, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x0f8, 0x000, 0x0df, 0x000, 0x000, 0x000, 0x000
};

static ushort macRomanISOMap[256] = {
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x020, 0x021, 0x022, 0x023, 0x024, 0x025, 0x026, 0x027,
  0x028, 0x029, 0x02a, 0x02b, 0x02c, 0x02d, 0x02e, 0x02f,
  0x030, 0x031, 0x032, 0x033, 0x034, 0x035, 0x036, 0x037,
  0x038, 0x039, 0x03a, 0x03b, 0x03c, 0x03d, 0x03e, 0x03f,
  0x040, 0x041, 0x042, 0x043, 0x044, 0x045, 0x046, 0x047,
  0x048, 0x049, 0x04a, 0x04b, 0x04c, 0x04d, 0x04e, 0x04f,
  0x050, 0x051, 0x052, 0x053, 0x054, 0x055, 0x056, 0x057,
  0x058, 0x059, 0x05a, 0x05b, 0x05c, 0x05d, 0x05e, 0x05f,
  0x000, 0x061, 0x062, 0x063, 0x064, 0x065, 0x066, 0x067,
  0x068, 0x069, 0x06a, 0x06b, 0x06c, 0x06d, 0x06e, 0x06f,
  0x070, 0x071, 0x072, 0x073, 0x074, 0x075, 0x076, 0x077,
  0x078, 0x079, 0x07a, 0x07b, 0x07c, 0x07d, 0x07e, 0x000,
  0x0c4, 0x0c5, 0x0c7, 0x0c9, 0x0d1, 0x0d6, 0x0dc, 0x0e1,
  0x0e0, 0x0e2, 0x0e4, 0x0e3, 0x0e5, 0x0e7, 0x0e9, 0x0e8,
  0x0ea, 0x0eb, 0x0ed, 0x0ec, 0x0ee, 0x0ef, 0x0f1, 0x0f3,
  0x0f2, 0x0f4, 0x0f6, 0x0f5, 0x0fa, 0x0f9, 0x0fb, 0x0fc,
  0x000, 0x0b0, 0x0a2, 0x0a3, 0x0a7, 0x100, 0x0b6, 0x0df,
  0x0ae, 0x0a9, 0x101, 0x0b4, 0x0a8, 0x000, 0x0c6, 0x0d8,
  0x000, 0x0b1, 0x000, 0x000, 0x0a5, 0x0b5, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x0aa, 0x0ba, 0x000, 0x0e6, 0x0f8,
  0x0bf, 0x0a1, 0x0ac, 0x000, 0x000, 0x000, 0x000, 0x0ab,
  0x0bb, 0x104, 0x020, 0x0c0, 0x0c3, 0x0d5, 0x000, 0x000,
  0x0ad, 0x02d, 0x105, 0x106, 0x060, 0x027, 0x0f7, 0x000,
  0x0ff, 0x000, 0x02f, 0x0a4, 0x000, 0x000, 0x102, 0x103,
  0x000, 0x0b7, 0x000, 0x000, 0x000, 0x0c2, 0x0ca, 0x0c1,
  0x0cb, 0x0c8, 0x0cd, 0x0ce, 0x0cf, 0x0cc, 0x0d3, 0x0d4,
  0x000, 0x0d2, 0x0da, 0x0db, 0x0d9, 0x000, 0x000, 0x000,
  0x0af, 0x000, 0x000, 0x0b0, 0x0b8, 0x000, 0x000, 0x000
};

static ushort winAnsiISOMap[256] = {
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x020, 0x021, 0x022, 0x023, 0x024, 0x025, 0x026, 0x027,
  0x028, 0x029, 0x02a, 0x02b, 0x02c, 0x02d, 0x02e, 0x02f,
  0x030, 0x031, 0x032, 0x033, 0x034, 0x035, 0x036, 0x037,
  0x038, 0x039, 0x03a, 0x03b, 0x03c, 0x03d, 0x03e, 0x03f,
  0x040, 0x041, 0x042, 0x043, 0x044, 0x045, 0x046, 0x047,
  0x048, 0x049, 0x04a, 0x04b, 0x04c, 0x04d, 0x04e, 0x04f,
  0x050, 0x051, 0x052, 0x053, 0x054, 0x055, 0x056, 0x057,
  0x058, 0x059, 0x05a, 0x05b, 0x05c, 0x05d, 0x05e, 0x05f,
  0x000, 0x061, 0x062, 0x063, 0x064, 0x065, 0x066, 0x067,
  0x068, 0x069, 0x06a, 0x06b, 0x06c, 0x06d, 0x06e, 0x06f,
  0x070, 0x071, 0x072, 0x073, 0x074, 0x075, 0x076, 0x077,
  0x078, 0x079, 0x07a, 0x07b, 0x07c, 0x07d, 0x07e, 0x100,
  0x100, 0x100, 0x000, 0x000, 0x000, 0x104, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x100, 0x100, 0x100,
  0x100, 0x060, 0x027, 0x105, 0x106, 0x100, 0x0ad, 0x02d,
  0x000, 0x101, 0x000, 0x000, 0x000, 0x100, 0x100, 0x000,
  0x020, 0x0a1, 0x0a2, 0x0a3, 0x0a4, 0x0a5, 0x0a6, 0x0a7,
  0x0a8, 0x0a9, 0x0aa, 0x0ab, 0x0ac, 0x02d, 0x0ae, 0x0af,
  0x0b0, 0x0b1, 0x0b2, 0x0b3, 0x0b4, 0x0b5, 0x0b6, 0x0b7,
  0x0b8, 0x0b9, 0x0ba, 0x0bb, 0x0bc, 0x0bd, 0x0be, 0x0bf,
  0x0c0, 0x0c1, 0x0c2, 0x0c3, 0x0c4, 0x0c5, 0x0c6, 0x0c7,
  0x0c8, 0x0c9, 0x0ca, 0x0cb, 0x0cc, 0x0cd, 0x0ce, 0x0cf,
  0x0d0, 0x0d1, 0x0d2, 0x0d3, 0x0d4, 0x0d5, 0x0d6, 0x0d7,
  0x0d8, 0x0d9, 0x0da, 0x0db, 0x0dc, 0x0dd, 0x0de, 0x0df,
  0x0e0, 0x0e1, 0x0e2, 0x0e3, 0x0e4, 0x0e5, 0x0e6, 0x0e7,
  0x0e8, 0x0e9, 0x0ea, 0x0eb, 0x0ec, 0x0ed, 0x0ee, 0x0ef,
  0x0f0, 0x0f1, 0x0f2, 0x0f3, 0x0f4, 0x0f5, 0x0f6, 0x0f7,
  0x0f8, 0x0f9, 0x0fa, 0x0fb, 0x0fc, 0x0fd, 0x0fe, 0x0ff
};

//------------------------------------------------------------------------
// Mappings from predefined encodings to PDF character names.
//------------------------------------------------------------------------

static ushort standardPDFMap[256] = {
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x0c9, 0x073, 0x0b7, 0x09a, 0x065, 0x0ae, 0x044, 0x0be,
  0x0ac, 0x0ad, 0x048, 0x0b2, 0x05c, 0x086, 0x0af, 0x0c8,
  0x0e3, 0x0a2, 0x0d2, 0x0cd, 0x07a, 0x077, 0x0c7, 0x0c6,
  0x06d, 0x098, 0x05b, 0x0c5, 0x08f, 0x071, 0x07f, 0x0b5,
  0x049, 0x000, 0x008, 0x009, 0x00b, 0x00c, 0x012, 0x013,
  0x014, 0x015, 0x01a, 0x01b, 0x01c, 0x01e, 0x01f, 0x021,
  0x029, 0x02a, 0x02b, 0x02c, 0x02e, 0x030, 0x035, 0x036,
  0x037, 0x038, 0x03b, 0x050, 0x04c, 0x051, 0x046, 0x0d9,
  0x0bb, 0x03d, 0x04b, 0x055, 0x05f, 0x068, 0x075, 0x07c,
  0x084, 0x087, 0x08c, 0x08d, 0x08e, 0x092, 0x097, 0x09b,
  0x0aa, 0x0b4, 0x0bf, 0x0c2, 0x0cb, 0x0d4, 0x0da, 0x0db,
  0x0dc, 0x0dd, 0x0e1, 0x04e, 0x04d, 0x04f, 0x047, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x074, 0x059, 0x0ca, 0x07b, 0x0e0, 0x079, 0x0c4,
  0x05e, 0x0be, 0x0b9, 0x080, 0x082, 0x083, 0x076, 0x078,
  0x000, 0x070, 0x060, 0x061, 0x0b0, 0x000, 0x0ab, 0x054,
  0x0bd, 0x0b8, 0x0ba, 0x081, 0x06e, 0x0b1, 0x000, 0x0b6,
  0x000, 0x07e, 0x040, 0x05a, 0x0d0, 0x093, 0x052, 0x066,
  0x063, 0x000, 0x0c1, 0x058, 0x000, 0x085, 0x0a0, 0x056,
  0x06f, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x001, 0x000, 0x0a6, 0x000, 0x000, 0x000, 0x000,
  0x01d, 0x027, 0x022, 0x0a7, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x042, 0x000, 0x000, 0x000, 0x067, 0x000, 0x000,
  0x091, 0x0a8, 0x09f, 0x07d, 0x000, 0x000, 0x000, 0x000
};

static ushort macRomanPDFMap[256] = {
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x0c9, 0x073, 0x0b7, 0x09a, 0x065, 0x0ae, 0x044, 0x0be,
  0x0ac, 0x0ad, 0x048, 0x0b2, 0x05c, 0x086, 0x0af, 0x0c8,
  0x0e3, 0x0a2, 0x0d2, 0x0cd, 0x07a, 0x077, 0x0c7, 0x0c6,
  0x06d, 0x098, 0x05b, 0x0c5, 0x08f, 0x071, 0x07f, 0x0b5,
  0x049, 0x000, 0x008, 0x009, 0x00b, 0x00c, 0x012, 0x013,
  0x014, 0x015, 0x01a, 0x01b, 0x01c, 0x01e, 0x01f, 0x021,
  0x029, 0x02a, 0x02b, 0x02c, 0x02e, 0x030, 0x035, 0x036,
  0x037, 0x038, 0x03b, 0x050, 0x04c, 0x051, 0x046, 0x0d9,
  0x07e, 0x03d, 0x04b, 0x055, 0x05f, 0x068, 0x075, 0x07c,
  0x084, 0x087, 0x08c, 0x08d, 0x08e, 0x092, 0x097, 0x09b,
  0x0aa, 0x0b4, 0x0bf, 0x0c2, 0x0cb, 0x0d4, 0x0da, 0x0db,
  0x0dc, 0x0dd, 0x0e1, 0x04e, 0x04d, 0x04f, 0x047, 0x000,
  0x004, 0x006, 0x00a, 0x00d, 0x020, 0x025, 0x033, 0x03e,
  0x043, 0x03f, 0x041, 0x04a, 0x045, 0x057, 0x069, 0x06c,
  0x06a, 0x06b, 0x088, 0x08b, 0x089, 0x08a, 0x099, 0x09c,
  0x0a1, 0x09d, 0x09e, 0x0a9, 0x0d5, 0x0d8, 0x0d6, 0x0d7,
  0x060, 0x062, 0x059, 0x0ca, 0x0c4, 0x054, 0x0ab, 0x07d,
  0x0c0, 0x05d, 0x0d1, 0x040, 0x063, 0x000, 0x001, 0x027,
  0x000, 0x0b3, 0x000, 0x000, 0x0e0, 0x095, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x0a6, 0x0a7, 0x000, 0x042, 0x0a8,
  0x0b6, 0x074, 0x090, 0x000, 0x079, 0x000, 0x000, 0x080,
  0x081, 0x06e, 0x0c9, 0x005, 0x007, 0x028, 0x022, 0x09f,
  0x070, 0x06f, 0x0b9, 0x0ba, 0x0bb, 0x0bc, 0x064, 0x000,
  0x0df, 0x03a, 0x07b, 0x05e, 0x082, 0x083, 0x076, 0x078,
  0x061, 0x0b0, 0x0bd, 0x0b8, 0x0b1, 0x003, 0x00e, 0x002,
  0x00f, 0x010, 0x016, 0x017, 0x018, 0x019, 0x023, 0x024,
  0x000, 0x026, 0x031, 0x032, 0x034, 0x067, 0x05a, 0x0d0,
  0x093, 0x052, 0x066, 0x0c1, 0x058, 0x085, 0x0a0, 0x056
};

static ushort winAnsiPDFMap[256] = {
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000, 0x000,
  0x0c9, 0x073, 0x0b7, 0x09a, 0x065, 0x0ae, 0x044, 0x0be,
  0x0ac, 0x0ad, 0x048, 0x0b2, 0x05c, 0x086, 0x0af, 0x0c8,
  0x0e3, 0x0a2, 0x0d2, 0x0cd, 0x07a, 0x077, 0x0c7, 0x0c6,
  0x06d, 0x098, 0x05b, 0x0c5, 0x08f, 0x071, 0x07f, 0x0b5,
  0x049, 0x000, 0x008, 0x009, 0x00b, 0x00c, 0x012, 0x013,
  0x014, 0x015, 0x01a, 0x01b, 0x01c, 0x01e, 0x01f, 0x021,
  0x029, 0x02a, 0x02b, 0x02c, 0x02e, 0x030, 0x035, 0x036,
  0x037, 0x038, 0x03b, 0x050, 0x04c, 0x051, 0x046, 0x0d9,
  0x07e, 0x03d, 0x04b, 0x055, 0x05f, 0x068, 0x075, 0x07c,
  0x084, 0x087, 0x08c, 0x08d, 0x08e, 0x092, 0x097, 0x09b,
  0x0aa, 0x0b4, 0x0bf, 0x0c2, 0x0cb, 0x0d4, 0x0da, 0x0db,
  0x0dc, 0x0dd, 0x0e1, 0x04e, 0x04d, 0x04f, 0x047, 0x054,
  0x054, 0x054, 0x0bd, 0x079, 0x0b8, 0x06e, 0x060, 0x061,
  0x05a, 0x0b1, 0x02d, 0x082, 0x022, 0x054, 0x054, 0x054,
  0x054, 0x0bb, 0x0bc, 0x0b9, 0x0ba, 0x054, 0x070, 0x06f,
  0x0d0, 0x0d1, 0x0c3, 0x083, 0x09f, 0x054, 0x054, 0x03a,
  0x0c9, 0x074, 0x059, 0x0ca, 0x05e, 0x0e0, 0x053, 0x0c4,
  0x063, 0x05d, 0x0a6, 0x080, 0x090, 0x086, 0x0c0, 0x093,
  0x062, 0x0b3, 0x0d3, 0x0cf, 0x040, 0x095, 0x0ab, 0x0b0,
  0x058, 0x0a5, 0x0a7, 0x081, 0x0a4, 0x0a3, 0x0ce, 0x0b6,
  0x005, 0x002, 0x003, 0x007, 0x004, 0x006, 0x001, 0x00a,
  0x010, 0x00d, 0x00e, 0x00f, 0x019, 0x016, 0x017, 0x018,
  0x011, 0x020, 0x026, 0x023, 0x024, 0x028, 0x025, 0x096,
  0x027, 0x034, 0x031, 0x032, 0x033, 0x039, 0x02f, 0x07d,
  0x043, 0x03e, 0x03f, 0x04a, 0x041, 0x045, 0x042, 0x057,
  0x06c, 0x069, 0x06a, 0x06b, 0x08b, 0x088, 0x089, 0x08a,
  0x072, 0x099, 0x0a1, 0x09c, 0x09d, 0x0a9, 0x09e, 0x064,
  0x0a8, 0x0d8, 0x0d5, 0x0d6, 0x0d7, 0x0de, 0x0cc, 0x0df
};

//------------------------------------------------------------------------
// Character widths for builtin fonts.
//------------------------------------------------------------------------

static ushort courierWidths[numNamedChars] = {
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600
};

static ushort courierBoldWidths[numNamedChars] = {
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600
};

static ushort courierBoldObliqueWidths[numNamedChars] = {
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600
};

static ushort courierObliqueWidths[numNamedChars] = {
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600,  600,  600,  600,  600,
   600,  600,  600,  600
};

static ushort helveticaWidths[numNamedChars] = {
   667, 1000,  667,  667,  667,  667,  667,  667,
   667,  722,  722,  722,  667,  667,  667,  667,
   667,  722,  611,  778,  722,  278,  278,  278,
   278,  278,  500,  667,  556,  556,  833,  722,
   722,  778, 1000,  778,  778,  778,  778,  778,
   778,  667,  778,  722,  667,  667,  611,  667,
   722,  722,  722,  722,  722,  667,  944,  667,
   667,  667,  667,  611,  611,  556,  556,  556,
   333,  556,  889,  556,  667,  556,  469,  584,
   389, 1015,  556,  556,  278,  260,  334,  334,
   278,  278,  333,  260,  350,  500,  333,  500,
   333,  556,  333,  278,  278,  737,  556,  556,
   556,  556,  400,  333,  584,  556,  333,  278,
   556,  556,  556,  556,  556,  556, 1000, 1000,
   556,  584,  556,  278,  333,  278,  500,  556,
   500,  556,  556,  167,  556,  611,  333,  584,
   556,  556,  333,  333,  556,  333,  333,  222,
   278,  278,  278,  278,  222,  500,  222,  584,
   584,  222,  833,  333,  584,  556,  584,  556,
   556,  556,  556,  556,  556,  556,  556,  944,
   333,  556,  556,  834,  834,  333,  370,  365,
   611,  556,  556,  537,  333,  333,  889,  278,
   278, 1000,  584,  584,  556,  556,  611,  355,
   333,  333,  333,  222,  222,  222,  191,  333,
   737,  333,  500,  500,  556,  278,  556,  556,
   278,  278,  556,  278,  556,  556,  834,  333,
   333, 1000,  556,  333,  556,  556,  556,  556,
   556,  556,  500,  722,  500,  500,  500,  500,
   556,  500,  500,  556
};

static ushort helveticaBoldWidths[numNamedChars] = {
   722, 1000,  722,  722,  722,  722,  722,  722,
   722,  722,  722,  722,  667,  667,  667,  667,
   667,  722,  611,  778,  722,  278,  278,  278,
   278,  278,  556,  722,  611,  611,  833,  722,
   722,  778, 1000,  778,  778,  778,  778,  778,
   778,  667,  778,  722,  667,  667,  611,  667,
   722,  722,  722,  722,  722,  667,  944,  667,
   667,  667,  667,  611,  611,  556,  556,  556,
   333,  556,  889,  556,  722,  556,  584,  584,
   389,  975,  556,  611,  278,  280,  389,  389,
   333,  333,  333,  280,  350,  556,  333,  556,
   333,  556,  333,  333,  278,  737,  556,  611,
   556,  556,  400,  333,  584,  556,  333,  278,
   556,  556,  556,  556,  556,  556, 1000, 1000,
   556,  584,  611,  333,  333,  333,  611,  556,
   611,  556,  556,  167,  611,  611,  333,  584,
   556,  556,  333,  333,  611,  333,  333,  278,
   278,  278,  278,  278,  278,  556,  278,  584,
   584,  278,  889,  333,  584,  611,  584,  611,
   556,  611,  556,  611,  611,  611,  611,  944,
   333,  611,  556,  834,  834,  333,  370,  365,
   611,  611,  611,  556,  333,  333,  889,  278,
   278, 1000,  584,  584,  611,  611,  611,  474,
   500,  500,  500,  278,  278,  278,  238,  389,
   737,  333,  556,  556,  556,  333,  556,  556,
   278,  278,  556,  333,  611,  556,  834,  333,
   333, 1000,  556,  333,  611,  611,  611,  611,
   611,  556,  556,  778,  556,  556,  556,  556,
   556,  500,  500,  556
};

static ushort helveticaBoldObliqueWidths[numNamedChars] = {
   722, 1000,  722,  722,  722,  722,  722,  722,
   722,  722,  722,  722,  667,  667,  667,  667,
   667,  722,  611,  778,  722,  278,  278,  278,
   278,  278,  556,  722,  611,  611,  833,  722,
   722,  778, 1000,  778,  778,  778,  778,  778,
   778,  667,  778,  722,  667,  667,  611,  667,
   722,  722,  722,  722,  722,  667,  944,  667,
   667,  667,  667,  611,  611,  556,  556,  556,
   333,  556,  889,  556,  722,  556,  584,  584,
   389,  975,  556,  611,  278,  280,  389,  389,
   333,  333,  333,  280,  350,  556,  333,  556,
   333,  556,  333,  333,  278,  737,  556,  611,
   556,  556,  400,  333,  584,  556,  333,  278,
   556,  556,  556,  556,  556,  556, 1000, 1000,
   556,  584,  611,  333,  333,  333,  611,  556,
   611,  556,  556,  167,  611,  611,  333,  584,
   556,  556,  333,  333,  611,  333,  333,  278,
   278,  278,  278,  278,  278,  556,  278,  584,
   584,  278,  889,  333,  584,  611,  584,  611,
   556,  611,  556,  611,  611,  611,  611,  944,
   333,  611,  556,  834,  834,  333,  370,  365,
   611,  611,  611,  556,  333,  333,  889,  278,
   278, 1000,  584,  584,  611,  611,  611,  474,
   500,  500,  500,  278,  278,  278,  238,  389,
   737,  333,  556,  556,  556,  333,  556,  556,
   278,  278,  556,  333,  611,  556,  834,  333,
   333, 1000,  556,  333,  611,  611,  611,  611,
   611,  556,  556,  778,  556,  556,  556,  556,
   556,  500,  500,  556
};

static ushort helveticaObliqueWidths[numNamedChars] = {
   667, 1000,  667,  667,  667,  667,  667,  667,
   667,  722,  722,  722,  667,  667,  667,  667,
   667,  722,  611,  778,  722,  278,  278,  278,
   278,  278,  500,  667,  556,  556,  833,  722,
   722,  778, 1000,  778,  778,  778,  778,  778,
   778,  667,  778,  722,  667,  667,  611,  667,
   722,  722,  722,  722,  722,  667,  944,  667,
   667,  667,  667,  611,  611,  556,  556,  556,
   333,  556,  889,  556,  667,  556,  469,  584,
   389, 1015,  556,  556,  278,  260,  334,  334,
   278,  278,  333,  260,  350,  500,  333,  500,
   333,  556,  333,  278,  278,  737,  556,  556,
   556,  556,  400,  333,  584,  556,  333,  278,
   556,  556,  556,  556,  556,  556, 1000, 1000,
   556,  584,  556,  278,  333,  278,  500,  556,
   500,  556,  556,  167,  556,  611,  333,  584,
   556,  556,  333,  333,  556,  333,  333,  222,
   278,  278,  278,  278,  222,  500,  222,  584,
   584,  222,  833,  333,  584,  556,  584,  556,
   556,  556,  556,  556,  556,  556,  556,  944,
   333,  556,  556,  834,  834,  333,  370,  365,
   611,  556,  556,  537,  333,  333,  889,  278,
   278, 1000,  584,  584,  556,  556,  611,  355,
   333,  333,  333,  222,  222,  222,  191,  333,
   737,  333,  500,  500,  556,  278,  556,  556,
   278,  278,  556,  278,  556,  556,  834,  333,
   333, 1000,  556,  333,  556,  556,  556,  556,
   556,  556,  500,  722,  500,  500,  500,  500,
   556,  500,  500,  556
};

static ushort symbolWidths[numNamedChars] = {
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,  778,    0,    0,    0,
     0,    0,    0,    0,    0,  200,  480,  480,
   333,  333,    0,    0,  460,    0,    0,    0,
     0,    0,    0,  278,  250,    0,    0,    0,
     0,    0,  400,    0,  549,    0,    0,    0,
     0,    0,    0,    0,    0,  500, 1000,    0,
     0,  549,    0,  333,    0,    0,    0,  500,
     0,  500,  500,  167,    0,    0,    0,  549,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,  549,
   713,    0,    0,    0,  549,  576,  549,    0,
   500,    0,  500,    0,    0,    0,    0,    0,
     0,    0,  500,    0,    0,    0,    0,    0,
     0,    0,    0,    0,  333,  333,  833,  250,
     0,    0,  549,  549,    0,  444,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,  278,  500,  500,
   278,  250,    0,    0,    0,  500,    0,    0,
     0,    0,  500,    0,    0,    0,    0,    0,
     0,  500,    0,    0,    0,    0,    0,    0,
     0,    0,    0,  500
};

static ushort timesBoldWidths[numNamedChars] = {
   722, 1000,  722,  722,  722,  722,  722,  722,
   667,  722,  722,  722,  667,  667,  667,  667,
   667,  722,  611,  778,  778,  389,  389,  389,
   389,  389,  500,  778,  667,  667,  944,  722,
   722,  778, 1000,  778,  778,  778,  778,  778,
   778,  611,  778,  722,  556,  556,  667,  611,
   722,  722,  722,  722,  722,  722, 1000,  722,
   722,  722,  722,  667,  667,  500,  500,  500,
   333,  500,  722,  500,  833,  500,  581,  520,
   500,  930,  500,  556,  278,  220,  394,  394,
   333,  333,  333,  220,  350,  444,  333,  444,
   333,  500,  333,  333,  250,  747,  500,  556,
   500,  500,  400,  333,  570,  500,  333,  278,
   444,  444,  444,  444,  444,  500, 1000, 1000,
   500,  570,  500,  333,  333,  333,  556,  500,
   556,  500,  500,  167,  500,  556,  333,  570,
   500,  500,  333,  333,  556,  333,  333,  278,
   278,  278,  278,  278,  333,  556,  278,  570,
   570,  278,  833,  333,  570,  556,  570,  556,
   500,  556,  500,  500,  500,  500,  500,  722,
   333,  500,  500,  750,  750,  300,  300,  330,
   500,  500,  556,  540,  333,  333, 1000,  250,
   250, 1000,  570,  570,  556,  500,  500,  555,
   500,  500,  500,  333,  333,  333,  278,  444,
   747,  333,  389,  389,  500,  333,  500,  500,
   278,  250,  500,  333,  556,  500,  750,  300,
   333, 1000,  500,  300,  556,  556,  556,  556,
   556,  500,  500,  722,  500,  500,  500,  500,
   500,  444,  444,  500
};

static ushort timesBoldItalicWidths[numNamedChars] = {
   667,  944,  667,  667,  667,  667,  667,  667,
   667,  667,  667,  722,  667,  667,  667,  667,
   667,  722,  667,  722,  778,  389,  389,  389,
   389,  389,  500,  667,  611,  611,  889,  722,
   722,  722,  944,  722,  722,  722,  722,  722,
   722,  611,  722,  667,  556,  556,  611,  611,
   722,  722,  722,  722,  722,  667,  889,  667,
   611,  611,  611,  611,  611,  500,  500,  500,
   333,  500,  722,  500,  778,  500,  570,  570,
   500,  832,  500,  500,  278,  220,  348,  348,
   333,  333,  333,  220,  350,  444,  333,  444,
   333,  500,  333,  333,  250,  747,  500,  500,
   500,  500,  400,  333,  570,  500,  333,  278,
   444,  444,  444,  444,  444,  500, 1000, 1000,
   500,  570,  500,  389,  389,  333,  556,  500,
   556,  500,  500,  167,  500,  500,  333,  570,
   500,  500,  333,  333,  556,  333,  333,  278,
   278,  278,  278,  278,  278,  500,  278,  570,
   606,  278,  778,  333,  606,  576,  570,  556,
   500,  556,  500,  500,  500,  500,  500,  722,
   333,  500,  500,  750,  750,  300,  266,  300,
   500,  500,  500,  500,  333,  333,  833,  250,
   250, 1000,  570,  570,  500,  500,  500,  555,
   500,  500,  500,  333,  333,  333,  278,  389,
   747,  333,  389,  389,  500,  333,  500,  500,
   278,  250,  500,  278,  500,  500,  750,  300,
   333, 1000,  500,  300,  556,  556,  556,  556,
   556,  500,  444,  667,  500,  444,  444,  444,
   500,  389,  389,  500
};

static ushort timesItalicWidths[numNamedChars] = {
   611,  889,  611,  611,  611,  611,  611,  611,
   611,  667,  667,  722,  611,  611,  611,  611,
   611,  722,  611,  722,  722,  333,  333,  333,
   333,  333,  444,  667,  556,  556,  833,  667,
   667,  722,  944,  722,  722,  722,  722,  722,
   722,  611,  722,  611,  500,  500,  556,  611,
   722,  722,  722,  722,  722,  611,  833,  611,
   556,  556,  556,  556,  556,  500,  500,  500,
   333,  500,  667,  500,  778,  500,  422,  541,
   500,  920,  500,  500,  278,  275,  400,  400,
   389,  389,  333,  275,  350,  444,  333,  444,
   333,  500,  333,  333,  250,  760,  500,  500,
   500,  500,  400,  333,  675,  500,  333,  278,
   444,  444,  444,  444,  444,  500,  889,  889,
   500,  675,  500,  333,  389,  278,  500,  500,
   500,  500,  500,  167,  500,  500,  333,  675,
   500,  500,  333,  333,  500,  333,  333,  278,
   278,  278,  278,  278,  278,  444,  278,  675,
   675,  278,  722,  333,  675,  500,  675,  500,
   500,  500,  500,  500,  500,  500,  500,  667,
   333,  500,  500,  750,  750,  300,  276,  310,
   500,  500,  500,  523,  333,  333,  833,  250,
   250, 1000,  675,  675,  500,  500,  500,  420,
   556,  556,  556,  333,  333,  333,  214,  389,
   760,  333,  389,  389,  500,  333,  500,  500,
   278,  250,  500,  278,  500,  500,  750,  300,
   333,  980,  500,  300,  500,  500,  500,  500,
   500,  500,  444,  667,  444,  444,  444,  444,
   500,  389,  389,  500
};

static ushort timesRomanWidths[numNamedChars] = {
   722,  889,  722,  722,  722,  722,  722,  722,
   667,  667,  667,  722,  611,  611,  611,  611,
   611,  722,  556,  722,  722,  333,  333,  333,
   333,  333,  389,  722,  611,  611,  889,  722,
   722,  722,  889,  722,  722,  722,  722,  722,
   722,  556,  722,  667,  556,  556,  611,  556,
   722,  722,  722,  722,  722,  722,  944,  722,
   722,  722,  722,  611,  611,  444,  444,  444,
   333,  444,  667,  444,  778,  444,  469,  541,
   500,  921,  444,  500,  278,  200,  480,  480,
   333,  333,  333,  200,  350,  444,  333,  444,
   333,  500,  333,  278,  250,  760,  500,  500,
   500,  500,  400,  333,  564,  500,  333,  278,
   444,  444,  444,  444,  444,  500, 1000, 1000,
   500,  564,  500,  333,  333,  333,  556,  500,
   556,  500,  500,  167,  500,  500,  333,  564,
   500,  500,  333,  333,  500,  333,  333,  278,
   278,  278,  278,  278,  278,  500,  278,  564,
   564,  278,  778,  333,  564,  500,  564,  500,
   500,  500,  500,  500,  500,  500,  500,  722,
   333,  500,  500,  750,  750,  300,  276,  310,
   500,  500,  500,  453,  333,  333,  833,  250,
   250, 1000,  564,  564,  500,  444,  444,  408,
   444,  444,  444,  333,  333,  333,  180,  333,
   760,  333,  389,  389,  500,  278,  500,  500,
   278,  250,  500,  278,  500,  500,  750,  300,
   333,  980,  500,  300,  500,  500,  500,  500,
   500,  500,  500,  722,  500,  500,  500,  500,
   500,  444,  444,  500
};

static ushort zapfDingbatsWidths[numNamedChars] = {
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,  278,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0,    0,    0,    0,    0,
     0,    0,    0,    0
};

struct BuiltinFont {
  char *name;
  ushort *widths;
};

#define numBuiltinFonts ((int)(sizeof(builtinFonts)/sizeof(BuiltinFont)))

static BuiltinFont builtinFonts[] = {
  {"Courier",                     courierWidths},
  {"Courier-Bold",                courierBoldWidths},
  {"Courier-BoldOblique",         courierBoldObliqueWidths},
  {"Courier-Oblique",             courierObliqueWidths},
  {"Helvetica",                   helveticaWidths},
  {"Helvetica-Bold",              helveticaBoldWidths},
  {"Helvetica-BoldOblique",       helveticaBoldObliqueWidths},
  {"Helvetica-Oblique",           helveticaObliqueWidths},
  {"Symbol",                      symbolWidths},
  {"Times-Bold",                  timesBoldWidths},
  {"Times-BoldItalic",            timesBoldItalicWidths},
  {"Times-Italic",                timesItalicWidths},
  {"Times-Roman",                 timesRomanWidths},
  {"ZapfDingbats",                zapfDingbatsWidths}
};

#endif
