 /*  *	+++ NAME +++   *2  *	 CABS   Double precision complex absolute value  *  *	+++ INDEX +++  *  *	 CABS  *	 complex functions    *	 machine independent routines  *	 math libraries  *  *	+++ DESCRIPTION +++  *7  *	Computes double precision absolute value of a double 5  *	precision complex argument, where "absolute value" 7  *	is taken to mean magnitude.  The result replaces the   *	argument.  *  *	+++ USAGE +++  *  *	 double cabs(z)  *	 COMPLEX *z;  *  *	+++ PROGRAMMER +++   *
  *	 Fred FishN)  *	 Goodyear Aerospace Corp, Arizona Div.   *	 (602) 932-7000 workC  *	 (602) 894-6881 home   *  *	+++ INTERNALS +++  *.  *	Computes CABS(z) where z = (x) + j(y) from:  *  *		CABS(z) = DSQRT(x*x + y*y)  *  *	---  */   
 /*)LIBRARY */   #include <stdio.h> #include "c:pmluse.h"  #include "pml.h"     double cabs(z) register COMPLEX *z; {      double dsqrt();   >     return (dsqrt((z->real * z->real) + (z->imag * z->imag))); } 