 /*  *	+++ NAME +++   *+  *	 DINT   Double precision integer portion   *  *	+++ INDEX +++  *  *	 DINT  *	 machine dependent routines  *	 math libraries  *  *	+++ DESCRIPTION +++  *?  *	Returns integer portion of double precision number as double   *	precision number.  *  *	+++ USAGE +++  *  *	 double dint(x)
  *	 double x;   *  *	+++ PROGRAMMER +++   *
  *	 Fred Fish )  *	 Goodyear Aerospace Corp, Arizona Div.  *	 (602) 932-7000 work   *	 (602) 894-6881 home  *  *	+++ RESTRICTIONS +++  *<  *	The current DEC-20 C system treats double as float.  This>  *	routine will need to be modified when true double precision  *	is implemented.  *  *	---  */   
 /*)LIBRARY */   #include <stdio.h> #include "c:pmluse.h"  #include "pml.h"     #ifdef PDP10? #define W1_FBITS  27		/* Number of fractional bits in word 1 */ H #define WORD_MASK 0777777777777	/* Mask for all 36 bits of first word	*/   double dint(x)	 double x;  { "     register int *vpntr, exponent;     int dxexp();       vpntr = &x;Z#     if ((exponent=dxexp(x)) <= 0) { 	 	x = 0.0; &     } else if (exponent <= W1_FBITS) {0 	*vpntr &= (WORD_MASK << (W1_FBITS - exponent));     } else { 	pmlerr(DINT_2BIG); 	 	x = 0.0;      }      if (x < 0.0) {
 	x += 1.0;     }      return (x);  }  #endif   #ifdef pdp11: #define W1_FBITS  8		/* (NOTE HIDDEN BIT NORMALIZATION)	*/? #define W2_FBITS  16		/* Number of fractional bits in word 2	*/ ? #define W3_FBITS  16		/* Number of fractional bits in word 3	*/ ? #define W4_FBITS  16		/* Number of fractional bits in word 4	*/ C #define WORD_MASK 0177777	/* Mask for each word of 4 word double	*/    double dint(x)	 double x;  { $     int exponent, dxexp(), fbitdown;,     register int *t1, *t2, *t3, *t4, *vpntr;       vpntr = &x;      t1 = &x;     t2 = t1+1;     t3 = t1+2;     t4 = t1+3;#     if ((exponent=dxexp(x)) <= 0) { 	 	x = 0.0; &     } else if (exponent <= W1_FBITS) {2 	*vpntr++ &= (WORD_MASK << (W1_FBITS - exponent)); 	*vpntr++ = 0; 	*vpntr++ = 0; 	*vpntr++ = 0;<     } else if (exponent <= (fbitdown = W1_FBITS+W2_FBITS)) {	 	vpntr++; 2 	*vpntr++ &= (WORD_MASK << (fbitdown - exponent)); 	*vpntr++ = 0; 	*vpntr++ = 0;E     } else if (exponent <= (fbitdown = W1_FBITS+W2_FBITS+W3_FBITS)) { 	 	vpntr++; 	 	vpntr++; 0 	*vpntr &= (WORD_MASK << (fbitdown - exponent)); 	*vpntr++ = 0;N     } else if (exponent <= (fbitdown = W1_FBITS+W2_FBITS+W3_FBITS+W4_FBITS)) {	 	vpntr++; 	 	vpntr++; 2 	*++vpntr &= (WORD_MASK << (fbitdown - exponent));     } else { 	pmlerr(DINT_2BIG);      }      return (x);  }  #endif