 /*  *	+++ NAME +++   *&  *	 DLN   Double precision natural log  *  *	+++ INDEX +++  *  *	 DLN    *	 machine independent routines  *	 math libraries  *  *	+++ DESCRIPTION +++  *;  *	Returns double precision natural log of double precision   *	floating point argument.   *  *	+++ USAGE +++  *  *	 double dln(x) 
  *	 double x;   *  *	+++ REFERENCES +++   *?  *	Computer Approximations, J.F. Hart et al, John Wiley & Sons,   *	1968, pp. 105-111.   *  *	+++ RESTRICTIONS +++   *8  *	The absolute error in the approximating polynomial is7  *	10**(-19.38).  Note that contrary to DEC's assertion29  *	in the F4P user's guide, the error is absolute and nots  *	relative.  *,  *	This error bound assumes exact arithmetic9  *	in the polynomial evaluation.  Additional rounding ande9  *	truncation errors may occur as the argument is reduced 7  *	to the range over which the polynomial approximationT5  *	is valid, and as the polynomial is evaluated using   *	finite-precision arithmetic.T  *  *	+++ PROGRAMMER +++h  *
  *	 Fred Fishn)  *	 Goodyear Aerospace Corp, Arizona Div.   *	 (602) 932-7000 workC  *	 (602) 894-6881 homeL  *  *	+++ INTERNALS +++  *  *	Computes DLN(X) from:  *.  *		(1)	If argument is zero then flag an error-  *			and return minus infinity (or rather itsG  *			machine representation).   *,  *		(2)	If argument is negative then flag an%  *			error and return minus infinity.s  *,  *		(3)	Given that x = m * 2**k then extract  *			mantissa m and exponent k.r  */  *		(4)	Transform m which is in range [0.5,1.0]o&  *			to range [1/sqrt(2), sqrt(2)] by:  *  *				s = m * sqrt(2)a  *%  *		(4)	Compute z = (s - 1) / (s + 1)	  *+  *		(5)	Now use the approximation from HARTf  *			page 111 to find ln(s):  *'  *			DLN(s) = z * ( P(z**2) / Q(z**2) )w  *  *			Where:	  *'  *			P(z**2) =  SUM [ Pj * (z**(2*j)) ]E  *			over j = {0,1,2,3}M  *'  *			Q(z**2) =  SUM [ Qj * (z**(2*j)) ]f  *			over j = {0,1,2,3}O  *(  *			P0 =  -0.240139179559210509868484e2&  *			P1 =  0.30957292821537650062264e2$  *			P2 =  -0.96376909336868659324e1   *			P3 =  0.4210873712179797145(  *			Q0 =  -0.120069589779605254717525e2&  *			Q1 =  0.19480966070088973051623e2$  *			Q2 =  -0.89111090279378312337e1  *			Q3 =  1.0000   *0  *			(coefficients from HART table #2705 pg 229)  *-  *			Note: according to a message in the Unixm(  *			USENET, the accuracy of the routine/  *			can be improved by changing the definition   *			of P2 above to:  *!  *			P2 = -.963769093377840513e1;r  *#  *			Submitted by Guido van Rossum,I!  *			{philabs,decvax}!mcvax!guidoc1  *			Centre for Mathematics and Computer Science,d  *			Amsterdam  *&  *			(with thanks to Lambert Meertens)  *$  *	(5)	Finally, compute DLN(x) from:  *2  *			DLN(x) = (k * dln(2)) - dln(sqrt(2)) + dln(s)  *  *	---  */o  
 /*)LIBRARY */   #include <stdio.h> #include "c:pmluse.h"E #include "pml.h"   static double dln_pcoeffs[] = {     -0.24013917955921050986e2,w     0.30957292821537650062e2,t #if 0e    -0.96376909336868659324e1,1 #elseS2     -.963769093377840513e1,		/* See note above		*/ #endif     0.4210873712179797145k };   static double dln_qcoeffs[] = {e    -0.12006958977960525471e2,o     0.19480966070088973051e2,2    -0.89111090279378312337e1,d
     1.0000 };   1
 double dln(x)i	 double x;( {      register int k;y     int dxexp();/     double s, z, zt2, dxmant(), pqofz, dpoly();        if (x == 0.0) {n 	pmlerr(LOG_OF_ZERO);k 	return(MAX_NEG_DBLF);     } else if (x < 0.0) {y 	pmlerr(LOG_OF_NEGATIVE);T 	return(MAX_NEG_DBLF);     } else { 	k = dxexp(x); 	s = DSQRT2 * dxmant(x); 	z = (s - 1.0) / (s + 1.0);r
 	zt2 = z * z; D 	pqofz = z * ( dpoly(3,dln_pcoeffs,zt2) / dpoly(3,dln_qcoeffs,zt2));& 	return ((k * LN2) - LNSQRT2 + pqofz);     }e }e  