 /*  *	+++ NAME +++   *2  *	 DPOLY   Double precision polynomial evaluation  *  *	+++ INDEX +++  *	  *	 DPOLY    *	 machine independent routines  *	 math libraries  *  *	+++ DESCRIPTION +++  *6  *	Evaluates a polynomial and returns double precision4  *	result.  Is passed a the order of the polynomial,7  *	a pointer to an array of double precision polynomial 9  *	coefficients (in ascending order), and the independent   *	variable.  *  *	+++ USAGE +++  *   *	 double dpoly(order,coeffs,x)  *	 int order;  *	 double *coeffs; 
  *	 double x;   *  *	+++ PROGRAMMER +++   *
  *	 Fred Fish )  *	 Goodyear Aerospace Corp, Arizona Div.   *	 (602) 932-7000 work   *	 (602) 894-6881 home   *  *	+++ INTERNALS +++  *8  *	Evalates the polynomial using recursion and the form:  *'  *		P(x) = P0 + x(P1 + x(P2 +...x(Pn)))   *  *	---  */   
 /*)LIBRARY */   #include <stdio.h> #include "c:pmluse.h"  #include "pml.h"     double dpoly(order,coeffs,x) register int order;  register double *coeffs;	 double x; {      double curr_coeff;     if (order <= 0) {  	return (*coeffs);     } else { 	curr_coeff = *coeffs++;2 	return(curr_coeff + x * dpoly(--order,coeffs,x));     }  }    /*@  *    NOTE:	If you try to be clever and eliminate the curr_coeff0  *		variable in the return line, by substituting3  *		*coeffs++, disaster may strike if your compiler 0  *		does not guarantee left-to-right evaluation.  */ 