 /*  *	+++ NAME +++   *5  *	 DXEXP   extract double precision numbers exponent   *  *	+++ INDEX +++  *	  *	 DXEXP   *	 math libraries  *	 machine dependent routines  *  *	+++ DESCRIPTION +++  *7  *	Extracts exponent from a double precision number and )  *	returns it as a normal length integer.X  *  *	+++ USAGE +++  *  *	 int dxexp(value)  *	 double value;   *  *	+++ PROGRAMMER +++   *
  *	 Fred Fish )  *	 Goodyear Aerospace Corp, Arizona Div.  *	 (602) 932-7000 work   *	 (602) 894-6881 homeI  *  *	+++ INTERNALS +++  *9  *	This routine is highly machine dependent.  As such, no 9  *	attempt was made to make it general, hence it may have 8  *	to be completely rewritten when transportation of the'  *	floating point library is attempted.   *<  *	For the DECSYSTEM-20 the double precision word format is:  *2  *	 WORD N	=>	SEEEEEEEEMMMMMMMMMMMMMMMMMMMMMMMMMMM4  *	 WORD N+1 =>	XMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM  *6  *	For the PDP-11 the double precision word format is:  *  *	 WORD N =>	SEEEEEEEEMMMMMMM   *	 WORD N+1 =>	MMMMMMMMMMMMMMMM   *	 WORD N+2 =>	MMMMMMMMMMMMMMMM   *	 WORD N+3 =>	MMMMMMMMMMMMMMMM  *  *	Where:		S  =>	Sign bitD  *			E  =>	ExponentM  *			X  =>	Ignored (set to 0)i  *			M  =>	Mantissa bit   *  *  */n  
 /*)LIBRARY */   #include <stdio.h> #include "c:pmluse.h"A #include "pml.h"   #ifdef PDP109 #define EXP_MASK  0377000000000		/* Mask for exponent		*/n6 #define EXP_SHIFTS 27			/* Shifts to get into LSB's	*/ #endif   #ifdef pdp112 #define EXP_MASK 077600			/* Mask for exponent		*/5 #define EXP_SHIFTS 7			/* Shifts to get into LSB's	*/* #endif  
 #ifdef vax2 #define EXP_MASK 077600			/* Mask for exponent		*/5 #define EXP_SHIFTS 7			/* Shifts to get into LSB's	*/e #endif   / int dxexp(value)
 double value;g {v     register int *vpntr;       if (value == 0.0) {A 	return (0);     } else { 	vpntr = &value; #ifdef PDP103 	if (value < 0.0) {		/* Exponent is complemented */n 	    *vpntr = ~*vpntr; 	} #endif 	*vpntr &= EXP_MASK; 	*vpntr = *vpntr >> EXP_SHIFTS;e 	return (*vpntr - 128);r     }p };  