 /*  *	+++ NAME +++   *7  *	 DXMANT   Extract double precision number's mantissa   *  *	+++ INDEX +++  *
  *	 DXMANT  *	 math libraries  *	 machine dependent routines  *  *	+++ DESCRIPTION +++  *?  *	Extracts a double precision number's mantissa and returns it >  *	as a double precision number with a normalized mantissa and  *	a zero exponent.$  *  *	+++ USAGE +++  *  *	 double dxmant(value)  *	 double value;   *  *	+++ PROGRAMMER +++   *
  *	 Fred Fish)  *	 Goodyear Aerospace Corp, Arizona Div.N  *	 (602) 932-7000 work   *	 (602) 894-6881 home   *  *	+++ INTERNALS +++  *9  *	This routine is highly machine dependent.  As such, no 9  *	attempt was made to make it general, hence it may have 8  *	to be completely rewritten when transportation of the'  *	floating point library is attempted.   *<  *	For the DECSYSTEM-20 the double precision word format is:  *2  *	 WORD N	=>	SEEEEEEEEMMMMMMMMMMMMMMMMMMMMMMMMMMM4  *	 WORD N+1 =>	XMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM  *6  *	For the PDP-11 the double precision word format is:  *  *	 WORD N =>	SEEEEEEEEMMMMMMM   *	 WORD N+1 =>	MMMMMMMMMMMMMMMM   *	 WORD N+2 =>	MMMMMMMMMMMMMMMM   *	 WORD N+3 =>	MMMMMMMMMMMMMMMM  *  *	Where:		S  =>	Sign bitM  *			E  =>	ExponentO  *			X  =>	Ignored (set to 0)   *			M  =>	Mantissa bit   *  */   
 /*)LIBRARY */   #include <stdio.h> #include "c:pmluse.h"s #include "pml.h"   #ifdef PDP10? #define MANT_MASK 0400777777777		/* Mantissa extraction mask	*/l? #define ZPOS_MASK 0200000000000		/* Positive # zero exp mask	*/i? #define ZNEG_MASK 0177000000000		/* Negative # zero exp mask	*/v #endif   #ifdef pdp119 #define MANT_MASK 0100177		/* Mantissa extraction mask	*/ 8 #define ZPOS_MASK 040000		/* Positive # zero exp mask	*/8 #define ZNEG_MASK 040000		/* Negative # zero exp mask	*/ #endif  
 #ifdef vax9 #define MANT_MASK 0100177		/* Mantissa extraction mask	*/k8 #define ZPOS_MASK 040000		/* Positive # zero exp mask	*/8 #define ZNEG_MASK 040000		/* Negative # zero exp mask	*/ #endif p double dxmant(value)
 double value;S {t     register int *vpntr;       if (value != 0.0) {  	vpntr = &value; 	*vpntr &= MANT_MASK;/ 	if (value < 0.0) {1 	    *vpntr |= ZNEG_MASK;		 	} else {n 	    *vpntr |= ZPOS_MASK;t 	}     }L     return(value); }M