/* 
 * pkg5.c --
 *
 *	This file provides a test case for Tcl's loading facilities.
 *	It contains an undefined symbol reference, which should cause
 *	the package not to load properly.
 *
 * Copyright (c) 1995 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

static char sccsid[] = "@(#) pkg5.c 1.1 95/08/22 08:07:36";
#include "tcl.h"

/*
 * Prototypes for procedures defined later in this file:
 */

static int	Pkg5_BogusCmd _ANSI_ARGS_((ClientData clientData,
		    Tcl_Interp *interp, int argc, char **argv));

/*
 *----------------------------------------------------------------------
 *
 * Pkg5_BogusCmd --
 *
 *	This procedure is invoked to process the "pkg5_bogus" Tcl command.
 *	It expects one argument, which it returns as result.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	See the user documentation.
 *
 *----------------------------------------------------------------------
 */

static int
Pkg5_BogusCmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Not used. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
    extern int non_existent_int;

    sprintf(interp->result, "%d", non_existent_int);
    return TCL_OK;
}

/*
 *----------------------------------------------------------------------
 *
 * Pkg5_Init --
 *
 *	This is a package initialization procedure, which is called
 *	by Tcl when this package is to be added to an interpreter.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

int
Pkg5_Init(interp)
    Tcl_Interp *interp;		/* Interpreter in which the package is
				 * to be made available. */
{
    Tcl_CreateCommand(interp, "pkg5_bogus", Pkg5_BogusCmd, (ClientData) 0,
	    (Tcl_CmdDeleteProc *) NULL);
    return TCL_OK;
}
