/* 
 * tclUnixInit.c --
 *
 *	Contains the Unix-specific interpreter initialization functions.
 *
 * Copyright (c) 1995 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

static char sccsid[] = "@(#) tclUnixInit.c 1.6 95/10/02 14:18:50";

#include "tclInt.h"
#ifndef NO_UNAME
#   include <sys/utsname.h>
#endif

#ifdef VMS
static int getsyiStuff(char *node, char *version);
#endif /* VMS */

/*
 *----------------------------------------------------------------------
 *
 * TclPlatformInit --
 *
 *	Performs Unix-specific interpreter initialization related to the
 *      tcl_library and tcl_platform.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Sets "tcl_library" and "tcl_platform" Tcl variables.
 *
 *----------------------------------------------------------------------
 */

void
TclPlatformInit(interp)
    Tcl_Interp *interp;
{
    char *libDir;
#ifndef NO_UNAME
    struct utsname name;
#endif
#ifdef VMS
    char node[17];
    char version[10];
#endif /* VMS */
    int unameOK;

    libDir = Tcl_GetVar2(interp, "env", "TCL_LIBRARY", TCL_GLOBAL_ONLY);
    if (libDir == NULL) {
	libDir = TCL_LIBRARY;
    }
    Tcl_SetVar(interp, "tcl_library", libDir, TCL_GLOBAL_ONLY);

    /*
    	It's defined as "unix" even on VMS.
    */
    Tcl_SetVar2(interp, "tcl_platform", "platform", "unix", TCL_GLOBAL_ONLY);
    unameOK = 0;
#ifndef NO_UNAME
    if (uname(&name) >= 0) {
	unameOK = 1;
	Tcl_SetVar2(interp, "tcl_platform", "os", name.sysname,
		TCL_GLOBAL_ONLY);
	Tcl_SetVar2(interp, "tcl_platform", "osVersion", name.release,
		TCL_GLOBAL_ONLY);
	Tcl_SetVar2(interp, "tcl_platform", "machine", name.machine,
		TCL_GLOBAL_ONLY);
    }
#endif
#ifdef VMS
    if (getsyiStuff(node, version)) {
	Tcl_SetVar2(interp, "tcl_platform", "os", "VMS", TCL_GLOBAL_ONLY);
	Tcl_SetVar2(interp, "tcl_platform", "osVersion", version, TCL_GLOBAL_ONLY);
	Tcl_SetVar2(interp, "tcl_platform", "machine", node, TCL_GLOBAL_ONLY);
	unameOK = 1;
    }
#endif /* VMS */
    if (!unameOK) {
	Tcl_SetVar2(interp, "tcl_platform", "os", "", TCL_GLOBAL_ONLY);
	Tcl_SetVar2(interp, "tcl_platform", "osVersion", "", TCL_GLOBAL_ONLY);
	Tcl_SetVar2(interp, "tcl_platform", "machine", "", TCL_GLOBAL_ONLY);
    }
}

/*
 *----------------------------------------------------------------------
 *
 * Tcl_Init --
 *
 *	This procedure is typically invoked by Tcl_AppInit procedures
 *	to perform additional initialization for a Tcl interpreter,
 *	such as sourcing the "init.tcl" script.
 *
 * Results:
 *	Returns a standard Tcl completion code and sets interp->result
 *	if there is an error.
 *
 * Side effects:
 *	Depends on what's in the init.tcl script.
 *
 *----------------------------------------------------------------------
 */

int
Tcl_Init(interp)
    Tcl_Interp *interp;		/* Interpreter to initialize. */
{
    static char initCmd[] =
	"if [file exists [info library]/init.tcl] {\n\
	    source [info library]/init.tcl\n\
	} else {\n\
	    set msg \"can't find [info library]/init.tcl; perhaps you \"\n\
	    append msg \"need to\\ninstall Tcl or set your TCL_LIBRARY \"\n\
	    append msg \"environment variable?\"\n\
	    error $msg\n\
	}";

    return Tcl_Eval(interp, initCmd);
}

#ifdef VMS
#include <starlet.h>
#include <syidef.h>

static 
getsyiStuff(char *node, char *version)
{
    short		lengthVersion;
    short		lengthNode;
    int			status;
    struct {
    	short	buflen;
    	short	item;
    	void	*addr;
    	short	*retLength;
    } syiList[3];

    syiList[0].buflen = 9;
    syiList[0].item = SYI$_VERSION;
    syiList[0].addr = version;
    syiList[0].retLength = &lengthVersion;
    syiList[1].buflen = 16;
    syiList[1].item = SYI$_NODENAME;
    syiList[1].addr = node;
    syiList[1].retLength = &lengthNode;
    syiList[2].buflen = 0;
    syiList[2].item = 0;
    status = sys$getsyiw(0, 0, 0, syiList, 0, 0, 0);
    if (status & 1) {
    	version[lengthVersion] = 0;
    	node[lengthNode] = 0;
    	return 1;
    }
    else
    	return 0;
}
#endif	/* VMS */
