#ifdef VMS	/* In case it gets compiled somewhere else... */

#include <starlet.h>
#include <stdio.h>
#include <ssdef.h>
#include <fscndef.h>
#include <string.h>
#include <unixlib.h>

static struct {
    char	*what;
    int		item;
} items[] = { "node", FSCN$_NODE,
	      "device", FSCN$_DEVICE,
	      "directory", FSCN$_DIRECTORY,
	      "filename", FSCN$_NAME,
	      "name", FSCN$_NAME,
	      "type", FSCN$_TYPE,
	      "extension", FSCN$_TYPE,
	      "version", FSCN$_VERSION,
	      NULL, 0
	    };

Tcl_VmsParseFileName(char *file, char *what, char *result)
{
    /*
	Return one piece from a DEC filename
    */
    int			status, flags;
    int			n;
    struct _fscn {
	short	length;
	short	item;
	char	*address;
    } ss[2];
    struct {
	int	l;
	char	*a;
    } d;

    ss[0].item = 0;
    for (n=0; items[n].what; n++) {
	if (strstr(items[n].what, what) == items[n].what) {
	    ss[0].item = items[n].item;
	    break;
	}
    }
    if (ss[0].item == 0)
	return(0);
    ss[1].length = ss[1].item = 0;
    d.l = strlen(file);
    d.a = file;
    status = sys$filescan(&d, &ss, &flags);
    if (status == SS$_NORMAL) {
	n = ss[0].length;
	if (n)
	    strncpy(result, ss[0].address, n);
	result[n] = 0;
	status = 1;
    }
    else
	status = 0;
    return status;
}

static int	actionRoutine(char *, int);
static char	*whereToCopy;

Tcl_Cvt2Vms(char *_unixName, char *vmsName)
{
    /*
	Convert a Unix filename to VMS
    */
    char		*s, *r;
    char		unixName[256];
    char		remainder[256];
    int			haveWild;

    /*
	If there are wildcard characters in the string, we
	need to remove them before trying to convert the string.
    */
    strcpy(unixName, _unixName);
    s = strchr(unixName, '*');
    if (s) {
    	/*
    	    Find the start of the last directory spec
	*/
    	for (r=s; r != unixName; r--) {
    	    if (*r == '/') {
    	    	strcpy(remainder, r+1);
    	    	*r = 0;
    	    	break;
    	    }
	}
	if (r == unixName) {
	    strcpy(unixName, ".");
	    strcpy(remainder, _unixName);
	}
	haveWild = 1;
	/* if (strchr(remainder, '/')) { bad news } */
    }
    else
    	haveWild = 0;

    whereToCopy = vmsName;

    /*
    	Don't have access to the docs to see
    	what the last argument is good for.
    */
    if (decc$to_vms(unixName, actionRoutine, 0, 0))
    {
        if (haveWild)
            strcat(vmsName, remainder);
	return 1;
    }
    else
	return 0;
}

static
actionRoutine(char *s, int whoKnows)
{
    strcpy(whereToCopy, s);
}



/* On VMS, fputs() cannot deal with strings > 64k.
   So do the transfer in chunks no larger than 32k.
         - sss (snyder@fnald0.fnal.gov) */
#ifdef fputs
#undef fputs
#endif
int Tcl_sys_fputs (char *text, FILE *f)
{
  const int chunk_size = 32768;
  int len_left = strlen (text);
  int ret;

  /* Don't write on the string if we don't have to. */
  if (len_left <= chunk_size)
    return fputs (text, f);

  while (len_left > 0) {
    char oldch;
    int thislen = len_left;
    if (thislen > chunk_size)
      thislen = chunk_size;
    oldch = (unsigned char)text[thislen];
    text[thislen] = '\0';
    if ((ret = fputs (text, f)) < 0)
      break;
    text[thislen] = oldch;
    text += thislen;
    len_left -= thislen;
  }
  return ret;
}


#endif	/* VMS */
