/* $XConsortium: ImUtil.c,v 11.60 94/04/17 20:19:59 kaleb Exp $ */
/*

Copyright (c) 1986  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.

*/

#if 0
#include <X11/Xlibint.h>
#else
typedef void *caddr_t;
# define Xcalloc(nelem, elsize) calloc(((nelem) > 0 ? (nelem) : 1), (elsize))
#include <X11/Xproto.h>
#include <X11/Xlib.h>
#endif
#include <X11/Xutil.h>
#include <stdio.h>

#if __STDC__
#define Const const
#else
#define Const /**/
#endif

#if NeedFunctionPrototypes
static int _XDestroyImage(XImage *);
static unsigned long _XGetPixel(XImage *, int, int);
static unsigned long _XGetPixel1(XImage *, int, int);
static unsigned long _XGetPixel8(XImage *, int, int);
static unsigned long _XGetPixel16(XImage *, int, int);
static unsigned long _XGetPixel32(XImage *, int, int);
static int _XPutPixel(XImage *, int, int, unsigned long);
static int _XPutPixel1(XImage *, int, int, unsigned long);
static int _XPutPixel8(XImage *, int, int, unsigned long);
static int _XPutPixel16(XImage *, int, int, unsigned long);
static int _XPutPixel32(XImage *, int, int, unsigned long);
static XImage *_XSubImage(XImage *, int, int, unsigned int, unsigned int);
static int _XAddPixel(XImage *, long);
#endif
static int _XReverse_Bytes ();

static unsigned char Const _lomask[0x09] = { 0x00, 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7f, 0xff };
static unsigned char Const _himask[0x09] = { 0xff, 0xfe, 0xfc, 0xf8, 0xf0, 0xe0, 0xc0, 0x80, 0x00 };

/*
 * This module provides rudimentary manipulation routines for image data
 * structures.  The functions provided are:
 *
 *	XCreateImage	Creates a default XImage data structure
 *	_XDestroyImage	Deletes an XImage data structure
 *	_XGetPixel	Reads a pixel from an image data structure
 *	_XGetPixel32	Reads a pixel from a 32-bit Z image data structure
 *	_XGetPixel16	Reads a pixel from a 16-bit Z image data structure
 *	_XGetPixel8	Reads a pixel from an 8-bit Z image data structure
 *	_XGetPixel1	Reads a pixel from an 1-bit image data structure
 *	_XPutPixel	Writes a pixel into an image data structure
 *	_XPutPixel32	Writes a pixel into a 32-bit Z image data structure
 *	_XPutPixel16	Writes a pixel into a 16-bit Z image data structure
 *	_XPutPixel8	Writes a pixel into an 8-bit Z image data structure
 *	_XPutPixel1	Writes a pixel into an 1-bit image data structure
 *	_XSubImage	Clones a new (sub)image from an existing one
 *	_XSetImage	Writes an image data pattern into another image
 *	_XAddPixel	Adds a constant value to every pixel in an image
 *
 * The logic contained in these routines makes several assumptions about
 * the image data structures, and at least for current implementations
 * these assumptions are believed to be true.  They are: 
 *
 *	For all formats, bits_per_pixel is less than or equal to 32.
 *	For XY formats, bitmap_unit is always less than or equal to bitmap_pad.
 *	For XY formats, bitmap_unit is 8, 16, or 32 bits.
 *	For Z format, bits_per_pixel is 1, 4, 8, 16, 24, or 32 bits.
 */
static _xynormalizeimagebits (bp, img)
    register unsigned char *bp;
    register XImage *img;
{
	register unsigned char c;

	if (img->byte_order != img->bitmap_bit_order) {
	    switch (img->bitmap_unit) {

		case 16:
		    c = *bp;
		    *bp = *(bp + 1);
		    *(bp + 1) = c;
		    break;

		case 32:
		    c = *(bp + 3);
		    *(bp + 3) = *bp;
		    *bp = c;
		    c = *(bp + 2);
		    *(bp + 2) = *(bp + 1);
		    *(bp + 1) = c;
		    break;
	    }
	}
	if (img->bitmap_bit_order == MSBFirst)
	    _XReverse_Bytes (bp, img->bitmap_unit >> 3);
}

static _znormalizeimagebits (bp, img)
    register unsigned char *bp;
    register XImage *img;
{
	register unsigned char c;
	switch (img->bits_per_pixel) {

	    case 4:
		*bp = ((*bp >> 4) & 0xF) | ((*bp << 4) & ~0xF);
		break;

	    case 16:
		c = *bp;
		*bp = *(bp + 1);
		*(bp + 1) = c;
		break;

	    case 24:
		c = *(bp + 2);
		*(bp + 2) = *bp;
		*bp = c;
		break;

	    case 32:
		c = *(bp + 3);
		*(bp + 3) = *bp;
		*bp = c;
		c = *(bp + 2);
		*(bp + 2) = *(bp + 1);
		*(bp + 1) = c;
		break;
	}
}

static _putbits (src, dstoffset, numbits, dst)
    register char *src;	/* address of source bit string */
    int dstoffset;	/* bit offset into destination; range is 0-31 */
    register int numbits;/* number of bits to copy to destination */
    register char *dst;	/* address of destination bit string */
{
	register unsigned char chlo, chhi;
	int hibits;
	dst = dst + (dstoffset >> 3);
	dstoffset = dstoffset & 7;
	hibits = 8 - dstoffset;
	chlo = *dst & _lomask[dstoffset];
	for (;;) {
	    chhi = (*src << dstoffset) & _himask[dstoffset];
	    if (numbits <= hibits) {
		chhi = chhi & _lomask[dstoffset + numbits];
		*dst = (*dst & _himask[dstoffset + numbits]) | chlo | chhi;
		break;
	    }
	    *dst = chhi | chlo;
	    dst++;
	    numbits = numbits - hibits;
	    chlo = (unsigned char) (*src & _himask[hibits]) >> hibits;
	    src++;
	    if (numbits <= dstoffset) {
		chlo = chlo & _lomask[numbits];
		*dst = (*dst & _himask[numbits]) | chlo;
		break;
	    }
	    numbits = numbits - dstoffset;
	}	
}


/*
 * Macros
 * 
 * The ROUNDUP macro rounds up a quantity to the specified boundary,
 * then truncates to bytes.
 *
 * The XYNORMALIZE macro determines whether XY format data requires 
 * normalization and calls a routine to do so if needed. The logic in
 * this module is designed for LSBFirst byte and bit order, so 
 * normalization is done as required to present the data in this order.
 *
 * The ZNORMALIZE macro performs byte and nibble order normalization if 
 * required for Z format data.
 *
 * The XYINDEX macro computes the index to the starting byte (char) boundary
 * for a bitmap_unit containing a pixel with coordinates x and y for image
 * data in XY format.
 * 
 * The ZINDEX macro computes the index to the starting byte (char) boundary 
 * for a pixel with coordinates x and y for image data in ZPixmap format.
 * 
 */

#define ROUNDUP(nbytes, pad) ((((nbytes) + ((pad)-1)) / (pad)) * ((pad)>>3))

#define XYNORMALIZE(bp, img) \
    if ((img->byte_order == MSBFirst) || (img->bitmap_bit_order == MSBFirst)) \
	_xynormalizeimagebits((unsigned char *)(bp), img)

#define ZNORMALIZE(bp, img) \
    if (img->byte_order == MSBFirst) \
	_znormalizeimagebits((unsigned char *)(bp), img)

#define XYINDEX(x, y, img) \
    ((y) * img->bytes_per_line) + \
    (((x) + img->xoffset) / img->bitmap_unit) * (img->bitmap_unit >> 3)

#define ZINDEX(x, y, img) ((y) * img->bytes_per_line) + \
    (((x) * img->bits_per_pixel) >> 3)


/*
 * _DestroyImage
 * 	
 * Deallocates the memory associated with the ximage data structure. 
 * this version handles the case of the image data being malloc'd
 * entirely by the library.
 */

static int _XDestroyImage (ximage)
    XImage *ximage;

{
	if (ximage->data != NULL) Xfree((char *)ximage->data);
	if (ximage->obdata != NULL) Xfree((char *)ximage->obdata);
	Xfree((char *)ximage);
	return 1;
}


/*
 * GetPixel
 * 
 * Returns the specified pixel.  The X and Y coordinates are relative to 
 * the origin (upper left [0,0]) of the image.  The pixel value is returned
 * in normalized format, i.e. the LSB of the long is the LSB of the pixel.
 * The algorithm used is:
 *
 *	copy the source bitmap_unit or Zpixel into temp
 *	normalize temp if needed
 *	extract the pixel bits into return value
 *
 */

static unsigned long Const low_bits_table[] = {
    0x00000000, 0x00000001, 0x00000003, 0x00000007,
    0x0000000f, 0x0000001f, 0x0000003f, 0x0000007f,
    0x000000ff, 0x000001ff, 0x000003ff, 0x000007ff,
    0x00000fff, 0x00001fff, 0x00003fff, 0x00007fff,
    0x0000ffff, 0x0001ffff, 0x0003ffff, 0x0007ffff,
    0x000fffff, 0x001fffff, 0x003fffff, 0x007fffff,
    0x00ffffff, 0x01ffffff, 0x03ffffff, 0x07ffffff,
    0x0fffffff, 0x1fffffff, 0x3fffffff, 0x7fffffff,
    0xffffffff
};

static unsigned long _XGetPixel (ximage, x, y)
    register XImage *ximage;
    int x;
    int y;

{
	unsigned long pixel, px;
	register char *src;
	register char *dst;
	register int i, j;
	int bits, nbytes;
	long plane;
     
	if ((ximage->bits_per_pixel | ximage->depth) == 1) {
		src = &ximage->data[XYINDEX(x, y, ximage)];
		dst = (char *)&pixel;
		pixel = 0;
		for (i = ximage->bitmap_unit >> 3; --i >= 0; ) *dst++ = *src++;
		XYNORMALIZE(&pixel, ximage);
          	bits = (x + ximage->xoffset) % ximage->bitmap_unit;
		pixel = ((((char *)&pixel)[bits>>3])>>(bits&7)) & 1;
	} else if (ximage->format == XYPixmap) {
		pixel = 0;
		plane = 0;
		nbytes = ximage->bitmap_unit >> 3;
		for (i = ximage->depth; --i >= 0; ) {
		    src = &ximage->data[XYINDEX(x, y, ximage)+ plane];
		    dst = (char *)&px;
		    px = 0;
		    for (j = nbytes; --j >= 0; ) *dst++ = *src++;
		    XYNORMALIZE(&px, ximage);
		    bits = (x + ximage->xoffset) % ximage->bitmap_unit;
		    pixel = (pixel << 1) |
			    (((((char *)&px)[bits>>3])>>(bits&7)) & 1);
		    plane = plane + (ximage->bytes_per_line * ximage->height);
		}
	} else if (ximage->format == ZPixmap) {
		src = &ximage->data[ZINDEX(x, y, ximage)];
		dst = (char *)&px;
		px = 0;
		for (i = (ximage->bits_per_pixel + 7) >> 3; --i >= 0; )
		    *dst++ = *src++;		
		ZNORMALIZE(&px, ximage);
		pixel = 0;
		for (i=sizeof(unsigned long); --i >= 0; )
		    pixel = (pixel << 8) | ((unsigned char *)&px)[i];
		if (ximage->bits_per_pixel == 4) {
		    if (x & 1)
			pixel >>= 4;
		    else
			pixel &= 0xf;
		}
	} else {
		return 0; /* bad image */
	}
	if (ximage->bits_per_pixel == ximage->depth)
	  return pixel;
	else
	  return (pixel & low_bits_table[ximage->depth]);
}

#ifndef WORD64
static unsigned long byteorderpixel = MSBFirst << 24;
#endif

static unsigned long _XGetPixel32 (ximage, x, y)
    register XImage *ximage;
    int x;
    int y;
{
	register unsigned char *addr;
	unsigned long pixel;

	if ((ximage->format == ZPixmap) && (ximage->bits_per_pixel == 32)) {
	    addr = &((unsigned char *)ximage->data)
			[y * ximage->bytes_per_line + (x << 2)];
#ifndef WORD64
	    if (*((char *)&byteorderpixel) == ximage->byte_order)
		pixel = *((CARD32 *)addr);
	    else
#endif
	    if (ximage->byte_order == MSBFirst)
		pixel = ((unsigned long)addr[0] << 24 |
			 (unsigned long)addr[1] << 16 |
			 (unsigned long)addr[2] << 8 |
			 addr[3]);
	    else
		pixel = ((unsigned long)addr[3] << 24 |
			 (unsigned long)addr[2] << 16 |
			 (unsigned long)addr[1] << 8 |
			 addr[0]);
	    if (ximage->depth != 32)
		pixel &= low_bits_table[ximage->depth];
	    return pixel;
	} else {
	    _XInitImageFuncPtrs(ximage);
	    return XGetPixel(ximage, x, y);
	}
}

static unsigned long _XGetPixel16 (ximage, x, y)
    register XImage *ximage;
    int x;
    int y;
{
	register unsigned char *addr;
	unsigned long pixel;

	if ((ximage->format == ZPixmap) && (ximage->bits_per_pixel == 16)) {
	    addr = &((unsigned char *)ximage->data)
			[y * ximage->bytes_per_line + (x << 1)];
	    if (ximage->byte_order == MSBFirst)
		pixel = addr[0] << 8 | addr[1];
	    else
		pixel = addr[1] << 8 | addr[0];
	    if (ximage->depth != 16)
		pixel &= low_bits_table[ximage->depth];
	    return pixel;
	} else {
	    _XInitImageFuncPtrs(ximage);
	    return XGetPixel(ximage, x, y);
	}
}

static unsigned long _XGetPixel8 (ximage, x, y)
    register XImage *ximage;
    int x;
    int y;
{
	unsigned char pixel;

	if ((ximage->format == ZPixmap) && (ximage->bits_per_pixel == 8)) {
	    pixel = ((unsigned char *)ximage->data)
			[y * ximage->bytes_per_line + x];
	    if (ximage->depth != 8)
		pixel &= low_bits_table[ximage->depth];
	    return pixel;
	} else {
	    _XInitImageFuncPtrs(ximage);
	    return XGetPixel(ximage, x, y);
	}
}

static unsigned long _XGetPixel1 (ximage, x, y)
    register XImage *ximage;
    int x;
    int y;
{
	unsigned char bit;
	int xoff, yoff;

	if (((ximage->bits_per_pixel | ximage->depth) == 1) &&
	    (ximage->byte_order == ximage->bitmap_bit_order)) {
	    xoff = x + ximage->xoffset;
	    yoff = y * ximage->bytes_per_line + (xoff >> 3);
	    xoff &= 7;
	    if (ximage->bitmap_bit_order == MSBFirst)
	        bit = 0x80 >> xoff;
	    else
		bit = 1 << xoff;
	    return (ximage->data[yoff] & bit) ? 1 : 0;
	} else {
	    _XInitImageFuncPtrs(ximage);
	    return XGetPixel(ximage, x, y);
	}
}
	
/*
 * PutPixel
 * 
 * Overwrites the specified pixel.  The X and Y coordinates are relative to 
 * the origin (upper left [0,0]) of the image.  The input pixel value must be
 * in normalized format, i.e. the LSB of the long is the LSB of the pixel.
 * The algorithm used is:
 *
 *	copy the destination bitmap_unit or Zpixel to temp
 *	normalize temp if needed
 *	copy the pixel bits into the temp
 *	renormalize temp if needed
 *	copy the temp back into the destination image data
 *
 */

static int _XPutPixel (ximage, x, y, pixel)
    register XImage *ximage;
    int x;
    int y;
    unsigned long pixel;

{
	unsigned long px, npixel;
	register char *src;
	register char *dst;
	register int i;
	int j, nbytes;
	long plane;

	if (ximage->depth == 4)
	    pixel &= 0xf;
        npixel = pixel;
	for (i=0, px=pixel; i<sizeof(unsigned long); i++, px>>=8)
	    ((unsigned char *)&pixel)[i] = px;
	if ((ximage->bits_per_pixel | ximage->depth) == 1) {
		src = &ximage->data[XYINDEX(x, y, ximage)];
		dst = (char *)&px;
		px = 0;
		nbytes = ximage->bitmap_unit >> 3;
		for (i = nbytes; --i >= 0; ) *dst++ = *src++;
		XYNORMALIZE(&px, ximage);
		i = ((x + ximage->xoffset) % ximage->bitmap_unit);
		_putbits ((char *)&pixel, i, 1, (char *)&px);
		XYNORMALIZE(&px, ximage);
		src = (char *) &px;
		dst = &ximage->data[XYINDEX(x, y, ximage)];
		for (i = nbytes; --i >= 0; ) *dst++ = *src++;
	} else if (ximage->format == XYPixmap) {
		plane = (ximage->bytes_per_line * ximage->height) *
		    (ximage->depth - 1); /* do least signif plane 1st */
		nbytes = ximage->bitmap_unit >> 3;
		for (j = ximage->depth; --j >= 0; ) {
		    src = &ximage->data[XYINDEX(x, y, ximage) + plane];
		    dst = (char *) &px;
		    px = 0;
		    for (i = nbytes; --i >= 0; ) *dst++ = *src++;
		    XYNORMALIZE(&px, ximage);
		    i = ((x + ximage->xoffset) % ximage->bitmap_unit);
		    _putbits ((char *)&pixel, i, 1, (char *)&px);
		    XYNORMALIZE(&px, ximage);
		    src = (char *)&px;
		    dst = &ximage->data[XYINDEX(x, y, ximage) + plane];
		    for (i = nbytes; --i >= 0; ) *dst++ = *src++;
		    npixel = npixel >> 1;
		    for (i=0, px=npixel; i<sizeof(unsigned long); i++, px>>=8)
			((unsigned char *)&pixel)[i] = px;
		    plane = plane - (ximage->bytes_per_line * ximage->height);
		}
	} else if (ximage->format == ZPixmap) {
		src = &ximage->data[ZINDEX(x, y, ximage)];
		dst = (char *)&px;
		px = 0;
		nbytes = (ximage->bits_per_pixel + 7) >> 3;
		for (i = nbytes; --i >= 0; ) *dst++ = *src++;
		ZNORMALIZE(&px, ximage);
		_putbits ((char *)&pixel, 
			  (x * ximage->bits_per_pixel) & 7, 
			  ximage->bits_per_pixel, (char *)&px);
		ZNORMALIZE(&px, ximage);
		src = (char *)&px;
		dst = &ximage->data[ZINDEX(x, y, ximage)];
		for (i = nbytes; --i >= 0; ) *dst++ = *src++;
	} else {
		return 0; /* bad image */
	}
	return 1;
}

static int _XPutPixel32 (ximage, x, y, pixel)
    register XImage *ximage;
    int x;
    int y;
    unsigned long pixel;
{
	unsigned char *addr;

	if ((ximage->format == ZPixmap) && (ximage->bits_per_pixel == 32)) {
	    addr = &((unsigned char *)ximage->data)
			[y * ximage->bytes_per_line + (x << 2)];
#ifndef WORD64
	    if (*((char *)&byteorderpixel) == ximage->byte_order)
		*((CARD32 *)addr) = pixel;
	    else
#endif
	    if (ximage->byte_order == MSBFirst) {
		addr[0] = pixel >> 24;
		addr[1] = pixel >> 16;
		addr[2] = pixel >> 8;
		addr[3] = pixel;
	    } else {
		addr[3] = pixel >> 24;
		addr[2] = pixel >> 16;
		addr[1] = pixel >> 8;
		addr[0] = pixel;
	    }
	    return 1;
	} else {
	    _XInitImageFuncPtrs(ximage);
	    return XPutPixel(ximage, x, y, pixel);
	}
}

static int _XPutPixel16 (ximage, x, y, pixel)
    register XImage *ximage;
    int x;
    int y;
    unsigned long pixel;
{
	unsigned char *addr;

	if ((ximage->format == ZPixmap) && (ximage->bits_per_pixel == 16)) {
	    addr = &((unsigned char *)ximage->data)
			[y * ximage->bytes_per_line + (x << 1)];
	    if (ximage->byte_order == MSBFirst) {
		addr[0] = pixel >> 8;
		addr[1] = pixel;
	    } else {
		addr[1] = pixel >> 8;
		addr[0] = pixel;
	    }
	    return 1;
	} else {
	    _XInitImageFuncPtrs(ximage);
	    return XPutPixel(ximage, x, y, pixel);
	}
}

static int _XPutPixel8 (ximage, x, y, pixel)
    register XImage *ximage;
    int x;
    int y;
    unsigned long pixel;
{
	if ((ximage->format == ZPixmap) && (ximage->bits_per_pixel == 8)) {
	    ximage->data[y * ximage->bytes_per_line + x] = pixel;
	    return 1;
	} else {
	    _XInitImageFuncPtrs(ximage);
	    return XPutPixel(ximage, x, y, pixel);
	}
}

static int _XPutPixel1 (ximage, x, y, pixel)
    register XImage *ximage;
    int x;
    int y;
    unsigned long pixel;
{
	unsigned char bit;
	int xoff, yoff;

	if (((ximage->bits_per_pixel | ximage->depth) == 1) &&
	    (ximage->byte_order == ximage->bitmap_bit_order)) {
	    xoff = x + ximage->xoffset;
	    yoff = y * ximage->bytes_per_line + (xoff >> 3);
	    xoff &= 7;
	    if (ximage->bitmap_bit_order == MSBFirst)
		bit = 0x80 >> xoff;
	    else
		bit = 1 << xoff;
	    if (pixel & 1)
		ximage->data[yoff] |= bit;
	    else
		ximage->data[yoff] &= ~bit;
	    return 1;
	} else {
	    _XInitImageFuncPtrs(ximage);
	    return XPutPixel(ximage, x, y, pixel);
	}
}

/*
 * SubImage
 * 
 * Creates a new image that is a subsection of an existing one.
 * Allocates the memory necessary for the new XImage data structure. 
 * Pointer to new image is returned.  The algorithm used is repetitive
 * calls to get and put pixel.
 *
 */

static XImage *_XSubImage (ximage, x, y, width, height)
    XImage *ximage;
    register int x;	/* starting x coordinate in existing image */
    register int y;	/* starting y coordinate in existing image */
    unsigned int width;	/* width in pixels of new subimage */
    unsigned int height;/* height in pixels of new subimage */

{
	register XImage *subimage;
	int dsize;
	register int row, col;
	register unsigned long pixel;
	char *data;

	if ((subimage = (XImage *) Xcalloc (1, sizeof (XImage))) == NULL)
	    return (XImage *) NULL;
	subimage->width = width;
	subimage->height = height;
	subimage->xoffset = 0;
	subimage->format = ximage->format;
	subimage->byte_order = ximage->byte_order;
	subimage->bitmap_unit = ximage->bitmap_unit;
	subimage->bitmap_bit_order = ximage->bitmap_bit_order;
	subimage->bitmap_pad = ximage->bitmap_pad;
	subimage->bits_per_pixel = ximage->bits_per_pixel;
	subimage->depth = ximage->depth;
	/*
	 * compute per line accelerator.
	 */
	if (subimage->format == ZPixmap) 	
	    subimage->bytes_per_line = 
		ROUNDUP(subimage->bits_per_pixel * width,
			subimage->bitmap_pad);
	else
	    subimage->bytes_per_line =
		ROUNDUP(width, subimage->bitmap_pad);
	subimage->obdata = NULL;
	_XInitImageFuncPtrs (subimage);
	dsize = subimage->bytes_per_line * height;
	if (subimage->format == XYPixmap) dsize = dsize * subimage->depth;
	if (((data = Xcalloc (1, (unsigned) dsize)) == NULL) && (dsize > 0)) {
	    Xfree((char *) subimage);
	    return (XImage *) NULL;
	}
	subimage->data = data;

	/*
	 * Test for cases where the new subimage is larger than the region
	 * that we are copying from the existing data.  In those cases,
	 * copy the area of the existing image, and allow the "uncovered"
	 * area of new subimage to remain with zero filled pixels.
	 */
	if (height > ximage->height - y ) height = ximage->height - y;
	if (width > ximage->width - x ) width = ximage->width - x;

	for (row = y; row < (y + height); row++) {
	    for (col = x; col < (x + width); col++) {
		pixel = XGetPixel(ximage, col, row);
		XPutPixel(subimage, (col - x), (row - y), pixel);
	    }
	}
	return subimage;
}


/*
 * AddPixel
 * 
 * Adds a constant value to every pixel in a pixmap.
 *
 */

static _XAddPixel (ximage, value)
    register XImage *ximage;
    register long value;
{
	register int x;
	register int y;

	if (!value)
	    return 0;
	if ((ximage->bits_per_pixel | ximage->depth) == 1) {
	    /* The only value that we can add here to an XYBitmap
	     * is one.  Since 1 + value = ~value for one bit wide
	     * data, we do this quickly by taking the ones complement
	     * of the entire bitmap data (offset and pad included!).
	     * Note that we don't need to be concerned with bit or
	     * byte order at all.
	     */
	    register unsigned char *dp = (unsigned char *) ximage->data;
	    x = ximage->bytes_per_line * ximage->height;
	    while (--x >= 0) {
		*dp = ~*dp;
		dp++;
	    }
	} else if ((ximage->format == ZPixmap) &&
		   (ximage->bits_per_pixel == 8)) {
	    register unsigned char *dp = (unsigned char *) ximage->data;
	    x = ximage->bytes_per_line * ximage->height;
	    while (--x >= 0)
		*dp++ += value;
#ifndef WORD64
	} else if ((ximage->format == ZPixmap) &&
		   (ximage->bits_per_pixel == 16) &&
		   (*((char *)&byteorderpixel) == ximage->byte_order)) {
	    register unsigned short *dp = (unsigned short *) ximage->data;
	    x = (ximage->bytes_per_line >> 1) * ximage->height;
	    while (--x >= 0)
		*dp++ += value;
	} else if ((ximage->format == ZPixmap) &&
		   (ximage->bits_per_pixel == 32) &&
		   (*((char *)&byteorderpixel) == ximage->byte_order)) {
	    register CARD32 *dp = (CARD32 *) ximage->data;
	    x = (ximage->bytes_per_line >> 2) * ximage->height;
	    while (--x >= 0)
		*dp++ += value;
#endif
	} else {
	    for (y = ximage->height; --y >= 0; ) {
		for (x = ximage->width; --x >= 0; ) {
		    register unsigned long pixel = XGetPixel(ximage, x, y);
		    pixel = pixel + value;
		    XPutPixel(ximage, x, y, pixel);
		}
	    }
	}
	return 0;
}

/*
 * This routine initializes the image object function pointers.  The
 * intent is to provide native (i.e. fast) routines for native format images
 * only using the generic (i.e. slow) routines when fast ones don't exist.
 * However, with the current rather botched external interface, clients may
 * have to mung image attributes after the image gets created, so the fast
 * routines always have to check to make sure the optimization is still
 * valid, and reinit the functions if not.
 */
_XInitImageFuncPtrs (image)
    register XImage *image;
{
	image->f.create_image = XCreateImage;
	image->f.destroy_image = _XDestroyImage;
	if ((image->format == ZPixmap) && (image->bits_per_pixel == 8)) {
	    image->f.get_pixel = _XGetPixel8;
	    image->f.put_pixel = _XPutPixel8;
	} else if (((image->bits_per_pixel | image->depth) == 1) &&
		   (image->byte_order == image->bitmap_bit_order)) {
	    image->f.get_pixel = _XGetPixel1;
	    image->f.put_pixel = _XPutPixel1;
	} else if ((image->format == ZPixmap) &&
		   (image->bits_per_pixel == 32)) {
	    image->f.get_pixel = _XGetPixel32;
	    image->f.put_pixel = _XPutPixel32;
	} else if ((image->format == ZPixmap) &&
		   (image->bits_per_pixel == 16)) {
	    image->f.get_pixel = _XGetPixel16;
	    image->f.put_pixel = _XPutPixel16;
	} else {
	    image->f.get_pixel = _XGetPixel;
	    image->f.put_pixel = _XPutPixel;
	}
	image->f.sub_image = _XSubImage;
/*	image->f.set_image = _XSetImage;*/
	image->f.add_pixel = _XAddPixel;
}

static unsigned char Const _reverse_byte[0x100] = {
	0x00, 0x80, 0x40, 0xc0, 0x20, 0xa0, 0x60, 0xe0,
	0x10, 0x90, 0x50, 0xd0, 0x30, 0xb0, 0x70, 0xf0,
	0x08, 0x88, 0x48, 0xc8, 0x28, 0xa8, 0x68, 0xe8,
	0x18, 0x98, 0x58, 0xd8, 0x38, 0xb8, 0x78, 0xf8,
	0x04, 0x84, 0x44, 0xc4, 0x24, 0xa4, 0x64, 0xe4,
	0x14, 0x94, 0x54, 0xd4, 0x34, 0xb4, 0x74, 0xf4,
	0x0c, 0x8c, 0x4c, 0xcc, 0x2c, 0xac, 0x6c, 0xec,
	0x1c, 0x9c, 0x5c, 0xdc, 0x3c, 0xbc, 0x7c, 0xfc,
	0x02, 0x82, 0x42, 0xc2, 0x22, 0xa2, 0x62, 0xe2,
	0x12, 0x92, 0x52, 0xd2, 0x32, 0xb2, 0x72, 0xf2,
	0x0a, 0x8a, 0x4a, 0xca, 0x2a, 0xaa, 0x6a, 0xea,
	0x1a, 0x9a, 0x5a, 0xda, 0x3a, 0xba, 0x7a, 0xfa,
	0x06, 0x86, 0x46, 0xc6, 0x26, 0xa6, 0x66, 0xe6,
	0x16, 0x96, 0x56, 0xd6, 0x36, 0xb6, 0x76, 0xf6,
	0x0e, 0x8e, 0x4e, 0xce, 0x2e, 0xae, 0x6e, 0xee,
	0x1e, 0x9e, 0x5e, 0xde, 0x3e, 0xbe, 0x7e, 0xfe,
	0x01, 0x81, 0x41, 0xc1, 0x21, 0xa1, 0x61, 0xe1,
	0x11, 0x91, 0x51, 0xd1, 0x31, 0xb1, 0x71, 0xf1,
	0x09, 0x89, 0x49, 0xc9, 0x29, 0xa9, 0x69, 0xe9,
	0x19, 0x99, 0x59, 0xd9, 0x39, 0xb9, 0x79, 0xf9,
	0x05, 0x85, 0x45, 0xc5, 0x25, 0xa5, 0x65, 0xe5,
	0x15, 0x95, 0x55, 0xd5, 0x35, 0xb5, 0x75, 0xf5,
	0x0d, 0x8d, 0x4d, 0xcd, 0x2d, 0xad, 0x6d, 0xed,
	0x1d, 0x9d, 0x5d, 0xdd, 0x3d, 0xbd, 0x7d, 0xfd,
	0x03, 0x83, 0x43, 0xc3, 0x23, 0xa3, 0x63, 0xe3,
	0x13, 0x93, 0x53, 0xd3, 0x33, 0xb3, 0x73, 0xf3,
	0x0b, 0x8b, 0x4b, 0xcb, 0x2b, 0xab, 0x6b, 0xeb,
	0x1b, 0x9b, 0x5b, 0xdb, 0x3b, 0xbb, 0x7b, 0xfb,
	0x07, 0x87, 0x47, 0xc7, 0x27, 0xa7, 0x67, 0xe7,
	0x17, 0x97, 0x57, 0xd7, 0x37, 0xb7, 0x77, 0xf7,
	0x0f, 0x8f, 0x4f, 0xcf, 0x2f, 0xaf, 0x6f, 0xef,
	0x1f, 0x9f, 0x5f, 0xdf, 0x3f, 0xbf, 0x7f, 0xff
};

static
_XReverse_Bytes (bpt, nb)
    register unsigned char *bpt;
    register int nb;
{
    do {
	*bpt = _reverse_byte[*bpt];
	bpt++;
    } while (--nb > 0);
    return 0;
}

